/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.fluids;

import abo.ABO;
import abo.actions.ABOEnergyPulser;
import abo.actions.ActionSwitchOnPipe;
import abo.actions.ActionToggleOffPipe;
import abo.actions.ActionToggleOnPipe;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.gates.IAction;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeFluidsWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeFluidsValve
extends PipeFluidsWood {
    private final ABOEnergyPulser pulser;
    private boolean powered;
    private boolean switched;
    private boolean toggled;
    private final int closedTexture = 18;
    private final int closedTextureSide = 19;
    private final int openTexture = 20;
    private final int openTextureSide = 21;

    public PipeFluidsValve(int itemID) {
        super(itemID);
        ((PipeTransportFluids)this.transport).flowRate = (short)160;
        ((PipeTransportFluids)this.transport).travelDelay = (short)2;
        this.pulser = new ABOEnergyPulser((IPowerReceptor)this);
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return ABO.instance.pipeIconProvider;
    }

    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.isPowered() ? 20 : 18;
        }
        int metadata = this.container.func_70322_n();
        if (metadata == direction.ordinal()) {
            return this.isPowered() ? 21 : 19;
        }
        return this.isPowered() ? 20 : 18;
    }

    public boolean isPowered() {
        return this.powered || this.switched || this.toggled;
    }

    public void updateRedstoneCurrent() {
        boolean lastPowered = this.powered;
        LinkedList<TileGenericPipe> neighbours = new LinkedList<TileGenericPipe>();
        neighbours.add(this.container);
        this.powered = false;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            Position pos = new Position((double)this.container.field_70329_l, (double)this.container.field_70330_m, (double)this.container.field_70327_n, o);
            pos.moveForwards(1.0);
            TileEntity tile = this.container.getTile(o);
            if (!(tile instanceof TileGenericPipe)) continue;
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (!BlockGenericPipe.isValid((Pipe)pipe.pipe)) continue;
            neighbours.add(pipe);
            if (!pipe.pipe.hasGate() || !pipe.pipe.gate.isEmittingRedstone()) continue;
            this.powered = true;
        }
        if (!this.powered) {
            this.powered = this.container.field_70331_k.func_72864_z(this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        }
        if (lastPowered != this.powered) {
            for (TileGenericPipe pipe : neighbours) {
                pipe.scheduleNeighborChange();
                pipe.func_70316_g();
            }
        }
    }

    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.updateRedstoneCurrent();
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("powered", this.powered);
        nbttagcompound.func_74757_a("switched", this.switched);
        nbttagcompound.func_74757_a("toggled", this.toggled);
        NBTTagCompound nbttagcompoundC = new NBTTagCompound();
        this.pulser.writeToNBT(nbttagcompoundC);
        nbttagcompound.func_74782_a("Pulser", (NBTBase)nbttagcompoundC);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.func_74767_n("powered");
        this.switched = nbttagcompound.func_74767_n("switched");
        this.toggled = nbttagcompound.func_74767_n("toggled");
        NBTTagCompound nbttagcompoundP = nbttagcompound.func_74775_l("Pulser");
        this.pulser.readFromNBT(nbttagcompoundP);
    }

    public void updateEntity() {
        this.updateRedstoneCurrent();
        if (this.isPowered()) {
            this.pulser.enablePulse();
        } else {
            this.pulser.disablePulse();
            this.liquidToExtract = 0;
        }
        this.pulser.update();
        super.updateEntity();
    }

    public LinkedList<IAction> getActions() {
        LinkedList actions = super.getActions();
        actions.add(ABO.actionSwitchOnPipe);
        actions.add(ABO.actionToggleOnPipe);
        actions.add(ABO.actionToggleOffPipe);
        return actions;
    }

    protected void actionsActivated(Map<IAction, Boolean> actions) {
        boolean lastSwitched = this.switched;
        boolean lastToggled = this.toggled;
        super.actionsActivated(actions);
        this.switched = false;
        for (IAction i : actions.keySet()) {
            if (!actions.get(i).booleanValue()) continue;
            if (i instanceof ActionSwitchOnPipe) {
                this.switched = true;
                continue;
            }
            if (i instanceof ActionToggleOnPipe) {
                this.toggled = true;
                continue;
            }
            if (!(i instanceof ActionToggleOffPipe)) continue;
            this.toggled = false;
        }
        if (lastSwitched != this.switched || lastToggled != this.toggled) {
            if (lastSwitched != this.switched && !this.switched) {
                this.toggled = false;
            }
            this.container.scheduleRenderUpdate();
            this.updateNeighbors(true);
        }
    }
}

