/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.items;

import abo.ABO;
import abo.PipeIconProvider;
import abo.actions.ActionSwitchOnPipe;
import abo.actions.ActionToggleOffPipe;
import abo.actions.ActionToggleOnPipe;
import abo.pipes.ABOPipe;
import abo.pipes.items.PipeItemsCompactorInventory;
import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsCompactor
extends ABOPipe<PipeTransportItems>
implements IPipeTransportItemsHook,
IActionReceptor {
    private final int onTexture = PipeIconProvider.PipeItemsCompactorOn;
    private final int offTexture = PipeIconProvider.PipeItemsCompactorOff;
    private boolean powered = false;
    private boolean toggled = false;
    private boolean switched = false;
    private final TreeMap<ForgeDirection, PipeItemsCompactorInventory> receivedStacks = new TreeMap();
    private final SafeTimeTracker timeTracker = new SafeTimeTracker();

    public PipeItemsCompactor(int itemID) {
        super(new PipeTransportItems(), itemID);
    }

    public void addItemToItemStack(ForgeDirection orientation, ItemStack stack) {
        if (!this.receivedStacks.containsKey(orientation)) {
            this.receivedStacks.put(orientation, new PipeItemsCompactorInventory());
        }
        this.receivedStacks.get(orientation).addItemStack(this.container.field_70331_k, stack);
    }

    public void dropContents() {
        this.powered = false;
        this.toggled = false;
        this.switched = false;
        for (Map.Entry<ForgeDirection, PipeItemsCompactorInventory> receivedStack : this.receivedStacks.entrySet()) {
            receivedStack.getValue().dropContents(this.container.field_70331_k, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        }
        this.receivedStacks.clear();
        super.dropContents();
    }

    public void entityEntered(TravelingItem item, ForgeDirection orientation) {
        if (this.isPowered() && item.getItemStack().func_77985_e()) {
            this.addItemToItemStack(orientation, item.getItemStack());
            ((PipeTransportItems)this.transport).items.scheduleRemoval(item);
        } else {
            this.readjustSpeed(item);
        }
    }

    public LinkedList<ForgeDirection> filterPossibleMovements(LinkedList<ForgeDirection> possibleOrientations, Position pos, TravelingItem item) {
        return possibleOrientations;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.func_74767_n("powered");
        this.switched = nbttagcompound.func_74767_n("switched");
        this.toggled = nbttagcompound.func_74767_n("toggled");
        NBTTagList nbtItems = nbttagcompound.func_74761_m("items");
        for (int j = 0; j < nbtItems.func_74745_c(); ++j) {
            try {
                NBTTagCompound nbtTreeMap = (NBTTagCompound)nbtItems.func_74743_b(j);
                ForgeDirection orientation = ForgeDirection.values()[nbtTreeMap.func_74762_e("orientation")];
                if (!this.receivedStacks.containsKey(orientation)) {
                    this.receivedStacks.put(orientation, new PipeItemsCompactorInventory());
                }
                NBTTagCompound nbtItemStacks = (NBTTagCompound)nbtTreeMap.func_74781_a("itemStacks");
                this.receivedStacks.get(orientation).readFromNBT(this.container.field_70331_k, nbtItemStacks);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("powered", this.powered);
        nbttagcompound.func_74757_a("switched", this.switched);
        nbttagcompound.func_74757_a("toggled", this.toggled);
        NBTTagList nbtItems = new NBTTagList();
        for (Map.Entry<ForgeDirection, PipeItemsCompactorInventory> receivedStack : this.receivedStacks.entrySet()) {
            NBTTagCompound nbtTreeMap = new NBTTagCompound();
            NBTTagCompound nbtItemStacks = new NBTTagCompound();
            nbtTreeMap.func_74768_a("orientation", receivedStack.getKey().ordinal());
            receivedStack.getValue().writeToNBT(nbtItemStacks);
            nbtTreeMap.func_74782_a("itemStacks", (NBTBase)nbtItemStacks);
            nbtItems.func_74742_a((NBTBase)nbtTreeMap);
        }
        nbttagcompound.func_74782_a("items", (NBTBase)nbtItems);
    }

    public boolean isPowered() {
        return this.powered || this.switched || this.toggled;
    }

    public void updateRedstoneCurrent() {
        boolean lastPowered = this.powered;
        LinkedList<TileGenericPipe> neighbours = new LinkedList<TileGenericPipe>();
        neighbours.add(this.container);
        this.powered = false;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            Position pos = new Position((double)this.container.field_70329_l, (double)this.container.field_70330_m, (double)this.container.field_70327_n, o);
            pos.moveForwards(1.0);
            TileEntity tile = this.container.getTile(o);
            if (!(tile instanceof TileGenericPipe)) continue;
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (!BlockGenericPipe.isValid((Pipe)pipe.pipe)) continue;
            neighbours.add(pipe);
            if (!pipe.pipe.hasGate() || !pipe.pipe.gate.isEmittingRedstone()) continue;
            this.powered = true;
        }
        if (!this.powered) {
            this.powered = this.container.field_70331_k.func_72864_z(this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        }
        if (lastPowered != this.powered) {
            for (TileGenericPipe pipe : neighbours) {
                pipe.scheduleNeighborChange();
                pipe.func_70316_g();
            }
        }
    }

    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.updateRedstoneCurrent();
    }

    public LinkedList<IAction> getActions() {
        LinkedList actions = super.getActions();
        actions.add(ABO.actionSwitchOnPipe);
        actions.add(ABO.actionToggleOnPipe);
        actions.add(ABO.actionToggleOffPipe);
        return actions;
    }

    protected void actionsActivated(Map<IAction, Boolean> actions) {
        boolean lastSwitched = this.switched;
        boolean lastToggled = this.toggled;
        super.actionsActivated(actions);
        this.switched = false;
        for (IAction i : actions.keySet()) {
            if (!actions.get(i).booleanValue()) continue;
            if (i instanceof ActionSwitchOnPipe) {
                this.switched = true;
                continue;
            }
            if (i instanceof ActionToggleOnPipe) {
                this.toggled = true;
                continue;
            }
            if (!(i instanceof ActionToggleOffPipe)) continue;
            this.toggled = false;
        }
        if (!(lastSwitched == this.switched && lastToggled == this.toggled || lastSwitched == this.switched || this.switched)) {
            this.toggled = false;
        }
    }

    public void actionActivated(IAction action) {
        boolean lastSwitched = this.switched;
        boolean lastToggled = this.toggled;
        this.switched = false;
        if (action instanceof ActionToggleOnPipe) {
            this.toggled = true;
        } else if (action instanceof ActionToggleOffPipe) {
            this.toggled = false;
        }
        if (!(lastSwitched == this.switched && lastToggled == this.toggled || lastSwitched == this.switched || this.switched)) {
            this.toggled = false;
        }
    }

    public void updateEntity() {
        super.updateEntity();
        this.updateRedstoneCurrent();
        if (this.isPowered() && this.timeTracker.markTimeIfDelay(this.container.field_70331_k, 25L)) {
            for (Map.Entry<ForgeDirection, PipeItemsCompactorInventory> receivedStack : this.receivedStacks.entrySet()) {
                ItemStack stack = receivedStack.getValue().findItemStackToRemove(this.container.field_70331_k, 16, 100);
                if (stack == null) continue;
                stack.field_77994_a -= Utils.addToRandomPipeAround((World)this.container.field_70331_k, (int)this.container.field_70329_l, (int)this.container.field_70330_m, (int)this.container.field_70327_n, (ForgeDirection)receivedStack.getKey(), (ItemStack)stack);
                if (stack.field_77994_a <= 0) continue;
                Position destPos = new Position((double)this.container.field_70329_l, (double)this.container.field_70330_m, (double)this.container.field_70327_n, receivedStack.getKey());
                destPos.moveForwards(0.3);
                InvUtils.dropItems((World)this.container.field_70331_k, (ItemStack)stack, (int)((int)destPos.x), (int)((int)destPos.y), (int)((int)destPos.z));
            }
        }
    }

    public void readjustSpeed(TravelingItem item) {
        item.setSpeed(Math.min(Math.max(0.01f, item.getSpeed()) * 2.0f, 0.19999999f));
    }

    public int getIconIndex(ForgeDirection direction) {
        if (this.container != null && this.container.field_70331_k != null) {
            return this.isPowered() ? this.onTexture : this.offTexture;
        }
        return this.offTexture;
    }
}

