/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.items;

import abo.pipes.ABOPipe;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsInsertion
extends ABOPipe<PipeTransportItems>
implements IPipeTransportItemsHook {
    public PipeItemsInsertion(int itemID) {
        super(new PipeTransportItems(), itemID);
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    public int getIconIndex(ForgeDirection direction) {
        return 5;
    }

    public LinkedList<ForgeDirection> filterPossibleMovements(LinkedList<ForgeDirection> possibleOrientations, Position pos, TravelingItem item) {
        LinkedList<ForgeDirection> nonPipesList = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> pipesList = new LinkedList<ForgeDirection>();
        item.blacklist.add(item.input.getOpposite());
        for (ForgeDirection o : possibleOrientations) {
            if (item.blacklist.contains(o) || !this.container.pipe.outputOpen(o) || !((PipeTransportItems)this.transport).canReceivePipeObjects(o, item)) continue;
            TileEntity entity = this.container.getTile(o);
            if (entity instanceof IPipeTile) {
                pipesList.add(o);
                continue;
            }
            nonPipesList.add(o);
        }
        if (!nonPipesList.isEmpty()) {
            return nonPipesList;
        }
        return pipesList;
    }

    public void entityEntered(TravelingItem item, ForgeDirection orientation) {
    }

    public void readjustSpeed(TravelingItem item) {
        ((PipeTransportItems)this.transport).defaultReajustSpeed(item);
    }
}

