/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.power;

import abo.ABO;
import abo.actions.ActionSwitchOnPipe;
import abo.actions.ActionToggleOffPipe;
import abo.actions.ActionToggleOnPipe;
import abo.pipes.ABOPipe;
import buildcraft.api.core.Position;
import buildcraft.api.gates.IAction;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeConnectionBans;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipePowerSwitch
extends ABOPipe<PipeTransportPower>
implements IPipeTransportPowerHook {
    private final int unpoweredTexture = 23;
    private final int poweredTexture = 22;
    private boolean powered;
    private boolean switched;
    private boolean toggled;

    public PipePowerSwitch(int itemID) {
        super(new PipeTransportPower(), itemID);
        PipeConnectionBans.banConnection((Class[])new Class[]{PipePowerSwitch.class, PipePowerSwitch.class});
        PipeTransportPower cfr_ignored_0 = (PipeTransportPower)this.transport;
        PipeTransportPower.powerCapacities.put(PipePowerSwitch.class, 1024);
        ((PipeTransportPower)this.transport).initFromPipe(((Object)((Object)this)).getClass());
    }

    public int getIconIndex(ForgeDirection direction) {
        return this.isPowered() ? 22 : 23;
    }

    public boolean isPowered() {
        return this.powered || this.switched || this.toggled;
    }

    public void updateRedstoneCurrent() {
        boolean lastPowered = this.powered;
        LinkedList<TileGenericPipe> neighbours = new LinkedList<TileGenericPipe>();
        neighbours.add(this.container);
        this.powered = false;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            Position pos = new Position((double)this.container.field_70329_l, (double)this.container.field_70330_m, (double)this.container.field_70327_n, o);
            pos.moveForwards(1.0);
            TileEntity tile = this.container.getTile(o);
            if (!(tile instanceof TileGenericPipe)) continue;
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (!BlockGenericPipe.isValid((Pipe)pipe.pipe)) continue;
            neighbours.add(pipe);
            if (!pipe.pipe.hasGate() || !pipe.pipe.gate.isEmittingRedstone()) continue;
            this.powered = true;
        }
        if (!this.powered) {
            this.powered = this.container.field_70331_k.func_72864_z(this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        }
        if (lastPowered != this.powered) {
            for (TileGenericPipe pipe : neighbours) {
                pipe.scheduleNeighborChange();
                pipe.func_70316_g();
            }
        }
    }

    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.updateRedstoneCurrent();
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("powered", this.powered);
        nbttagcompound.func_74757_a("switched", this.switched);
        nbttagcompound.func_74757_a("toggled", this.toggled);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.func_74767_n("powered");
        this.switched = nbttagcompound.func_74767_n("switched");
        this.toggled = nbttagcompound.func_74767_n("toggled");
    }

    public void updateEntity() {
        super.updateEntity();
        this.updateRedstoneCurrent();
    }

    public LinkedList<IAction> getActions() {
        LinkedList actions = super.getActions();
        actions.add(ABO.actionSwitchOnPipe);
        actions.add(ABO.actionToggleOnPipe);
        actions.add(ABO.actionToggleOffPipe);
        return actions;
    }

    protected void actionsActivated(Map<IAction, Boolean> actions) {
        boolean lastSwitched = this.switched;
        boolean lastToggled = this.toggled;
        super.actionsActivated(actions);
        this.switched = false;
        for (IAction i : actions.keySet()) {
            if (!actions.get(i).booleanValue()) continue;
            if (i instanceof ActionSwitchOnPipe) {
                this.switched = true;
                continue;
            }
            if (i instanceof ActionToggleOnPipe) {
                this.toggled = true;
                continue;
            }
            if (!(i instanceof ActionToggleOffPipe)) continue;
            this.toggled = false;
        }
        if (lastSwitched != this.switched || lastToggled != this.toggled) {
            if (lastSwitched != this.switched && !this.switched) {
                this.toggled = false;
            }
            this.container.scheduleRenderUpdate();
            this.updateNeighbors(true);
        }
    }

    public float receiveEnergy(ForgeDirection from, float val) {
        if (!this.isPowered()) {
            return val;
        }
        if ((double)val > 0.0) {
            int n = from.ordinal();
            ((PipeTransportPower)this.transport).internalNextPower[n] = ((PipeTransportPower)this.transport).internalNextPower[n] + val;
            if (((PipeTransportPower)this.transport).internalNextPower[from.ordinal()] > (float)((PipeTransportPower)this.transport).maxPower) {
                val = ((PipeTransportPower)this.transport).internalNextPower[from.ordinal()] - (float)((PipeTransportPower)this.transport).maxPower;
                ((PipeTransportPower)this.transport).internalNextPower[from.ordinal()] = ((PipeTransportPower)this.transport).maxPower;
            }
        }
        return val;
    }

    public float requestEnergy(ForgeDirection from, float amount) {
        if (!this.isPowered()) {
            return 0.0f;
        }
        return amount;
    }
}

