/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api.electricity;

import icbm.api.explosion.IExplosion;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.electricity.ElectricConversions$;
import net.machinemuse.api.electricity.MuseElectricItem;
import net.machinemuse.utils.ElectricItemUtils$;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import scala.math.package$;

public abstract class MuseElectricItem$class {
    public static double getCurrentEnergy(MuseElectricItem $this, ItemStack stack) {
        return MuseItemUtils.getDoubleOrZero(stack, ElectricItemUtils$.MODULE$.CURRENT_ENERGY());
    }

    public static double getMaxEnergy(MuseElectricItem $this, ItemStack stack) {
        return ModuleManager.computeModularProperty(stack, ElectricItemUtils$.MODULE$.MAXIMUM_ENERGY());
    }

    public static void setCurrentEnergy(MuseElectricItem $this, ItemStack stack, double energy) {
        MuseItemUtils.setDoubleOrRemove(stack, ElectricItemUtils$.MODULE$.CURRENT_ENERGY(), Math.min(energy, $this.getMaxEnergy(stack)));
    }

    public static double drainEnergyFrom(MuseElectricItem $this, ItemStack stack, double requested) {
        double d;
        double available = $this.getCurrentEnergy(stack);
        if (available > requested) {
            $this.setCurrentEnergy(stack, available - requested);
            d = requested;
        } else {
            $this.setCurrentEnergy(stack, 0.0);
            d = available;
        }
        return d;
    }

    public static double giveEnergyTo(MuseElectricItem $this, ItemStack stack, double provided) {
        double d;
        double max;
        double available = $this.getCurrentEnergy(stack);
        if (available + provided < (max = $this.getMaxEnergy(stack))) {
            $this.setCurrentEnergy(stack, available + provided);
            d = provided;
        } else {
            $this.setCurrentEnergy(stack, max);
            d = max - available;
        }
        return d;
    }

    public static boolean canProvideEnergy(MuseElectricItem $this, ItemStack itemStack) {
        return true;
    }

    public static int getChargedItemId(MuseElectricItem $this, ItemStack itemStack) {
        return itemStack.field_77993_c;
    }

    public static int getEmptyItemId(MuseElectricItem $this, ItemStack itemStack) {
        return itemStack.field_77993_c;
    }

    public static int getMaxCharge(MuseElectricItem $this, ItemStack itemStack) {
        return (int)ElectricConversions$.MODULE$.museEnergyToEU($this.getCurrentEnergy(itemStack));
    }

    public static int getTier(MuseElectricItem $this, ItemStack itemStack) {
        return ElectricConversions$.MODULE$.getTier(itemStack);
    }

    public static int getTransferLimit(MuseElectricItem $this, ItemStack itemStack) {
        return (int)ElectricConversions$.MODULE$.museEnergyToEU(Math.sqrt($this.getMaxEnergy(itemStack)));
    }

    public static int charge(MuseElectricItem $this, ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double current = $this.getCurrentEnergy(itemStack);
        double transfer = ignoreTransferLimit || amount < $this.getTransferLimit(itemStack) ? ElectricConversions$.MODULE$.museEnergyFromEU(amount) : (double)$this.getTransferLimit(itemStack);
        double given = $this.giveEnergyTo(itemStack, transfer);
        if (simulate) {
            $this.setCurrentEnergy(itemStack, current);
        }
        return (int)ElectricConversions$.MODULE$.museEnergyToEU(given);
    }

    public static int discharge(MuseElectricItem $this, ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double current = $this.getCurrentEnergy(itemStack);
        double transfer = ignoreTransferLimit || amount < $this.getTransferLimit(itemStack) ? ElectricConversions$.MODULE$.museEnergyFromEU(amount) : (double)$this.getTransferLimit(itemStack);
        double taken = $this.drainEnergyFrom(itemStack, transfer);
        if (simulate) {
            $this.setCurrentEnergy(itemStack, current);
        }
        return (int)ElectricConversions$.MODULE$.museEnergyToEU(taken);
    }

    public static boolean canUse(MuseElectricItem $this, ItemStack itemStack, int amount) {
        return ElectricConversions$.MODULE$.museEnergyFromEU(amount) < $this.getCurrentEnergy(itemStack);
    }

    public static boolean canShowChargeToolTip(MuseElectricItem $this, ItemStack itemStack) {
        return false;
    }

    public static void onEMP(MuseElectricItem $this, ItemStack itemStack, Entity entity, IExplosion empExplosive) {
        $this.setCurrentEnergy(itemStack, 0.0);
    }

    public static float getElectricityStored(MuseElectricItem $this, ItemStack itemStack) {
        return ElectricConversions$.MODULE$.museEnergyToJoules($this.getCurrentEnergy(itemStack));
    }

    public static void setElectricity(MuseElectricItem $this, ItemStack itemStack, float joules) {
        $this.setCurrentEnergy(itemStack, ElectricConversions$.MODULE$.museEnergyFromJoules(joules));
    }

    public static float getMaxElectricityStored(MuseElectricItem $this, ItemStack itemStack) {
        return ElectricConversions$.MODULE$.museEnergyToJoules($this.getMaxEnergy(itemStack));
    }

    public static float getVoltage(MuseElectricItem $this, ItemStack itemStack) {
        return 120.0f;
    }

    public static float recharge(MuseElectricItem $this, ItemStack itemStack, float energy, boolean doCharge) {
        float joulesConsumed = 0.0f;
        double energyReceiving = ElectricConversions$.MODULE$.museEnergyFromJoules(energy);
        if (doCharge) {
            double energyConsumed = $this.giveEnergyTo(itemStack, energyReceiving);
            joulesConsumed = ElectricConversions$.MODULE$.museEnergyToJoules(energyConsumed);
        } else {
            double energyChargeable = $this.getMaxEnergy(itemStack) - $this.getCurrentEnergy(itemStack);
            joulesConsumed = ElectricConversions$.MODULE$.museEnergyToJoules(package$.MODULE$.min(energyReceiving, energyChargeable));
        }
        return joulesConsumed;
    }

    public static float discharge(MuseElectricItem $this, ItemStack itemStack, float energy, boolean doCharge) {
        double energyRequested = ElectricConversions$.MODULE$.museEnergyFromJoules(energy);
        float joulesGiven = 0.0f;
        if (doCharge) {
            double energyGiven = $this.drainEnergyFrom(itemStack, energyRequested);
            joulesGiven = ElectricConversions$.MODULE$.museEnergyToJoules(energyGiven);
        } else {
            double energyAvailable = $this.getCurrentEnergy(itemStack);
            joulesGiven = ElectricConversions$.MODULE$.museEnergyToJoules(package$.MODULE$.min(energyAvailable, energyRequested));
        }
        return joulesGiven;
    }

    public static float getTransfer(MuseElectricItem $this, ItemStack itemStack) {
        return ElectricConversions$.MODULE$.museEnergyToJoules($this.getMaxEnergy(itemStack) - $this.getCurrentEnergy(itemStack));
    }

    public static int receiveEnergy(MuseElectricItem $this, ItemStack stack, int energy, boolean simulate) {
        double current = $this.getCurrentEnergy(stack);
        double receivedME = ElectricConversions$.MODULE$.museEnergyFromRF(energy);
        double eatenME = $this.giveEnergyTo(stack, receivedME);
        if (simulate) {
            $this.setCurrentEnergy(stack, current);
        }
        return ElectricConversions$.MODULE$.museEnergyToRF(eatenME);
    }

    public static int extractEnergy(MuseElectricItem $this, ItemStack stack, int energy, boolean simulate) {
        double current = $this.getCurrentEnergy(stack);
        double requesteddME = ElectricConversions$.MODULE$.museEnergyFromRF(energy);
        double takenME = $this.drainEnergyFrom(stack, requesteddME);
        if (simulate) {
            $this.setCurrentEnergy(stack, current);
        }
        return ElectricConversions$.MODULE$.museEnergyToRF(takenME);
    }

    public static int getEnergyStored(MuseElectricItem $this, ItemStack theItem) {
        return (int)ElectricConversions$.MODULE$.museEnergyToMJ($this.getCurrentEnergy(theItem));
    }

    public static int getMaxEnergyStored(MuseElectricItem $this, ItemStack theItem) {
        return (int)ElectricConversions$.MODULE$.museEnergyToMJ($this.getMaxEnergy(theItem));
    }

    public static void $init$(MuseElectricItem $this) {
    }
}

