/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui;

import java.util.ArrayList;
import java.util.List;
import net.machinemuse.general.gui.clickable.IClickable;
import net.machinemuse.general.gui.frame.IGuiFrame;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.DrawableMuseRect;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class MuseGui
extends GuiScreen {
    protected long creationTime;
    protected int xSize;
    protected int ySize;
    protected DrawableMuseRect backgroundRect;
    protected DrawableMuseRect tooltipRect;
    protected List<IGuiFrame> frames = new ArrayList<IGuiFrame>();

    public void func_73866_w_() {
        super.func_73866_w_();
        this.frames.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.creationTime = System.currentTimeMillis();
        int xpadding = (this.field_73880_f - this.getxSize()) / 2;
        int ypadding = (this.field_73881_g - this.ySize) / 2;
        this.backgroundRect = new DrawableMuseRect((double)this.absX(-1.0), (double)this.absY(-1.0), (double)this.absX(1.0), (double)this.absY(1.0), true, new Colour((double)0.1f, (double)0.9f, (double)0.1f, (double)0.8f), new Colour(0.0, (double)0.2f, 0.0, (double)0.8f));
        this.tooltipRect = new DrawableMuseRect(0.0, 0.0, 0.0, 0.0, false, new Colour((double)0.2f, (double)0.6f, (double)0.9f, (double)0.7f), new Colour((double)0.1f, (double)0.3f, (double)0.4f, (double)0.7f));
    }

    public void drawRectangularBackground() {
        this.backgroundRect.draw();
    }

    public void addFrame(IGuiFrame frame) {
        this.frames.add(frame);
    }

    public void drawClickables(List<? extends IClickable> list) {
        if (list == null) {
            return;
        }
        for (IClickable iClickable : list) {
            iClickable.draw();
        }
    }

    public void drawBackground() {
        this.func_73873_v_();
        this.drawRectangularBackground();
    }

    public void func_73863_a(int x, int y, float z) {
        super.func_73863_a(x, y, z);
        this.update();
        this.drawBackground();
        for (IGuiFrame frame : this.frames) {
            frame.draw();
        }
        this.drawToolTip();
    }

    public void update() {
        double x = (double)(Mouse.getEventX() * this.field_73880_f) / (double)this.field_73882_e.field_71443_c;
        double y = (double)this.field_73881_g - (double)(Mouse.getEventY() * this.field_73881_g) / (double)this.field_73882_e.field_71440_d - 1.0;
        for (IGuiFrame frame : this.frames) {
            frame.update(x, y);
        }
    }

    public int hitboxClickables(int x, int y, List<? extends IClickable> list) {
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            IClickable clickie = list.get(i);
            if (!clickie.hitBox(x, y)) continue;
            return i;
        }
        return -1;
    }

    public boolean func_73868_f() {
        return false;
    }

    public int absX(double relx) {
        int absx = (int)((relx + 1.0) * (double)this.getxSize() / 2.0);
        int xpadding = (this.field_73880_f - this.getxSize()) / 2;
        return absx + xpadding;
    }

    public int relX(double absx) {
        int padding = (this.field_73880_f - this.getxSize()) / 2;
        int relx = (int)((absx - (double)padding) * 2.0 / (double)this.getxSize() - 1.0);
        return relx;
    }

    public int absY(double rely) {
        int absy = (int)((rely + 1.0) * (double)this.ySize / 2.0);
        int ypadding = (this.field_73881_g - this.ySize) / 2;
        return absy + ypadding;
    }

    public int relY(float absy) {
        int padding = (this.field_73881_g - this.ySize) / 2;
        int rely = (int)((absy - (float)padding) * 2.0f / (float)this.ySize - 1.0f);
        return rely;
    }

    public int getxSize() {
        return this.xSize;
    }

    public void setxSize(int xSize) {
        this.xSize = xSize;
    }

    public int getySize() {
        return this.ySize;
    }

    public void setySize(int ySize) {
        this.ySize = ySize;
    }

    protected void func_73864_a(int x, int y, int button) {
        for (IGuiFrame frame : this.frames) {
            frame.onMouseDown(x, y, button);
        }
    }

    protected void func_73879_b(int x, int y, int which) {
        for (IGuiFrame frame : this.frames) {
            frame.onMouseUp(x, y, which);
        }
    }

    protected void drawToolTip() {
        int y;
        int x = Mouse.getEventX() * this.field_73880_f / this.field_73882_e.field_71443_c;
        List<String> tooltip = this.getToolTip(x, y = this.field_73881_g - Mouse.getEventY() * this.field_73881_g / this.field_73882_e.field_71440_d - 1);
        if (tooltip != null) {
            double right;
            double left;
            double bottom;
            double top;
            double strwidth = 0.0;
            for (String s : tooltip) {
                double currstrwidth = MuseRenderer.getStringWidth(s);
                if (!(currstrwidth > strwidth)) continue;
                strwidth = currstrwidth;
            }
            if (y > this.field_73881_g / 2) {
                top = y - 10 * tooltip.size() - 8;
                bottom = y;
                left = x;
                right = (double)(x + 8) + strwidth;
            } else {
                top = y;
                bottom = y + 10 * tooltip.size() + 8;
                left = x + 4;
                right = (double)(x + 12) + strwidth;
            }
            this.tooltipRect.setTop(top);
            this.tooltipRect.setLeft(left);
            this.tooltipRect.setRight(right);
            this.tooltipRect.setBottom(bottom);
            this.tooltipRect.draw();
            for (int i = 0; i < tooltip.size(); ++i) {
                MuseRenderer.drawString(tooltip.get(i), left + 4.0, bottom - (double)(10 * (tooltip.size() - i)) - 4.0);
            }
        }
    }

    public List<String> getToolTip(int x, int y) {
        List<String> hitTip = null;
        for (IGuiFrame frame : this.frames) {
            hitTip = frame.getToolTip(x, y);
            if (hitTip == null) continue;
            return hitTip;
        }
        return null;
    }

    public void refresh() {
    }
}

