/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.net.URL;
import net.machinemuse.general.sound.SoundLoader;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.network.MusePacketHandler;
import net.machinemuse.numina.network.MusePacketModeChangeRequest;
import net.machinemuse.numina.render.RenderGameOverlayEventHandler;
import net.machinemuse.powersuits.block.TileEntityLuxCapacitor;
import net.machinemuse.powersuits.block.TileEntityTinkerTable;
import net.machinemuse.powersuits.client.render.block.RenderLuxCapacitorTESR;
import net.machinemuse.powersuits.client.render.block.TinkerTableRenderer;
import net.machinemuse.powersuits.client.render.entity.RenderLuxCapacitorEntity;
import net.machinemuse.powersuits.client.render.entity.RenderPlasmaBolt;
import net.machinemuse.powersuits.client.render.entity.RenderSpinningBlade;
import net.machinemuse.powersuits.client.render.item.ToolRenderer;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpecXMLReader;
import net.machinemuse.powersuits.common.CommonProxy;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.ModularPowersuits;
import net.machinemuse.powersuits.control.KeybindKeyHandler;
import net.machinemuse.powersuits.control.KeybindManager;
import net.machinemuse.powersuits.entity.EntityLuxCapacitor;
import net.machinemuse.powersuits.entity.EntityPlasmaBolt;
import net.machinemuse.powersuits.entity.EntitySpinningBlade;
import net.machinemuse.powersuits.event.RenderEventHandler;
import net.machinemuse.powersuits.tick.ClientTickHandler;
import net.machinemuse.powersuits.tick.PlayerTickHandler;
import net.machinemuse.powersuits.tick.RenderTickHandler;
import net.machinemuse.utils.render.MuseShaders;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.network.packet.Packet;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    private static ToolRenderer toolRenderer;
    private static ClientTickHandler clientTickHandler;
    private static RenderTickHandler renderTickHandler;
    private static PlayerTickHandler playerTickHandler;
    public static KeybindKeyHandler keybindHandler;

    @Override
    public void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new SoundLoader());
    }

    @Override
    public void registerRenderers() {
        toolRenderer = new ToolRenderer();
        MinecraftForgeClient.registerItemRenderer((int)ModularPowersuits.powerTool.field_77779_bT, (IItemRenderer)toolRenderer);
        int tinkTableRenderID = RenderingRegistry.getNextAvailableRenderId();
        TinkerTableRenderer tinkTableRenderer = new TinkerTableRenderer(tinkTableRenderID);
        ModularPowersuits.tinkerTable.setRenderType(tinkTableRenderID);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTinkerTable.class, (TileEntitySpecialRenderer)tinkTableRenderer);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)tinkTableRenderer);
        int luxCapacitorRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderLuxCapacitorTESR luxCapacitorRenderer = new RenderLuxCapacitorTESR(luxCapacitorRenderID);
        ModularPowersuits.luxCapacitor.setRenderType(luxCapacitorRenderID);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLuxCapacitor.class, (TileEntitySpecialRenderer)luxCapacitorRenderer);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)luxCapacitorRenderer);
        RenderingRegistry.registerEntityRenderingHandler(EntityPlasmaBolt.class, (Render)new RenderPlasmaBolt());
        RenderingRegistry.registerEntityRenderingHandler(EntitySpinningBlade.class, (Render)new RenderSpinningBlade());
        RenderingRegistry.registerEntityRenderingHandler(EntityLuxCapacitor.class, (Render)new RenderLuxCapacitorEntity());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
        URL resource = ClientProxy.class.getResource("/assets/powersuits/models/modelspec.xml");
        ModelSpecXMLReader.parseFile(resource);
        URL otherResource = ClientProxy.class.getResource("/assets/powersuits/models/armor2.xml");
        ModelSpecXMLReader.parseFile(otherResource);
        try {
            MuseShaders.hBlurProgram().program();
            Config.canUseShaders = true;
        }
        catch (Throwable e) {
            MuseLogger.logException((String)"Loading shaders failed!", (Throwable)e);
        }
    }

    @Override
    public void registerHandlers() {
        super.registerHandlers();
        keybindHandler = new KeybindKeyHandler();
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)keybindHandler);
        playerTickHandler = new PlayerTickHandler();
        TickRegistry.registerTickHandler((ITickHandler)playerTickHandler, (Side)Side.CLIENT);
        renderTickHandler = new RenderTickHandler();
        TickRegistry.registerTickHandler((ITickHandler)renderTickHandler, (Side)Side.CLIENT);
        clientTickHandler = new ClientTickHandler();
        TickRegistry.registerTickHandler((ITickHandler)clientTickHandler, (Side)Side.CLIENT);
        packetHandler = new MusePacketHandler();
    }

    @Override
    public void postInit() {
        KeybindManager.readInKeybinds();
    }

    @Override
    public void sendModeChange(int dMode, String newMode) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        RenderGameOverlayEventHandler.updateSwap((int)((int)Math.signum(dMode)));
        MusePacketModeChangeRequest modeChangePacket = new MusePacketModeChangeRequest((Player)player, newMode, player.field_71071_by.field_70461_c);
        player.field_71174_a.func_72552_c((Packet)modeChangePacket.getPacket131());
    }
}

