/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import net.machinemuse.general.recipe.RecipeManager;
import net.machinemuse.powersuits.block.BlockLuxCapacitor;
import net.machinemuse.powersuits.block.BlockTinkerTable;
import net.machinemuse.powersuits.common.CommonProxy;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.GuiHandler;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.entity.EntityLuxCapacitor;
import net.machinemuse.powersuits.entity.EntityPlasmaBolt;
import net.machinemuse.powersuits.entity.EntitySpinningBlade;
import net.machinemuse.powersuits.event.HarvestEventHandler;
import net.machinemuse.powersuits.event.MovementManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.item.ItemPowerArmorBoots;
import net.machinemuse.powersuits.item.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.item.ItemPowerArmorHelmet;
import net.machinemuse.powersuits.item.ItemPowerArmorLeggings;
import net.machinemuse.powersuits.item.ItemPowerFist;
import net.machinemuse.utils.MuseFileUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="powersuits", name="MachineMuse's Modular Powersuits", dependencies="required-after:Forge@[9.10.1.856,);after:IC2;required-after:numina", version="0.8.0-62")
@NetworkMod(clientSideRequired=true, serverSideRequired=true)
public class ModularPowersuits {
    public static ItemPowerArmorHelmet powerArmorHead;
    public static ItemPowerArmorChestplate powerArmorTorso;
    public static ItemPowerArmorLeggings powerArmorLegs;
    public static ItemPowerArmorBoots powerArmorFeet;
    public static ItemPowerFist powerTool;
    public static ItemComponent components;
    public static BlockTinkerTable tinkerTable;
    public static BlockLuxCapacitor luxCapacitor;
    @Mod.Instance(value="ModularPowersuits")
    public static ModularPowersuits INSTANCE;
    @SidedProxy(clientSide="net.machinemuse.powersuits.client.ClientProxy", serverSide="net.machinemuse.powersuits.common.ServerProxy")
    public static CommonProxy proxy;
    public static Config config;
    public static GuiHandler guiHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        INSTANCE = this;
        File oldConfig = event.getSuggestedConfigurationFile();
        File newConfig = new File(event.getModConfigurationDirectory() + "/machinemuse/powersuits.cfg");
        if (oldConfig.exists()) {
            try {
                MuseFileUtils.copyFile(oldConfig, newConfig);
                oldConfig.delete();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        Config.init(new Configuration(newConfig));
        Config.setConfigFolderBase(event.getModConfigurationDirectory());
        MinecraftForge.EVENT_BUS.register((Object)new HarvestEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MovementManager());
        proxy.registerEvents();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        powerArmorHead = new ItemPowerArmorHelmet(Config.helmID);
        GameRegistry.registerItem((Item)powerArmorHead, (String)powerArmorHead.func_77658_a());
        powerArmorTorso = new ItemPowerArmorChestplate(Config.chestID);
        GameRegistry.registerItem((Item)powerArmorTorso, (String)powerArmorTorso.func_77658_a());
        powerArmorLegs = new ItemPowerArmorLeggings(Config.legsID);
        GameRegistry.registerItem((Item)powerArmorLegs, (String)powerArmorLegs.func_77658_a());
        powerArmorFeet = new ItemPowerArmorBoots(Config.bootsID);
        GameRegistry.registerItem((Item)powerArmorFeet, (String)powerArmorFeet.func_77658_a());
        powerTool = new ItemPowerFist();
        GameRegistry.registerItem((Item)powerTool, (String)powerTool.func_77658_a());
        tinkerTable = new BlockTinkerTable();
        GameRegistry.registerBlock((Block)tinkerTable, (String)tinkerTable.func_71917_a());
        luxCapacitor = new BlockLuxCapacitor();
        GameRegistry.registerBlock((Block)luxCapacitor, (String)luxCapacitor.func_71917_a());
        components = new ItemComponent();
        components.populate();
        GameRegistry.registerItem((Item)components, (String)components.func_77658_a());
        Config.loadPowerModules();
        Config.getMaximumArmorPerPiece();
        Config.getMaximumFlyingSpeedmps();
        Config.useMouseWheel();
        Config.useGraphicalMeters();
        Config.getSalvageChance();
        Config.baseMaxHeat();
        Config.allowConflictingKeybinds();
        Config.fontURI();
        Config.fontName();
        Config.fontDetail();
        Config.fontAntiAliasing();
        Config.useCustomFonts();
        Config.glowMultiplier();
        Config.useShaders();
        EntityRegistry.registerModEntity(EntityPlasmaBolt.class, (String)"entityPlasmaBolt", (int)2477, (Object)this, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntitySpinningBlade.class, (String)"entitySpinningBlade", (int)2478, (Object)this, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityLuxCapacitor.class, (String)"entityLuxCapacitor", (int)2479, (Object)this, (int)64, (int)20, (boolean)true);
        proxy.registerHandlers();
        proxy.registerRenderers();
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)guiHandler);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        RecipeManager.addRecipes();
        ModCompatability.registerModSpecificModules();
        Config.getConfig().save();
    }

    static {
        guiHandler = new GuiHandler();
    }
}

