/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.entity;

import java.util.ArrayList;
import java.util.Random;
import net.machinemuse.api.ModuleManager;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class EntitySpinningBlade
extends EntityThrowable {
    public static final int SIZE = 24;
    public double damage;
    public Entity shootingEntity;
    public ItemStack shootingItem;

    public EntitySpinningBlade(World world) {
        super(world);
    }

    public EntitySpinningBlade(World par1World, EntityLivingBase shootingEntity) {
        super(par1World, shootingEntity);
        this.shootingEntity = shootingEntity;
        if (shootingEntity instanceof EntityPlayer) {
            this.shootingItem = ((EntityPlayer)shootingEntity).func_71045_bC();
            if (this.shootingItem != null) {
                this.damage = ModuleManager.computeModularProperty(this.shootingItem, "Spinning Blade Damage");
            }
        }
        Vec3 direction = shootingEntity.func_70040_Z().func_72432_b();
        double speed = 1.0;
        double scale = 1.0;
        this.field_70159_w = direction.field_72450_a * speed;
        this.field_70181_x = direction.field_72448_b * speed;
        this.field_70179_y = direction.field_72449_c * speed;
        double r = 1.0;
        double xoffset = (double)1.3f + r - direction.field_72448_b * (double)shootingEntity.func_70047_e();
        double yoffset = -0.2;
        double zoffset = 0.3f;
        double horzScale = Math.sqrt(direction.field_72450_a * direction.field_72450_a + direction.field_72449_c * direction.field_72449_c);
        double horzx = direction.field_72450_a / horzScale;
        double horzz = direction.field_72449_c / horzScale;
        this.field_70165_t = shootingEntity.field_70165_t + direction.field_72450_a * xoffset - direction.field_72448_b * horzx * yoffset - horzz * zoffset;
        this.field_70163_u = shootingEntity.field_70163_u + (double)shootingEntity.func_70047_e() + direction.field_72448_b * xoffset + (1.0 - Math.abs(direction.field_72448_b)) * yoffset;
        this.field_70161_v = shootingEntity.field_70161_v + direction.field_72449_c * xoffset - direction.field_72448_b * horzz * yoffset + horzx * zoffset;
        this.field_70121_D.func_72324_b(this.field_70165_t - r, this.field_70163_u - r, this.field_70161_v - r, this.field_70165_t + r, this.field_70163_u + r, this.field_70161_v + r);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public int getMaxLifetime() {
        return 200;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > this.getMaxLifetime()) {
            this.func_70106_y();
        }
    }

    protected void func_70184_a(MovingObjectPosition hitMOP) {
        if (hitMOP.field_72313_a == EnumMovingObjectType.TILE) {
            World world = this.field_70170_p;
            if (world == null) {
                return;
            }
            int id = world.func_72798_a(hitMOP.field_72311_b, hitMOP.field_72312_c, hitMOP.field_72309_d);
            Block block = Block.field_71973_m[id];
            if (block instanceof IShearable) {
                IShearable target = (IShearable)block;
                if (target.isShearable(this.shootingItem, world, hitMOP.field_72311_b, hitMOP.field_72312_c, hitMOP.field_72309_d) && !world.field_72995_K) {
                    ArrayList drops = target.onSheared(this.shootingItem, world, hitMOP.field_72311_b, hitMOP.field_72312_c, hitMOP.field_72309_d, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.shootingItem));
                    Random rand = new Random();
                    for (ItemStack stack : drops) {
                        float f = 0.7f;
                        double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        EntityItem entityitem = new EntityItem(world, (double)hitMOP.field_72311_b + d, (double)hitMOP.field_72312_c + d1, (double)hitMOP.field_72309_d + d2, stack);
                        entityitem.field_70293_c = 10;
                        world.func_72838_d((Entity)entityitem);
                    }
                    if (this.shootingEntity instanceof EntityPlayer) {
                        ((EntityPlayer)this.shootingEntity).func_71064_a(StatList.field_75934_C[id], 1);
                    }
                }
                world.func_94578_a(hitMOP.field_72311_b, hitMOP.field_72312_c, hitMOP.field_72309_d, true);
            } else {
                this.func_70076_C();
            }
        } else if (hitMOP.field_72313_a == EnumMovingObjectType.ENTITY && hitMOP.field_72308_g != this.shootingEntity) {
            if (hitMOP.field_72308_g instanceof IShearable) {
                IShearable target = (IShearable)hitMOP.field_72308_g;
                Entity entity = hitMOP.field_72308_g;
                if (target.isShearable(this.shootingItem, entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
                    ArrayList drops = target.onSheared(this.shootingItem, entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.shootingItem));
                    Random rand = new Random();
                    for (ItemStack drop : drops) {
                        EntityItem ent = entity.func_70099_a(drop, 1.0f);
                        ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                        ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                        ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    }
                }
            } else {
                hitMOP.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.shootingEntity), (float)((int)this.damage));
            }
        }
    }
}

