/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PickaxeModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_PICKAXE = "Pickaxe";
    public static final ItemStack ironPickaxe = new ItemStack(Item.field_77696_g);
    public static final String PICKAXE_HARVEST_SPEED = "Pickaxe Harvest Speed";
    public static final String PICKAXE_ENERGY_CONSUMPTION = "Pickaxe Energy Consumption";

    public PickaxeModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(Item.field_77703_o, 3));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(PICKAXE_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(PICKAXE_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", PICKAXE_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", PICKAXE_HARVEST_SPEED, 22.0);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_PICKAXE;
    }

    @Override
    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)"module.pickaxe.name");
    }

    @Override
    public String getDescription() {
        return "Picks are good for harder materials like stone and ore.";
    }

    @Override
    public String getTextureFile() {
        return "toolpick";
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, Block block, int meta, EntityPlayer player) {
        return PickaxeModule.harvestCheck(stack, block, meta, player);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World world, int blockID, int x, int y, int z, EntityPlayer player) {
        Block block = Block.field_71973_m[blockID];
        int meta = world.func_72805_g(x, y, z);
        if (this.canHarvestBlock(stack, block, meta, player)) {
            ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(stack, PICKAXE_ENERGY_CONSUMPTION));
            return true;
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.newSpeed = (float)((double)event.newSpeed * ModuleManager.computeModularProperty(event.entityPlayer.func_71045_bC(), PICKAXE_HARVEST_SPEED));
    }

    public static boolean harvestCheck(ItemStack stack, Block block, int meta, EntityPlayer player) {
        return (ironPickaxe.func_77987_b(block) || ForgeHooks.canToolHarvestBlock((Block)block, (int)meta, (ItemStack)ironPickaxe)) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, PICKAXE_ENERGY_CONSUMPTION);
    }
}

