/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.tick;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.gui.EnergyMeter;
import net.machinemuse.general.gui.HeatMeter;
import net.machinemuse.powersuits.block.BlockTinkerTable;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.event.ThaumRenderEventHandler;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MuseStringUtils;
import net.machinemuse.utils.render.GlowBuffer;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;

public class RenderTickHandler
implements ITickHandler {
    protected static HeatMeter heat;
    protected static HeatMeter energy;
    private int lightningCounter = 0;

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        if (Config.canUseShaders) {
            GlowBuffer.clear();
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && MuseItemUtils.modularItemsEquipped((EntityPlayer)player).size() > 0 && Minecraft.func_71410_x().field_71462_r == null) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution screen = new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
            this.drawMeters((EntityPlayer)player, screen);
            this.drawGogglesHUD((EntityPlayer)player, mc, ((Float)tickData[0]).floatValue());
        }
    }

    private void drawMeters(EntityPlayer player, ScaledResolution screen) {
        double currEnergy = ElectricItemUtils.getPlayerEnergy(player);
        double maxEnergy = ElectricItemUtils.getMaxEnergy(player);
        double currHeat = MuseHeatUtils.getPlayerHeat(player);
        double maxHeat = MuseHeatUtils.getMaxHeat(player);
        if (maxEnergy > 0.0 && BlockTinkerTable.energyIcon != null) {
            String currStr = MuseStringUtils.formatNumberShort(currEnergy);
            String maxStr = MuseStringUtils.formatNumberShort(maxEnergy);
            String currHeatStr = MuseStringUtils.formatNumberShort(currHeat);
            String maxHeatStr = MuseStringUtils.formatNumberShort(maxHeat);
            if (Config.useGraphicalMeters()) {
                if (energy == null) {
                    energy = new EnergyMeter();
                    heat = new HeatMeter();
                }
                double left = screen.func_78326_a() - 20;
                double top = (double)screen.func_78328_b() / 2.0 - 16.0;
                energy.draw(left, top, currEnergy / maxEnergy);
                heat.draw(left + 8.0, top, currHeat / maxHeat);
                MuseRenderer.drawRightAlignedString(currStr, left - 2.0, top + 10.0);
                MuseRenderer.drawRightAlignedString(currHeatStr, left - 2.0, top + 20.0);
            } else {
                MuseRenderer.drawString(currStr + '/' + maxStr + " \u1d60", 1.0, 1.0);
                MuseRenderer.drawString(currHeatStr + '/' + maxHeatStr + " C", 1.0, 10.0);
            }
        }
    }

    private void drawGogglesHUD(EntityPlayer player, Minecraft mc, float partialTickTime) {
        if (ModCompatability.isThaumCraftLoaded() && ModCompatability.enableThaumGogglesModule() && player.func_82169_q(3) != null && player.func_82169_q(3).func_77973_b() instanceof IModularItem && ModuleManager.itemHasActiveModule(player.func_82169_q(3), "Aurameter")) {
            ThaumRenderEventHandler.renderGogglesHUD(partialTickTime, player, mc.field_71441_e.func_72820_D());
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.RENDER);
    }

    public String getLabel() {
        return "MMMPS: Render Tick";
    }
}

