/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.InventoryCraftingDummy;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class FireworkRecipeHandler
extends ShapelessRecipeHandler {
    private vk inventoryCrafting = new InventoryCraftingDummy();
    private zz recipeFireworks = new zz();
    public ArrayList<CachedFireworkRecipe> mfireworks = new ArrayList();

    public FireworkRecipeHandler() {
        this.stackorder = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};
        this.loadAllFireworks();
    }

    private void loadAllFireworks() {
        yc[] shapes = new yc[]{null, yc.bG, yc.bs, yc.N, yc.bS};
        yc[] effects = new yc[]{null, yc.p, yc.aV};
        for (yc shape : shapes) {
            for (yc effect : effects) {
                this.genRecipe(yc.O, shape, effect, yc.aY, yc.aY, 0);
            }
        }
        this.genRecipe(yc.O, yc.aM, yc.bX, 2);
        this.genRecipe(yc.O, yc.O, yc.aM, yc.bX, 2);
        this.genRecipe(yc.O, yc.O, yc.O, yc.aM, yc.bX, 2);
        for (int i = 0; i < 9; ++i) {
            this.inventoryCrafting.a(i, null);
        }
        this.inventoryCrafting.a(0, new ye(yc.O));
        this.inventoryCrafting.a(1, new ye(yc.aY));
        this.recipeFireworks.a(this.inventoryCrafting, null);
        ye charge = this.recipeFireworks.a(null);
        this.genRecipe(charge, yc.aY, yc.aY, 1);
    }

    private void genRecipe(Object ... params) {
        int i;
        int numIngreds = 0;
        for (i = 0; i < params.length - 2; ++i) {
            if (params[i] == null) continue;
            ++numIngreds;
        }
        for (i = 0; i < params.length - 1; ++i) {
            if (!(params[i] instanceof yc)) continue;
            params[i] = new ye((yc)params[i], 1, Short.MAX_VALUE);
        }
        Object[] ingreds = new Object[numIngreds];
        int j = 0;
        for (int i2 = 0; i2 < params.length - 2; ++i2) {
            if (params[i2] == null) continue;
            ingreds[j++] = params[i2];
        }
        this.mfireworks.add(new CachedFireworkRecipe(ingreds, params[params.length - 2], (Integer)params[params.length - 1]));
    }

    @Override
    public void loadCraftingRecipes(ye result) {
        for (CachedFireworkRecipe recipe : this.mfireworks) {
            if (recipe.result.item.d != result.d) continue;
            recipe.cycle();
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && this.getClass() == FireworkRecipeHandler.class) {
            this.arecipes.addAll(this.mfireworks);
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadUsageRecipes(ye ingredient) {
        for (CachedFireworkRecipe recipe : this.mfireworks) {
            if (!recipe.contains((Collection<PositionedStack>)recipe.ingredients, ingredient)) continue;
            recipe.cycle();
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void onUpdate() {
        if (!NEIClientUtils.shiftKey()) {
            ++this.cycleticks;
            if (this.cycleticks % 20 == 0) {
                for (TemplateRecipeHandler.CachedRecipe crecipe : this.arecipes) {
                    ((CachedFireworkRecipe)crecipe).cycle();
                }
            }
        }
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.firework", new Object[0]);
    }

    @Override
    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        currenttip = super.handleTooltip(gui, currenttip, recipe);
        Point mousepos = GuiDraw.getMousePosition();
        Point relMouse = new Point(mousepos.x - gui.p, mousepos.y - gui.q);
        Point recipepos = gui.getRecipePosition(recipe);
        if (currenttip.isEmpty() && gui.manager.getStackMouseOver() == null && new Rectangle(recipepos.x, recipepos.y, 166, 55).contains(relMouse)) {
            currenttip.add(NEIClientUtils.translate("recipe.firework.tooltip" + ((CachedFireworkRecipe)this.arecipes.get((int)recipe)).recipeType, new Object[0]));
        }
        return currenttip;
    }

    public class CachedFireworkRecipe
    extends ShapelessRecipeHandler.CachedShapelessRecipe {
        LinkedList<Object> itemList;
        public Object[] baseIngredients;
        public Object extraIngred;
        public int recipeType;

        public CachedFireworkRecipe(Object[] base, Object extra, int type) {
            super((ShapelessRecipeHandler)FireworkRecipeHandler.this, new ye(yc.bW));
            this.itemList = new LinkedList();
            this.baseIngredients = base;
            this.extraIngred = extra;
            this.recipeType = type;
            this.cycle();
        }

        public void cycle() {
            this.itemList.clear();
            for (Object obj : this.baseIngredients) {
                this.itemList.add(obj);
            }
            int extras = FireworkRecipeHandler.this.cycleticks / 40 % (10 - this.itemList.size());
            for (int i = 0; i < extras; ++i) {
                this.itemList.add(this.extraIngred);
            }
            this.setIngredients(this.itemList);
            List<PositionedStack> ingreds = this.getIngredients();
            for (int i = 0; i < 9; ++i) {
                FireworkRecipeHandler.this.inventoryCrafting.a(i, i < ingreds.size() ? ingreds.get((int)i).item : null);
            }
            if (!FireworkRecipeHandler.this.recipeFireworks.a(FireworkRecipeHandler.this.inventoryCrafting, null)) {
                throw new RuntimeException("Invalid Recipe?");
            }
            this.setResult(FireworkRecipeHandler.this.recipeFireworks.a(null));
        }
    }
}

