/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core;

import com.google.common.primitives.Ints;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import micdoodle8.mods.galacticraft.core.GCLog;
import net.minecraft.block.Block;
import net.minecraftforge.common.Configuration;

public class GCCoreConfigManager {
    public static boolean loaded;
    static Configuration configuration;
    public static int idDimensionOverworldOrbit;
    public static int idDimensionOverworldOrbitStatic;
    public static int idBlockBreatheableAir;
    public static int idBlockTreasureChest;
    public static int idBlockLandingPad;
    public static int idBlockLandingPadFull;
    public static int idBlockUnlitTorch;
    public static int idBlockUnlitTorchLit;
    public static int idBlockAirDistributor;
    public static int idBlockAirPipe;
    public static int idBlockAirCollector;
    public static int idBlockSapling2;
    public static int idBlockRocketBench;
    public static int idBlockFallenMeteor;
    public static int idBlockDecorationBlock;
    public static int idBlockAirLockFrame;
    public static int idBlockAirLockSeal;
    public static int idBlockCrudeOilStill;
    public static int idBlockRefinery;
    public static int idBlockAirCompressor;
    public static int idBlockFuelLoader;
    public static int idBlockSpaceStationBase;
    public static int idBlockDummy;
    public static int idBlockOxygenSealer;
    public static int idBlockEnclosedWire;
    public static int idBlockOxygenDetector;
    public static int idBlockCargoLoader;
    public static int idBlockParachest;
    public static int idBlockSolarPanel;
    public static int idBlockBasicMachine;
    public static int idBlockCopperWire;
    public static int idBlockBasicMachine2;
    public static int idBlockGlowstoneTorch;
    public static int idBlockFuel;
    public static int idItemKnowledgeBook;
    public static int idItemLightOxygenTank;
    public static int idItemMedOxygenTank;
    public static int idItemHeavyOxygenTank;
    public static int idItemSpaceship;
    public static int idItemIngotTitanium;
    public static int idItemIngotCopper;
    public static int idItemIngotAluminum;
    public static int idItemTinCanister;
    public static int idItemAirVent;
    public static int idItemOxygenConcentrator;
    public static int idItemFan;
    public static int idItemGravityBow;
    public static int idItemRocketEngine;
    public static int idItemHeavyPlate;
    public static int idItemRocketNoseCone;
    public static int idItemRocketFins;
    public static int idItemSensorLens;
    public static int idItemBuggy;
    public static int idItemFlag;
    public static int idItemOxygenGear;
    public static int idItemCanvas;
    public static int idItemParachute;
    public static int idItemRocketFuelBucket;
    public static int idItemFlagPole;
    public static int idItemOilCanister;
    public static int idItemOilExtractor;
    public static int idItemSchematic;
    public static int idItemKey;
    public static int idItemBuggyMaterial;
    public static int idItemBasic;
    public static int idItemBattery;
    public static int idItemInfiniteBattery;
    public static int idItemMeteorChunk;
    public static int idItemStandardWrench;
    public static int idSchematicRocketT1;
    public static int idSchematicMoonBuggy;
    public static int idSchematicAddSchematic;
    public static int idArmorOxygenMask;
    public static int idArmorSensorGlasses;
    public static int idArmorSteelHelmet;
    public static int idArmorSteelChestplate;
    public static int idArmorSteelLeggings;
    public static int idArmorSteelBoots;
    public static int idToolSteelSword;
    public static int idToolSteelPickaxe;
    public static int idToolSteelAxe;
    public static int idToolSteelSpade;
    public static int idToolSteelHoe;
    public static int idGuiRocketCraftingBench;
    public static int idGuiBuggyCraftingBench;
    public static int idGuiGalaxyMap;
    public static int idGuiSpaceshipInventory;
    public static int idGuiAddSchematic;
    public static int idGuiKnowledgeBook;
    public static int idGuiExtendedInventory;
    public static int idAchievBase;
    public static int idEntityEvolvedSpider;
    public static int idEntityEvolvedCreeper;
    public static int idEntityEvolvedZombie;
    public static int idEntityEvolvedSkeleton;
    public static int idEntityEvolvedSkeletonBoss;
    public static int idEntitySpaceship;
    public static int idEntityAntiGravityArrow;
    public static int idEntityMeteor;
    public static int idEntityBuggy;
    public static int idEntityFlag;
    public static int idEntityAstroOrb;
    public static int idEntityParaChest;
    public static int idEntityAlienVillager;
    public static int idEntityOxygenBubble;
    public static int idEntityLander;
    public static int idEntityLanderChest;
    public static int idEntityMeteorChunk;
    public static boolean moreStars;
    public static boolean wasdMapMovement;
    public static String[] sealableIDs;
    public static String[] detectableIDs;
    public static boolean disableSpaceshipParticles;
    public static boolean disableSpaceshipGrief;
    public static boolean oxygenIndicatorLeft;
    public static boolean oxygenIndicatorBottom;
    public static double oilGenFactor;
    public static boolean disableLeafDecay;
    public static boolean spaceStationsRequirePermission;
    public static boolean disableSpaceStationCreation;
    public static boolean overrideCapes;
    public static double spaceStationEnergyScalar;
    public static boolean disableLander;
    public static double dungeonBossHealthMod;
    public static int suffocationCooldown;
    public static int suffocationDamage;
    public static int[] externalOilGen;
    public static boolean forceOverworldRespawn;
    public static boolean enableDebug;
    public static boolean enableCopperOreGen;
    public static boolean enableTinOreGen;
    public static boolean enableAluminumOreGen;
    public static boolean enableSiliconOreGen;
    public static int[] staticLoadDimensions;
    public static boolean enableSealerMultithreading;
    public static boolean enableSealerEdgeChecks;
    public static boolean alternateCanisterRecipe;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultValues(File file) {
        if (!loaded) {
            configuration = new Configuration(file);
        }
        try {
            configuration.load();
            idDimensionOverworldOrbit = configuration.get("DIMENSIONS", "idDimensionOverworldOrbit", -27).getInt(-27);
            idDimensionOverworldOrbitStatic = configuration.get("DIMENSIONS", "idDimensionOverworldOrbitStatic", -26, "Static Space Station ID").getInt(-26);
            staticLoadDimensions = configuration.get("DIMENSIONS", "Static Loaded Dimensions", staticLoadDimensions, "IDs to load at startup, and keep loaded until server stops. Can be added via /gckeeploaded").getIntList();
            idBlockBreatheableAir = configuration.get("block", "idBlockCoreBreatheableAir", 3350).getInt(3350);
            idBlockLandingPad = configuration.get("block", "idBlockLandingPad", 3351).getInt(3351);
            idBlockLandingPadFull = configuration.get("block", "idBlockLandingPadFull", 3352).getInt(3352);
            idBlockUnlitTorch = configuration.get("block", "idBlockUnlitTorch", 3353).getInt(3353);
            idBlockUnlitTorchLit = configuration.get("block", "idBlockUnlitTorchLit", 3354).getInt(3354);
            idBlockAirDistributor = configuration.get("block", "idBlockAirDistributor", 3355).getInt(3355);
            idBlockAirCompressor = configuration.get("block", "idBlockAirCompressor", 3356).getInt(3356);
            idBlockAirCollector = configuration.get("block", "idBlockAirCollector", 3357).getInt(3357);
            idBlockRefinery = configuration.get("block", "idBlockRefinery", 3358).getInt(3358);
            idBlockFuelLoader = configuration.get("block", "idBlockFuelLoader", 3359).getInt(3359);
            idBlockOxygenSealer = configuration.get("block", "idBlockOxygenSealer", 3360).getInt(3360);
            idBlockOxygenDetector = configuration.get("block", "idBlockOxygenDetector", 3361).getInt(3361);
            idBlockCargoLoader = configuration.get("block", "idBlockCargoLoader", 3362).getInt(3362);
            idBlockAirPipe = configuration.get("block", "idBlockAirPipe", 3368).getInt(3368);
            idBlockSapling2 = configuration.get("block", "idBlockSapling2", 3369).getInt(3369);
            idBlockRocketBench = configuration.get("block", "idBlockRocketBench", 3370).getInt(3370);
            idBlockFallenMeteor = configuration.get("block", "idBlockFallenMeteor", 3371).getInt(3371);
            idBlockDecorationBlock = configuration.get("block", "idBlockDecorationBlock", 3372).getInt(3372);
            idBlockAirLockFrame = configuration.get("block", "idBlockAirLockFrame", 3373).getInt(3373);
            idBlockAirLockSeal = configuration.get("block", "idBlockAirLockSeal", 3374).getInt(3374);
            idBlockCrudeOilStill = configuration.get("block", "idBlockCrudeOilStill", 3377).getInt(3377);
            idBlockDummy = configuration.get("block", "idBlockDummy", 3378).getInt(3378);
            idBlockEnclosedWire = configuration.get("block", "idBlockEnclosedWire", 3379).getInt(3379);
            idBlockSpaceStationBase = configuration.get("block", "idBlockSpaceStationBase", 3380, "Even though this will be generated, it can use block IDs greater than 256").getInt(3380);
            idBlockTreasureChest = configuration.get("block", "idBlockTieredTreasureChest", 3381, "Even though this will be generated, it can use block IDs greater than 256").getInt(3381);
            idBlockParachest = configuration.get("block", "idBlockParachest", 3382).getInt(3382);
            idBlockSolarPanel = configuration.get("block", "idBlockSolarPanel", 3383).getInt(3383);
            idBlockCopperWire = configuration.get("block", "idBlockCopperWire", 3972).getInt(3972);
            idBlockBasicMachine = configuration.get("block", "idBlockMachineB", 3363).getInt(3363);
            idBlockBasicMachine2 = configuration.get("block", "idBlockMachineB2", 3364).getInt(3364);
            idBlockGlowstoneTorch = configuration.get("block", "idBlockGlowstoneTorch", 3384).getInt(3384);
            idBlockFuel = configuration.get("block", "idBlockFuel", 3385).getInt(3385);
            idItemSpaceship = configuration.get("item", "idItemSpaceship", 9855).getInt(9855);
            idItemLightOxygenTank = configuration.get("item", "idItemLightOxygenTank", 9856).getInt(9856);
            idItemMedOxygenTank = configuration.get("item", "idItemMedOxygenTank", 9857).getInt(9857);
            idItemHeavyOxygenTank = configuration.get("item", "idItemHeavyOxygenTank", 9858).getInt(9858);
            idArmorOxygenMask = configuration.get("item", "idArmorOxygenMask", 9859).getInt(9859);
            idArmorSensorGlasses = configuration.get("item", "idArmorSensorGlasses", 9860).getInt(9860);
            idItemTinCanister = configuration.get("item", "idItemCanister", 9861).getInt(9861);
            idItemAirVent = configuration.get("item", "idItemAirVent", 9862).getInt(9862);
            idItemOxygenConcentrator = configuration.get("item", "idItemOxygenConcentrator", 9863).getInt(9863);
            idItemFan = configuration.get("item", "idItemFan", 9864).getInt(9864);
            idItemGravityBow = configuration.get("item", "idItemGravityBow", 9865).getInt(9865);
            idItemRocketEngine = configuration.get("item", "idItemRocketEngine", 9866).getInt(9866);
            idItemHeavyPlate = configuration.get("item", "idItemHeavyPlate", 9867).getInt(9867);
            idItemRocketNoseCone = configuration.get("item", "idItemRocketNoseCone", 9868).getInt(9868);
            idItemRocketFins = configuration.get("item", "idItemRocketFins", 9869).getInt(9869);
            idItemSensorLens = configuration.get("item", "idItemSensorLens", 9870).getInt(9870);
            idItemBuggy = configuration.get("item", "idItemBuggyPlacer", 9871).getInt(9871);
            idItemFlagPole = configuration.get("item", "idItemFlagPole", 9872).getInt(9872);
            idItemFlag = configuration.get("item", "idItemFlagPlacer", 9873).getInt(9873);
            idItemOxygenGear = configuration.get("item", "idItemOxygenGear", 9874).getInt(9874);
            idItemCanvas = configuration.get("item", "idItemCanvas", 9875).getInt(9875);
            idItemParachute = configuration.get("item", "idItemParachute", 9876).getInt(9876);
            idItemOilExtractor = configuration.get("item", "idItemOilExtractor", 9877).getInt(9877);
            idItemOilCanister = configuration.get("item", "idItemOilCanister", 9878).getInt(9878);
            idItemRocketFuelBucket = configuration.get("item", "idItemRocketFuelCanister", 9879).getInt(9879);
            idItemKnowledgeBook = configuration.get("item", "idItemKnowledgeBook", 9881).getInt(9881);
            idItemSchematic = configuration.get("item", "idItemSchematic", 9882).getInt(9882);
            idItemKey = configuration.get("item", "idItemKey", 9883).getInt(9883);
            idItemBuggyMaterial = configuration.get("item", "idItemBuggyMaterial", 9884).getInt(9884);
            idItemBasic = configuration.get("item", "idItemBasic", 9894).getInt(9894);
            idItemBattery = configuration.get("item", "idItemBattery", 13970).getInt(13970);
            idItemInfiniteBattery = configuration.get("item", "idItemInfiniteBattery", 13971).getInt(13971);
            idItemMeteorChunk = configuration.get("item", "idItemMeteorChunk", 9895).getInt(9895);
            idItemStandardWrench = configuration.get("item", "idItemStandardWrench", 9896).getInt(9896);
            idToolSteelSword = configuration.get("item", "idToolSteelSword", 9885).getInt(9885);
            idToolSteelPickaxe = configuration.get("item", "idToolSteelPickaxe", 9886).getInt(9886);
            idToolSteelSpade = configuration.get("item", "idToolSteelSpade", 9887).getInt(9887);
            idToolSteelHoe = configuration.get("item", "idToolSteelHoe", 9888).getInt(9888);
            idToolSteelAxe = configuration.get("item", "idToolSteelAxe", 9889).getInt(9889);
            idArmorSteelHelmet = configuration.get("item", "idArmorSteelHelmet", 9890).getInt(9890);
            idArmorSteelChestplate = configuration.get("item", "idArmorSteelChestplate", 9891).getInt(9891);
            idArmorSteelLeggings = configuration.get("item", "idArmorSteelLeggings", 9892).getInt(9892);
            idArmorSteelBoots = configuration.get("item", "idArmorSteelBoots", 9893).getInt(9893);
            idGuiRocketCraftingBench = configuration.get("GUI", "idGuiRocketCraftingBench", 130).getInt(130);
            idGuiBuggyCraftingBench = configuration.get("GUI", "idGuiBuggyCraftingBench", 131).getInt(131);
            idGuiGalaxyMap = configuration.get("GUI", "idGuiGalaxyMap", 132).getInt(132);
            idGuiSpaceshipInventory = configuration.get("GUI", "idGuiSpaceshipInventory", 133).getInt(133);
            idGuiAddSchematic = configuration.get("GUI", "idGuiAddSchematic", 138).getInt(138);
            idGuiKnowledgeBook = configuration.get("GUI", "idGuiKnowledgeBook", 140).getInt(140);
            idGuiExtendedInventory = configuration.get("GUI", "idGuiExtendedInventory", 145).getInt(145);
            idSchematicRocketT1 = configuration.get("Schematic", "idSchematicRocketT1", 0).getInt(0);
            idSchematicMoonBuggy = configuration.get("Schematic", "idSchematicMoonBuggy", 1).getInt(1);
            idSchematicAddSchematic = configuration.get("Schematic", "idSchematicAddSchematic", Integer.MAX_VALUE).getInt(Integer.MAX_VALUE);
            idAchievBase = configuration.get("Achievements", "idAchievBase", 1784).getInt(1784);
            idEntityEvolvedSpider = configuration.get("Entities", "idEntityEvolvedSpider", 155).getInt(155);
            idEntityEvolvedCreeper = configuration.get("Entities", "idEntityEvolvedCreeper", 156).getInt(156);
            idEntityEvolvedZombie = configuration.get("Entities", "idEntityEvolvedZombie", 157).getInt(157);
            idEntityEvolvedSkeleton = configuration.get("Entities", "idEntityEvolvedSkeleton", 158).getInt(158);
            idEntitySpaceship = configuration.get("Entities", "idEntitySpaceship", 159).getInt(159);
            idEntityAntiGravityArrow = configuration.get("Entities", "idEntityAntiGravityArrow", 160).getInt(160);
            idEntityMeteor = configuration.get("Entities", "idEntityMeteor", 161).getInt(161);
            idEntityBuggy = configuration.get("Entities", "idEntityBuggy", 162).getInt(162);
            idEntityFlag = configuration.get("Entities", "idEntityFlag", 163).getInt(163);
            idEntityAstroOrb = configuration.get("Entities", "idEntityAstroOrb", 164).getInt(164);
            idEntityParaChest = configuration.get("Entities", "idEntityParaChest", 165).getInt(165);
            idEntityAlienVillager = configuration.get("Entities", "idEntityAlienVillager", 166).getInt(166);
            idEntityOxygenBubble = configuration.get("Entities", "idEntityOxygenBubble", 167).getInt(167);
            idEntityLander = configuration.get("Entities", "idEntityLander", 168).getInt(168);
            idEntityLanderChest = configuration.get("Entities", "idEntityLanderChest", 169).getInt(169);
            idEntityEvolvedSkeletonBoss = configuration.get("Entities", "idEntityEvolvedSkeletonBoss", 170).getInt(170);
            idEntityMeteorChunk = configuration.get("Entities", "idEntityMeteorChunk", 179).getInt(179);
            moreStars = configuration.get("general", "More Stars", true, "Setting this to false will revert night skies back to default minecraft star count").getBoolean(true);
            wasdMapMovement = configuration.get("general", "WASD Map Movement", true, "If you prefer to move the Galaxy map with your mouse, set to false").getBoolean(true);
            oilGenFactor = configuration.get("general", "Oil Generation Factor", 1.8, "Increasing this will increase amount of oil that will generate in each chunk.").getDouble(1.8);
            disableSpaceshipParticles = configuration.get("general", "Disable Spaceship Particles", false, "If you have FPS problems, setting this to true will help if spaceship particles are in your sights").getBoolean(false);
            disableSpaceshipGrief = configuration.get("general", "Disable Spaceship Explosion", false, "Spaceships will not explode on contact if set to true").getBoolean(false);
            oxygenIndicatorLeft = configuration.get("general", "Minimap Left", false, "If true, this will move the Oxygen Indicator to the left side. You can combine this with \"Minimap Bottom\"").getBoolean(false);
            oxygenIndicatorBottom = configuration.get("general", "Minimap Bottom", false, "If true, this will move the Oxygen Indicator to the bottom. You can combine this with \"Minimap Left\"").getBoolean(false);
            disableLeafDecay = configuration.get("general", "Disable Oxygen Collector Leaf Decay", false, "If set to true, Oxygen Collectors will not consume leaf blocks.").getBoolean(false);
            spaceStationsRequirePermission = configuration.get("general", "Space Stations Require Permission", true, "While true, space stations require you to invite other players using /ssinvite <playername>").getBoolean(true);
            disableSpaceStationCreation = configuration.get("general", "Disable Space Station creation", false, "If set to true on a server, players will be completely unable to create space stations.").getBoolean(false);
            overrideCapes = configuration.get("general", "Override Capes", true, "By default, Galacticraft will override capes with the mod's donor cape. Set to false to disable.").getBoolean(true);
            spaceStationEnergyScalar = configuration.get("general", "Space Station Solar Energy Multiplier", 2.0, "If Mekanism is installed, solar panels will work (default 2x) more effective on space stations.").getDouble(2.0);
            sealableIDs = configuration.get("general", "External Sealable IDs", new String[]{String.valueOf(Block.field_72003_bq.field_71990_ca + ":0")}, "List IDs of non-opaque blocks from other mods (for example, special types of glass) that the Oxygen Sealer should recognize as solid seals. Format is ID:METADATA").getStringList();
            detectableIDs = configuration.get("general", "External Detectable IDs", new String[]{String.valueOf(Block.field_71950_I.field_71990_ca + ":0"), String.valueOf(Block.field_72073_aw.field_71990_ca + ":0"), String.valueOf(Block.field_71941_G.field_71990_ca + ":0"), String.valueOf(Block.field_71949_H.field_71990_ca + ":0"), String.valueOf(Block.field_71947_N.field_71990_ca + ":0"), String.valueOf(Block.field_72047_aN.field_71990_ca + ":0"), String.valueOf(Block.field_72048_aO.field_71990_ca + ":0")}, "List IDs from other mods that the Sensor Glasses should recognize as solid blocks. Format is ID:METADATA").getStringList();
            dungeonBossHealthMod = configuration.get("general", "Dungeon Boss Health Modifier", 1.0, "Change this is you wish to balance the mod (if you have more powerful weapon mods)").getDouble(1.0);
            suffocationCooldown = configuration.get("general", "Suffocation Cooldown", 100, "Lower/Raise this value to change time between suffocation damage ticks").getInt(100);
            suffocationDamage = configuration.get("general", "Suffocation Damage", 2, "Change this value to modify the damage taken per suffocation tick").getInt(2);
            externalOilGen = configuration.get("general", "Oil gen in external dimensions", new int[]{0}, "List of non-galacticraft dimension IDs to generate oil in").getIntList();
            forceOverworldRespawn = configuration.get("general", "Force Overworld Spawn", false, "By default, you will respawn on galacticraft dimensions if you die. If you set this to true, you will respawn back on earth.").getBoolean(false);
            enableDebug = configuration.get("general", "Enable Debug Messages", false, "If this is enabled, debug messages will appear in the console. This is useful for finding bugs in the mod.").getBoolean(false);
            enableSealerMultithreading = configuration.get("general", "Enable Sealer Multithreading", false, "(Experimental) If this is enabled, Oxygen Sealers seal checks will run in a separate thread - faster but there may be some artifacts.").getBoolean(false);
            enableSealerEdgeChecks = configuration.get("general", "Enable Sealed edge checks", true, "If this is enabled, areas sealed by Oxygen Sealers will run a seal check when the player breaks or places a block (or on block updates).  This should be enabled for a 100% accurate sealed status is accurate, but can be disabled on servers for performance reasons.").getBoolean(true);
            enableCopperOreGen = configuration.get("general", "Enable Copper Ore Gen", true, "If this is enabled, copper ore will generate on the overworld.").getBoolean(true);
            enableTinOreGen = configuration.get("general", "Enable Tin Ore Gen", true, "If this is enabled, tin ore will generate on the overworld.").getBoolean(true);
            enableAluminumOreGen = configuration.get("general", "Enable Aluminum Ore Gen", true, "If this is enabled, aluminum ore will generate on the overworld.").getBoolean(true);
            enableSiliconOreGen = configuration.get("general", "Enable Silicon Ore Gen", true, "If this is enabled, silicon ore will generate on the overworld.").getBoolean(true);
            alternateCanisterRecipe = configuration.get("general", "Alternate recipe for canisters", false, "Enable this if the standard canister recipe causes a conflict.").getBoolean(false);
        }
        catch (Exception e) {
            GCLog.severe("Problem loading core config (\"core.conf\")");
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
            loaded = true;
        }
    }

    public static boolean setLoaded(int newID) {
        boolean found = false;
        for (int staticLoadDimension : staticLoadDimensions) {
            if (staticLoadDimension != newID) continue;
            found = true;
            break;
        }
        if (!found) {
            int[] oldIDs = staticLoadDimensions;
            staticLoadDimensions = new int[staticLoadDimensions.length + 1];
            for (int i = 0; i < oldIDs.length; ++i) {
                GCCoreConfigManager.staticLoadDimensions[i] = oldIDs[i];
            }
            GCCoreConfigManager.staticLoadDimensions[GCCoreConfigManager.staticLoadDimensions.length - 1] = newID;
            String[] values = new String[staticLoadDimensions.length];
            Arrays.sort(staticLoadDimensions);
            for (int i = 0; i < values.length; ++i) {
                values[i] = String.valueOf(staticLoadDimensions[i]);
            }
            configuration.get("DIMENSIONS", "Static Loaded Dimensions", staticLoadDimensions, "IDs to load at startup, and keep loaded until server stops. Can be added via /gckeeploaded").set(values);
            configuration.save();
        }
        return !found;
    }

    public static boolean setUnloaded(int idToRemove) {
        int foundCount = 0;
        for (int staticLoadDimension : staticLoadDimensions) {
            if (staticLoadDimension != idToRemove) continue;
            ++foundCount;
        }
        if (foundCount > 0) {
            ArrayList idArray = new ArrayList(Ints.asList((int[])staticLoadDimensions));
            idArray.removeAll(Collections.singleton(idToRemove));
            staticLoadDimensions = new int[idArray.size()];
            for (int i = 0; i < idArray.size(); ++i) {
                GCCoreConfigManager.staticLoadDimensions[i] = (Integer)idArray.get(i);
            }
            String[] values = new String[staticLoadDimensions.length];
            Arrays.sort(staticLoadDimensions);
            for (int i = 0; i < values.length; ++i) {
                values[i] = String.valueOf(staticLoadDimensions[i]);
            }
            configuration.get("DIMENSIONS", "Static Loaded Dimensions", staticLoadDimensions, "IDs to load at startup, and keep loaded until server stops. Can be added via /gckeeploaded").set(values);
            configuration.save();
        }
        return foundCount > 0;
    }

    static {
        staticLoadDimensions = new int[0];
    }
}

