/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class GCCoreBlockFluid
extends BlockFluidClassic {
    private Icon stillIcon;
    private Icon flowingIcon;
    private final String fluidName;
    private final Fluid fluid;

    public GCCoreBlockFluid(int id, Fluid fluid, String assetName) {
        super(id, fluid, Material.field_76244_g);
        this.setRenderPass(1);
        this.fluidName = assetName;
        this.fluid = fluid;
        if (assetName.equals("oil")) {
            this.field_72028_cf = true;
        }
    }

    public CreativeTabs func_71882_w() {
        return GalacticraftCore.galacticraftTab;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int par1, int par2) {
        return par1 == 0 ? this.stillIcon : this.flowingIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.stillIcon = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + this.fluidName + "_still");
        this.flowingIcon = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + this.fluidName + "_flow");
        this.fluid.setStillIcon(this.stillIcon);
        this.fluid.setFlowingIcon(this.flowingIcon);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int x, int y, int z, Random rand) {
        super.func_71862_a(world, x, y, z, rand);
        if (this.fluidName.equals("oil") && rand.nextInt(1200) == 0) {
            world.func_72980_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "liquid.lava", rand.nextFloat() * 0.25f + 0.75f, 1.0E-5f + rand.nextFloat() * 0.5f, false);
        }
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_72803_f(x, y, z).func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_72803_f(x, y, z).func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }

    public Icon getStillIcon() {
        return this.stillIcon;
    }

    public Icon getFlowingIcon() {
        return this.flowingIcon;
    }
}

