/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockTile;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityCoalGenerator;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectricFurnace;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityIngotCompressor;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class GCCoreBlockMachine
extends GCCoreBlockTile {
    public static final int COAL_GENERATOR_METADATA = 0;
    public static final int STORAGE_MODULE_METADATA = 4;
    public static final int ELECTRIC_FURNACE_METADATA = 8;
    public static final int COMPRESSOR_METADATA = 12;
    private Icon iconMachineSide;
    private Icon iconInput;
    private Icon iconOutput;
    private Icon iconCoalGenerator;
    private Icon[] iconEnergyStorageModule;
    private Icon iconElectricFurnace;
    private Icon iconCompressor;

    public GCCoreBlockMachine(int id, String assetName) {
        super(id, GCCoreBlocks.machine);
        this.func_71864_b("basicMachine");
        this.func_71848_c(1.0f);
        this.func_71884_a(Block.field_71977_i);
        this.func_111022_d(GalacticraftCore.ASSET_PREFIX + assetName);
        this.func_71864_b(assetName);
    }

    public CreativeTabs func_71882_w() {
        return GalacticraftCore.galacticraftTab;
    }

    public int func_71857_b() {
        return GalacticraftCore.proxy.getBlockRenderID(this.field_71990_ca);
    }

    public void func_94332_a(IconRegister iconRegister) {
        this.field_94336_cN = iconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine");
        this.iconInput = iconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_input");
        this.iconOutput = iconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_output");
        this.iconMachineSide = iconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_side");
        this.iconCoalGenerator = iconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "coalGenerator");
        this.iconEnergyStorageModule = new Icon[17];
        for (int i = 0; i < this.iconEnergyStorageModule.length; ++i) {
            this.iconEnergyStorageModule[i] = iconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "energyStorageModule_" + i);
        }
        this.iconElectricFurnace = iconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "electricFurnace");
        this.iconCompressor = iconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "compressor");
    }

    public void func_71862_a(World par1World, int x, int y, int z, Random par5Random) {
        TileEntity tile = par1World.func_72796_p(x, y, z);
        if (tile instanceof GCCoreTileEntityCoalGenerator) {
            GCCoreTileEntityCoalGenerator tileEntity = (GCCoreTileEntityCoalGenerator)tile;
            if (tileEntity.generateWatts > 0.0f) {
                int metadata = par1World.func_72805_g(x, y, z);
                float var7 = (float)x + 0.5f;
                float var8 = (float)y + 0.0f + par5Random.nextFloat() * 6.0f / 16.0f;
                float var9 = (float)z + 0.5f;
                float var10 = 0.52f;
                float var11 = par5Random.nextFloat() * 0.6f - 0.3f;
                if (metadata == 3) {
                    par1World.func_72869_a("smoke", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (metadata == 2) {
                    par1World.func_72869_a("smoke", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (metadata == 1) {
                    par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                } else if (metadata == 0) {
                    par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= 4 && metadata < 8) {
            TileEntity tile = world.func_72796_p(x, y, z);
            metadata -= 4;
            if (side == 0 || side == 1) {
                return this.field_94336_cN;
            }
            if (side == metadata + 2) {
                return this.iconOutput;
            }
            if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
                return this.iconInput;
            }
            if (tile instanceof GCCoreTileEntityEnergyStorageModule) {
                return this.iconEnergyStorageModule[((GCCoreTileEntityEnergyStorageModule)tile).scaledEnergyLevel];
            }
            return this.iconEnergyStorageModule[0];
        }
        return this.func_71858_a(side, world.func_72805_g(x, y, z));
    }

    public Icon func_71858_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.field_94336_cN;
        }
        if (metadata >= 12) {
            if ((metadata -= 12) == 0 && side == 4 || metadata == 1 && side == 5 || metadata == 2 && side == 3 || metadata == 3 && side == 2) {
                return this.iconCompressor;
            }
        } else if (metadata >= 8) {
            if (side == (metadata -= 8) + 2) {
                return this.iconInput;
            }
            if (metadata == 0 && side == 4 || metadata == 1 && side == 5 || metadata == 2 && side == 3 || metadata == 3 && side == 2) {
                return this.iconElectricFurnace;
            }
        } else {
            if (metadata >= 4) {
                if (side == (metadata -= 4) + 2) {
                    return this.iconOutput;
                }
                if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
                    return this.iconInput;
                }
                return this.iconEnergyStorageModule[16];
            }
            if (side == metadata + 2) {
                return this.iconOutput;
            }
            if (metadata == 0 && side == 4 || metadata == 1 && side == 5 || metadata == 2 && side == 3 || metadata == 3 && side == 2) {
                return this.iconCoalGenerator;
            }
        }
        return this.iconMachineSide;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        if (metadata >= 12) {
            world.func_72921_c(x, y, z, 12 + change, 3);
        } else if (metadata >= 8) {
            world.func_72921_c(x, y, z, 8 + change, 3);
        } else if (metadata >= 4) {
            world.func_72921_c(x, y, z, 4 + change, 3);
        } else {
            world.func_72921_c(x, y, z, 0 + change, 3);
        }
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata;
        int original = metadata = par1World.func_72805_g(x, y, z);
        int change = 0;
        if (metadata >= 12) {
            original -= 12;
        } else if (metadata >= 8) {
            original -= 8;
        } else if (metadata >= 4) {
            original -= 4;
        }
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        if (metadata >= 12) {
            change += 12;
        } else if (metadata >= 8) {
            change += 8;
        } else if (metadata >= 4) {
            change += 4;
        }
        par1World.func_72921_c(x, y, z, change, 3);
        return true;
    }

    @Override
    public boolean onMachineActivated(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = par1World.func_72805_g(x, y, z);
        if (!par1World.field_72995_K) {
            if (metadata >= 12) {
                par5EntityPlayer.openGui((Object)GalacticraftCore.instance, -1, par1World, x, y, z);
                return true;
            }
            if (metadata >= 8) {
                par5EntityPlayer.openGui((Object)GalacticraftCore.instance, -1, par1World, x, y, z);
                return true;
            }
            if (metadata >= 4) {
                par5EntityPlayer.openGui((Object)GalacticraftCore.instance, -1, par1World, x, y, z);
                return true;
            }
            par5EntityPlayer.openGui((Object)GalacticraftCore.instance, -1, par1World, x, y, z);
            return true;
        }
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= 12) {
            return new GCCoreTileEntityIngotCompressor();
        }
        if (metadata >= 8) {
            return new GCCoreTileEntityElectricFurnace();
        }
        if (metadata >= 4) {
            return new GCCoreTileEntityEnergyStorageModule();
        }
        return new GCCoreTileEntityCoalGenerator();
    }

    public ItemStack getCompressor() {
        return new ItemStack(this.field_71990_ca, 1, 12);
    }

    public ItemStack getCoalGenerator() {
        return new ItemStack(this.field_71990_ca, 1, 0);
    }

    public ItemStack getEnergyStorageModule() {
        return new ItemStack(this.field_71990_ca, 1, 4);
    }

    public ItemStack getElectricFurnace() {
        return new ItemStack(this.field_71990_ca, 1, 8);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getCoalGenerator());
        par3List.add(this.getEnergyStorageModule());
        par3List.add(this.getElectricFurnace());
        par3List.add(this.getCompressor());
    }

    public int func_71899_b(int metadata) {
        if (metadata >= 12) {
            return 12;
        }
        if (metadata >= 8) {
            return 8;
        }
        if (metadata >= 4) {
            return 4;
        }
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Item item = Item.field_77698_e[this.field_71990_ca];
        if (item == null) {
            return null;
        }
        int metadata = this.func_71873_h(world, x, y, z);
        return new ItemStack(this.field_71990_ca, 1, metadata);
    }
}

