/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.entities.ISizeable;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenDistributor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class GCCoreEntityOxygenBubble
extends Entity
implements IPacketReceiver,
ISizeable {
    private float size;
    protected long ticks = 0L;
    public GCCoreTileEntityOxygenDistributor distributor;

    public GCCoreEntityOxygenBubble(World world, Vector3 mainBlockVec, GCCoreTileEntityOxygenDistributor distributor) {
        this(world);
        this.field_70165_t = mainBlockVec.x + 0.5;
        this.field_70163_u = mainBlockVec.y + 1.0;
        this.field_70161_v = mainBlockVec.z + 0.5;
        this.distributor = distributor;
    }

    public GCCoreEntityOxygenBubble(World world) {
        super(world);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    protected boolean func_70048_i(double par1, double par3, double par5) {
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70091_d(double par1, double par3, double par5) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.func_70107_b(par1, par3, par5);
        this.func_70101_b(par7, par8);
    }

    public void func_70030_z() {
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 1L;
        }
        ++this.ticks;
        if (this.distributor != null) {
            Vector3 vec = new Vector3(this.distributor);
            this.field_70165_t = vec.x + 0.5;
            this.field_70163_u = vec.y + 1.0;
            this.field_70161_v = vec.z + 0.5;
        }
        super.func_70030_z();
        TileEntity tileAt = this.field_70170_p.func_72796_p(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v));
        if (tileAt instanceof GCCoreTileEntityOxygenDistributor) {
            GCCoreTileEntityOxygenDistributor distributor;
            this.distributor = distributor = (GCCoreTileEntityOxygenDistributor)tileAt;
        }
        if (this.distributor != null && (this.distributor.oxygenBubble == null || this.distributor.oxygenBubble.equals(this)) && !this.field_70170_p.field_72995_K) {
            this.distributor.oxygenBubble = this;
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        if (tileAt == null && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && this.distributor != null) {
            this.size = this.distributor.getEnergyStored() > 0.0f && this.distributor.storedOxygen > this.distributor.oxygenPerTick ? (this.size += 0.01f) : (this.size -= 0.1f);
            this.size = Math.min(Math.max(this.size, 0.0f), 10.0f);
        }
        if (this.distributor != null) {
            Vector3 vec = new Vector3(this.distributor);
            this.field_70165_t = vec.x + 0.5;
            this.field_70163_u = vec.y + 1.0;
            this.field_70161_v = vec.z + 0.5;
        }
        if (!this.field_70170_p.field_72995_K && this.ticks % 5L == 0L) {
            GCCorePacketManager.sendPacketToClients(this.getDescriptionPacket(), this.field_70170_p, new Vector3(this), 50.0);
        }
    }

    public Packet getDescriptionPacket() {
        return GCCorePacketManager.getPacket("GCCoreEntities", (Entity)this, Float.valueOf(this.size));
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            if (this.field_70170_p.field_72995_K) {
                this.size = dataStream.readFloat();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public void setSize(float bubbleSize) {
        this.size = bubbleSize;
    }

    @Override
    public float getSize() {
        return this.size;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.size = nbt.func_74758_c().contains("bubbleSize") ? (float)nbt.func_74769_h("bubbleSize") : nbt.func_74760_g("bubbleSizeF");
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74776_a("bubbleSizeF", this.size);
    }
}

