/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityAIArrowAttack;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityArrow;
import micdoodle8.mods.galacticraft.core.entities.IBoss;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityTreasureChest;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class GCCoreEntitySkeletonBoss
extends EntityMob
implements IEntityBreathable,
IBossDisplayData,
IRangedAttackMob,
IBoss {
    protected long ticks = 0L;
    private static final ItemStack defaultHeldItem = new ItemStack((Item)Item.field_77707_k, 1);
    private GCCoreTileEntityDungeonSpawner spawner;
    public int throwTimer;
    public int postThrowDelay = 20;
    public Entity thrownEntity;
    public Entity targetEntity;
    public int deathTicks = 0;
    public int entitiesWithin;
    public int entitiesWithinLast;
    private Vector3 roomCoords;
    private Vector3 roomSize;

    public GCCoreEntitySkeletonBoss(World par1World) {
        super(par1World);
        this.func_70105_a(1.5f, 4.0f);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new GCCoreEntityAIArrowAttack(this, 1.0, 25, 10.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0 * GCCoreConfigManager.dungeonBossHealthMod);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public GCCoreEntitySkeletonBoss(World world, Vector3 vec) {
        this(world);
        this.func_70107_b(vec.x, vec.y, vec.z);
    }

    public boolean func_70090_H() {
        return false;
    }

    public boolean func_70072_I() {
        return false;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double offsetX = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            double offsetZ = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            double offsetY = 2.0 * Math.cos((float)(this.throwTimer + this.postThrowDelay) * 0.05f);
            this.field_70153_n.func_70107_b(this.field_70165_t + offsetX, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W() + offsetY, this.field_70161_v + offsetZ);
        }
    }

    public void func_70653_a(Entity par1Entity, float par2, double par3, double par5) {
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (this.field_70153_n == null && this.postThrowDelay == 0 && this.throwTimer == 0 && par1EntityPlayer.equals((Object)this.targetEntity) && this.deathTicks == 0) {
            if (!this.field_70170_p.field_72995_K) {
                PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)40.0, (int)this.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.PLAY_SOUND_BOSS_LAUGH, new Object[]{0}));
                par1EntityPlayer.func_70078_a((Entity)this);
            }
            this.throwTimer = 40;
        }
        super.func_70100_b_(par1EntityPlayer);
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected String func_70639_aQ() {
        return "";
    }

    protected String func_70621_aR() {
        this.func_85030_a(GalacticraftCore.ASSET_PREFIX + "entity.bossliving", this.func_70599_aP(), this.func_70647_i() + 6.0f);
        return "";
    }

    protected String func_70673_aS() {
        return "";
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 2.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks >= 180 && this.deathTicks % 5 == 0) {
                PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)40.0, (int)this.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.PLAY_SOUND_EXPLODE, new Object[]{0}));
            }
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                int j;
                for (int i = 30; i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            if (this.deathTicks == 1) {
                PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)40.0, (int)this.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.PLAY_SOUND_BOSS_DEATH, new Object[]{0}));
            }
        }
        this.func_70091_d(0.0, 0.1f, 0.0);
        this.field_70761_aq = this.field_70177_z += 20.0f;
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            int j;
            for (int i = 20; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
            for (TileEntity tile : this.field_70170_p.field_73009_h) {
                double d5;
                double d4;
                double d3;
                double dSq;
                if (!(tile instanceof GCCoreTileEntityTreasureChest) || !((dSq = (d3 = (double)tile.field_70329_l + 0.5 - this.field_70165_t) * d3 + (d4 = (double)tile.field_70330_m + 0.5 - this.field_70163_u) * d4 + (d5 = (double)tile.field_70327_n + 0.5 - this.field_70161_v) * d5) < Math.pow(100.0, 2.0))) continue;
                if (!((GCCoreTileEntityTreasureChest)tile).locked) {
                    ((GCCoreTileEntityTreasureChest)tile).locked = true;
                }
                for (int k = 0; k < ((GCCoreTileEntityTreasureChest)tile).func_70302_i_(); ++k) {
                    ((GCCoreTileEntityTreasureChest)tile).func_70299_a(k, null);
                }
                ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
                WeightedRandomChestContent.func_76293_a((Random)this.field_70146_Z, (WeightedRandomChestContent[])info.getItems(this.field_70146_Z), (IInventory)((GCCoreTileEntityTreasureChest)tile), (int)info.getCount(this.field_70146_Z));
                WeightedRandomChestContent.func_76293_a((Random)this.field_70146_Z, (WeightedRandomChestContent[])info.getItems(this.field_70146_Z), (IInventory)((GCCoreTileEntityTreasureChest)tile), (int)info.getCount(this.field_70146_Z));
                ((GCCoreTileEntityTreasureChest)tile).func_70299_a(this.field_70146_Z.nextInt(((GCCoreTileEntityTreasureChest)tile).func_70302_i_()), this.getGuaranteedLoot(this.field_70146_Z));
                break;
            }
            this.func_70099_a(new ItemStack(GCCoreItems.key.field_77779_bT, 1, 0), 0.5f);
            super.func_70106_y();
            if (this.spawner != null) {
                this.spawner.isBossDefeated = true;
                this.spawner.boss = null;
                this.spawner.spawned = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_70694_bm() {
        return defaultHeldItem;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_70106_y() {
        if (this.spawner != null) {
            this.spawner.isBossDefeated = false;
            this.spawner.boss = null;
            this.spawner.spawned = false;
        }
        super.func_70106_y();
    }

    public void func_70636_d() {
        EntityPlayer player;
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 1L;
        }
        ++this.ticks;
        if (!this.field_70170_p.field_72995_K && (double)this.func_110143_aJ() <= 150.0 * GCCoreConfigManager.dungeonBossHealthMod / 2.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        }
        if ((player = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 20.0)) != null && !player.equals((Object)this.targetEntity)) {
            if (this.func_70068_e((Entity)player) < 400.0) {
                this.func_70661_as().func_75494_a((Entity)player);
                this.targetEntity = player;
            }
        } else {
            this.targetEntity = null;
        }
        if (this.throwTimer > 0) {
            --this.throwTimer;
        }
        if (this.postThrowDelay > 0) {
            --this.postThrowDelay;
        }
        new Vector3((Entity)this);
        if (this.roomCoords != null && this.roomSize != null) {
            List entitiesWithin = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72332_a().func_72299_a((double)(this.roomCoords.intX() - 1), (double)(this.roomCoords.intY() - 1), (double)(this.roomCoords.intZ() - 1), (double)(this.roomCoords.intX() + this.roomSize.intX()), (double)(this.roomCoords.intY() + this.roomSize.intY()), (double)(this.roomCoords.intZ() + this.roomSize.intZ())));
            this.entitiesWithin = entitiesWithin.size();
            if (this.entitiesWithin == 0 && this.entitiesWithinLast != 0) {
                List entitiesWithin2 = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72332_a().func_72299_a((double)(this.roomCoords.intX() - 11), (double)(this.roomCoords.intY() - 11), (double)(this.roomCoords.intZ() - 11), (double)(this.roomCoords.intX() + this.roomSize.intX() + 10), (double)(this.roomCoords.intY() + this.roomSize.intY() + 10), (double)(this.roomCoords.intZ() + this.roomSize.intZ() + 10)));
                for (EntityPlayer p : entitiesWithin2) {
                    p.func_70006_a(ChatMessageComponent.func_111066_d((String)"Boss despawned, don't leave the boss room while fighting! Re-enter room to respawn boss."));
                }
                this.func_70106_y();
                if (this.spawner != null) {
                    this.spawner.playerCheated = true;
                }
                return;
            }
            this.entitiesWithinLast = this.entitiesWithin;
        }
        if (this.field_70153_n != null && this.throwTimer == 0) {
            this.postThrowDelay = 20;
            this.thrownEntity = this.field_70153_n;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70153_n.func_70078_a(null);
            }
        }
        if (this.thrownEntity != null && this.postThrowDelay == 18) {
            double d0 = this.field_70165_t - this.thrownEntity.field_70165_t;
            double d1 = this.field_70161_v - this.thrownEntity.field_70161_v;
            while (d0 * d0 + d1 * d1 < 1.0E-4) {
                d0 = (Math.random() - Math.random()) * 0.01;
                d1 = (Math.random() - Math.random()) * 0.01;
            }
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)40.0, (int)this.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.PLAY_SOUND_BOW, new Object[]{0}));
            ((EntityPlayer)this.thrownEntity).field_70739_aP = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - this.field_70177_z;
            this.thrownEntity.field_70160_al = true;
            float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            float f1 = 2.4f;
            this.thrownEntity.field_70159_w /= 2.0;
            this.thrownEntity.field_70181_x /= 2.0;
            this.thrownEntity.field_70179_y /= 2.0;
            this.thrownEntity.field_70159_w -= d0 / (double)f * (double)2.4f;
            this.thrownEntity.field_70181_x += 0.48000001907348633;
            this.thrownEntity.field_70179_y -= d1 / (double)f * (double)2.4f;
            if (this.thrownEntity.field_70181_x > (double)0.4f) {
                this.thrownEntity.field_70181_x = 0.4f;
            }
        }
        super.func_70636_d();
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76364_f() instanceof EntityArrow && par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)par1DamageSource.func_76346_g();
            double var3 = var2.field_70165_t - this.field_70165_t;
            double var5 = var2.field_70161_v - this.field_70161_v;
            if (var3 * var3 + var5 * var5 >= 2500.0) {
                var2.func_71029_a((StatBase)AchievementList.field_76020_v);
            }
        }
    }

    protected int func_70633_aT() {
        return Item.field_77704_l.field_77779_bT;
    }

    protected void func_70628_a(boolean par1, int par2) {
    }

    public EntityItem func_70099_a(ItemStack par1ItemStack, float par2) {
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)par2, this.field_70161_v, par1ItemStack);
        entityitem.field_70181_x = -2.0;
        entityitem.field_70293_c = 10;
        if (this.captureDrops) {
            this.capturedDrops.add(entityitem);
        } else {
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
        return entityitem;
    }

    protected void func_70600_l(int par1) {
        if (par1 > 0) {
            ItemStack var2 = new ItemStack((Item)Item.field_77707_k);
            EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)var2, (int)5);
            this.func_70099_a(var2, 0.0f);
        } else {
            this.func_70025_b(Item.field_77707_k.field_77779_bT, 1);
        }
    }

    @Override
    public boolean canBreath() {
        return true;
    }

    public float getExperienceToSpawn() {
        return 50.0f;
    }

    public double getDistanceToSpawn() {
        return 40.0;
    }

    public ItemStack getGuaranteedLoot(Random rand) {
        List<ItemStack> stackList = GalacticraftRegistry.getDungeonLoot(1);
        return stackList.get(rand.nextInt(stackList.size()));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.roomCoords != null) {
            nbt.func_74780_a("roomCoordsX", this.roomCoords.x);
            nbt.func_74780_a("roomCoordsY", this.roomCoords.y);
            nbt.func_74780_a("roomCoordsZ", this.roomCoords.z);
            nbt.func_74780_a("roomSizeX", this.roomSize.x);
            nbt.func_74780_a("roomSizeY", this.roomSize.y);
            nbt.func_74780_a("roomSizeZ", this.roomSize.z);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.roomCoords = new Vector3();
        this.roomCoords.x = nbt.func_74769_h("roomCoordsX");
        this.roomCoords.y = nbt.func_74769_h("roomCoordsY");
        this.roomCoords.z = nbt.func_74769_h("roomCoordsZ");
        this.roomSize = new Vector3();
        this.roomSize.x = nbt.func_74769_h("roomSizeX");
        this.roomSize.y = nbt.func_74769_h("roomSizeY");
        this.roomSize.z = nbt.func_74769_h("roomSizeZ");
    }

    public void func_82196_d(EntityLivingBase entitylivingbase, float f) {
        if (this.field_70153_n != null) {
            return;
        }
        GCCoreEntityArrow var1 = this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider ? new GCCoreEntityArrow(this.field_70170_p, (EntityLivingBase)this, entitylivingbase, 0.3f, 12.0f) : new EntityArrow(this.field_70170_p, (EntityLivingBase)this, entitylivingbase, 1.6f, 12.0f);
        this.field_70170_p.func_72956_a((Entity)this, "random.bow", 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)var1);
    }

    @Override
    public void setRoom(Vector3 roomCoords, Vector3 roomSize) {
        this.roomCoords = roomCoords;
        this.roomSize = roomSize;
    }

    @Override
    public void onBossSpawned(GCCoreTileEntityDungeonSpawner spawner) {
        this.spawner = spawner;
    }
}

