/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.IGridNetwork;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.IOxygenNetwork;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.OxygenNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCCoreAnnotations;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public abstract class GCCoreTileEntityOxygenTransmitter
extends GCCoreTileEntityAdvanced
implements ITransmitter {
    private IGridNetwork network;
    public TileEntity[] adjacentConnections = null;

    public void func_70313_j() {
        if (!this.field_70331_k.field_72995_K) {
            this.getNetwork().split(this);
        }
        super.func_70313_j();
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public IGridNetwork getNetwork() {
        if (this.network == null) {
            this.resetNetwork();
        }
        return this.network;
    }

    @Override
    public void onNetworkChanged() {
    }

    protected void resetNetwork() {
        OxygenNetwork network = new OxygenNetwork();
        network.getTransmitters().add(this);
        this.setNetwork(network);
    }

    @Override
    public void setNetwork(IGridNetwork network) {
        this.network = network;
    }

    @Override
    public void refresh() {
        if (!this.field_70331_k.field_72995_K) {
            this.adjacentConnections = null;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity = new Vector3(this).modifyPositionFromSide(side).getTileEntity((IBlockAccess)this.field_70331_k);
                if (tileEntity == null || tileEntity.getClass() != this.getClass() || !(tileEntity instanceof INetworkProvider) || this.getNetwork().equals(((INetworkProvider)tileEntity).getNetwork())) continue;
                this.setNetwork(this.getNetwork().merge(((INetworkProvider)tileEntity).getNetwork()));
            }
            this.getNetwork().refresh();
        }
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        if (this.adjacentConnections == null) {
            this.adjacentConnections = WorldUtil.getAdjacentOxygenConnections(this);
        }
        return this.adjacentConnections;
    }

    @Override
    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        return type == NetworkType.OXYGEN;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
    }

    @Override
    public NetworkType getNetworkType() {
        return NetworkType.OXYGEN;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return stack.amount - (int)Math.floor(((IOxygenNetwork)this.getNetwork()).produce(stack.amount, this));
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public GasStack drawGas(ForgeDirection side, int amount) {
        return null;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.gas.IGasAcceptor", modID="Mekanism")
    public int receiveGas(GasStack stack) {
        return (int)Math.floor(((IOxygenNetwork)this.getNetwork()).produce(stack.amount, this));
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.gas.IGasAcceptor", altClasses={"mekanism.api.gas.IGasHandler"}, modID="Mekanism")
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return type.getName().equals("oxygen");
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.gas.ITubeConnection", modID="Mekanism")
    public boolean canTubeConnect(ForgeDirection side) {
        return this.canConnect(side, NetworkType.OXYGEN);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.gas.IGasStorage", modID="Mekanism")
    public GasStack getGas(Object ... data) {
        return new GasStack((Gas)NetworkConfigHandler.gasOxygen, 0);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.gas.IGasStorage", modID="Mekanism")
    public void setGas(GasStack stack, Object ... data) {
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.gas.IGasStorage", modID="Mekanism")
    public int getMaxGas(Object ... data) {
        return 1;
    }
}

