/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import buildcraft.api.power.IPowerReceptor;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.gas.IGasTransmitter;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.TransmissionType;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IWorldTransferCallback;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ICelestialBody;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IMapObject;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GCLog;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreSpaceStationData;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreWorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerSP;
import micdoodle8.mods.galacticraft.core.items.GCCoreItemParachute;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketDimensionListPlanets;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketDimensionListSpaceStations;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerClient;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketSpaceStationData;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.moon.dimension.GCMoonWorldProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet41EntityEffect;
import net.minecraft.network.packet.Packet43Experience;
import net.minecraft.network.packet.Packet9Respawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeDirection;

public class WorldUtil {
    public static Collection<Integer> registeredSpaceStations;
    public static Collection<Integer> registeredPlanets;
    public static Collection<String> registeredPlanetNames;

    public static double getGravityForEntity(EntityLivingBase eLiving) {
        if (eLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)eLiving.field_70170_p.field_73011_w;
            if (eLiving instanceof EntityPlayer) {
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && eLiving instanceof GCCorePlayerSP) {
                    return ((GCCorePlayerSP)eLiving).touchedGround ? 0.08 - (double)customProvider.getGravity() : 0.08;
                }
                if (eLiving instanceof GCCorePlayerMP) {
                    return ((GCCorePlayerMP)eLiving).isTouchedGround() ? 0.08 - (double)customProvider.getGravity() : 0.08;
                }
                return 0.08;
            }
            return 0.08 - (double)customProvider.getGravity();
        }
        return 0.08;
    }

    public static double getItemGravity(EntityItem e) {
        if (e.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)e.field_70170_p.field_73011_w;
            return (double)0.04f - (customProvider instanceof IOrbitDimension ? 0.05999999910593033 : (double)customProvider.getGravity()) / 1.75;
        }
        return 0.04f;
    }

    public static double getItemGravity2(EntityItem e) {
        if (e.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            return 1.0;
        }
        return 0.98f;
    }

    public static Vector3 getWorldColor(World world) {
        if (world.field_73011_w instanceof GCMoonWorldProvider) {
            float f1 = world.func_72826_c(1.0f);
            float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            double d = 1.0 - (double)(f2 * f2) * 0.7;
            return new Vector3(d, d, d);
        }
        return new Vector3(1.0, 1.0, 1.0);
    }

    public static float getColorRed(World world) {
        return (float)WorldUtil.getWorldColor((World)world).x;
    }

    public static float getColorGreen(World world) {
        return (float)WorldUtil.getWorldColor((World)world).y;
    }

    public static float getColorBlue(World world) {
        return (float)WorldUtil.getWorldColor((World)world).z;
    }

    public static Vec3 getFogColorHook(World world) {
        if (world.field_73011_w instanceof WorldProviderSurface && FMLClientHandler.instance().getClient().field_71439_g.field_70163_u >= 200.0) {
            float var20 = (float)(FMLClientHandler.instance().getClient().field_71439_g.field_70163_u - 200.0) / 1000.0f;
            float var21 = Math.max(1.0f - var20 * 4.0f, 0.0f);
            Vec3 vec = world.func_72948_g(1.0f);
            return Vec3.func_72443_a((double)(vec.field_72450_a * (double)var21), (double)(vec.field_72448_b * (double)var21), (double)(vec.field_72449_c * (double)var21));
        }
        return world.func_72948_g(1.0f);
    }

    public static Vec3 getSkyColorHook(World world) {
        if (world.field_73011_w instanceof WorldProviderSurface && FMLClientHandler.instance().getClient().field_71439_g.field_70163_u >= 200.0) {
            float var20 = (float)(FMLClientHandler.instance().getClient().field_71439_g.field_70163_u - 200.0) / 1000.0f;
            float var21 = Math.max(1.0f - var20 * 2.0f, 0.0f);
            Vec3 vec = world.func_72833_a((Entity)FMLClientHandler.instance().getClient().field_71451_h, 1.0f);
            return Vec3.func_72443_a((double)(vec.field_72450_a * (double)var21), (double)(vec.field_72448_b * (double)var21), (double)(vec.field_72449_c * (double)var21));
        }
        return world.func_72833_a((Entity)FMLClientHandler.instance().getClient().field_71451_h, 1.0f);
    }

    public static WorldProvider getProviderForName(String par1String) {
        Integer[] var1;
        for (Integer element : var1 = WorldUtil.getArrayOfPossibleDimensions()) {
            if (WorldProvider.func_76570_a((int)element) == null || WorldProvider.func_76570_a((int)element).func_80007_l() == null) continue;
            if (par1String.contains("$")) {
                String[] twoDimensions = par1String.split("\\$");
                if (!WorldProvider.func_76570_a((int)element).func_80007_l().equals(twoDimensions[0])) continue;
                return WorldProvider.func_76570_a((int)element);
            }
            if (!WorldProvider.func_76570_a((int)element).func_80007_l().equals(par1String)) continue;
            return WorldProvider.func_76570_a((int)element);
        }
        return null;
    }

    public static List<Integer> getPossibleDimensionsForSpaceshipTier(int tier) {
        WorldProvider provider;
        ArrayList<Integer> temp = new ArrayList<Integer>();
        temp.add(0);
        for (Integer element : registeredPlanets) {
            provider = WorldProvider.func_76570_a((int)element);
            if (provider == null) continue;
            if (provider instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)provider).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        for (Integer element : registeredSpaceStations) {
            provider = WorldProvider.func_76570_a((int)element);
            if (provider == null) continue;
            if (provider instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)provider).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        return temp;
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensions(List<Integer> ids, GCCorePlayerMP playerBase) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Integer id : ids) {
            if (WorldProvider.func_76570_a((int)id) == null) continue;
            if (WorldProvider.func_76570_a((int)id) instanceof IGalacticraftWorldProvider && !(WorldProvider.func_76570_a((int)id) instanceof IOrbitDimension) || WorldProvider.func_76570_a((int)id.intValue()).field_76574_g == 0) {
                map.put(WorldProvider.func_76570_a((int)id).func_80007_l(), WorldProvider.func_76570_a((int)id.intValue()).field_76574_g);
                continue;
            }
            if (playerBase == null || !(WorldProvider.func_76570_a((int)id) instanceof IOrbitDimension)) continue;
            GCCoreSpaceStationData data = GCCoreSpaceStationData.getStationData(playerBase.field_70170_p, id, (EntityPlayer)playerBase);
            if (GCCoreConfigManager.spaceStationsRequirePermission && !data.getAllowedPlayers().contains(playerBase.field_71092_bJ.toLowerCase()) && !data.getAllowedPlayers().contains(playerBase.field_71092_bJ) && !playerBase.field_71133_b.func_71203_ab().func_72353_e(playerBase.field_71092_bJ)) continue;
            map.put(WorldProvider.func_76570_a((int)id).func_80007_l() + "$" + data.getOwner() + "$" + data.getSpaceStationName(), WorldProvider.func_76570_a((int)id.intValue()).field_76574_g);
        }
        for (int j = 0; j < GalacticraftRegistry.getCelestialBodies().size(); ++j) {
            ICelestialBody object = GalacticraftRegistry.getCelestialBodies().get(j);
            if (object.isReachable() || !object.addToList()) continue;
            map.put(object.getName() + "*", 0);
        }
        return map;
    }

    public static List<String> getPlayersOnPlanet(IMapObject planet) {
        ArrayList<String> list = new ArrayList<String>();
        for (WorldServer world : DimensionManager.getWorlds()) {
            if (world == null || !(world.field_73011_w instanceof IGalacticraftWorldProvider) || !planet.getSlotRenderer().getPlanetName().toLowerCase().equals(world.field_73011_w.func_80007_l().toLowerCase())) continue;
            for (int j = 0; j < world.func_72910_y().size(); ++j) {
                if (world.func_72910_y().get(j) == null || !(world.func_72910_y().get(j) instanceof EntityPlayer)) continue;
                list.add(((EntityPlayer)world.func_72910_y().get((int)j)).field_71092_bJ);
            }
        }
        return list;
    }

    private static List<Integer> getExistingSpaceStationList(File var0) {
        ArrayList<Integer> var1 = new ArrayList<Integer>();
        for (File var5 : var0.listFiles()) {
            if (!var5.getName().contains("spacestation_")) continue;
            String var6 = var5.getName();
            var6 = var6.substring(13, var6.length() - 4);
            var1.add(Integer.parseInt(var6));
        }
        return var1;
    }

    public static void unregisterSpaceStations() {
        if (registeredSpaceStations != null) {
            for (Integer registeredID : registeredSpaceStations) {
                DimensionManager.unregisterDimension((int)registeredID);
            }
            registeredSpaceStations = null;
        }
    }

    public static void registerSpaceStations(File spaceStationList) {
        registeredSpaceStations = WorldUtil.getExistingSpaceStationList(spaceStationList);
        for (Integer registeredID : registeredSpaceStations) {
            int id = Arrays.binarySearch(GCCoreConfigManager.staticLoadDimensions, registeredID);
            if (id >= 0) {
                DimensionManager.registerDimension((int)registeredID, (int)GCCoreConfigManager.idDimensionOverworldOrbitStatic);
                FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(registeredID.intValue());
                continue;
            }
            DimensionManager.registerDimension((int)registeredID, (int)GCCoreConfigManager.idDimensionOverworldOrbit);
        }
    }

    public static void registerPlanet(int planetID, boolean isStatic) {
        if (registeredPlanets == null) {
            registeredPlanets = new ArrayList<Integer>();
        }
        registeredPlanets.add(planetID);
        if (isStatic) {
            DimensionManager.registerDimension((int)planetID, (int)planetID);
            GCLog.info("Registered Dimension: " + planetID);
        }
    }

    public static void unregisterPlanets() {
        if (registeredPlanets != null) {
            for (Integer var1 : registeredPlanets) {
                DimensionManager.unregisterDimension((int)var1);
                GCLog.info("Unregistered Dimension: " + var1);
            }
            registeredPlanets = null;
        }
    }

    public static Integer[] getArrayOfPossibleDimensions() {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        temp.add(0);
        for (Integer i : registeredPlanets) {
            temp.add(i);
        }
        for (Integer i : registeredSpaceStations) {
            temp.add(i);
        }
        Integer[] finalArray = new Integer[temp.size()];
        int count = 0;
        for (Integer integ : temp) {
            finalArray[count++] = integ;
        }
        return finalArray;
    }

    public static GCCoreSpaceStationData bindSpaceStationToNewDimension(World world, GCCorePlayerMP player) {
        int newID = DimensionManager.getNextFreeDimId();
        GCCoreSpaceStationData data = WorldUtil.createSpaceStation(world, newID, player);
        player.setSpaceStationDimensionID(newID);
        player.field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.UPDATE_SPACESTATION_CLIENT_ID, new Object[]{newID}));
        return data;
    }

    public static GCCoreSpaceStationData createSpaceStation(World world, int dimID, GCCorePlayerMP player) {
        registeredSpaceStations.add(dimID);
        int id = Arrays.binarySearch(GCCoreConfigManager.staticLoadDimensions, dimID);
        if (id >= 0) {
            DimensionManager.registerDimension((int)dimID, (int)GCCoreConfigManager.idDimensionOverworldOrbitStatic);
        } else {
            DimensionManager.registerDimension((int)dimID, (int)GCCoreConfigManager.idDimensionOverworldOrbit);
        }
        MinecraftServer var2 = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (var2 != null) {
            ArrayList<Integer> var1 = new ArrayList<Integer>();
            var1.add(dimID);
            var2.func_71203_ab().func_72384_a(GCCorePacketDimensionListSpaceStations.buildDimensionListPacket(var1));
        }
        GCCoreSpaceStationData var3 = GCCoreSpaceStationData.getStationData(world, dimID, (EntityPlayer)player);
        return var3;
    }

    public static Entity transferEntityToDimension(Entity entity, int dimensionID, WorldServer world) {
        return WorldUtil.transferEntityToDimension(entity, dimensionID, world, true, null);
    }

    public static Entity transferEntityToDimension(Entity entity, int dimensionID, WorldServer world, boolean transferInv, EntityAutoRocket ridingRocket) {
        if (!world.field_72995_K) {
            MinecraftServer mcServer;
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                ArrayList<Integer> array = new ArrayList<Integer>();
                for (int i : registeredPlanets) {
                    array.add(i);
                }
                server.func_71203_ab().func_72384_a(GCCorePacketDimensionListPlanets.buildDimensionListPacket(array));
            }
            if ((mcServer = FMLCommonHandler.instance().getMinecraftServerInstance()) != null) {
                ITeleportType type;
                WorldServer var6 = mcServer.func_71218_a(dimensionID);
                if (var6 == null) {
                    System.err.println("Cannot Transfer Entity to Dimension: Could not get World for Dimension " + dimensionID);
                }
                if ((type = GalacticraftRegistry.getTeleportTypeForDimension(var6.field_73011_w.getClass())) != null) {
                    return WorldUtil.teleportEntity((World)var6, entity, dimensionID, type, transferInv, ridingRocket);
                }
            }
        }
        return null;
    }

    private static Entity teleportEntity(World worldNew, Entity entity, int dimID, ITeleportType type, boolean transferInv, EntityAutoRocket ridingRocket) {
        NBTTagCompound nbt;
        Vector3 spawnPos;
        if (entity.field_70154_o != null && entity.field_70154_o instanceof EntitySpaceshipBase) {
            entity.func_70078_a(entity.field_70154_o);
        }
        boolean dimChange = entity.field_70170_p != worldNew;
        entity.field_70170_p.func_72866_a(entity, false);
        GCCorePlayerMP player = null;
        if (entity instanceof GCCorePlayerMP) {
            player = (GCCorePlayerMP)entity;
            player.func_71053_j();
            if (dimChange) {
                player.field_71093_bK = dimID;
                player.field_71135_a.func_72567_b((Packet)new Packet9Respawn(player.field_71093_bK, (byte)player.field_70170_p.field_73013_u, worldNew.func_72912_H().func_76067_t(), worldNew.func_72800_K(), player.field_71134_c.func_73081_b()));
                if (worldNew.field_73011_w instanceof GCCoreWorldProviderSpaceStation && registeredSpaceStations.contains((Object)player)) {
                    player.field_71135_a.func_72567_b(GCCorePacketSpaceStationData.buildSpaceStationDataPacket(worldNew, worldNew.field_73011_w.field_76574_g, player));
                }
                ((WorldServer)entity.field_70170_p).func_73040_p().func_72695_c((EntityPlayerMP)player);
            }
            player.setNotUsingPlanetGui();
        }
        if (dimChange) {
            if (ridingRocket == null) {
                WorldUtil.removeEntityFromWorld(entity.field_70170_p, entity, true);
            } else {
                WorldUtil.removeEntityFromWorld(entity.field_70170_p, entity, true);
            }
        }
        if (dimChange && entity instanceof EntityPlayerMP) {
            player = (GCCorePlayerMP)entity;
            entity.func_70012_b(type.getPlayerSpawnLocation((WorldServer)((WorldServer)entity.field_70170_p), (EntityPlayerMP)player).x, type.getPlayerSpawnLocation((WorldServer)((WorldServer)entity.field_70170_p), (EntityPlayerMP)player).y, type.getPlayerSpawnLocation((WorldServer)((WorldServer)entity.field_70170_p), (EntityPlayerMP)player).z, entity.field_70177_z, entity.field_70125_A);
            spawnPos = type.getPlayerSpawnLocation((WorldServer)entity.field_70170_p, (EntityPlayerMP)entity);
            ChunkCoordIntPair pair = worldNew.func_72964_e(spawnPos.intX(), spawnPos.intZ()).func_76632_l();
            ((WorldServer)worldNew).field_73059_b.func_73158_c(pair.field_77276_a, pair.field_77275_b);
            entity.func_70107_b(spawnPos.x, spawnPos.y, spawnPos.z);
        }
        if (ridingRocket != null) {
            nbt = new NBTTagCompound();
            ridingRocket.field_70128_L = false;
            ridingRocket.field_70153_n = null;
            ridingRocket.func_70039_c(nbt);
            ((WorldServer)ridingRocket.field_70170_p).func_73039_n().func_72790_b((Entity)ridingRocket);
            ridingRocket.field_70170_p.field_72996_f.remove(ridingRocket);
            ridingRocket.field_70170_p.func_72847_b((Entity)ridingRocket);
            ridingRocket = (EntityAutoRocket)EntityList.func_75615_a((NBTTagCompound)nbt, (World)worldNew);
            if (ridingRocket != null) {
                ridingRocket.setWaitForPlayer(true);
                if (ridingRocket instanceof IWorldTransferCallback) {
                    ((IWorldTransferCallback)((Object)ridingRocket)).onWorldTransferred(worldNew);
                }
            }
        }
        if (dimChange) {
            if (!(entity instanceof EntityPlayer)) {
                nbt = new NBTTagCompound();
                entity.field_70128_L = false;
                entity.func_70039_c(nbt);
                entity.field_70128_L = true;
                entity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)worldNew);
                if (entity == null) {
                    return null;
                }
                if (entity instanceof IWorldTransferCallback) {
                    ((IWorldTransferCallback)entity).onWorldTransferred(worldNew);
                }
            }
            worldNew.func_72838_d(entity);
            entity.func_70029_a(worldNew);
        }
        if (dimChange && entity instanceof EntityPlayer) {
            entity.func_70012_b(type.getPlayerSpawnLocation((WorldServer)((WorldServer)entity.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)entity)).x, type.getPlayerSpawnLocation((WorldServer)((WorldServer)entity.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)entity)).y, type.getPlayerSpawnLocation((WorldServer)((WorldServer)entity.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)entity)).z, entity.field_70177_z, entity.field_70125_A);
        }
        worldNew.func_72866_a(entity, false);
        if (dimChange && entity instanceof EntityPlayer) {
            entity.func_70012_b(type.getPlayerSpawnLocation((WorldServer)((WorldServer)entity.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)entity)).x, type.getPlayerSpawnLocation((WorldServer)((WorldServer)entity.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)entity)).y, type.getPlayerSpawnLocation((WorldServer)((WorldServer)entity.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)entity)).z, entity.field_70177_z, entity.field_70125_A);
        }
        if (entity instanceof GCCorePlayerMP) {
            player = (GCCorePlayerMP)entity;
            if (dimChange) {
                player.field_71133_b.func_71203_ab().func_72375_a((EntityPlayerMP)player, (WorldServer)worldNew);
            }
            player.field_71135_a.func_72569_a(type.getPlayerSpawnLocation((WorldServer)((WorldServer)entity.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)entity)).x, type.getPlayerSpawnLocation((WorldServer)((WorldServer)entity.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)entity)).y, type.getPlayerSpawnLocation((WorldServer)((WorldServer)entity.field_70170_p), (EntityPlayerMP)((EntityPlayerMP)entity)).z, entity.field_70177_z, entity.field_70125_A);
            GCLog.info("Server attempting to transfer player " + player.field_71092_bJ + " to dimension " + worldNew.field_73011_w.field_76574_g);
        }
        worldNew.func_72866_a(entity, false);
        if (entity instanceof GCCorePlayerMP) {
            player = (GCCorePlayerMP)entity;
            if (ridingRocket == null && type.useParachute() && player.getExtendedInventory().func_70301_a(4) != null && player.getExtendedInventory().func_70301_a(4).func_77973_b() instanceof GCCoreItemParachute) {
                player.setUsingParachute(true);
            } else {
                player.setUsingParachute(false);
            }
        }
        if (entity instanceof GCCorePlayerMP && dimChange) {
            player = (GCCorePlayerMP)entity;
            player.field_71134_c.func_73080_a((WorldServer)worldNew);
            player.field_71133_b.func_71203_ab().func_72354_b((EntityPlayerMP)player, (WorldServer)worldNew);
            player.field_71133_b.func_71203_ab().func_72385_f((EntityPlayerMP)player);
            for (PotionEffect var10 : player.func_70651_bq()) {
                player.field_71135_a.func_72567_b((Packet)new Packet41EntityEffect(player.field_70157_k, var10));
            }
            player.field_71135_a.func_72567_b((Packet)new Packet43Experience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        }
        if (entity instanceof GCCorePlayerMP) {
            spawnPos = null;
            if (player != null) {
                spawnPos = type.getPlayerSpawnLocation((WorldServer)entity.field_70170_p, (EntityPlayerMP)entity);
                entity.func_70012_b(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
            } else {
                spawnPos = type.getEntitySpawnLocation((WorldServer)entity.field_70170_p, entity);
                entity.func_70012_b(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
            }
        }
        if (entity instanceof GCCorePlayerMP) {
            player = (GCCorePlayerMP)entity;
            if (player.getRocketStacks() != null && player.getRocketStacks().length > 0) {
                for (int stack = 0; stack < player.getRocketStacks().length; ++stack) {
                    if (transferInv) {
                        if (player.getRocketStacks()[stack] != null) continue;
                        if (stack == player.getRocketStacks().length - 1) {
                            if (player.getRocketItem() == null) continue;
                            player.getRocketStacks()[stack] = new ItemStack(player.getRocketItem(), 1, player.getRocketType());
                            continue;
                        }
                        if (stack != player.getRocketStacks().length - 2) continue;
                        player.getRocketStacks()[stack] = player.getLaunchpadStack();
                        player.setLaunchpadStack(null);
                        continue;
                    }
                    player.getRocketStacks()[stack] = null;
                }
            }
            if (transferInv && player.getChestSpawnCooldown() == 0) {
                player.setChestSpawnVector(type.getParaChestSpawnLocation((WorldServer)entity.field_70170_p, player, new Random()));
                player.setChestSpawnCooldown(200);
            }
        }
        if (ridingRocket != null) {
            entity.func_70080_a(ridingRocket.field_70165_t, ridingRocket.field_70163_u, ridingRocket.field_70161_v, 0.0f, 0.0f);
            worldNew.func_72866_a(entity, true);
            worldNew.func_72838_d((Entity)ridingRocket);
            ridingRocket.func_70029_a(worldNew);
            worldNew.func_72866_a((Entity)ridingRocket, true);
        }
        if (entity instanceof EntityPlayerMP) {
            GameRegistry.onPlayerChangedDimension((EntityPlayer)((EntityPlayerMP)entity));
            type.onSpaceDimensionChanged(worldNew, (EntityPlayerMP)entity, ridingRocket != null);
        }
        if (ridingRocket != null) {
            entity.field_70154_o = ridingRocket;
            ridingRocket.field_70153_n = entity;
        }
        return entity;
    }

    private static void removeEntityFromWorld(World var0, Entity var1, boolean directlyRemove) {
        if (var1 instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)var1;
            var2.func_71053_j();
            var0.field_73010_i.remove(var2);
            var0.func_72854_c();
            int var3 = var1.field_70176_ah;
            int var4 = var1.field_70164_aj;
            if (var1.field_70175_ag && var0.func_72863_F().func_73149_a(var3, var4)) {
                var0.func_72964_e(var3, var4).func_76622_b(var1);
                var0.func_72964_e((int)var3, (int)var4).field_76643_l = true;
            }
            if (directlyRemove) {
                var0.field_72996_f.remove(var1);
                var0.func_72847_b(var1);
            }
        }
        var1.field_70128_L = false;
    }

    public static SpaceStationRecipe getSpaceStationRecipe(int planetID) {
        for (SpaceStationType type : GalacticraftRegistry.getSpaceStationData()) {
            if (type.getWorldToOrbitID() != planetID) continue;
            return type.getRecipeForSpaceStation();
        }
        return null;
    }

    public static TileEntity[] getAdjacentOxygenConnections(TileEntity tile) {
        TileEntity[] adjacentConnections = new TileEntity[ForgeDirection.VALID_DIRECTIONS.length];
        boolean isMekLoaded = NetworkConfigHandler.isMekanismLoaded();
        BlockVec3 thisVec = new BlockVec3(tile);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = thisVec.getTileEntityOnSide(tile.field_70331_k, direction);
            if (tileEntity instanceof IConnector) {
                if (!((IConnector)tileEntity).canConnect(direction.getOpposite(), NetworkType.OXYGEN)) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (!isMekLoaded || !(tileEntity instanceof ITubeConnection) || tileEntity instanceof IGasTransmitter && !TransmissionType.checkTransmissionType((TileEntity)tileEntity, (TransmissionType)TransmissionType.GAS, (TileEntity)tileEntity) || !((ITubeConnection)tileEntity).canTubeConnect(direction)) continue;
            adjacentConnections[direction.ordinal()] = tileEntity;
        }
        return adjacentConnections;
    }

    public static TileEntity[] getAdjacentPowerConnections(TileEntity tile) {
        TileEntity[] adjacentConnections = new TileEntity[6];
        boolean isMekLoaded = NetworkConfigHandler.isMekanismLoaded();
        boolean isTELoaded = NetworkConfigHandler.isThermalExpansionLoaded();
        boolean isIC2Loaded = NetworkConfigHandler.isIndustrialCraft2Loaded();
        boolean isBCLoaded = NetworkConfigHandler.isBuildcraftLoaded();
        BlockVec3 thisVec = new BlockVec3(tile);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = thisVec.getTileEntityOnSide(tile.field_70331_k, direction);
            if (tileEntity instanceof IConnector) {
                if (!((IConnector)tileEntity).canConnect(direction.getOpposite(), NetworkType.POWER)) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isMekLoaded && tileEntity instanceof IStrictEnergyAcceptor) {
                if (!((IStrictEnergyAcceptor)tileEntity).canReceiveEnergy(direction.getOpposite())) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isTELoaded && tileEntity instanceof IEnergyHandler) {
                if (!((IEnergyHandler)tileEntity).canInterface(direction.getOpposite())) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isIC2Loaded && tileEntity instanceof IEnergyTile) {
                if (tileEntity instanceof IEnergyAcceptor && ((IEnergyAcceptor)tileEntity).acceptsEnergyFrom(tile, direction.getOpposite())) {
                    adjacentConnections[direction.ordinal()] = tileEntity;
                    continue;
                }
                if (tileEntity instanceof IEnergyEmitter && ((IEnergyEmitter)tileEntity).emitsEnergyTo(tileEntity, direction.getOpposite())) {
                    adjacentConnections[direction.ordinal()] = tileEntity;
                    continue;
                }
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (!isBCLoaded || !(tileEntity instanceof IPowerReceptor) || ((IPowerReceptor)tileEntity).getPowerReceiver(direction.getOpposite()) == null) continue;
            adjacentConnections[direction.ordinal()] = tileEntity;
        }
        return adjacentConnections;
    }
}

