/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class EntityItem
extends Entity {
    public int field_70292_b;
    public int field_70293_c;
    private int field_70291_e = 5;
    public float field_70290_d = (float)(Math.random() * Math.PI * 2.0);
    public boolean wasinWater = false;
    public int lifespan = 6000;

    public EntityItem(World par1World, double par2, double par4, double par6) {
        super(par1World);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.func_70107_b(par2, par4, par6);
        this.field_70177_z = (float)(Math.random() * 360.0);
        this.field_70159_w = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.field_70181_x = 0.2f;
        this.field_70179_y = (float)(Math.random() * (double)0.2f - (double)0.1f);
    }

    public EntityItem(World par1World, double par2, double par4, double par6, ItemStack par8ItemStack) {
        this(par1World, par2, par4, par6);
        this.func_92058_a(par8ItemStack);
        this.lifespan = par8ItemStack.func_77973_b() == null ? 6000 : par8ItemStack.func_77973_b().getEntityLifespan(par8ItemStack, par1World);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public EntityItem(World par1World) {
        super(par1World);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    protected void func_70088_a() {
        this.func_70096_w().func_82709_a(10, 5);
    }

    public void func_70071_h_() {
        boolean flag;
        ItemStack stack = this.func_70096_w().func_82710_f(10);
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b().onEntityItemUpdate(this)) {
            return;
        }
        super.func_70071_h_();
        if (this.field_70293_c > 0) {
            --this.field_70293_c;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= (double)0.04f;
        this.field_70145_X = this.func_70048_i(this.field_70165_t, (this.field_70121_D.field_72338_b + this.field_70121_D.field_72337_e) / 2.0, this.field_70161_v);
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        boolean bl = flag = (int)this.field_70169_q != (int)this.field_70165_t || (int)this.field_70167_r != (int)this.field_70163_u || (int)this.field_70166_s != (int)this.field_70161_v;
        if (flag || this.field_70173_aa % 25 == 0) {
            int id = this.field_70170_p.func_72798_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            if (this.field_70170_p.func_72803_f(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) == Material.field_76256_h | (id != 0 && Block.field_71973_m[id] != null && Block.field_71973_m[id].isFireSource(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.field_70170_p.func_72805_g((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), ForgeDirection.UP)) && this.canItemBurn()) {
                this.func_85030_a("random.fizz", 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_85054_d();
            }
        }
        float f = 0.98f;
        if (this.field_70122_E) {
            f = 0.58800006f;
            int i = this.field_70170_p.func_72798_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            if (i > 0) {
                f = Block.field_71973_m[i].field_72016_cq * 0.98f;
            }
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= -0.5;
        }
        if (this.field_70122_E) {
            this.field_70181_x *= -0.5;
        }
        if (this.func_70055_a(Material.field_76244_g) | this.func_70055_a(Material.field_76256_h)) {
            if (!this.wasinWater) {
                this.field_70181_x /= 2.0;
            }
            this.field_70159_w = this.field_70159_w > 0.0 ? (this.field_70159_w -= 0.01) : (this.field_70159_w += 0.01);
            if (this.field_70159_w > 0.3 | this.field_70159_w < -0.3) {
                this.field_70159_w = 0.0;
            }
            this.field_70179_y = this.field_70179_y > 0.0 ? (this.field_70179_y -= 0.01) : (this.field_70179_y += 0.01);
            if (this.field_70179_y > 0.3 | this.field_70179_y < -0.3) {
                this.field_70159_w = 0.0;
            }
            if (this.canItemSwim()) {
                if (this.field_70181_x < 0.06) {
                    this.field_70181_x += 0.06;
                }
            } else if (this.field_70181_x < 0.01) {
                this.field_70181_x += 0.04;
            }
            this.wasinWater = true;
        } else {
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)f;
            this.wasinWater = false;
        }
        if (!this.func_92059_d().func_77948_v()) {
            ++this.field_70292_b;
        }
        ItemStack item = this.func_70096_w().func_82710_f(10);
        if (!this.field_70170_p.field_72995_K && this.field_70292_b >= this.lifespan) {
            if (item != null) {
                ItemExpireEvent event = new ItemExpireEvent(this, item.func_77973_b() == null ? 6000 : item.func_77973_b().getEntityLifespan(item, this.field_70170_p));
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    this.lifespan += event.extraLife;
                } else {
                    this.func_70106_y();
                }
            } else {
                this.func_70106_y();
            }
        }
        if (item != null && item.field_77994_a <= 0) {
            this.func_70106_y();
        }
    }

    public boolean canItemSwim() {
        ItemStack stack = this.func_92059_d();
        Item item = stack.func_77973_b();
        if (item == null | item instanceof ItemBlock && Block.field_71973_m[stack.field_77993_c] != null) {
            Material m = Block.field_71973_m[stack.field_77993_c].field_72018_cp;
            return m == Material.field_76253_m | m == Material.field_76245_d | m == Material.field_76266_z | m == Material.field_76268_x | m == Material.field_76238_C | m == Material.field_76260_u | m == Material.field_76257_i | m == Material.field_76254_j | m == Material.field_76255_k;
        }
        return item != null;
    }

    private void func_85054_d() {
        for (EntityItem entityitem : this.field_70170_p.func_72872_a(EntityItem.class, this.field_70121_D.func_72314_b(0.5, 0.0, 0.5))) {
            this.func_70289_a(entityitem);
        }
    }

    public boolean func_70289_a(EntityItem par1EntityItem) {
        if (par1EntityItem == this) {
            return false;
        }
        if (par1EntityItem.func_70089_S() && this.func_70089_S()) {
            ItemStack itemstack = this.func_92059_d();
            ItemStack itemstack1 = par1EntityItem.func_92059_d();
            if (itemstack1.func_77973_b() != itemstack.func_77973_b()) {
                return false;
            }
            if (itemstack1.func_77942_o() ^ itemstack.func_77942_o()) {
                return false;
            }
            if (itemstack1.func_77942_o() && !itemstack1.func_77978_p().equals((Object)itemstack.func_77978_p())) {
                return false;
            }
            if (itemstack1.func_77973_b().func_77614_k() && itemstack1.func_77960_j() != itemstack.func_77960_j()) {
                return false;
            }
            if (itemstack1.field_77994_a < itemstack.field_77994_a) {
                return par1EntityItem.func_70289_a(this);
            }
            if (itemstack1.field_77994_a + itemstack.field_77994_a > itemstack1.func_77976_d()) {
                return false;
            }
            itemstack1.field_77994_a += itemstack.field_77994_a;
            par1EntityItem.field_70293_c = Math.max(par1EntityItem.field_70293_c, this.field_70293_c);
            par1EntityItem.field_70292_b = Math.min(par1EntityItem.field_70292_b, this.field_70292_b);
            par1EntityItem.func_92058_a(itemstack1);
            this.func_70106_y();
            return true;
        }
        return false;
    }

    public void func_70288_d() {
        this.field_70292_b = 4800;
    }

    public boolean func_70072_I() {
        return this.field_70170_p.func_72918_a(this.field_70121_D, Material.field_76244_g, (Entity)this);
    }

    protected void func_70081_e(int par1) {
        this.func_70097_a(DamageSource.field_76372_a, par1);
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (this.func_92059_d() != null && this.func_92059_d().field_77993_c == Item.field_82792_bS.field_77779_bT && par1DamageSource.func_94541_c()) {
            return false;
        }
        if (par1DamageSource == DamageSource.field_76371_c | par1DamageSource == DamageSource.field_76370_b | par1DamageSource == DamageSource.field_76372_a && !this.canItemBurn()) {
            return false;
        }
        if (par1DamageSource == DamageSource.field_76367_g) {
            return false;
        }
        this.func_70018_K();
        this.field_70291_e -= par2;
        if (this.field_70291_e <= 0) {
            this.func_70106_y();
        }
        return false;
    }

    public boolean canItemBurn() {
        ItemStack itemstack = this.func_92059_d();
        if (itemstack.field_77993_c < Block.field_71973_m.length && Block.field_71973_m[itemstack.field_77993_c] != null && Block.field_71973_m[itemstack.field_77993_c].isFlammable((IBlockAccess)this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.field_70170_p.func_72805_g((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), ForgeDirection.UP)) {
            return true;
        }
        return TileEntityFurnace.func_70401_b(itemstack);
    }

    public boolean isItemBurning() {
        Block block = Block.field_71973_m[this.field_70170_p.func_72798_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)];
        if (block != null && block.isFireSource(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.field_70170_p.func_72805_g((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), ForgeDirection.UP) | block.field_72018_cp == Material.field_76256_h) {
            return this.canItemBurn();
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74777_a("Health", (short)((byte)this.field_70291_e));
        par1NBTTagCompound.func_74777_a("Age", (short)this.field_70292_b);
        par1NBTTagCompound.func_74768_a("Lifespan", this.lifespan);
        if (this.func_92059_d() != null) {
            par1NBTTagCompound.func_74766_a("Item", this.func_92059_d().func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.field_70291_e = par1NBTTagCompound.func_74765_d("Health") & 0xFF;
        this.field_70292_b = par1NBTTagCompound.func_74765_d("Age");
        NBTTagCompound nbttagcompound1 = par1NBTTagCompound.func_74775_l("Item");
        this.func_92058_a(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        ItemStack item = this.func_70096_w().func_82710_f(10);
        if (item == null || item.field_77994_a <= 0) {
            this.func_70106_y();
        }
        if (par1NBTTagCompound.func_74764_b("Lifespan")) {
            this.lifespan = par1NBTTagCompound.func_74762_e("Lifespan");
        }
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70293_c > 0) {
                return;
            }
            EntityItemPickupEvent event = new EntityItemPickupEvent(par1EntityPlayer, this);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            ItemStack itemstack = this.func_92059_d();
            int i = itemstack.field_77994_a;
            if (this.field_70293_c <= 0 && (event.getResult() == Event.Result.ALLOW || i <= 0 || par1EntityPlayer.field_71071_by.func_70441_a(itemstack))) {
                if (itemstack.field_77993_c == Block.field_71951_J.field_71990_ca) {
                    par1EntityPlayer.func_71029_a((StatBase)AchievementList.field_76005_g);
                }
                if (itemstack.field_77993_c == Item.field_77770_aF.field_77779_bT) {
                    par1EntityPlayer.func_71029_a((StatBase)AchievementList.field_76022_t);
                }
                if (itemstack.field_77993_c == Item.field_77702_n.field_77779_bT) {
                    par1EntityPlayer.func_71029_a((StatBase)AchievementList.field_76019_w);
                }
                if (itemstack.field_77993_c == Item.field_77731_bo.field_77779_bT) {
                    par1EntityPlayer.func_71029_a((StatBase)AchievementList.field_76027_z);
                }
                GameRegistry.onPickupNotification((EntityPlayer)par1EntityPlayer, (EntityItem)this);
                this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                par1EntityPlayer.func_71001_a((Entity)this, i);
                if (itemstack.field_77994_a <= 0) {
                    this.func_70106_y();
                }
            }
        }
    }

    public String func_70023_ak() {
        return StatCollector.func_74838_a((String)("item." + this.func_92059_d().func_77977_a()));
    }

    public boolean func_70075_an() {
        return false;
    }

    public void func_71027_c(int par1) {
        super.func_71027_c(par1);
        if (!this.field_70170_p.field_72995_K) {
            this.func_85054_d();
        }
    }

    public ItemStack func_92059_d() {
        ItemStack itemstack = this.func_70096_w().func_82710_f(10);
        if (itemstack == null) {
            if (this.field_70170_p != null) {
                this.field_70170_p.func_98180_V().func_98232_c("Item entity " + this.field_70157_k + " has no item?!");
            }
            return new ItemStack(Block.field_71981_t);
        }
        return itemstack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return this.isItemBurning();
    }

    public void func_92058_a(ItemStack par1ItemStack) {
        this.func_70096_w().func_75692_b(10, (Object)par1ItemStack);
        this.func_70096_w().func_82708_h(10);
    }
}

