/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.gates;

import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionProvider;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.transport.IPipe;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;

public class ActionManager {
    public static Map<String, ITrigger> triggers = new HashMap<String, ITrigger>();
    public static Map<String, IAction> actions = new HashMap<String, IAction>();
    private static LinkedList<ITriggerProvider> triggerProviders = new LinkedList();
    private static LinkedList<IActionProvider> actionProviders = new LinkedList();

    public static void registerTriggerProvider(ITriggerProvider iTriggerProvider) {
        if (iTriggerProvider != null && !triggerProviders.contains(iTriggerProvider)) {
            triggerProviders.add(iTriggerProvider);
        }
    }

    public static void registerTrigger(ITrigger iTrigger) {
        triggers.put(iTrigger.getUniqueTag(), iTrigger);
    }

    public static void registerAction(IAction iAction) {
        actions.put(iAction.getUniqueTag(), iAction);
    }

    public static LinkedList<ITrigger> getNeighborTriggers(Block block, TileEntity tileEntity) {
        LinkedList<ITrigger> linkedList = new LinkedList<ITrigger>();
        for (ITriggerProvider iTriggerProvider : triggerProviders) {
            LinkedList<ITrigger> linkedList2 = iTriggerProvider.getNeighborTriggers(block, tileEntity);
            if (linkedList2 == null) continue;
            for (ITrigger iTrigger : linkedList2) {
                if (linkedList.contains(iTrigger)) continue;
                linkedList.add(iTrigger);
            }
        }
        return linkedList;
    }

    public static void registerActionProvider(IActionProvider iActionProvider) {
        if (iActionProvider != null && !actionProviders.contains(iActionProvider)) {
            actionProviders.add(iActionProvider);
        }
    }

    public static LinkedList<IAction> getNeighborActions(Block block, TileEntity tileEntity) {
        LinkedList<IAction> linkedList = new LinkedList<IAction>();
        for (IActionProvider iActionProvider : actionProviders) {
            LinkedList<IAction> linkedList2 = iActionProvider.getNeighborActions(block, tileEntity);
            if (linkedList2 == null) continue;
            for (IAction iAction : linkedList2) {
                if (linkedList.contains(iAction)) continue;
                linkedList.add(iAction);
            }
        }
        return linkedList;
    }

    public static LinkedList<ITrigger> getPipeTriggers(IPipe iPipe) {
        LinkedList<ITrigger> linkedList = new LinkedList<ITrigger>();
        for (ITriggerProvider iTriggerProvider : triggerProviders) {
            LinkedList<ITrigger> linkedList2 = iTriggerProvider.getPipeTriggers(iPipe);
            if (linkedList2 == null) continue;
            for (ITrigger iTrigger : linkedList2) {
                if (linkedList.contains(iTrigger)) continue;
                linkedList.add(iTrigger);
            }
        }
        return linkedList;
    }

    public static ITrigger getTriggerFromLegacyId(int n) {
        for (ITrigger iTrigger : triggers.values()) {
            if (iTrigger.getLegacyId() != n) continue;
            return iTrigger;
        }
        return null;
    }

    public static IAction getActionFromLegacyId(int n) {
        for (IAction iAction : actions.values()) {
            if (iAction.getLegacyId() != n) continue;
            return iAction;
        }
        return null;
    }
}

