/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import powercrystals.minefactoryreloaded.api.IUpgrade;
import powercrystals.minefactoryreloaded.item.ItemFactory;

public class ItemUpgrade
extends ItemFactory
implements IUpgrade {
    private static String[] _upgradeNames = new String[]{"lapis", "iron", "tin", "copper", "bronze", "silver", "gold", "quartz", "diamond", "platinum", "emerald", "cobble"};
    private static Icon[] _upgradeIcons = new Icon[_upgradeNames.length];

    public ItemUpgrade(int n) {
        super(n);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.setMetaMax(_upgradeNames.length - 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        super.func_77624_a(itemStack, entityPlayer, list, bl);
        list.add(StatCollector.func_74838_a((String)"tip.info.mfr.upgrade.radius") + " " + this.getUpgradeLevel(IUpgrade.UpgradeType.RADIUS, itemStack));
    }

    @Override
    public int getUpgradeLevel(IUpgrade.UpgradeType upgradeType, ItemStack itemStack) {
        if (upgradeType != IUpgrade.UpgradeType.RADIUS) {
            return 0;
        }
        int n = itemStack.func_77960_j();
        switch (n) {
            case 11: {
                return -1;
            }
        }
        return n + 1;
    }

    @Override
    public boolean isApplicableFor(IUpgrade.UpgradeType upgradeType, ItemStack itemStack) {
        return upgradeType == IUpgrade.UpgradeType.RADIUS;
    }

    public String func_77667_c(ItemStack itemStack) {
        int n = Math.min(itemStack.func_77960_j(), _upgradeNames.length);
        return this.func_77658_a() + "." + _upgradeNames[n];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        for (int i = 0; i < _upgradeIcons.length; ++i) {
            ItemUpgrade._upgradeIcons[i] = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a() + "." + _upgradeNames[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int n) {
        n = Math.min(n, _upgradeIcons.length);
        return _upgradeIcons[n];
    }
}

