/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.extrabiomes;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableTreeLeaves;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableStandard;
import powercrystals.minefactoryreloaded.modhelpers.extrabiomes.FertilizableExtraBiomesTree;

@Mod(modid="MineFactoryReloaded|CompatExtraBiomes", name="MFR Compat: ExtraBiomes", version="1.6.4R2.7.9", dependencies="after:MineFactoryReloaded;after:ExtrabiomesXL")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class ExtraBiomes {
    private static Map<String, HarvestType> _harvestRegistries;

    @Mod.EventHandler
    public static void load(FMLInitializationEvent fMLInitializationEvent) {
        if (!Loader.isModLoaded((String)"ExtrabiomesXL")) {
            FMLLog.warning((String)"ExtraBiomesXL missing - MFR ExtraBiomesXL Compat not loading", (Object[])new Object[0]);
            return;
        }
        _harvestRegistries = new HashMap<String, HarvestType>();
        _harvestRegistries.put("CATTAIL", HarvestType.Normal);
        _harvestRegistries.put("FLOWER", HarvestType.Normal);
        _harvestRegistries.put("GRASS", HarvestType.Normal);
        _harvestRegistries.put("LEAFPILE", HarvestType.Normal);
        _harvestRegistries.put("CUSTOMLOG", HarvestType.Tree);
        _harvestRegistries.put("QUARTERLOG0", HarvestType.Tree);
        _harvestRegistries.put("QUARTERLOG1", HarvestType.Tree);
        _harvestRegistries.put("QUARTERLOG2", HarvestType.Tree);
        _harvestRegistries.put("QUARTERLOG3", HarvestType.Tree);
        try {
            Integer n;
            Object object;
            Class<?> clazz = Class.forName("extrabiomes.lib.BlockSettings");
            for (String n2 : new String[]{"AUTUMNLEAVES", "GREENLEAVES"}) {
                object = clazz.getField(n2).get(null);
                n = (Integer)clazz.getMethod("getID", new Class[0]).invoke(object, new Object[0]);
                MFRRegistry.registerHarvestable(new HarvestableTreeLeaves(n));
            }
            for (Map.Entry entry : _harvestRegistries.entrySet()) {
                Object object4 = clazz.getField((String)entry.getKey()).get(null);
                Integer n2 = (Integer)clazz.getMethod("getID", new Class[0]).invoke(object4, new Object[0]);
                MFRRegistry.registerHarvestable(new HarvestableStandard(n2, (HarvestType)((Object)entry.getValue())));
            }
            for (String string : new String[]{"SAPLING", "CATTAIL"}) {
                object = clazz.getField(string).get(null);
                n = (Integer)clazz.getMethod("getID", new Class[0]).invoke(object, new Object[0]);
                MFRRegistry.registerPlantable(new PlantableStandard(n, n));
            }
            Class<?> clazz2 = Class.forName("extrabiomes.blocks.BlockCustomSapling");
            Method method = clazz2.getMethod("growTree", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Random.class);
            Object object2 = clazz.getField("SAPLING").get(null);
            int n3 = (Integer)clazz.getMethod("getID", new Class[0]).invoke(object2, new Object[0]);
            MFRRegistry.registerFertilizable(new FertilizableExtraBiomesTree(n3, method));
            MFRRegistry.registerSludgeDrop(15, new ItemStack(((Integer)clazz.getMethod("getID", new Class[0]).invoke(clazz.getField("QUICKSAND").get(null), new Object[0])).intValue(), 1, 0));
            MFRRegistry.registerSludgeDrop(15, new ItemStack(((Integer)clazz.getMethod("getID", new Class[0]).invoke(clazz.getField("CRACKEDSAND").get(null), new Object[0])).intValue(), 1, 0));
            MFRRegistry.registerRubberTreeBiome("Autumn Woods");
            MFRRegistry.registerRubberTreeBiome("Birch Forest");
            MFRRegistry.registerRubberTreeBiome("Extreme Jungle");
            MFRRegistry.registerRubberTreeBiome("Forested Hills");
            MFRRegistry.registerRubberTreeBiome("Forested Island");
            MFRRegistry.registerRubberTreeBiome("Green Hills");
            MFRRegistry.registerRubberTreeBiome("Green Swamplands");
            MFRRegistry.registerRubberTreeBiome("Mini Jungle");
            MFRRegistry.registerRubberTreeBiome("Mountain Taiga");
            MFRRegistry.registerRubberTreeBiome("Pine Forest");
            MFRRegistry.registerRubberTreeBiome("Rainforest");
            MFRRegistry.registerRubberTreeBiome("Redwood Forest");
            MFRRegistry.registerRubberTreeBiome("Lush Redwoods");
            MFRRegistry.registerRubberTreeBiome("Snow Forest");
            MFRRegistry.registerRubberTreeBiome("Snowy Rainforest");
            MFRRegistry.registerRubberTreeBiome("Temperate Rainforest");
            MFRRegistry.registerRubberTreeBiome("Woodlands");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

