/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.pam;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.modhelpers.pam.Pam;

public class HarvestablePams
implements IFactoryHarvestable {
    protected int _sourceId;
    protected Method getCrop;
    protected Method getGrowthStage;
    protected final Object[] dummyArgs = new Object[0];

    public HarvestablePams(int n) throws ClassNotFoundException {
        this._sourceId = n;
        this.getCrop = Pam.pamTEGetCropId;
        this.getGrowthStage = Pam.pamTEGetGrowthStage;
    }

    @Override
    public int getPlantId() {
        return this._sourceId;
    }

    @Override
    public HarvestType getHarvestType() {
        return HarvestType.Normal;
    }

    @Override
    public boolean breakBlock() {
        return false;
    }

    @Override
    public boolean canBeHarvested(World world, Map<String, Boolean> map, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        try {
            if (tileEntity != null && (Integer)this.getGrowthStage.invoke((Object)tileEntity, this.dummyArgs) >= 2) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public List<ItemStack> getDrops(World world, Random random, Map<String, Boolean> map, int n, int n2, int n3) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity != null) {
            try {
                int n4 = (Integer)this.getCrop.invoke((Object)tileEntity, new Object[0]);
                if (n4 <= 28) {
                    int n5 = random.nextInt(3) + 2;
                    int n6 = random.nextInt(2) + 1;
                    if (Pam.pamSeedFromCrop) {
                        arrayList.add(new ItemStack(Pam.pamCropItems[n4], 1, 0));
                        arrayList.add(new ItemStack(Pam.pamSeeds[n4], n6, 0));
                    } else {
                        arrayList.add(new ItemStack(Pam.pamCropItems[n4], n5, 0));
                    }
                } else {
                    arrayList.add(new ItemStack(Pam.pamCropItems[n4], 1, 0));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    @Override
    public void preHarvest(World world, int n, int n2, int n3) {
    }

    @Override
    public void postHarvest(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        try {
            int n4 = (Integer)this.getCrop.invoke((Object)tileEntity, this.dummyArgs);
            if (n4 > 28) {
                Pam.pamTESetGrowthStage.invoke((Object)tileEntity, 1);
                world.func_72845_h(n, n2, n3);
            } else {
                world.func_72932_q(n, n2, n3);
                world.func_94571_i(n, n2, n3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

