/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cofh.api.energy.IEnergyHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.util.Util;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public abstract class TileEntityGenerator
extends TileEntityFactoryInventory
implements IPowerEmitter,
IEnergyHandler {
    private int _ticksBetweenConsumption;
    private int _outputPulseSize;
    private int _ticksSinceLastConsumption = 0;
    private int _bufferMax;
    private int _buffer;
    private IEnergyHandler[] handlerCache;
    private IPowerReceptor[] receiverCache;
    private boolean deadCache;

    protected TileEntityGenerator(Machine machine, int n) {
        super(machine);
        assert (machine.getActivationEnergy() > 0) : "Generators cannot produce 0 energy.";
        this._ticksBetweenConsumption = n;
        this._outputPulseSize = machine.getActivationEnergy();
        this._bufferMax = machine.getMaxEnergyStorage();
    }

    @Override
    public void func_70312_q() {
        super.func_70312_q();
        this.deadCache = true;
        this.handlerCache = null;
        this.receiverCache = null;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            boolean bl;
            if (this.deadCache) {
                this.reCache();
            }
            this.setIsActive(this._buffer > this._outputPulseSize * 2);
            boolean bl2 = bl = ++this._ticksSinceLastConsumption < this._ticksBetweenConsumption;
            if (Util.isRedstonePowered((TileEntity)this)) {
                return;
            }
            int n = Math.min(this._buffer, this._outputPulseSize);
            this._buffer -= n;
            this._buffer += this.transmitEnergy(n);
            if (bl || !this.canConsumeFuel(this._bufferMax - this._buffer)) {
                return;
            }
            if (this.consumeFuel()) {
                this._buffer += this.produceEnergy();
                this._ticksSinceLastConsumption = 0;
            }
        }
    }

    protected abstract boolean canConsumeFuel(int var1);

    protected abstract boolean consumeFuel();

    protected abstract int produceEnergy();

    protected final int transmitEnergy(int n) {
        if (this.handlerCache != null) {
            int n2 = this.handlerCache.length;
            while (n2-- > 0) {
                IEnergyHandler iEnergyHandler = this.handlerCache[n2];
                if (iEnergyHandler == null) continue;
                ForgeDirection forgeDirection = ForgeDirection.VALID_DIRECTIONS[n2];
                if (iEnergyHandler.receiveEnergy(forgeDirection, n, true) > 0) {
                    n -= iEnergyHandler.receiveEnergy(forgeDirection, n, false);
                }
                if (n > 0) continue;
                return 0;
            }
        }
        if (this.receiverCache != null) {
            float f;
            float f2 = f = (float)n / 10.0f;
            int n3 = this.receiverCache.length;
            while (n3-- > 0) {
                float f3;
                ForgeDirection forgeDirection;
                PowerHandler.PowerReceiver powerReceiver;
                IPowerReceptor iPowerReceptor = this.receiverCache[n3];
                if (iPowerReceptor == null || (powerReceiver = iPowerReceptor.getPowerReceiver(forgeDirection = ForgeDirection.VALID_DIRECTIONS[n3])) == null) continue;
                float f4 = powerReceiver.getMaxEnergyReceived();
                if (!(Math.min(f3, powerReceiver.getMaxEnergyStored() - powerReceiver.getEnergyStored()) > 0.0f)) continue;
                float f5 = Math.min(Math.min(f4, f2), powerReceiver.getMaxEnergyStored() - powerReceiver.getEnergyStored());
                powerReceiver.receiveEnergy(PowerHandler.Type.GATE, f5, forgeDirection);
                if (!((f2 -= f5) <= 0.0f)) continue;
                return 0;
            }
            n = (int)((float)n - (f - f2));
        }
        return n;
    }

    public int getBuffer() {
        return this._buffer;
    }

    public void setBuffer(int n) {
        this._buffer = n;
    }

    public int getBufferMax() {
        return this._bufferMax;
    }

    private void reCache() {
        if (this.deadCache) {
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                this.onNeighborTileChange(this.field_70329_l + forgeDirection.offsetX, this.field_70330_m + forgeDirection.offsetY, this.field_70327_n + forgeDirection.offsetZ);
            }
            this.deadCache = false;
        }
    }

    @Override
    public void onNeighborTileChange(int n, int n2, int n3) {
        TileEntity tileEntity = this.field_70331_k.func_72796_p(n, n2, n3);
        if (n < this.field_70329_l) {
            this.addCache(tileEntity, 5);
        } else if (n > this.field_70329_l) {
            this.addCache(tileEntity, 4);
        } else if (n3 < this.field_70327_n) {
            this.addCache(tileEntity, 3);
        } else if (n3 > this.field_70327_n) {
            this.addCache(tileEntity, 2);
        } else if (n2 < this.field_70330_m) {
            this.addCache(tileEntity, 1);
        } else if (n2 > this.field_70330_m) {
            this.addCache(tileEntity, 0);
        }
    }

    private void addCache(TileEntity tileEntity, int n) {
        PowerHandler.PowerReceiver powerReceiver;
        if (this.handlerCache != null) {
            this.handlerCache[n] = null;
        }
        if (this.receiverCache != null) {
            this.receiverCache[n] = null;
        }
        if (tileEntity instanceof IEnergyHandler) {
            if (((IEnergyHandler)tileEntity).canInterface(ForgeDirection.VALID_DIRECTIONS[n])) {
                if (this.handlerCache == null) {
                    this.handlerCache = new IEnergyHandler[6];
                }
                this.handlerCache[n] = (IEnergyHandler)tileEntity;
            }
        } else if (tileEntity instanceof IPowerReceptor && (powerReceiver = ((IPowerReceptor)tileEntity).getPowerReceiver(ForgeDirection.VALID_DIRECTIONS[n])) != null) {
            if (this.receiverCache == null) {
                this.receiverCache = new IPowerReceptor[6];
            }
            this.receiverCache[n] = (IPowerReceptor)tileEntity;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("ticksSinceLastConsumption", this._ticksSinceLastConsumption);
        nBTTagCompound.func_74768_a("buffer", this._buffer);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._ticksSinceLastConsumption = nBTTagCompound.func_74762_e("ticksSinceLastConsumption");
        this._buffer = nBTTagCompound.func_74762_e("buffer");
    }

    @Override
    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return 0;
    }

    @Override
    public boolean canInterface(ForgeDirection forgeDirection) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection forgeDirection) {
        return this._buffer;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return this._bufferMax;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection forgeDirection) {
        if (pipeType == IPipeTile.PipeType.POWER) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return super.overridePipeConnection(pipeType, forgeDirection);
    }

    @Override
    public boolean canEmitPowerFrom(ForgeDirection forgeDirection) {
        return true;
    }
}

