/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiChunkLoader;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerChunkLoader;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.net.ConnectionHandler;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityChunkLoader
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    protected static Map<String, Integer> fluidConsumptionRate = new HashMap<String, Integer>();
    protected short _radius = 0;
    protected boolean activated;
    protected boolean unableToRequestTicket;
    protected ForgeChunkManager.Ticket _ticket;
    protected int consumptionTicks;
    protected int emptyTicks;
    protected int prevEmpty;
    protected int unactivatedTicks;

    private static void bypassLimit(ForgeChunkManager.Ticket ticket) {
        try {
            Field field = ForgeChunkManager.Ticket.class.getDeclaredField("maxDepth");
            field.setAccessible(true);
            field.setInt(ticket, Short.MAX_VALUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public TileEntityChunkLoader() {
        super(Machine.ChunkLoader);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiChunkLoader(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        if (this.unableToRequestTicket && inventoryPlayer.field_70458_d.func_70005_c_().equals(this._owner)) {
            inventoryPlayer.field_70458_d.func_70006_a(new ChatMessageComponent().func_111072_b("chat.info.mfr.chunkloader.noticket"));
        }
        return new ContainerChunkLoader(this, inventoryPlayer);
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(10000)};
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this._ticket != null) {
            this.unforceChunks();
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this._ticket);
        }
    }

    public void setRadius(short n) {
        int n2 = 49;
        if (this._ticket != null) {
            n2 = Math.min((int)Math.sqrt((double)this._ticket.getChunkListDepth() / Math.PI), n2);
        }
        if (n < 0 | n > n2 | n == this._radius) {
            return;
        }
        this._radius = (short)n;
        this.func_70296_d();
        if (!this.field_70331_k.field_72995_K) {
            this.forceChunks();
        }
    }

    @Override
    protected boolean activateMachine() {
        this.activated = true;
        this.unactivatedTicks = 0;
        if (this.consumptionTicks > 0) {
            --this.consumptionTicks;
        } else {
            this.emptyTicks = Math.min(65535, this.emptyTicks + 1);
            FluidStack fluidStack = this._tanks[0].getFluid();
            if (this.drain(this._tanks[0], 1, true) == 1) {
                Integer n = fluidConsumptionRate.get(this.getFluidName(fluidStack));
                this.consumptionTicks = n == null ? 0 : n;
                this.emptyTicks = Math.max(-65535, this.emptyTicks - 2);
            }
        }
        return true;
    }

    @Override
    public void func_70316_g() {
        block14: {
            block13: {
                ImmutableSet immutableSet;
                block16: {
                    block15: {
                        if (this._owner.isEmpty()) {
                            return;
                        }
                        if (this.unableToRequestTicket) {
                            this.setIdleTicks(this.getIdleTicksMax());
                            super.setIsActive(false);
                            return;
                        }
                        this.activated = false;
                        if (!this.field_70331_k.field_72995_K && MFRConfig.enableChunkLoaderRequiresOwner.getBoolean(false) && !ConnectionHandler.onlinePlayerMap.containsKey(this._owner)) {
                            this.setIdleTicks(this.getIdleTicksMax());
                        }
                        super.func_70316_g();
                        if (this.field_70331_k.field_72995_K) {
                            return;
                        }
                        if (this.getIdleTicks() > 0) {
                            if (this._ticket != null) {
                                this.unforceChunks();
                            }
                            return;
                        }
                        if (this.activated) break block13;
                        if (this._ticket == null || (immutableSet = this._ticket.getChunkList()).size() == 0) break block14;
                        this.unactivatedTicks = Math.min(this._tanks[0].getCapacity() + 10, this.unactivatedTicks + 1);
                        if (this.consumptionTicks <= 0) break block15;
                        this.consumptionTicks /= 10;
                        break block16;
                    }
                    this.emptyTicks = Math.min(65535, this.emptyTicks + 1);
                    FluidStack fluidStack = this._tanks[0].getFluid();
                    if (this.drain(this._tanks[0], Math.min(this.unactivatedTicks, this._tanks[0].getFluidAmount()), true) != this.unactivatedTicks) break block16;
                    this.consumptionTicks = fluidConsumptionRate.get(this.getFluidName(fluidStack));
                    this.consumptionTicks = Math.max(0, this.consumptionTicks - this.unactivatedTicks);
                    this.activated = this.emptyTicks == 1 && this.unactivatedTicks < this._tanks[0].getCapacity();
                    this.emptyTicks = Math.max(-65535, this.emptyTicks - 2);
                    if (this.activated) break block14;
                }
                for (ChunkCoordIntPair chunkCoordIntPair : immutableSet) {
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this._ticket, (ChunkCoordIntPair)chunkCoordIntPair);
                }
                break block14;
            }
            if (this.activated & !this.isActive()) {
                if (this._ticket == null) {
                    this._ticket = ForgeChunkManager.requestPlayerTicket((Object)((Object)MineFactoryReloadedCore.instance()), (String)this._owner, (World)this.field_70331_k, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                    if (this._ticket == null) {
                        this.unableToRequestTicket = true;
                        return;
                    }
                    this._ticket.getModData().func_74768_a("X", this.field_70329_l);
                    this._ticket.getModData().func_74768_a("Y", this.field_70330_m);
                    this._ticket.getModData().func_74768_a("Z", this.field_70327_n);
                }
                this.forceChunks();
            }
        }
        if (this.prevEmpty != this.emptyTicks) {
            this.prevEmpty = this.emptyTicks;
            this.onFactoryInventoryChanged();
        }
        super.setIsActive(this.activated);
    }

    protected void unforceChunks() {
        ImmutableSet immutableSet = this._ticket.getChunkList();
        if (immutableSet.size() == 0) {
            return;
        }
        for (ChunkCoordIntPair chunkCoordIntPair : immutableSet) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this._ticket, (ChunkCoordIntPair)chunkCoordIntPair);
        }
    }

    protected void forceChunks() {
        int n;
        if (this._ticket == null) {
            return;
        }
        if (MFRConfig.enableChunkLimitBypassing.getBoolean(false)) {
            TileEntityChunkLoader.bypassLimit(this._ticket);
        }
        ImmutableSet immutableSet = this._ticket.getChunkList();
        int n2 = this.field_70329_l >> 4;
        int n3 = this.field_70327_n >> 4;
        int n4 = this._radius * this._radius;
        for (ChunkCoordIntPair chunkCoordIntPair : immutableSet) {
            n = chunkCoordIntPair.field_77276_a - n2;
            int n5 = chunkCoordIntPair.field_77275_b - n3;
            if (n * n + n5 * n5 <= n4) continue;
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this._ticket, (ChunkCoordIntPair)chunkCoordIntPair);
        }
        for (int i = -this._radius; i <= this._radius; ++i) {
            int n6 = i * i;
            for (n = (int)(-this._radius); n <= this._radius; ++n) {
                ChunkCoordIntPair chunkCoordIntPair;
                if (n6 + n * n > n4 || immutableSet.contains(chunkCoordIntPair = new ChunkCoordIntPair(n2 + i, n3 + n))) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this._ticket, (ChunkCoordIntPair)chunkCoordIntPair);
            }
        }
    }

    @Override
    protected void onFactoryInventoryChanged() {
        int n;
        int n2;
        if (this.func_70320_p()) {
            return;
        }
        int n3 = this._radius + 1;
        if (this._ticket == null) {
            n2 = 0;
            int n4 = this._radius * this._radius;
            for (int i = -this._radius; i <= this._radius; ++i) {
                n = i * i;
                for (int j = -this._radius; j <= this._radius; ++j) {
                    if (n + j * j > n4) continue;
                    ++n2;
                }
            }
        } else {
            n2 = this._ticket.getChunkList().size();
        }
        double d = n3 * n3 * 32 - 17 + n3 * n3 * n3;
        n = n3 / 10;
        while (n-- > 0) {
            d *= (double)n3 / 6.0;
        }
        this.setActivationEnergy((int)(d * 10.0) + (int)(StrictMath.cbrt(this.emptyTicks) * (double)n2));
    }

    public boolean receiveTicket(ForgeChunkManager.Ticket ticket) {
        if (!MFRConfig.enableChunkLoaderRequiresOwner.getBoolean(false) || ConnectionHandler.onlinePlayerMap.containsKey(this._owner)) {
            if (this._ticket == null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                this._ticket = ForgeChunkManager.requestPlayerTicket((Object)((Object)MineFactoryReloadedCore.instance()), (String)this._owner, (World)this.field_70331_k, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                if (this._ticket == null) {
                    this.unableToRequestTicket = true;
                    return true;
                }
                this._ticket.getModData().func_74768_a("X", this.field_70329_l);
                this._ticket.getModData().func_74768_a("Y", this.field_70330_m);
                this._ticket.getModData().func_74768_a("Z", this.field_70327_n);
            }
            return true;
        }
        this._ticket = ticket;
        this.unforceChunks();
        this._ticket = null;
        return false;
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74777_a("radius", this._radius);
        nBTTagCompound.func_74768_a("empty", this.emptyTicks);
        nBTTagCompound.func_74768_a("inactive", this.unactivatedTicks);
        nBTTagCompound.func_74768_a("consumed", this.consumptionTicks);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._radius = nBTTagCompound.func_74765_d("radius");
        this.emptyTicks = nBTTagCompound.func_74762_e("empty");
        this.unactivatedTicks = nBTTagCompound.func_74762_e("inactive");
        this.consumptionTicks = nBTTagCompound.func_74762_e("consumed");
        this.onFactoryInventoryChanged();
    }

    protected boolean isFluidFuel(FluidStack fluidStack) {
        String string = this.getFluidName(fluidStack);
        if (string == null) {
            return false;
        }
        return fluidConsumptionRate.containsKey(string);
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (!this.unableToRequestTicket & fluidStack != null && this.isFluidFuel(fluidStack)) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (fluidTank.getFluidAmount() != 0 && !fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.fill(fluidStack, bl);
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
            if (fluidTank.getFluidAmount() <= 0) continue;
            return fluidTank.drain(n, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (!fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.drain(fluidStack.amount, bl);
            }
        }
        return null;
    }

    @Override
    public boolean allowBucketFill() {
        return !this.unableToRequestTicket;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return !this.unableToRequestTicket;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return this.unableToRequestTicket;
    }

    protected String getFluidName(FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return null;
        }
        String string = fluidStack.getFluid().getName();
        if (string == null) {
            return null;
        }
        return string;
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 40;
    }

    public short getRadius() {
        return this._radius;
    }

    public boolean getUnableToWork() {
        return this.unableToRequestTicket;
    }

    @SideOnly(value=Side.CLIENT)
    public void setEmpty(int n) {
        this.emptyTicks = n;
        this.onFactoryInventoryChanged();
    }

    public short getEmpty() {
        return (short)this.emptyTicks;
    }

    @Override
    public void setIsActive(boolean bl) {
    }

    static {
        fluidConsumptionRate.put("mobessence", 10);
        fluidConsumptionRate.put("liquidessence", 20);
        fluidConsumptionRate.put("ender", 40);
    }
}

