/*
 * Decompiled with CFR 0.152.
 */
package skyboy.core.fluid;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ModContainer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import skyboy.core.container.CarbonContainer;

public final class LiquidRegistry {
    private static LiquidRegistry instance;
    private static final Map<String, Fluid> nameMap;
    private static final ArrayList<String> names;
    private static final Map<Fluid, String> liquidMap;
    private static final Map<String, Integer> idMap;
    private static final List<ILiquidRegistryCallback> callbacks;
    private static int id;
    private static Map<String, Boolean> seenNames;
    private static File config;
    private static ModContainer parent;

    public LiquidRegistry(File file, ModContainer modContainer) throws IOException {
        if (instance != null) {
            throw new IllegalArgumentException();
        }
        FMLLog.log((String)modContainer.getName(), (Level)Level.INFO, (String)"Creating %s LiquidRegistry", (Object[])new Object[]{modContainer.getName()});
        instance = this;
        parent = modContainer;
        this.loadLiquidConfig(new File(file.getAbsolutePath() + "/liquids.cfg"));
        for (Map.Entry entry : FluidRegistry.getRegisteredFluids().entrySet()) {
            Fluid fluid = (Fluid)entry.getValue();
            String string = (String)entry.getKey();
            FMLLog.log((String)parent.getName(), (Level)Level.FINER, (String)"Registering Liquid %s in PreInit", (Object[])new Object[]{string});
            this.preInitRegister(string, fluid);
            CarbonContainer.registerAsContainer(fluid);
        }
    }

    private void loadLiquidConfig(File file) throws IOException {
        String string;
        FMLLog.log((String)parent.getName(), (Level)Level.FINE, (String)"Loading Liquids", (Object[])new Object[0]);
        config = file;
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string2 = "";
        while ((string = bufferedReader.readLine()) != null) {
            String string3 = (string = string.trim()).substring(0, 3);
            if (string3.equalsIgnoreCase("end")) {
                id = Integer.parseInt(string.substring(4));
                continue;
            }
            if (!string3.equalsIgnoreCase("lis")) continue;
            string2 = string.substring(5);
        }
        bufferedReader.close();
        if (id < 0) {
            int n;
            int n2 = string2.indexOf(44);
            int n3 = n = n2 != -1 ? -1 : 0;
            while (n2 != -1) {
                ++n;
                n2 = string2.indexOf(44, n2);
            }
            FMLLog.log((String)parent.getName(), (Level)Level.SEVERE, (String)"Liquid list size %s loaded from config. Defaulting to actual list size of %s.", (Object[])new Object[]{id, n});
            id = n;
        }
        FMLLog.log((String)parent.getName(), (Level)Level.FINE, (String)"Loaded %s Liquids", (Object[])new Object[]{id});
        FMLLog.log((String)parent.getName(), (Level)Level.FINER, (String)"Preparing ID map", (Object[])new Object[]{id});
        names.ensureCapacity(id);
        int n = id;
        while (n-- != 0) {
            names.add("");
        }
        String[] stringArray = string2.split(",");
        int n4 = stringArray.length;
        while (n4-- != 0) {
            String string4 = stringArray[n4];
            int n5 = string4.lastIndexOf(58);
            if (n5 == -1) continue;
            int n6 = Integer.parseInt(string4.substring(n5 + 1));
            string4 = string4.substring(0, n5).trim();
            String string5 = names.get(n6);
            if (string5.isEmpty() && n6 < id && n6 > 0) {
                idMap.put(string4, n6);
                names.set(n6, string4);
                FMLLog.log((String)parent.getName(), (Level)Level.ALL, (String)"%s: %s", (Object[])new Object[]{n6, string4});
                continue;
            }
            if (n6 >= id || n6 <= 0) {
                FMLLog.log((String)parent.getName(), (Level)Level.WARNING, (String)"ID %s for %s outside range of 0-%s; skipping %s. This may break existing buckets.", (Object[])new Object[]{n6, string4, id, string4});
                continue;
            }
            FMLLog.log((String)parent.getName(), (Level)Level.SEVERE, (String)"Existing liquid [%s] using ID %s; skipping %s. This may break existing buckets.", (Object[])new Object[]{string5, n6, string4});
        }
    }

    public void saveLiquidConfig() throws IOException {
        FMLLog.log((String)parent.getName(), (Level)Level.FINE, (String)"Saving Liquids", (Object[])new Object[0]);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(config, false));
        bufferedWriter.write("end:", 0, 4);
        String string = Integer.toString(id, 10);
        bufferedWriter.write(string, 0, string.length());
        bufferedWriter.newLine();
        bufferedWriter.write("list:", 0, 5);
        FMLLog.log((String)parent.getName(), (Level)Level.FINER, (String)"Saving ID map", (Object[])new Object[0]);
        for (Map.Entry<String, Integer> entry : idMap.entrySet()) {
            string = entry.getKey();
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.write(58);
            string = Integer.toString(entry.getValue(), 10);
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.write(44);
            FMLLog.log((String)parent.getName(), (Level)Level.FINEST, (String)"%s: %s", (Object[])new Object[]{string, entry.getKey()});
        }
        bufferedWriter.newLine();
        bufferedWriter.close();
        FMLLog.log((String)parent.getName(), (Level)Level.FINE, (String)"Saved %s Liquids", (Object[])new Object[]{id});
    }

    @ForgeSubscribe
    public void registeredLiquid(FluidRegistry.FluidRegisterEvent fluidRegisterEvent) throws Throwable {
        String string = fluidRegisterEvent.fluidName;
        Fluid fluid = FluidRegistry.getFluid((String)string);
        FMLLog.log((String)parent.getName(), (Level)Level.FINER, (String)"Received LiquidRegistrationEvent for %s", (Object[])new Object[]{string});
        this.preInitRegister(string, fluid);
        if (!seenNames.containsKey(string)) {
            CarbonContainer.registerAsContainer(fluid);
            LiquidEvent liquidEvent = new LiquidEvent(fluidRegisterEvent, idMap.get(string));
            for (ILiquidRegistryCallback iLiquidRegistryCallback : callbacks) {
                try {
                    iLiquidRegistryCallback.registeredLiquid(liquidEvent);
                }
                catch (Throwable throwable) {}
            }
            seenNames.put(string, true);
        } else {
            FMLLog.log((String)parent.getName(), (Level)Level.FINER, (String)"%s has previously triggered a LiquidRegistrationEvent", (Object[])new Object[]{string});
        }
    }

    public void preInitRegister(String string, Fluid fluid) throws IOException {
        Fluid fluid2 = fluid;
        if (!liquidMap.containsKey(fluid2)) {
            liquidMap.put(fluid2, string);
            nameMap.put(string, fluid);
        } else {
            FMLLog.log((String)parent.getName(), (Level)Level.FINEST, (String)"%s already has a LiquidStack associated", (Object[])new Object[]{string});
        }
        if (!names.contains(string)) {
            idMap.put(string, id);
            names.add(id, string);
            FMLLog.log((String)parent.getName(), (Level)Level.FINER, (String)"Added %s to the ID map as %s", (Object[])new Object[]{string, id});
            ++id;
            if (Loader.instance().getModState(parent).ordinal() >= LoaderState.ModState.AVAILABLE.ordinal()) {
                FMLLog.log((String)parent.getName(), (Level)Level.FINE, (String)"Liquid %s registered after LoadComplete", (Object[])new Object[]{string});
                this.saveLiquidConfig();
            }
        }
    }

    public static String getName(FluidStack fluidStack) {
        return liquidMap.get(fluidStack.getFluid());
    }

    public static String getName(int n) {
        return n < id ? names.get(n) : null;
    }

    public static FluidStack getLiquid(String string) {
        FluidStack fluidStack = FluidRegistry.getFluidStack((String)string, (int)1000);
        return fluidStack != null ? fluidStack.copy() : null;
    }

    public static FluidStack getLiquid(int n) {
        return LiquidRegistry.getLiquid(LiquidRegistry.getName(n));
    }

    public static FluidStack getLiquid(String string, int n) {
        FluidStack fluidStack = LiquidRegistry.getLiquid(string);
        if (fluidStack != null) {
            fluidStack.amount = n;
        }
        return fluidStack;
    }

    public static FluidStack getLiquid(int n, int n2) {
        return LiquidRegistry.getLiquid(LiquidRegistry.getName(n), n2);
    }

    public static int getID(FluidStack fluidStack) {
        return LiquidRegistry.getID(LiquidRegistry.getName(fluidStack));
    }

    public static int getID(String string) {
        return idMap.get(string);
    }

    public static String[] getNames() {
        int n = id - 1;
        String[] stringArray = new String[n];
        while (n-- != 0) {
            stringArray[n] = names.get(n);
        }
        return stringArray;
    }

    public static boolean liquidExists(String string) {
        return nameMap.get(string) != null;
    }

    public static boolean liquidExists(int n) {
        return LiquidRegistry.liquidExists(LiquidRegistry.getName(n));
    }

    public static int getRegisteredLiquidCount() {
        return id - 1;
    }

    public static void registerCallback(ILiquidRegistryCallback iLiquidRegistryCallback) {
        if (iLiquidRegistryCallback != null) {
            callbacks.add(iLiquidRegistryCallback);
        }
    }

    static {
        nameMap = new HashMap<String, Fluid>();
        names = new ArrayList();
        liquidMap = new HashMap<Fluid, String>();
        idMap = new HashMap<String, Integer>();
        callbacks = new ArrayList<ILiquidRegistryCallback>();
        id = 1;
        seenNames = new HashMap<String, Boolean>();
    }

    public static interface ILiquidRegistryCallback {
        public void registeredLiquid(LiquidEvent var1);
    }

    public class LiquidEvent
    extends FluidRegistry.FluidRegisterEvent {
        public final int ID;

        public LiquidEvent(FluidRegistry.FluidRegisterEvent fluidRegisterEvent, int n) {
            super(fluidRegisterEvent.fluidName, fluidRegisterEvent.fluidID);
            this.ID = n;
        }
    }
}

