/*
 * Decompiled with CFR 0.152.
 */
package appeng.common;

import appeng.api.IAEItemStack;
import appeng.api.IAppEngApi;
import appeng.api.ICellRegistry;
import appeng.api.IExternalStorageRegistry;
import appeng.api.IGridCacheRegistry;
import appeng.api.IGrinderRecipeManager;
import appeng.api.IItemList;
import appeng.api.ILocateableRegistry;
import appeng.api.ISpecialComparisonRegistry;
import appeng.api.IWirelessTermRegistery;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.me.items.IMemoryCard;
import appeng.api.me.tiles.IColoredMETile;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.util.IAssemblerPattern;
import appeng.api.me.util.IMEInventory;
import appeng.api.me.util.IMEInventoryUtil;
import appeng.common.AppEng;
import appeng.common.registries.AppEngCellRegistry;
import appeng.common.registries.AppEngExternalStorageRegistry;
import appeng.common.registries.AppEngGridCacheRegistry;
import appeng.common.registries.AppEngGrinderRecipeManager;
import appeng.common.registries.AppEngLocateableRegistry;
import appeng.common.registries.AppEngSpecialComparisonRegistry;
import appeng.common.registries.AppEngWirelessRegistry;
import appeng.me.AssemblerPatternInventory;
import appeng.me.CellInventory;
import appeng.me.MEInventoryUtil;
import appeng.me.tile.TileCable;
import appeng.me.tile.TileColorlessCable;
import appeng.util.AEItemStack;
import appeng.util.ItemList;
import appeng.util.Platform;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class AppEngApi
implements IAppEngApi {
    private AppEngGrinderRecipeManager GrinderRecipes = new AppEngGrinderRecipeManager();
    private AppEngExternalStorageRegistry ExternalStorageHandlers = new AppEngExternalStorageRegistry();
    private AppEngCellRegistry CellRegistry = new AppEngCellRegistry();
    private AppEngLocateableRegistry LocateableRegistry = new AppEngLocateableRegistry();
    private AppEngSpecialComparisonRegistry SpecialComparsonRegistry = new AppEngSpecialComparisonRegistry();
    private AppEngWirelessRegistry WirelessRegistery = new AppEngWirelessRegistry();
    private AppEngGridCacheRegistry GridCacheRegistry = new AppEngGridCacheRegistry();

    public static IAppEngApi getInstance() {
        return AppEng.getApiInstance();
    }

    @Override
    public IMEInventoryUtil getIMEInventoryUtil(IMEInventory mei) {
        return new MEInventoryUtil(mei);
    }

    @Override
    public IWirelessTermRegistery getWirelessRegistry() {
        return this.WirelessRegistery;
    }

    @Override
    public Object getLocateableBySerial(Long serial) {
        return this.LocateableRegistry.findLocateableBySerial(serial);
    }

    @Override
    public IAEItemStack createItemStack(ItemStack is) {
        return AEItemStack.create(is);
    }

    @Override
    public IItemList createItemList() {
        return new ItemList();
    }

    @Override
    public ICellRegistry getCellRegistry() {
        return this.CellRegistry;
    }

    @Override
    public IGrinderRecipeManager getGrinderRecipeManage() {
        return this.GrinderRecipes;
    }

    @Override
    public ISpecialComparisonRegistry getSpecialComparsonRegistry() {
        return this.SpecialComparsonRegistry;
    }

    @Override
    public IExternalStorageRegistry getExternalStorageRegistry() {
        return this.ExternalStorageHandlers;
    }

    @Override
    public IMemoryCard getMemoryCardHandler() {
        return AppEng.getInstance().registration.itemMemoryCard;
    }

    @Override
    public boolean paintBlock(World world, int x, int y, int z, int color) {
        int getMEColor = Platform.MC2MEColor(color);
        TileEntity te = world.func_72796_p(x, y, z);
        int blockID = world.func_72798_a(x, y, z);
        if (te instanceof IColoredMETile && te instanceof IGridTileEntity && getMEColor >= 0 && ((IColoredMETile)te).getColor() != getMEColor) {
            if (te instanceof TileCable) {
                world.func_72832_d(x, y, z, AppEng.getInstance().registration.blkCable_Colored[getMEColor].getBlockID(), AppEng.getInstance().registration.blkCable_Colored[getMEColor].getMetaData(), 3);
            }
            IGridTileEntity ent = (IGridTileEntity)te;
            ((IColoredMETile)te).setColor(getMEColor);
            Block.field_71973_m[blockID].func_71863_a(world, x, y, z, 0);
            world.func_72845_h(x, y, z);
            MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(ent, world, ent.getLocation()));
            return true;
        }
        if (te instanceof TileColorlessCable && getMEColor >= 0) {
            world.func_72832_d(x, y, z, AppEng.getInstance().registration.blkCable_Colored[getMEColor].getBlockID(), AppEng.getInstance().registration.blkCable_Colored[getMEColor].getMetaData(), 3);
            te = new TileCable();
            world.func_72837_a(x, y, z, te);
            IGridTileEntity ent = (IGridTileEntity)te;
            if (((IColoredMETile)te).getColor() != getMEColor) {
                ((IColoredMETile)te).setColor(getMEColor);
                world.func_72845_h(x, y, z);
                MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(ent, world, ent.getLocation()));
                return true;
            }
        }
        return false;
    }

    @Override
    public ILocateableRegistry getLocateableRegistry() {
        return this.LocateableRegistry;
    }

    @Override
    public ItemStack addItemsToInv(IMEInventory inv, ItemStack is) {
        return Platform.addItems(inv, is);
    }

    @Override
    public void addBasicBlackList(int itemID, int meta) {
        CellInventory.addBasicBlackList(itemID, meta);
    }

    @Override
    public IMEInventory getBasicCell(ItemStack i) {
        return CellInventory.getCell(i);
    }

    @Override
    public Boolean isBasicCell(ItemStack i) {
        return CellInventory.isCell(i);
    }

    @Override
    public IAssemblerPattern getAssemblerPattern(ItemStack i) {
        return AssemblerPatternInventory.getAssemblerPattern(i);
    }

    @Override
    public Boolean isAssemblerPattern(ItemStack i) {
        return AssemblerPatternInventory.isAssemblerPattern(i);
    }

    @Override
    public Boolean isBlankPattern(ItemStack i) {
        return AssemblerPatternInventory.isBlankPattern(i);
    }

    @Override
    public ItemStack extractItems(IMEInventory inv, ItemStack is) {
        return Platform.extractItems(inv, is);
    }

    @Override
    public IGridCacheRegistry getGridCacheRegistry() {
        return this.GridCacheRegistry;
    }
}

