/*
 * Decompiled with CFR 0.152.
 */
package appeng.common;

import appeng.api.config.EnableDisable;
import appeng.api.config.PowerUnits;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.common.AppEngCreativeTab;
import appeng.common.AutoID;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Date;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Configuration;

public class AppEngConfiguration
extends Configuration {
    public static final String VERSION = "rv13.c";
    public static final String CHANNEL = "Stable";
    public static final boolean disallowCells = true;
    public static final boolean enableTestItem = false;
    public static boolean allowLogging = false;
    public static boolean logPowerUsage = false;
    public static boolean logGrinderOres = false;
    public static boolean logCrafting = false;
    public static boolean logInventoryAdaptor = false;
    public static boolean logIntegration = false;
    public static boolean logConcurrentModificationExceptions = false;
    public static boolean enableQuartzTools = true;
    public static boolean enableCrafting = true;
    public static boolean enableWirelessAccess = true;
    public static boolean enableLevelEmiter = true;
    public static boolean enableCraftingTerm = true;
    public static boolean enableStorageMonitor = true;
    public static boolean enableGrinder = true;
    public static boolean enableMAC = true;
    public static boolean enableQNB = true;
    public static boolean enableTPlane = true;
    public static boolean enableImportBus = true;
    public static boolean enableExportBus = true;
    public static boolean enableStorageBus = true;
    public static boolean enableVibrationCata = true;
    public static boolean enableEntropyAcc = true;
    public static boolean enableMassCannon = true;
    public static boolean enableMassCannonBlockDamage = true;
    public static boolean enableTinyTNTBlockDamage = true;
    public static boolean disableNetherQuartzRecipes = false;
    public static boolean enableStorageMonitorConvMatrix = true;
    public static boolean enableVillagerTrading = true;
    public static boolean useBuildcraftChips = false;
    public static boolean enableBCtoMEChipRecipe = false;
    public static boolean disableNonAssemblyTableChips = false;
    public static boolean gfxDrivesHighDef = true;
    public static boolean gfxCableAnimation = true;
    public static int gfxCableMinTickRate = 22;
    public static AutoID blockMulti = new AutoID(AutoID.Type.BLOCK, "appeng.blockMulti", 900);
    public static AutoID blockMulti2 = new AutoID(AutoID.Type.BLOCK, "appeng.blockMulti2", 901);
    public static AutoID blockMulti3 = new AutoID(AutoID.Type.BLOCK, "appeng.blockMulti3", 903);
    public static AutoID blockWorld = new AutoID(AutoID.Type.BLOCK, "appeng.blockWorld", 902);
    public static AutoID blockTinyTNT = new AutoID(AutoID.Type.BLOCK, "appeng.TinyTNT", 904);
    public static AutoID itemMulti = new AutoID(AutoID.Type.ITEM, "appeng.itemMulti", 4105);
    public static AutoID itemMaterial = new AutoID(AutoID.Type.ITEM, "appeng.materialID", 4106);
    public static AutoID toolEntropyAccelerator = new AutoID(AutoID.Type.ITEM, "appeng.toolEntropyAccelerator", 4107);
    public static AutoID toolVibrationCatalyst = new AutoID(AutoID.Type.ITEM, "appeng.toolVibrationCatalyst", 4108);
    public static AutoID toolQuartzAxe = new AutoID(AutoID.Type.ITEM, "appeng.toolQuartzAxe", 4109);
    public static AutoID toolQuartzHoe = new AutoID(AutoID.Type.ITEM, "appeng.toolQuartzHoe", 4110);
    public static AutoID toolQuartzShovel = new AutoID(AutoID.Type.ITEM, "appeng.toolQuartzShovel", 4111);
    public static AutoID toolQuartzPick = new AutoID(AutoID.Type.ITEM, "appeng.toolQuartzPick", 4112);
    public static AutoID toolQuartzSword = new AutoID(AutoID.Type.ITEM, "appeng.toolQuartzSword", 4113);
    public static AutoID toolQuartzWrench = new AutoID(AutoID.Type.ITEM, "appeng.toolQuartzWrench", 4114);
    public static AutoID toolQuartzKnife = new AutoID(AutoID.Type.ITEM, "appeng.toolQuartzKnife", 4115);
    public static AutoID toolMassCannon = new AutoID(AutoID.Type.ITEM, "appeng.toolMassCannon", 4116);
    public static AutoID itemMultiChargeable = new AutoID(AutoID.Type.ITEM, "appeng.itemMultiChargeable", 4117);
    public static double WirelessRange = 32.0;
    public static int WirelessRangeExtenders = 16;
    public static int WirelessRangeExtenderBonus = 2;
    public static boolean terminalUseLargeFont = false;
    public static boolean terminalSearchToolTips = true;
    public static SearchBoxMode terminalAutoSearch = SearchBoxMode.Autosearch;
    public static boolean enableVersionChecker = true;
    public static boolean enableWorldGenQuartz = true;
    public static boolean enableSpaceClickMoving = true;
    public static int additionalOresPerCluster = 0;
    public static PowerUnits defaultUnits = PowerUnits.AE;
    public static boolean requirePower = true;
    public static boolean sharePowerLPRS485 = true;
    public static float tier1Power = 0.5f;
    public static float tier2Power = 1.0f;
    public static float tier3Power = 1.5f;
    public static float tier4Power = 2.0f;
    public static float powerUsageMultiplier = 1.0f;
    public static int automationMinTickRate = 5;
    public static int storageBusMinTickRate = 5;
    public static int craftingMinTickRate = 0;
    public static int terminalUpdateMinTickRate = 0;
    public static int blockUpdateMinTickRate = 12;
    public static int condenserMatterBalls = 256;
    public static int condenserSingularies = 256000;
    public long lastLoaded = 0L;
    public static String[] blackListTransition = new String[0];
    public static String[] grinderOres = new String[]{"Obsidian", "EnderPearl", "Coal", "Iron", "Gold", "Invar", "Aluminium", "Electrum", "Charcoal", "Copper", "Tin", "Silver", "Lead", "Bronze", "Brass", "Platinum", "Nickel"};
    public static final String PACKET_CHANNEL = "AE";
    public static final AppEngCreativeTab creativeTab = new AppEngCreativeTab("Applied Energistics");
    public static SortOrder SortBy = SortOrder.Name;
    public static SortDir SortDirection = SortDir.ASC;
    public static ViewItems SortView = ViewItems.ALL;
    public static EnableDisable enableShiftInCondenser = EnableDisable.Disabled;
    public static double WirelessDistanceMultiplier = 10.0;
    public static boolean disableNetherQuartzDeblocking = false;
    public static boolean logTransaction = false;
    public static boolean logBlockUpdates = false;
    public static float perTickNetworkBridge = 200.0f;
    public static long packetSize;

    public static ResourceLocation GfxPath(String file) {
        return new ResourceLocation("appeng", "textures/" + file);
    }

    private int getItemID(String name, int defid) {
        return this.getItem(name, defid).getInt();
    }

    public void save() {
        if (enableVersionChecker) {
            this.get("appeng.vesionChecker", "lastStarted", "").set(Long.toString(new Date().getTime(), 36));
        }
        this.get("me.options", "terminalSortBy", SortBy.toString()).set(SortBy.toString());
        this.get("me.options", "terminalSortDirection", SortDirection.toString()).set(SortDirection.toString());
        this.get("me.options", "terminalViewItems", SortView.toString()).set(SortView.toString());
        this.get("me.options", "terminalAutoSearch", terminalAutoSearch.toString()).set(terminalAutoSearch.toString());
        this.get("me.options", "enableShiftInCondenser", enableShiftInCondenser == EnableDisable.Enabled).set(enableShiftInCondenser == EnableDisable.Enabled);
        this.get("me.options", "defaultUnits", defaultUnits.toString()).set(defaultUnits.toString());
        super.save();
    }

    public AppEngConfiguration(File file) {
        super(file);
        this.load();
        this.addCustomCategoryComment("logging", "Enable or disable various logging features, enabling logging features will create large logs.");
        this.addCustomCategoryComment("graphics", "Adjust Visual quality of complicated rendering.");
        this.addCustomCategoryComment("appeng.options", "Options for Applied Energistics as a whole.");
        this.addCustomCategoryComment("me.options", "Options for Mass Energy Components.");
        this.addCustomCategoryComment("item", "ItemID's for items added by Applied Energistics.");
        this.addCustomCategoryComment("features", "Enable / Disable AE Features.");
        this.addCustomCategoryComment("block", "BlockID's for blocks added by Applied Energistics ( these are not shifted. +256 for Ingame )\nTinyTNT - set to -1 to disable ( you can turn off block damage for this item using enableTinyTNTBlockDamage )");
        allowLogging = this.get("logging", "enableLogging", allowLogging).getBoolean(allowLogging);
        logGrinderOres = this.get("logging", "logGrinderOres", logGrinderOres).getBoolean(logGrinderOres);
        logPowerUsage = this.get("logging", "logPowerUsage", logPowerUsage).getBoolean(logPowerUsage);
        logCrafting = this.get("logging", "logCrafting", logCrafting).getBoolean(logCrafting);
        logInventoryAdaptor = this.get("logging", "logInventoryAdaptor", logInventoryAdaptor).getBoolean(logInventoryAdaptor);
        logIntegration = this.get("logging", "logIntegration", logIntegration).getBoolean(logIntegration);
        logTransaction = this.get("logging", "logTransactions", logTransaction).getBoolean(logTransaction);
        logBlockUpdates = this.get("logging", "logBlockUpdates", logBlockUpdates).getBoolean(logBlockUpdates);
        logConcurrentModificationExceptions = this.get("logging", "logConcurrentModificationExceptions", logConcurrentModificationExceptions).getBoolean(logConcurrentModificationExceptions);
        gfxDrivesHighDef = this.get("graphics", "gfxDrivesHighDef", gfxDrivesHighDef).getBoolean(gfxDrivesHighDef);
        gfxCableAnimation = this.get("graphics", "gfxCableAnimation", gfxCableAnimation).getBoolean(gfxCableAnimation);
        gfxCableMinTickRate = this.get("graphics", "gfxCableMinTickRate", gfxCableMinTickRate).getInt(gfxCableMinTickRate);
        grinderOres = this.get("grindstone", "grindableOres", grinderOres).getStringList();
        blackListTransition = this.get("transitionPlane", "blackList", blackListTransition).getStringList();
        useBuildcraftChips = this.get("appeng.bcIntegration", "useBuildcraftChips", useBuildcraftChips).getBoolean(useBuildcraftChips);
        enableBCtoMEChipRecipe = this.get("appeng.bcIntegration", "enableBCtoMEChipRecipe", enableBCtoMEChipRecipe).getBoolean(enableBCtoMEChipRecipe);
        enableSpaceClickMoving = this.get("features", "enableSpaceClickMoving", enableSpaceClickMoving).getBoolean(enableSpaceClickMoving);
        enableGrinder = this.get("features", "enableGrinder", enableGrinder).getBoolean(enableGrinder);
        enableVibrationCata = this.get("features", "enableVibrationCata", enableVibrationCata).getBoolean(enableVibrationCata);
        enableEntropyAcc = this.get("features", "enableEntropyAcc", enableEntropyAcc).getBoolean(enableEntropyAcc);
        enableMassCannon = this.get("features", "enableMassCannon", enableMassCannon).getBoolean(enableMassCannon);
        enableMassCannonBlockDamage = this.get("features", "enableMassCannonBlockDamage", enableMassCannonBlockDamage).getBoolean(enableMassCannonBlockDamage);
        enableTinyTNTBlockDamage = this.get("features", "enableTinyTNTBlockDamage", enableTinyTNTBlockDamage).getBoolean(enableTinyTNTBlockDamage);
        enableQuartzTools = this.get("features", "enableQuartzTools", enableQuartzTools).getBoolean(enableQuartzTools);
        enableTPlane = this.get("features", "enableTPlane", enableTPlane).getBoolean(enableTPlane);
        enableMAC = this.get("features", "enableMAC", enableMAC).getBoolean(enableMAC);
        enableQNB = this.get("features", "enableQNB", enableQNB).getBoolean(enableQNB);
        enableImportBus = this.get("features", "enableImportBus", enableImportBus).getBoolean(enableImportBus);
        enableExportBus = this.get("features", "enableExportBus", enableExportBus).getBoolean(enableExportBus);
        enableStorageBus = this.get("features", "enableStorageBus", enableStorageBus).getBoolean(enableStorageBus);
        enableCrafting = this.get("features", "enableCrafting", enableCrafting).getBoolean(enableCrafting);
        enableWirelessAccess = this.get("features", "enableWirelessAccess", enableWirelessAccess).getBoolean(enableWirelessAccess);
        enableLevelEmiter = this.get("features", "enableLevelEmiter", enableLevelEmiter).getBoolean(enableLevelEmiter);
        enableStorageMonitor = this.get("features", "enableStorageMonitor", enableStorageMonitor).getBoolean(enableStorageMonitor);
        enableCraftingTerm = this.get("features", "enableCraftingTerm", enableCraftingTerm).getBoolean(enableCraftingTerm);
        enableStorageMonitorConvMatrix = this.get("features", "enableStorageMonitorConvMatrix", enableStorageMonitorConvMatrix).getBoolean(enableStorageMonitorConvMatrix);
        enableVillagerTrading = this.get("features", "enableVillagerTrading", enableVillagerTrading).getBoolean(enableVillagerTrading);
        enableWorldGenQuartz = this.get("appeng.options", "enableWorldGenQuartz", enableWorldGenQuartz).getBoolean(true);
        enableVersionChecker = this.get("appeng.options", "enableVersionChecker", enableVersionChecker).getBoolean(true);
        additionalOresPerCluster = this.get("appeng.options", "ore.additionalOresPerCluster", additionalOresPerCluster).getInt();
        disableNetherQuartzRecipes = this.get("appeng.disableNetherQuartzRecipes", "ore.disableNetherQuartzRecipes", disableNetherQuartzRecipes).getBoolean(disableNetherQuartzRecipes);
        disableNetherQuartzDeblocking = this.get("appeng.disableNetherQuartzDeblocking", "ore.disableNetherQuartzDeblocking", disableNetherQuartzDeblocking).getBoolean(disableNetherQuartzDeblocking);
        if (additionalOresPerCluster < 0) {
            additionalOresPerCluster = 0;
        }
        try {
            defaultUnits = PowerUnits.valueOf(this.get("me.options", "defaultUnits", defaultUnits.toString()).getString());
        }
        catch (Throwable _) {
            defaultUnits = PowerUnits.AE;
        }
        requirePower = this.get("me.options", "requirePower", requirePower).getBoolean(true);
        sharePowerLPRS485 = this.get("me.options", "sharePowerLPRS485", sharePowerLPRS485).getBoolean(true);
        condenserMatterBalls = this.get("me.condenser", "MatterBalls", condenserMatterBalls).getInt(condenserMatterBalls);
        condenserSingularies = this.get("me.condenser", "Singularies", condenserSingularies).getInt(condenserSingularies);
        tier1Power = (float)this.get("me.power", "tier1Power", tier1Power).getDouble((double)tier1Power);
        tier2Power = (float)this.get("me.power", "tier2Power", tier2Power).getDouble((double)tier2Power);
        tier3Power = (float)this.get("me.power", "tier3Power", tier3Power).getDouble((double)tier3Power);
        tier4Power = (float)this.get("me.power", "tier4Power", tier4Power).getDouble((double)tier4Power);
        perTickNetworkBridge = (float)this.get("me.options", "perTickNetworkBridge", perTickNetworkBridge).getDouble((double)perTickNetworkBridge);
        powerUsageMultiplier = (float)this.get("me.options", "powerUsageMultiplier", powerUsageMultiplier).getDouble((double)powerUsageMultiplier);
        WirelessDistanceMultiplier = (float)this.get("me.options", "powerWirelessDistanceMultiplier", WirelessDistanceMultiplier).getDouble(WirelessDistanceMultiplier);
        storageBusMinTickRate = this.get("me.options", "storageBusMinTickRate", storageBusMinTickRate).getInt(storageBusMinTickRate);
        automationMinTickRate = this.get("me.options", "automationMinTickRate", automationMinTickRate).getInt(automationMinTickRate);
        craftingMinTickRate = this.get("me.options", "craftingMinTickRate", craftingMinTickRate).getInt(craftingMinTickRate);
        terminalUpdateMinTickRate = this.get("me.options", "terminalUpdateMinTickRate", terminalUpdateMinTickRate).getInt(terminalUpdateMinTickRate);
        blockUpdateMinTickRate = this.get("me.options", "updateMinTickRate", blockUpdateMinTickRate).getInt(blockUpdateMinTickRate);
        if ((double)powerUsageMultiplier < 0.01) {
            requirePower = false;
        }
        try {
            SortBy = SortOrder.valueOf(this.get("me.options", "terminalSortBy", SortBy.toString(), "Name, Size, or Priority").getString());
            SortDirection = SortDir.valueOf(this.get("me.options", "terminalSortDirection", SortDirection.toString(), "ASC, or DESC").getString());
            SortView = ViewItems.valueOf(this.get("me.options", "terminalViewItems", SortView.toString(), "").getString());
        }
        catch (Exception e) {
            SortBy = SortOrder.Name;
            SortDirection = SortDir.ASC;
            SortView = ViewItems.ALL;
        }
        enableShiftInCondenser = this.get("me.options", "enableShiftInCondenser", enableShiftInCondenser == EnableDisable.Enabled).getBoolean(enableShiftInCondenser == EnableDisable.Enabled) ? EnableDisable.Enabled : EnableDisable.Disabled;
        terminalUseLargeFont = this.get("me.options", "terminalUseLargeFont", terminalUseLargeFont).getBoolean(terminalUseLargeFont);
        terminalSearchToolTips = this.get("me.options", "terminalSearchToolTips", terminalSearchToolTips).getBoolean(terminalSearchToolTips);
        try {
            terminalAutoSearch = SearchBoxMode.valueOf(this.get("me.options", "terminalAutoSearch", terminalAutoSearch.toString()).getString());
        }
        catch (Throwable _) {
            terminalAutoSearch = SearchBoxMode.Autosearch;
        }
        WirelessRange = this.get("me.options", "base.wireless.range", WirelessRange).getDouble(WirelessRange);
        WirelessRangeExtenders = this.get("me.options", "max.wireless.extenders", WirelessRangeExtenders).getInt(WirelessRangeExtenders);
        WirelessRangeExtenderBonus = this.get("me.options", "max.wireless.extenderBonus", WirelessRangeExtenderBonus).getInt(WirelessRangeExtenderBonus);
        if (enableVersionChecker) {
            this.lastLoaded = Long.parseLong(this.get("appeng.vesionChecker", "lastStarted", "0").getString(), 36);
        }
        this.initItemAndBlockIDs();
    }

    private void initItemAndBlockIDs() {
        Class<AppEngConfiguration> c = AppEngConfiguration.class;
        for (Field f : c.getFields()) {
            if (!f.getType().isAssignableFrom(AutoID.class)) continue;
            try {
                AutoID ai = (AutoID)f.get(AppEngConfiguration.class);
                ai.pass1(this);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void confirmItemAndBLockIDs() {
        Class<AppEngConfiguration> c = AppEngConfiguration.class;
        for (Field f : c.getFields()) {
            if (!f.getType().isAssignableFrom(AutoID.class)) continue;
            try {
                AutoID ai = (AutoID)f.get(AppEngConfiguration.class);
                ai.pass2(this);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.save();
    }

    public void confirmOwnership() {
        Class<AppEngConfiguration> c = AppEngConfiguration.class;
        for (Field f : c.getFields()) {
            if (!f.getType().isAssignableFrom(AutoID.class)) continue;
            try {
                AutoID ai = (AutoID)f.get(AppEngConfiguration.class);
                ai.conirmOwnership(this);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

