/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.base;

import appeng.api.Blocks;
import appeng.api.me.items.IMemoryCard;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngTextureRegistry;
import appeng.common.AutoID;
import appeng.common.base.AppEngMultiItemBlock;
import appeng.common.base.AppEngSubBlock;
import appeng.common.base.AppEngTile;
import appeng.common.base.IAEItemOrBlock;
import appeng.interfaces.ICustomCollision;
import appeng.interfaces.IDismantleable;
import appeng.me.block.BlockCable;
import appeng.me.block.BlockColorlessCable;
import appeng.me.block.BlockDarkCable;
import appeng.me.block.BlockInputCableBasic;
import appeng.me.block.BlockInputCableFuzzy;
import appeng.me.block.BlockInputCablePrecision;
import appeng.me.block.BlockLevelEmitter;
import appeng.me.block.BlockOutputCableBasic;
import appeng.me.block.BlockOutputCableFuzzy;
import appeng.me.block.BlockOutputCablePrecision;
import appeng.me.block.BlockQuantumLinkChamber;
import appeng.me.block.BlockQuantumRing;
import appeng.me.block.BlockStorageBus;
import appeng.me.block.BlockStorageBusFuzzy;
import appeng.proxy.helpers.IFacadeTile;
import appeng.render.AppEngBlockRenderer;
import appeng.tech1.block.BlockPhantom;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IPartialSealedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.minefactoryreloaded.api.rednet.IConnectableRedNet;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;

public class AppEngMultiBlock
extends BlockContainer
implements IAEItemOrBlock,
IPartialSealedBlock,
IConnectableRedNet {
    private int subBlocks;
    private AppEngSubBlock[] SubBlocks;
    private String blockName;
    public static List<AppEngMultiBlock> multiBLocks = new ArrayList<AppEngMultiBlock>();
    public boolean[] dontrender;
    private static final ThreadLocal<ItemStack> placingIS = new ThreadLocal();

    public AppEngMultiBlock(AutoID id) {
        super(id.get(), Material.field_76243_f);
        id.setID(this, this.field_71990_ca);
        this.func_71849_a(AppEngConfiguration.creativeTab);
        this.subBlocks = 0;
        this.SubBlocks = new AppEngSubBlock[16];
        this.func_71848_c(1.9f);
        this.func_71894_b(5.0f);
        multiBLocks.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World w, int x, int y, int z, Random r) {
        int meta = w.func_72805_g(x, y, z);
        if (this.notValidBlock(meta)) {
            return;
        }
        this.SubBlocks[meta].randomDisplayTick(w, x, y, z, r);
    }

    public void func_71847_b(World w, int x, int y, int z, Random r) {
        int meta = w.func_72805_g(x, y, z);
        if (this.notValidBlock(meta)) {
            return;
        }
        this.SubBlocks[meta].updateTick(w, x, y, z, r);
    }

    public int func_71885_a(int meta, Random rand, int fortune) {
        if (this.notValidBlock(meta)) {
            return 1;
        }
        return this.SubBlocks[meta].idDropped(meta, rand, fortune);
    }

    public int func_71899_b(int meta) {
        if (this.notValidBlock(meta)) {
            return 1;
        }
        return this.SubBlocks[meta].damageDropped(meta);
    }

    public int func_71910_a(int meta, Random rand) {
        if (this.notValidBlock(meta)) {
            return 1;
        }
        return this.SubBlocks[meta].quantityDroppedWithBonus(meta, rand);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        if (this.notValidBlock(meta)) {
            return 1;
        }
        return this.SubBlocks[meta].quantityDropped(meta, fortune, random);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        AppEngTextureRegistry.loadTextures(par1IconRegister, AppEngTextureRegistry.Blocks);
    }

    public void func_71869_a(World w, int x, int y, int z, Entity entitiy) {
        int metadata = w.func_72805_g(x, y, z);
        if (!this.notValidBlock(metadata)) {
            this.SubBlocks[metadata].onEntityCollidedWithBlock(w, x, y, z, entitiy);
        }
    }

    public boolean isBlockSolidOnSide(World w, int x, int y, int z, ForgeDirection side) {
        int metadata = w.func_72805_g(x, y, z);
        if (!this.notValidBlock(metadata)) {
            TileEntity te = w.func_72796_p(x, y, z);
            if (te instanceof IFacadeTile && ((IFacadeTile)te).getFacadeProxy().hasFacade((IFacadeTile)te, side)) {
                return true;
            }
            if (this.SubBlocks[metadata] instanceof BlockLevelEmitter) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockQuantumLinkChamber) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockQuantumRing) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockLevelEmitter) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockCable) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockDarkCable) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockColorlessCable) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockOutputCablePrecision) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockInputCablePrecision) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockOutputCableBasic) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockInputCableBasic) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockOutputCableFuzzy) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockInputCableFuzzy) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockStorageBus) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockStorageBusFuzzy) {
                return false;
            }
            if (this.SubBlocks[metadata] instanceof BlockPhantom) {
                return false;
            }
        }
        return true;
    }

    public boolean canPlaceTorchOnTop(World w, int x, int y, int z) {
        return false;
    }

    boolean isOpaqueCube(int meta) {
        if (this.notValidBlock(meta)) {
            return false;
        }
        return this.SubBlocks[meta].isOpaqueCube();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess par1iBlockAccess, int x, int y, int z, int s) {
        if (this.dontrender != null && this.dontrender[s]) {
            return false;
        }
        Block block = Block.field_71973_m[par1iBlockAccess.func_72798_a(x, y, z)];
        if (block instanceof AppEngMultiBlock) {
            return !((AppEngMultiBlock)block).isOpaqueCube(par1iBlockAccess.func_72805_g(x, y, z));
        }
        return super.func_71877_c(par1iBlockAccess, x, y, z, s);
    }

    public int getLightOpacity(World world, int x, int y, int z) {
        AppEngTile te = this.getTile((IBlockAccess)world, x, y, z);
        if (te != null) {
            return te.getLightOpacity();
        }
        int metadata = world.func_72805_g(x, y, z);
        if (!this.notValidBlock(metadata)) {
            return this.SubBlocks[metadata].getLightOpacity();
        }
        return 255;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (AppEngBlockRenderer.overrideBrightness >= 0) {
            return AppEngBlockRenderer.overrideBrightness;
        }
        AppEngTile te = this.getTile(world, x, y, z);
        if (te != null) {
            return te.getLightValue();
        }
        int meta = world.func_72805_g(x, y, z);
        if (this.notValidBlock(meta)) {
            return super.getLightValue(world, x, y, z);
        }
        return this.SubBlocks[meta].getLightValue(world, x, y, z);
    }

    int addSubBlock(AppEngSubBlock sb) {
        int metadata = this.subBlocks++;
        this.SubBlocks[metadata] = sb;
        return metadata;
    }

    public void registerBlock() {
        GameRegistry.registerBlock((Block)this, AppEngMultiItemBlock.class, (String)this.blockName);
    }

    public int func_71857_b() {
        return AppEngBlockRenderer.instance.getRenderId();
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        if (this.notValidBlock(metadata)) {
            return false;
        }
        return this.SubBlocks[metadata].canSilkHarvest(world, player, x, y, z, metadata);
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean isBlockNormalCube(World w, int x, int y, int z) {
        AppEngTile te = this.getTile((IBlockAccess)w, x, y, z);
        if (te != null) {
            return te.isBlockNormalCube();
        }
        return true;
    }

    public boolean notValidBlock(int meta) {
        return meta < 0 || meta >= this.subBlocks;
    }

    public void func_71863_a(World w, int x, int y, int z, int blockid) {
        super.func_71863_a(w, x, y, z, blockid);
        int metadata = w.func_72805_g(x, y, z);
        if (!this.notValidBlock(metadata)) {
            this.SubBlocks[metadata].onNeighborBlockChange(w, x, y, z, blockid);
        }
    }

    public ArrayList getBlockDropped(World w, int x, int y, int z, int meta, int fortune) {
        if (this.notValidBlock(meta)) {
            return new ArrayList();
        }
        ArrayList drops = new ArrayList();
        this.SubBlocks[meta].getDrops(w, x, y, z, fortune, drops);
        return drops;
    }

    public ItemStack getPickBlock(MovingObjectPosition var1, World w, int x, int y, int z) {
        ItemStack result = new ItemStack((Block)this, 1, w.func_72805_g(x, y, z));
        if (Platform.isSameItemType(Blocks.blkPhantom, result)) {
            return null;
        }
        return result;
    }

    public void func_71861_g(World w, int x, int y, int z) {
        int metadata = w.func_72805_g(x, y, z);
        if (this.hasTileEntity(metadata)) {
            super.func_71861_g(w, x, y, z);
        }
    }

    public void func_71860_a(World w, int x, int y, int z, EntityLivingBase entityliving, ItemStack is) {
        int metadata = w.func_72805_g(x, y, z);
        AppEngTile te = this.getTile((IBlockAccess)w, x, y, z);
        if (te != null) {
            te.placedBy(entityliving);
        }
    }

    public int func_71920_b(IBlockAccess ba, int x, int y, int z) {
        if (AppEngBlockRenderer.overrideRenderColor != -1) {
            return AppEngBlockRenderer.overrideRenderColor;
        }
        return super.func_71920_b(ba, x, y, z);
    }

    public Icon func_71895_b(IBlockAccess ba, int x, int y, int z, int side) {
        if (AppEngBlockRenderer.overrideTexture != null) {
            return AppEngBlockRenderer.overrideTexture;
        }
        int metadata = ba.func_72805_g(x, y, z);
        if (this.notValidBlock(metadata)) {
            return null;
        }
        AppEngTile te = this.getTile(ba, x, y, z);
        if (te != null) {
            return te.getBlockTextureFromSide(side);
        }
        return this.SubBlocks[metadata].getBlockTextureFromSide(side);
    }

    public Icon func_71858_a(int side, int metadata) {
        if (AppEngBlockRenderer.overrideTexture != null) {
            return AppEngBlockRenderer.overrideTexture;
        }
        if (this.notValidBlock(metadata)) {
            return null;
        }
        return this.SubBlocks[metadata].getBlockTextureFromSide(side);
    }

    public void setPlacingItemStack(ItemStack is) {
        placingIS.set(is);
    }

    public AxisAlignedBB func_71872_e(World w, int x, int y, int z) {
        ItemStack is = placingIS.get();
        if (is == null) {
            return super.func_71872_e(w, x, y, z);
        }
        AxisAlignedBB bb = this.SubBlocks[is.func_77960_j()].getCollisionBoundingBoxFromPool(w, x, y, z, is);
        placingIS.set(null);
        return bb;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (this.notValidBlock(metadata)) {
            return false;
        }
        int FDside = ForgeDirection.UNKNOWN.ordinal();
        if (side == 2) {
            FDside = ForgeDirection.NORTH.ordinal();
        }
        if (side == 3) {
            FDside = ForgeDirection.EAST.ordinal();
        }
        if (side == 0) {
            FDside = ForgeDirection.SOUTH.ordinal();
        }
        if (side == 1) {
            FDside = ForgeDirection.WEST.ordinal();
        }
        return this.SubBlocks[metadata].canConnectRedstone(world, x, y, z, FDside);
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        AppEngTile te;
        if (Platform.isClient() && (te = this.getTile((IBlockAccess)world, x, y, z)) != null) {
            te.markInvalid();
            te.clientNotifyBlockOfNeighborChange(x - 1, y, z);
            te.clientNotifyBlockOfNeighborChange(x + 1, y, z);
            te.clientNotifyBlockOfNeighborChange(x, y - 1, z);
            te.clientNotifyBlockOfNeighborChange(x, y + 1, z);
            te.clientNotifyBlockOfNeighborChange(x, y, z - 1);
            te.clientNotifyBlockOfNeighborChange(x, y, z + 1);
        }
        return super.removeBlockByPlayer(world, player, x, y, z);
    }

    public boolean func_71903_a(World w, int x, int y, int z, EntityPlayer player, int side, float j2, float j3, float j4) {
        IMemoryCard mc;
        ItemStack hand;
        int metadata = w.func_72805_g(x, y, z);
        if (this.notValidBlock(metadata)) {
            return false;
        }
        if (!this.SubBlocks[metadata].isEnabled()) {
            return false;
        }
        TileEntity te = w.func_72796_p(x, y, z);
        if (AppEng.getInstance().BCProxy != null && player.func_71045_bC() != null && AppEng.getInstance().BCProxy.isFacade(hand = player.func_71045_bC()) && te instanceof IFacadeTile) {
            if (player.func_70093_af()) {
                ((IFacadeTile)te).getFacadeProxy().dropFacade((IFacadeTile)te, ForgeDirection.getOrientation((int)side));
            } else if (((IFacadeTile)te).getFacadeProxy().addFacade(te, side, hand) && !player.field_71075_bZ.field_75098_d) {
                --hand.field_77994_a;
                if (hand.field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
            }
            return true;
        }
        ItemStack eq = player.func_71045_bC();
        if (te instanceof AppEngTile && (mc = AppEng.getApiInstance().getMemoryCardHandler()).isMemoryCard(eq)) {
            AppEngTile ate = (AppEngTile)te;
            String myName = "AppEng.Blocks." + this.getName(metadata);
            if (player.func_70093_af()) {
                NBTTagCompound data = ate.getSettings();
                if (data != null) {
                    mc.setMemoryCardContents(eq, myName + ".name", data);
                    Platform.LocalizedChatMsg("ChatMsg.SettingsSaved", player);
                    return true;
                }
            } else if (mc.getSettingsName(eq).equals(myName + ".name")) {
                ate.restoreSettings(mc.getData(eq));
                Platform.LocalizedChatMsg("ChatMsg.SettingsLoaded", player);
                return true;
            }
            Platform.LocalizedChatMsg("ChatMsg.IncorrectDevice", player);
            return true;
        }
        if (player.func_70093_af() && Platform.isWrench(player, eq, x, y, z) && this.SubBlocks[metadata] instanceof IDismantleable) {
            if (Platform.isServer()) {
                this.SubBlocks[metadata].onBlockDismantle(w, x, y, z, player, side);
            }
            return false;
        }
        return this.SubBlocks[metadata].onBlockActivated(w, x, y, z, player, side);
    }

    public boolean canBeReplacedByLeaves(World world, int x, int y, int z) {
        return false;
    }

    public void func_71852_a(World w, int x, int y, int z, int j2, int j3) {
        int metadata = w.func_72805_g(x, y, z);
        if (this.notValidBlock(metadata)) {
            return;
        }
        AppEngTile te = this.getTile((IBlockAccess)w, x, y, z);
        if (te != null) {
            te.breakBlock(w, x, y, z);
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            boolean ignoreStandard = te.getDrops(w, x, y, z, drops);
            if (te instanceof IInventory && !ignoreStandard) {
                IInventory inv = (IInventory)te;
                for (int l = 0; l < inv.func_70302_i_(); ++l) {
                    ItemStack is = inv.func_70301_a(l);
                    if (is == null) continue;
                    drops.add(is);
                    inv.func_70299_a(l, (ItemStack)null);
                }
            }
            Platform.spawnDrops(w, x, y, z, drops);
        }
        this.SubBlocks[metadata].breakBlock(w, x, y, z);
        super.func_71852_a(w, x, y, z, j2, j3);
        if (te instanceof IGridTileEntity) {
            w.func_72837_a(x, y, z, null);
        }
    }

    public TileEntity func_72274_a(World worlda) {
        return null;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return this.createTileEntity(world, metadata);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (this.notValidBlock(metadata)) {
            return null;
        }
        if (!this.SubBlocks[metadata].isEnabled()) {
            return null;
        }
        return this.SubBlocks[metadata].createNewTileEntity(world);
    }

    public boolean hasTileEntity(int metadata) {
        if (this.notValidBlock(metadata)) {
            return false;
        }
        if (!this.SubBlocks[metadata].isEnabled()) {
            return false;
        }
        return this.SubBlocks[metadata].hasTileEntity();
    }

    public AppEngTile getTile(IBlockAccess w, int x, int y, int z) {
        TileEntity te;
        int meta = w.func_72805_g(x, y, z);
        if (this.hasTileEntity(meta) && y > 0 && y < 255 && (te = w.func_72796_p(x, y, z)) instanceof AppEngTile) {
            return (AppEngTile)te;
        }
        return null;
    }

    public boolean func_71883_b(World w, int x, int y, int z, int j1, int j2) {
        super.func_71883_b(w, x, y, z, j1, j2);
        AppEngTile te = this.getTile((IBlockAccess)w, x, y, z);
        if (te != null) {
            return te.func_70315_b(j1, j2);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs tab, List subItems) {
        for (int ix = 0; ix < this.subBlocks; ++ix) {
            if (this.SubBlocks[ix] instanceof BlockPhantom || !this.SubBlocks[ix].isEnabled()) continue;
            ItemStack mbs = new ItemStack((Block)this, 1, ix);
            subItems.add(mbs);
        }
    }

    public void configureCollidingBlockToList(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
    }

    public MovingObjectPosition func_71878_a(World world, int i, int j, int k, Vec3 vec3d, Vec3 vec3d1) {
        AppEngTile te = this.getTile((IBlockAccess)world, i, j, k);
        if (te instanceof ICustomCollision) {
            AxisAlignedBB[] bbs;
            for (AxisAlignedBB bb : bbs = ((ICustomCollision)((Object)te)).getSelectedBoundingBoxsFromPool(world, i, j, k)) {
                this.func_71905_a((float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f);
                MovingObjectPosition r = super.func_71878_a(world, i, j, k, vec3d, vec3d1);
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                if (r == null) continue;
                return r;
            }
            return null;
        }
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return super.func_71878_a(world, i, j, k, vec3d, vec3d1);
    }

    public AxisAlignedBB func_71911_a_(World world, int i, int j, int k) {
        AppEngTile te = this.getTile((IBlockAccess)world, i, j, k);
        AxisAlignedBB b = null;
        if (te instanceof ICustomCollision) {
            for (AxisAlignedBB bx : ((ICustomCollision)((Object)te)).getSelectedBoundingBoxsFromPool(world, i, j, k)) {
                if (b == null) {
                    b = bx;
                    continue;
                }
                double minX = Math.min(b.field_72340_a, bx.field_72340_a);
                double minY = Math.min(b.field_72338_b, bx.field_72338_b);
                double minZ = Math.min(b.field_72339_c, bx.field_72339_c);
                double maxX = Math.max(b.field_72336_d, bx.field_72336_d);
                double maxY = Math.max(b.field_72337_e, bx.field_72337_e);
                double maxZ = Math.max(b.field_72334_f, bx.field_72334_f);
                b.func_72324_b(minX, minY, minZ, maxX, maxY, maxZ);
            }
            b.func_72324_b(b.field_72340_a + (double)i, b.field_72338_b + (double)j, b.field_72339_c + (double)k, b.field_72336_d + (double)i, b.field_72337_e + (double)j, b.field_72334_f + (double)k);
        } else {
            b = super.func_71911_a_(world, i, j, k);
        }
        return b;
    }

    public void func_71871_a(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        AppEngTile te = this.getTile((IBlockAccess)world, i, j, k);
        if (te != null) {
            if (te instanceof ICustomCollision) {
                ((ICustomCollision)((Object)te)).addCollidingBlockToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            } else {
                te.func_70311_o().func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                this.configureCollidingBlockToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
        } else {
            super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
    }

    public int func_71865_a(IBlockAccess world, int x, int y, int z, int s) {
        AppEngTile te = this.getTile(world, x, y, z);
        if (te != null) {
            return te.isProvidingWeakPower(s);
        }
        return 0;
    }

    public int func_71855_c(IBlockAccess world, int x, int y, int z, int s) {
        AppEngTile te = this.getTile(world, x, y, z);
        if (te != null) {
            return te.isProvidingStrongPower(s);
        }
        return 0;
    }

    public AppEngSubBlock getSubBlock(int metadata) {
        if (this.notValidBlock(metadata)) {
            return null;
        }
        return this.SubBlocks[metadata];
    }

    public String getName(int itemDamage) {
        if (this.notValidBlock(itemDamage)) {
            return "INVALID ITEM";
        }
        return this.SubBlocks[itemDamage].unlocalizedName;
    }

    public RedNetConnectionType getConnectionType(World world, int x, int y, int z, ForgeDirection side) {
        AppEngTile te = this.getTile((IBlockAccess)world, x, y, z);
        if (te != null) {
            return te.getConnectionType(world, x, y, z, side);
        }
        return RedNetConnectionType.None;
    }

    public int[] getOutputValues(World world, int x, int y, int z, ForgeDirection side) {
        AppEngTile te = this.getTile((IBlockAccess)world, x, y, z);
        if (te != null) {
            return te.getOutputValues(world, x, y, z, side);
        }
        return null;
    }

    public int getOutputValue(World world, int x, int y, int z, ForgeDirection side, int subnet) {
        AppEngTile te = this.getTile((IBlockAccess)world, x, y, z);
        if (te != null) {
            return te.getOutputValue(world, x, y, z, side, subnet);
        }
        return 0;
    }

    public void onInputsChanged(World world, int x, int y, int z, ForgeDirection side, int[] inputValues) {
        AppEngTile te = this.getTile((IBlockAccess)world, x, y, z);
        if (te != null) {
            te.onInputsChanged(world, x, y, z, side, inputValues);
        }
    }

    public void onInputChanged(World world, int x, int y, int z, ForgeDirection side, int inputValue) {
        AppEngTile te = this.getTile((IBlockAccess)world, x, y, z);
        if (te != null) {
            te.onInputChanged(world, x, y, z, side, inputValue);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasSpecialRenderer(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        AppEngSubBlock blk = this.getSubBlock(meta);
        if (blk != null) {
            return blk.hasSpecialRender();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean specialRenderer(IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        int meta = world.func_72805_g(x, y, z);
        AppEngSubBlock blk = this.getSubBlock(meta);
        if (blk != null) {
            return blk.specialRenderer(world, x, y, z, renderer);
        }
        return false;
    }

    public boolean isSealed(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.isOpaqueCube(meta);
    }
}

