/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.base;

import appeng.api.WorldCoord;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.me.tiles.IConfigureableTile;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.IInventoryNotifyable;
import appeng.common.grid.MEGridEvents;
import appeng.common.network.IAppEngNetworkTile;
import appeng.common.network.packets.PacketActionTile;
import appeng.gui.AppEngContainer;
import appeng.gui.AppEngGui;
import appeng.interfaces.IBulkNetworkTile;
import appeng.interfaces.IConfigEnabledTile;
import appeng.interfaces.InvOperation;
import appeng.me.tile.IInternalInventory;
import appeng.me.tile.TileCable;
import appeng.me.tile.TileChest;
import appeng.me.tile.TileColorlessCable;
import appeng.me.tile.TileCondenser;
import appeng.me.tile.TileController;
import appeng.me.tile.TileCraftingMonitor;
import appeng.me.tile.TileCraftingTerminal;
import appeng.me.tile.TileDarkCable;
import appeng.me.tile.TileDrive;
import appeng.me.tile.TileIOPort;
import appeng.me.tile.TileInputCable;
import appeng.me.tile.TileInterfaceBase;
import appeng.me.tile.TileLevelEmitter;
import appeng.me.tile.TileOutputCable;
import appeng.me.tile.TilePartitioner;
import appeng.me.tile.TilePatternEncoder;
import appeng.me.tile.TileQuantumBridge;
import appeng.me.tile.TileStorageBus;
import appeng.me.tile.TileStorageMonitor;
import appeng.me.tile.TileTerminal;
import appeng.me.tile.TileTransitionPlane;
import appeng.render.AppEngBlockRenderer;
import appeng.tech1.tile.TileGrinder;
import appeng.tech1.tile.TilePhantom;
import appeng.util.Platform;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import powercrystals.minefactoryreloaded.api.rednet.IConnectableRedNet;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;

public abstract class AppEngTile
extends TileEntity
implements IConnectableRedNet,
IInventoryNotifyable {
    protected boolean isLoaded = false;
    private short redstoneUpdateLimit = 0;
    private boolean hasRedstone = false;
    private String Owner = "";
    private Chunk cachedChunk = null;
    private final int idx = 64 + this.getTileIndex();
    public static final int ACTION_SET_PRIORITY = 1;
    public static final int ACTION_SET_LIMIT = 2;
    WorldCoord loc;
    boolean onIC2ENet;
    boolean sendUpdate = false;
    protected byte tickUpdateCount = 0;
    boolean updateContainers = false;
    private boolean isValidFlag = true;

    private Chunk getChunk() {
        if (this.cachedChunk == null) {
            this.cachedChunk = this.field_70331_k.func_72938_d(this.field_70329_l, this.field_70327_n);
        }
        if (!this.cachedChunk.field_76636_d) {
            this.cachedChunk = this.field_70331_k.func_72938_d(this.field_70329_l, this.field_70327_n);
        }
        return this.cachedChunk;
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderFace(Block block, RenderBlocks renderer, ForgeDirection orientation) {
        AppEngBlockRenderer AppEngRenderer = AppEngBlockRenderer.instance;
        Icon ico = AppEngBlockRenderer.overrideTexture == null ? this.getBlockTextureFromSide(orientation) : AppEngBlockRenderer.overrideTexture;
        switch (orientation) {
            case NORTH: {
                renderer.func_78611_c(block, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, ico);
                break;
            }
            case SOUTH: {
                renderer.func_78622_d(block, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, ico);
                break;
            }
            case EAST: {
                renderer.func_78605_f(block, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, ico);
                break;
            }
            case WEST: {
                renderer.func_78573_e(block, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, ico);
                break;
            }
            case UP: {
                renderer.func_78617_b(block, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, ico);
                break;
            }
            case DOWN: {
                renderer.func_78613_a(block, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, ico);
                break;
            }
        }
    }

    public void func_70296_d() {
        Chunk c;
        if (this.field_70331_k != null && (c = this.getChunk()) != null) {
            c.func_76630_e();
        }
    }

    @Override
    public void onSubInventoryChange() {
        this.func_70296_d();
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    private int getTileIndex() {
        if (this instanceof IConfigEnabledTile || this instanceof IConfigureableTile || this instanceof IAppEngNetworkTile) {
            if (this instanceof TileCable) {
                return 0;
            }
            if (this instanceof TileColorlessCable) {
                return 1;
            }
            if (this instanceof TileChest) {
                return 2;
            }
            if (this instanceof TileCraftingMonitor) {
                return 3;
            }
            if (this instanceof TileCraftingTerminal) {
                return 4;
            }
            if (this instanceof TileDarkCable) {
                return 5;
            }
            if (this instanceof TileDrive) {
                return 6;
            }
            if (this instanceof TileInputCable) {
                return 7;
            }
            if (this instanceof TileLevelEmitter) {
                return 8;
            }
            if (this instanceof TileOutputCable) {
                return 9;
            }
            if (this instanceof TilePatternEncoder) {
                return 10;
            }
            if (this instanceof TilePartitioner) {
                return 11;
            }
            if (this instanceof TileStorageBus) {
                return 12;
            }
            if (this instanceof TileTerminal) {
                return 13;
            }
            if (this instanceof TileTransitionPlane) {
                return 14;
            }
            if (this instanceof TileInterfaceBase) {
                return 15;
            }
            if (this instanceof TileController) {
                return 16;
            }
            if (this instanceof TileStorageMonitor) {
                return 17;
            }
            if (this instanceof TileIOPort) {
                return 18;
            }
            if (this instanceof TileGrinder) {
                return 19;
            }
            if (this instanceof TilePatternEncoder) {
                return 20;
            }
            if (this instanceof TilePhantom) {
                return 21;
            }
            if (this instanceof TileCondenser) {
                return 22;
            }
            if (this instanceof TileQuantumBridge) {
                return 23;
            }
            throw new RuntimeException("INVALID INDEX");
        }
        return -1;
    }

    public ForgeDirection getDirectionFromAERotation(byte rotation) {
        switch (rotation) {
            case 0: {
                return ForgeDirection.SOUTH;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.EAST;
            }
            case 4: {
                return ForgeDirection.UP;
            }
            case 5: {
                return ForgeDirection.DOWN;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public byte getAERotationFromDirection(ForgeDirection rotation) {
        if (rotation == null) {
            return 0;
        }
        switch (rotation) {
            case SOUTH: {
                return 0;
            }
            case WEST: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case EAST: {
                return 3;
            }
            case UP: {
                return 4;
            }
            case DOWN: {
                return 5;
            }
        }
        return -1;
    }

    public byte getAERotationFromLivingEntity(EntityLivingBase entityliving, boolean upAndDown) {
        if (entityliving.field_70125_A > 65.0f && upAndDown) {
            return 4;
        }
        if (entityliving.field_70125_A < -65.0f && upAndDown) {
            return 5;
        }
        return (byte)(MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3);
    }

    public ForgeDirection getOrientationFromLivingEntity(EntityLivingBase ent, boolean upAndDown) {
        return this.getDirectionFromAERotation(this.getAERotationFromLivingEntity(ent, upAndDown));
    }

    public final boolean canUpdate() {
        return this.requiresTickingUpdates();
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (!this.isLoaded) {
            if (Platform.isClient() && AppEng.getInstance().AEGenericTick_client != null) {
                AppEng.getInstance().AEGenericTick_client.TriggerInit(this);
            } else if (AppEng.getInstance().AEGenericTick_server != null) {
                AppEng.getInstance().AEGenericTick_server.TriggerInit(this);
            }
        }
    }

    public boolean requiresTickingUpdates() {
        return true;
    }

    protected boolean getRedstoneState() {
        return this.hasRedstone;
    }

    public void pulseRedStone() {
    }

    public void notifyNeightbors() {
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        try {
            super.func_70310_b(par1nbtTagCompound);
            par1nbtTagCompound.func_74778_a("owner", this.Owner);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        try {
            super.func_70307_a(par1nbtTagCompound);
            this.Owner = par1nbtTagCompound.func_74779_i("owner");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isIndirectlyPowered(World par1World, int x, int y, int z) {
        return par1World.func_94574_k(x, y - 1, z, ForgeDirection.DOWN.ordinal()) || par1World.func_94574_k(x, y + 1, z, ForgeDirection.UP.ordinal()) || par1World.func_94574_k(x, y, z - 1, ForgeDirection.NORTH.ordinal()) || par1World.func_94574_k(x, y, z + 1, ForgeDirection.SOUTH.ordinal()) || par1World.func_94574_k(x + 1, y, z, ForgeDirection.EAST.ordinal()) || par1World.func_94574_k(x - 1, y, z, ForgeDirection.WEST.ordinal());
    }

    public void clientNotifyBlockOfNeighborChange(int x, int y, int z) {
        TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
        if (te != null && te instanceof AppEngTile) {
            ((AppEngTile)te).updateClientTile();
        }
    }

    public void updateClientTile() {
    }

    public boolean requiresRedstoneUpdates() {
        return false;
    }

    public void onNeighborBlockChange() {
        if (Platform.isClient()) {
            this.clientNotifyBlockOfNeighborChange(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n);
            this.clientNotifyBlockOfNeighborChange(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n);
            this.clientNotifyBlockOfNeighborChange(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
            this.clientNotifyBlockOfNeighborChange(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
            this.clientNotifyBlockOfNeighborChange(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
            this.clientNotifyBlockOfNeighborChange(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1);
        }
        if (this.requiresRedstoneUpdates()) {
            this.updateRSState(this.isIndirectlyPowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
    }

    private void updateRSState(boolean indirectlyPowered) {
        boolean hadRedStone = this.hasRedstone;
        this.hasRedstone = indirectlyPowered;
        this.redstoneUpdateLimit = 0;
        if (hadRedStone != this.getRedstoneState()) {
            boolean bl = hadRedStone = !hadRedStone;
            if (hadRedStone) {
                this.pulseRedStone();
            }
            this.onUpdateRedstone();
        }
    }

    public void onUpdateRedstone() {
    }

    public WorldCoord getLocation() {
        return new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isAddedToEnergyNet() {
        return this.onIC2ENet;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.isLoaded) {
            this.terminate();
        }
    }

    public void onChunkLoad() {
        if (!this.isLoaded) {
            if (Platform.isClient()) {
                AppEng.getInstance().AEGenericTick_client.TriggerInit(this);
            } else {
                AppEng.getInstance().AEGenericTick_server.TriggerInit(this);
            }
        }
    }

    public void init() {
        if (this.isLoaded) {
            return;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return;
        }
        this.isValidFlag = true;
        this.isLoaded = true;
        this.cachedChunk = null;
        if (AppEng.getInstance().IC2Proxy != null) {
            AppEng.getInstance().IC2Proxy.addToEnergyNet(this);
            this.onIC2ENet = true;
        }
        if (this instanceof IGridTileEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new GridTileLoadEvent((IGridTileEntity)((Object)this), this.field_70331_k, this.getLocation()));
        }
        this.onNeighborBlockChange();
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    protected void terminate() {
        this.isLoaded = false;
        if (this.onIC2ENet && AppEng.getInstance().IC2Proxy != null) {
            AppEng.getInstance().IC2Proxy.removeFromEnergyNet(this);
            this.onIC2ENet = false;
        }
    }

    protected void updatePowerConnectivity() {
        if (AppEng.getInstance().IC2Proxy != null) {
            AppEng.getInstance().IC2Proxy.removeFromEnergyNet(this);
            this.onIC2ENet = false;
            AppEng.getInstance().IC2Proxy.addToEnergyNet(this);
            this.onIC2ENet = true;
        }
    }

    public void updateTileEntity() {
    }

    public void triggerContainerUpdate() {
        this.updateContainers = true;
        if (!this.requiresTickingUpdates()) {
            this.scheduleBlockUpdate(1);
        }
    }

    public void afterContainerUpdate() {
    }

    public final void func_70316_g() {
        try {
            super.func_70316_g();
            if (!this.isLoaded) {
                return;
            }
            if (this.func_70320_p()) {
                return;
            }
            if (this.requiresRedstoneUpdates()) {
                short s = this.redstoneUpdateLimit;
                this.redstoneUpdateLimit = (short)(s + 1);
                if (s > 600) {
                    this.updateRSState(this.isIndirectlyPowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n));
                }
            }
            if (this.updateContainers) {
                List PlayerList;
                this.updateContainers = false;
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (server != null && (PlayerList = server.func_71203_ab().field_72404_b) != null) {
                    for (int o = 0; o < PlayerList.size(); ++o) {
                        Packet pack;
                        AppEngTile tc;
                        EntityPlayerMP p = (EntityPlayerMP)PlayerList.get(o);
                        if (p.field_71093_bK != this.field_70331_k.field_73011_w.field_76574_g || p.field_71070_bA == null || !(p.field_71070_bA instanceof AppEngContainer) || (tc = ((AppEngContainer)p.field_71070_bA).getTile()) == null || tc != this) continue;
                        if (tc instanceof IAppEngNetworkTile) {
                            if (((IAppEngNetworkTile)((Object)tc)).syncStyle(IAppEngNetworkTile.SyncTime.GUI) && (pack = tc.getUpdatePacket()) != null) {
                                PacketDispatcher.sendPacketToPlayer((Packet)pack, (Player)((Player)p));
                            }
                        } else if (tc instanceof IConfigEnabledTile) {
                            pack = tc.getUpdatePacket();
                            if (pack != null) {
                                PacketDispatcher.sendPacketToPlayer((Packet)pack, (Player)((Player)p));
                            }
                        } else if (tc instanceof IConfigureableTile && (pack = tc.getUpdatePacket()) != null) {
                            PacketDispatcher.sendPacketToPlayer((Packet)pack, (Player)((Player)p));
                        }
                        ((AppEngContainer)p.field_71070_bA).triggerUpdate();
                    }
                }
                this.afterContainerUpdate();
            }
            if (this.tickUpdateCount > 0) {
                this.tickUpdateCount = (byte)(this.tickUpdateCount - 1);
            } else if (this.sendUpdate) {
                this.sendUpdate = false;
                Packet p = this.func_70319_e();
                if (p != null) {
                    AppEng.getInstance().SideProxy.sendToAllNearExcept(null, this.field_70329_l, this.field_70330_m, this.field_70327_n, 512.0, this.field_70331_k, p);
                } else {
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
                this.tickUpdateCount = (byte)(this.tickUpdateCount + AppEngConfiguration.blockUpdateMinTickRate);
            }
            this.updateTileEntity();
        }
        catch (Throwable t) {
            FMLLog.severe((String)("Exception When Ticking " + this.getClass().getName() + " at " + this.field_70329_l + ", " + this.field_70330_m + ", " + this.field_70327_n), (Object[])new Object[0]);
            t.printStackTrace();
            FMLLog.severe((String)"MC might crash now...", (Object[])new Object[0]);
            throw new RuntimeException(t);
        }
    }

    public void scheduleBlockUpdate(int delay) {
        if (this.field_70331_k != null) {
            this.field_70331_k.func_72836_a(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n), delay);
        }
    }

    public void markForUpdate() {
        if (Platform.isClient()) {
            if (AppEngConfiguration.logBlockUpdates) {
                AppEng.log("CLIENT - " + this.getClass().getName() + " - " + this.field_70329_l + ", " + this.field_70330_m + ", " + this.field_70327_n);
            }
            if (this.hasVisibleFace()) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        } else if (this.requiresTickingUpdates()) {
            this.sendUpdate = true;
        } else {
            Packet p = this.func_70319_e();
            if (p != null) {
                AppEng.getInstance().SideProxy.sendToAllNearExcept(null, this.field_70329_l, this.field_70330_m, this.field_70327_n, 512.0, this.field_70331_k, p);
            } else {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        return AppEngTile.defaultRenderWorldBlock(world, x, y, z, block, modelId, renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean defaultRenderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        block.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        renderer.func_83018_a(block);
        return renderer.func_78570_q(block, x, y, z);
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.cachedChunk = null;
        if (this.isLoaded) {
            this.terminate();
        } else if (Platform.isClient()) {
            AppEng.getInstance().AEGenericTick_client.UntriggerInit(this);
        } else {
            AppEng.getInstance().AEGenericTick_server.UntriggerInit(this);
        }
    }

    void breakBlock(World w, int x, int y, int z) {
        if (this.isLoaded) {
            this.terminate();
            Platform.closeContainers(this);
        }
    }

    public boolean getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        return false;
    }

    public void placedBy(EntityLivingBase entityliving) {
    }

    public abstract Icon getBlockTextureFromSide(ForgeDirection var1);

    public final Icon getBlockTextureFromSide(int side) {
        return this.getBlockTextureFromSide(ForgeDirection.getOrientation((int)side));
    }

    public boolean hasVisibleFace() {
        Block blk = this.func_70311_o();
        return blk.func_71877_c((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, 0) || blk.func_71877_c((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, 1) || blk.func_71877_c((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n - 1, 2) || blk.func_71877_c((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n + 1, 3) || blk.func_71877_c((IBlockAccess)this.field_70331_k, this.field_70329_l - 1, this.field_70330_m, this.field_70327_n, 4) || blk.func_71877_c((IBlockAccess)this.field_70331_k, this.field_70329_l + 1, this.field_70330_m, this.field_70327_n, 5);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        try {
            if (pkt.field_73330_d == this.idx) {
                List<String> conf;
                NBTTagCompound out = pkt.field_73331_e;
                if (this instanceof IAppEngNetworkTile) {
                    DataInputStream stream = new DataInputStream(new ByteArrayInputStream(pkt.field_73331_e.func_74770_j("B")));
                    ((IAppEngNetworkTile)((Object)this)).handleTilePacket(stream);
                }
                if (this instanceof IConfigEnabledTile) {
                    conf = ((IConfigEnabledTile)((Object)this)).getConfigManager().getConfigurations();
                    for (String xv : conf) {
                        ((IConfigEnabledTile)((Object)this)).getConfigManager().setConfiguration(xv, out.func_74779_i(xv));
                    }
                } else if (this instanceof IConfigureableTile) {
                    conf = ((IConfigureableTile)((Object)this)).getConfigurations();
                    for (String xv : conf) {
                        ((IConfigureableTile)((Object)this)).setConfiguration(xv, out.func_74779_i(xv));
                    }
                }
                if (Minecraft.func_71410_x().field_71462_r instanceof AppEngGui) {
                    ((AppEngGui)Minecraft.func_71410_x().field_71462_r).networkedUpdate();
                }
            }
            return;
        }
        catch (ClassCastException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Packet func_70319_e() {
        if (AppEngConfiguration.logBlockUpdates) {
            AppEng.log("SERVER - " + this.getClass().getName() + " - " + this.field_70329_l + ", " + this.field_70330_m + ", " + this.field_70327_n);
        }
        if (this instanceof IBulkNetworkTile) {
            ((IBulkNetworkTile)((Object)this)).bulkUpdate(MEGridEvents.tickInstance, null);
        }
        if (this instanceof IAppEngNetworkTile && ((IAppEngNetworkTile)((Object)this)).syncStyle(IAppEngNetworkTile.SyncTime.WORLD)) {
            return this.getUpdatePacket();
        }
        return null;
    }

    public Packet getUpdatePacket() {
        if ((this instanceof IConfigEnabledTile || this instanceof IConfigureableTile || this instanceof IAppEngNetworkTile) && Platform.isServer()) {
            List<String> conf;
            NBTTagCompound c = new NBTTagCompound();
            if (this instanceof IAppEngNetworkTile) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                DataOutputStream data = new DataOutputStream(bytes);
                ((IAppEngNetworkTile)((Object)this)).configureTilePacket(data);
                c.func_74773_a("B", bytes.toByteArray());
            }
            if (this instanceof IConfigEnabledTile) {
                conf = ((IConfigEnabledTile)((Object)this)).getConfigManager().getConfigurations();
                for (String x : conf) {
                    c.func_74778_a(x, ((IConfigEnabledTile)((Object)this)).getConfigManager().getConfiguration(x));
                }
            } else if (this instanceof IConfigureableTile) {
                conf = ((IConfigureableTile)((Object)this)).getConfigurations();
                for (String x : conf) {
                    c.func_74778_a(x, ((IConfigureableTile)((Object)this)).getConfiguration(x));
                }
            }
            Packet132TileEntityData p = new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.idx, c);
            AppEngConfiguration.packetSize += (long)p.func_73284_a();
            return p;
        }
        return null;
    }

    public boolean isBlockNormalCube() {
        return true;
    }

    public void setOrientationBySide(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
    }

    public int getLightOpacity() {
        return 255;
    }

    public int getLightValue() {
        return 0;
    }

    public int isProvidingWeakPower(int s) {
        return 0;
    }

    public int isProvidingStrongPower(int s) {
        return 0;
    }

    public void sendAction(int action, ByteArrayOutputStream msg) {
        if (Platform.isClient()) {
            try {
                PacketDispatcher.sendPacketToServer((Packet)new PacketActionTile(this.field_70329_l, this.field_70330_m, this.field_70327_n, action, msg).getPacket());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void actionHandler(EntityPlayerMP pmp, int action, DataInputStream stream) {
    }

    public boolean canConnectRedstone(int side) {
        return false;
    }

    @Override
    public void InvChanged(IInternalInventory inv, int slot, InvOperation Operation) {
    }

    public boolean isValid() {
        return this.isValidFlag && !this.field_70328_o;
    }

    public void markInvalid() {
        this.isValidFlag = false;
    }

    public void setOwner(String entityName) {
        this.Owner = entityName;
    }

    public boolean isCommonUseableByPlayer(EntityPlayer p) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : p.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 32.0;
    }

    public RedNetConnectionType getConnectionType(World world, int x, int y, int z, ForgeDirection side) {
        return this.requiresRedstoneUpdates() ? (this.isBlockNormalCube() ? RedNetConnectionType.CableSingle : RedNetConnectionType.PlateSingle) : RedNetConnectionType.None;
    }

    public int[] getOutputValues(World world, int x, int y, int z, ForgeDirection side) {
        return null;
    }

    public int getOutputValue(World world, int x, int y, int z, ForgeDirection side, int subnet) {
        return 0;
    }

    public void onInputsChanged(World world, int x, int y, int z, ForgeDirection side, int[] inputValues) {
    }

    public void onInputChanged(World world, int x, int y, int z, ForgeDirection side, int inputValue) {
        this.updateRSState(inputValue != 0);
    }

    public void openGui(EntityPlayer p) {
    }

    public NBTTagCompound getSettings() {
        return null;
    }

    public void restoreSettings(NBTTagCompound tag) {
    }

    public void cycleOrientation() {
    }
}

