/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.grid;

import appeng.api.DimentionalCoord;
import appeng.api.WorldCoord;
import appeng.api.exceptions.AppEngException;
import appeng.api.me.tiles.IColoredMETile;
import appeng.api.me.tiles.IConnectionSensitive;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IFulllyOptionalMETile;
import appeng.api.me.tiles.IGridTeleport;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.INonSignalBlock;
import appeng.api.me.tiles.IOptionalMETile;
import appeng.me.tile.TileController;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class GridEnumeration {
    private HashMap<World, HashMap<Gridcoord, NetworkNode>> nodeLocations;
    private Queue<NetworkNode> queuedUpdates;
    private Queue<NetworkNode> networkUpdates;
    long networkIteration = Long.MIN_VALUE;

    public GridEnumeration() {
        this.nodeLocations = new HashMap();
        this.queuedUpdates = new LinkedList<NetworkNode>();
        this.networkUpdates = new LinkedList<NetworkNode>();
    }

    public void queueNetworkCheck(NetworkNode networkNode) {
        if (networkNode.isOptional && !((IOptionalMETile)((Object)networkNode.te)).isEnabled()) {
            return;
        }
        this.networkUpdates.add(networkNode);
    }

    public void queueUpdate(NetworkNode networkNode) {
        this.queuedUpdates.add(networkNode);
    }

    private ConnectionType testConnection(IGridTileEntity src, ForgeDirection dir) {
        TileEntity te = (TileEntity)src;
        Gridcoord dc = new Gridcoord(src.getWorld(), src.getLocation());
        dc.x += dir.offsetX;
        dc.y += dir.offsetY;
        dc.z += dir.offsetZ;
        NetworkNode onn = this.findNodeByCoord(dc);
        if (onn == null) {
            return ConnectionType.NONE;
        }
        IGridTileEntity gte = onn.getTile();
        if (gte != null) {
            IDirectionalMETile d;
            if (gte instanceof IFulllyOptionalMETile && ((IFulllyOptionalMETile)((Object)gte)).isSeperated()) {
                return ConnectionType.NONE;
            }
            NetworkNode nn = this.findNode(gte, false);
            if (nn == null) {
                return ConnectionType.NONE;
            }
            if (gte instanceof IColoredMETile && src instanceof IColoredMETile && ((IColoredMETile)((Object)gte)).isColored() && ((IColoredMETile)((Object)src)).isColored() && ((IColoredMETile)((Object)gte)).getColor() != ((IColoredMETile)((Object)src)).getColor()) {
                return ConnectionType.NONE;
            }
            if (gte instanceof IDirectionalMETile && !(d = (IDirectionalMETile)((Object)gte)).canConnect(dir.getOpposite())) {
                return ConnectionType.NONE;
            }
            if (src instanceof IDirectionalMETile && !(d = (IDirectionalMETile)((Object)src)).canConnect(dir)) {
                return ConnectionType.NONE;
            }
            if (gte instanceof IOptionalMETile && !((IOptionalMETile)((Object)gte)).isEnabled()) {
                return ConnectionType.VISUAL;
            }
            return ConnectionType.PHYSICAL;
        }
        return ConnectionType.NONE;
    }

    public IGridTileEntity getEntityFromCoord(Gridcoord dc) {
        NetworkNode nn = this.findNodeByCoord(dc);
        if (nn == null) {
            return null;
        }
        return nn.te;
    }

    public IGridTileEntity getEntityFromCoord(DimentionalCoord dc) {
        return this.getEntityFromCoord(new Gridcoord(dc));
    }

    NetworkNode findNodeByCoord(Gridcoord dc) {
        HashMap<Gridcoord, NetworkNode> x = null;
        if (this.nodeLocations.containsKey(dc.getWorld())) {
            x = this.nodeLocations.get(dc.getWorld());
            NetworkNode n = x.get(dc);
            return n;
        }
        return null;
    }

    NetworkNode findNode(IGridTileEntity te, boolean createNode) {
        NetworkNode n;
        Gridcoord dc = new Gridcoord(te.getWorld(), te.getLocation());
        HashMap<Gridcoord, NetworkNode> x = null;
        if (this.nodeLocations.containsKey(te.getWorld())) {
            x = this.nodeLocations.get(te.getWorld());
            n = x.get(dc);
            if (n != null) {
                n.te = te;
                n.isDead = false;
                return n;
            }
        } else if (createNode) {
            x = new HashMap();
            this.nodeLocations.put(te.getWorld(), x);
        }
        if (createNode) {
            n = new NetworkNode(te);
            x.put(n.dc, n);
            return n;
        }
        return null;
    }

    private NetworkNode findNode(Gridcoord dc) {
        HashMap<Gridcoord, NetworkNode> n = this.nodeLocations.get(dc.getWorld());
        if (n != null) {
            return n.get(dc);
        }
        return null;
    }

    void connectionAddSet(ConnectionType type, ForgeDirection dir, EnumSet<ForgeDirection> physical, EnumSet<ForgeDirection> visual) {
        switch (type) {
            case PHYSICAL: {
                physical.add(dir);
            }
            case VISUAL: {
                visual.add(dir);
            }
        }
    }

    public void update() {
        NetworkNode n;
        ++this.networkIteration;
        int updates = 0;
        while (!this.queuedUpdates.isEmpty()) {
            n = this.queuedUpdates.poll();
            if (n.networkIteration == this.networkIteration) continue;
            n.networkIteration = this.networkIteration;
            EnumSet<ForgeDirection> set = EnumSet.noneOf(ForgeDirection.class);
            EnumSet<ForgeDirection> visual = EnumSet.noneOf(ForgeDirection.class);
            IGridTileEntity te = n.getTile();
            this.connectionAddSet(this.testConnection(te, ForgeDirection.SOUTH), ForgeDirection.SOUTH, set, visual);
            this.connectionAddSet(this.testConnection(te, ForgeDirection.NORTH), ForgeDirection.NORTH, set, visual);
            this.connectionAddSet(this.testConnection(te, ForgeDirection.EAST), ForgeDirection.EAST, set, visual);
            this.connectionAddSet(this.testConnection(te, ForgeDirection.WEST), ForgeDirection.WEST, set, visual);
            this.connectionAddSet(this.testConnection(te, ForgeDirection.UP), ForgeDirection.UP, set, visual);
            this.connectionAddSet(this.testConnection(te, ForgeDirection.DOWN), ForgeDirection.DOWN, set, visual);
            ++updates;
            n.updateConnections(this, set, visual);
        }
        ++this.networkIteration;
        while (!this.networkUpdates.isEmpty()) {
            n = this.networkUpdates.poll();
            if (n.isDead || n.networkIteration == this.networkIteration) continue;
            LinkedList<NetworkNode> list = new LinkedList<NetworkNode>();
            LinkedList<NetworkNode> next = new LinkedList<NetworkNode>();
            ArrayList<TileController> controllers = new ArrayList<TileController>();
            next.add(n);
            while (!next.isEmpty()) {
                NetworkNode nn = (NetworkNode)next.poll();
                if (nn.networkIteration == this.networkIteration) continue;
                if (nn.isNonSignal) {
                    boolean alreadyPresent = false;
                    for (NetworkNode o : list) {
                        if (o != nn) continue;
                        alreadyPresent = true;
                    }
                    if (alreadyPresent) continue;
                    list.add(nn);
                    continue;
                }
                list.add(nn);
                nn.networkIteration = this.networkIteration;
                if (nn.isController) {
                    controllers.add((TileController)nn.getTile());
                }
                if (nn.connections.contains(ForgeDirection.SOUTH)) {
                    this.findNewMembers(ForgeDirection.SOUTH, nn, list, next, this.networkIteration);
                }
                if (nn.connections.contains(ForgeDirection.NORTH)) {
                    this.findNewMembers(ForgeDirection.NORTH, nn, list, next, this.networkIteration);
                }
                if (nn.connections.contains(ForgeDirection.EAST)) {
                    this.findNewMembers(ForgeDirection.EAST, nn, list, next, this.networkIteration);
                }
                if (nn.connections.contains(ForgeDirection.WEST)) {
                    this.findNewMembers(ForgeDirection.WEST, nn, list, next, this.networkIteration);
                }
                if (nn.connections.contains(ForgeDirection.UP)) {
                    this.findNewMembers(ForgeDirection.UP, nn, list, next, this.networkIteration);
                }
                if (nn.connections.contains(ForgeDirection.DOWN)) {
                    this.findNewMembers(ForgeDirection.DOWN, nn, list, next, this.networkIteration);
                }
                if (!nn.isTeleport) continue;
                try {
                    for (DimentionalCoord location : ((IGridTeleport)((Object)nn.getTile())).findRemoteSide()) {
                        this.considerNode(new Gridcoord(location), list, next, this.networkIteration);
                    }
                }
                catch (ClassCastException err) {
                    nn.isTeleport = false;
                }
            }
            Iterator i = list.iterator();
            while (i.hasNext()) {
                NetworkNode nx = (NetworkNode)i.next();
                if (!nx.isOptional) continue;
                try {
                    if (((IOptionalMETile)((Object)nx.te)).isEnabled()) continue;
                    i.remove();
                }
                catch (Throwable t) {
                    nx.isOptional = false;
                }
            }
            if (controllers.isEmpty()) {
                for (NetworkNode nx : list) {
                    nx.getTile().setGrid(null);
                }
                continue;
            }
            if (controllers.size() > 1) {
                for (NetworkNode nx : list) {
                    nx.getTile().setGrid(null);
                }
                for (TileController tc : controllers) {
                    tc.configureController(new ArrayList<NetworkNode>());
                }
                continue;
            }
            for (TileController tc : controllers) {
                tc.configureController(list);
            }
        }
    }

    private void considerNode(Gridcoord dc, List<NetworkNode> list, Queue<NetworkNode> next, long ni) {
        NetworkNode n = this.findNode(dc);
        if (n != null) {
            try {
                if (n.isOptional && !((IOptionalMETile)((Object)n.getTile())).isEnabled()) {
                    return;
                }
            }
            catch (ClassCastException er) {
                n.isOptional = false;
            }
            if (n.networkIteration == ni) {
                return;
            }
            next.add(n);
        }
    }

    private void findNewMembers(ForgeDirection dir, NetworkNode nn, List<NetworkNode> list, Queue<NetworkNode> next, long ni) {
        Gridcoord dc = nn.dc.shift(dir);
        this.considerNode(dc, list, next, ni);
    }

    public void addNode(IGridTileEntity te, World w, WorldCoord loc) throws AppEngException {
        Gridcoord dc = new Gridcoord(w, loc.x, loc.y, loc.z);
        NetworkNode n = this.findNode(te, true);
        this.queueUpdate(n);
        if (n.isController) {
            this.queueNetworkCheck(n);
        }
        this.triggerNetworkUpdateAt(dc, ForgeDirection.UP);
        this.triggerNetworkUpdateAt(dc, ForgeDirection.DOWN);
        this.triggerNetworkUpdateAt(dc, ForgeDirection.NORTH);
        this.triggerNetworkUpdateAt(dc, ForgeDirection.SOUTH);
        this.triggerNetworkUpdateAt(dc, ForgeDirection.EAST);
        this.triggerNetworkUpdateAt(dc, ForgeDirection.WEST);
    }

    public void rmvNode(IGridTileEntity te, World w, WorldCoord loc) throws AppEngException {
        NetworkNode nn;
        Gridcoord dc = new Gridcoord(w, loc.x, loc.y, loc.z);
        HashMap<Gridcoord, NetworkNode> h = this.nodeLocations.get(w);
        if (h != null && (nn = h.get(dc)) != null && (nn.te == te || te == null)) {
            nn.isDead = true;
            h.remove(dc);
        }
        this.triggerUpdateAt(dc, ForgeDirection.UP);
        this.triggerUpdateAt(dc, ForgeDirection.DOWN);
        this.triggerUpdateAt(dc, ForgeDirection.NORTH);
        this.triggerUpdateAt(dc, ForgeDirection.SOUTH);
        this.triggerUpdateAt(dc, ForgeDirection.EAST);
        this.triggerUpdateAt(dc, ForgeDirection.WEST);
    }

    public void updateNode(World w, WorldCoord loc) throws AppEngException {
        Gridcoord dc = new Gridcoord(w, loc.x, loc.y, loc.z);
        NetworkNode n = this.findNode(dc);
        if (n != null) {
            this.queueUpdate(n);
        }
        this.triggerUpdateAt(dc, ForgeDirection.UP);
        this.triggerUpdateAt(dc, ForgeDirection.DOWN);
        this.triggerUpdateAt(dc, ForgeDirection.NORTH);
        this.triggerUpdateAt(dc, ForgeDirection.SOUTH);
        this.triggerUpdateAt(dc, ForgeDirection.EAST);
        this.triggerUpdateAt(dc, ForgeDirection.WEST);
    }

    private void triggerUpdateAt(Gridcoord dc, ForgeDirection dir) {
        NetworkNode n = this.findNode(dc = dc.shift(dir));
        if (n != null) {
            this.queueUpdate(n);
            this.queueNetworkCheck(n);
        }
    }

    private void triggerNetworkUpdateAt(Gridcoord dc, ForgeDirection dir) {
        NetworkNode n = this.findNode(dc = dc.shift(dir));
        if (n != null) {
            this.queueNetworkCheck(n);
        }
    }

    public void deleteWorld(World world) {
        this.nodeLocations.remove(world);
    }

    static enum ConnectionType {
        NONE,
        VISUAL,
        PHYSICAL;

    }

    class Gridcoord {
        private World w;
        private int x;
        private int y;
        private int z;

        public boolean equals(Object obj) {
            Gridcoord b = (Gridcoord)obj;
            return this.w == b.w && this.x == b.x && this.y == b.y && this.z == b.z;
        }

        public Gridcoord shift(ForgeDirection direction) {
            return new Gridcoord(this.w, this.x + direction.offsetX, this.y + direction.offsetY, this.z + direction.offsetZ);
        }

        public Gridcoord(DimentionalCoord s) {
            this.w = s.getWorld();
            this.x = s.x;
            this.y = s.y;
            this.z = s.z;
        }

        public Gridcoord(World world, WorldCoord location) {
            this.w = world;
            this.x = location.x;
            this.y = location.y;
            this.z = location.z;
        }

        public Gridcoord(World _w, int _x, int _y, int _z) {
            this.w = _w;
            this.x = _x;
            this.y = _y;
            this.z = _z;
        }

        public int hashCode() {
            return this.y << 16 ^ this.x ^ Integer.reverse(this.z);
        }

        public World getWorld() {
            return this.w;
        }
    }

    public class NetworkNode {
        IGridTileEntity te;
        Gridcoord dc;
        long networkIteration;
        public boolean isController;
        public boolean isConnectionSensitive;
        public boolean isOptional;
        public boolean isNonSignal;
        public boolean isTeleport;
        EnumSet<ForgeDirection> connections;
        public boolean isDead;

        NetworkNode(IGridTileEntity _te) {
            this.te = _te;
            this.isDead = false;
            this.networkIteration = Long.MIN_VALUE;
            this.dc = new Gridcoord(this.te.getWorld(), this.te.getLocation());
            this.isConnectionSensitive = _te instanceof IConnectionSensitive;
            this.isController = _te instanceof TileController;
            this.isOptional = _te instanceof IOptionalMETile;
            this.isNonSignal = _te instanceof INonSignalBlock;
            this.isTeleport = _te instanceof IGridTeleport;
            this.connections = EnumSet.noneOf(ForgeDirection.class);
        }

        public void updateConnections(GridEnumeration ge, EnumSet<ForgeDirection> dirs, EnumSet<ForgeDirection> visualConnections) {
            Object intersect = this.connections.clone();
            ((AbstractCollection)intersect).retainAll(dirs);
            Object union = this.connections.clone();
            ((AbstractCollection)union).addAll(dirs);
            if (!this.isOptional) {
                ((AbstractSet)union).removeAll((Collection<?>)intersect);
            }
            this.connections = dirs;
            Iterator i$ = ((AbstractCollection)union).iterator();
            while (i$.hasNext()) {
                ForgeDirection d = (ForgeDirection)i$.next();
                Gridcoord dcx = this.dc.shift(d);
                NetworkNode nn = GridEnumeration.this.findNode(dcx);
                if (nn == null) continue;
                ge.queueUpdate(nn);
            }
            if (this.isConnectionSensitive) {
                try {
                    ((IConnectionSensitive)((Object)this.te)).onMEConnectionsChanged(dirs, visualConnections);
                }
                catch (ClassCastException err) {
                    this.isConnectionSensitive = false;
                }
            }
        }

        public IGridTileEntity getTile() {
            return this.te;
        }

        public int hashCode() {
            return this.dc.x | Integer.reverse(this.dc.z);
        }
    }
}

