/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.grid;

import appeng.api.DimentionalCoord;
import appeng.api.events.GridErrorEvent;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.events.MultiBlockUpdateEvent;
import appeng.api.me.tiles.IAssemblerMB;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngTile;
import appeng.common.grid.GridEnumeration;
import appeng.common.grid.MEUpdateRequest;
import appeng.interfaces.IBulkNetworkTile;
import appeng.me.tile.TileStorageMonitor;
import appeng.util.Platform;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.Player;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;

public class MEGridEvents
implements ITickHandler {
    public static Queue<MEUpdateRequest> requests = new LinkedList<MEUpdateRequest>();
    public static Queue<MEUpdateRequest> mbupdates = new LinkedList<MEUpdateRequest>();
    public static long tickInstance = Long.MIN_VALUE;
    private long updateInstance = Long.MIN_VALUE;
    private GridEnumeration ge = new GridEnumeration();

    public IGridTileEntity getEntityFromCoord(DimentionalCoord dc) {
        return this.ge.getEntityFromCoord(dc);
    }

    @ForgeSubscribe
    public void watchChunkUpdate(ChunkWatchEvent.Watch e) {
        if (e.isCanceled()) {
            return;
        }
        ++this.updateInstance;
        for (Object te : e.player.field_70170_p.func_72964_e((int)e.chunk.field_77276_a, (int)e.chunk.field_77275_b).field_76648_i.values()) {
            if (!(te instanceof IBulkNetworkTile)) continue;
            ((IBulkNetworkTile)te).bulkUpdate(this.updateInstance, (Player)e.player);
        }
    }

    @ForgeSubscribe
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (e != null && !e.isCanceled() && e.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            TileEntity te;
            Block b;
            int blkID = e.entityPlayer.field_70170_p.func_72798_a(e.x, e.y, e.z);
            int meta = e.entityPlayer.field_70170_p.func_72805_g(e.x, e.y, e.z);
            if (blkID > 0 && (b = Block.field_71973_m[blkID]) instanceof AppEngMultiBlock && b.hasTileEntity(meta) && (te = e.entityPlayer.field_70170_p.func_72796_p(e.x, e.y, e.z)) instanceof TileStorageMonitor) {
                ((TileStorageMonitor)te).onPlayerInteract(e);
            }
        }
    }

    @ForgeSubscribe
    public void watchChunkUpdate(ChunkEvent.Load e) {
        if (e.isCanceled()) {
            return;
        }
        ++this.updateInstance;
        for (Object te : e.getChunk().field_76648_i.values()) {
            if (!(te instanceof AppEngTile)) continue;
            ((AppEngTile)te).onChunkLoad();
        }
    }

    @ForgeSubscribe
    public void calculateMB(MultiBlockUpdateEvent e) {
        if (!e.isCanceled() && Platform.isServer()) {
            mbupdates.add(new MEUpdateRequest(e.te, e.world, e.coord, MEUpdateRequest.operation.Update));
        }
    }

    @ForgeSubscribe
    public void worldUnload(WorldEvent.Unload w) {
        if (!w.isCanceled() && Platform.isServer()) {
            this.ge.deleteWorld(w.world);
        }
    }

    @ForgeSubscribe
    public void errorGrid(GridErrorEvent add) {
        if (!add.isCanceled() && Platform.isServer()) {
            requests.add(new MEUpdateRequest(null, add.world, add.coord, MEUpdateRequest.operation.Error));
        }
    }

    @ForgeSubscribe
    public void updateGrid(GridTileConnectivityEvent up) {
        if (!up.isCanceled() && Platform.isServer()) {
            requests.add(new MEUpdateRequest(up.te, up.world, up.coord, MEUpdateRequest.operation.Update));
        }
    }

    @ForgeSubscribe
    public void addToGrid(GridTileLoadEvent add) {
        if (!add.isCanceled() && Platform.isServer()) {
            requests.add(new MEUpdateRequest(add.te, add.world, add.coord, MEUpdateRequest.operation.Add));
        }
    }

    @ForgeSubscribe
    public void rmvToGrid(GridTileUnloadEvent rmv) {
        if (!rmv.isCanceled() && Platform.isServer()) {
            requests.add(new MEUpdateRequest(rmv.te, rmv.world, rmv.coord, MEUpdateRequest.operation.Remove));
        }
    }

    public synchronized void tickStart(EnumSet<TickType> type, Object ... tickData) {
        World w = (World)tickData[0];
        ++tickInstance;
        ++this.updateInstance;
        Iterator mbreqs = mbupdates.iterator();
        while (mbreqs.hasNext()) {
            MEUpdateRequest req = (MEUpdateRequest)mbreqs.next();
            if (req.w != w) continue;
            try {
                if (req.te instanceof IAssemblerMB) {
                    ((IAssemblerMB)((Object)req.te)).calculateMultiblock(this.updateInstance);
                }
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            mbreqs.remove();
        }
        if (requests.isEmpty()) {
            return;
        }
        Iterator reqs = requests.iterator();
        while (reqs.hasNext()) {
            MEUpdateRequest req = (MEUpdateRequest)reqs.next();
            if (req.w != w) continue;
            try {
                if (req.op == MEUpdateRequest.operation.Add) {
                    this.ge.addNode(req.te, w, req.loc);
                } else if (req.op == MEUpdateRequest.operation.Remove || req.op == MEUpdateRequest.operation.Error) {
                    this.ge.rmvNode(req.te, w, req.loc);
                } else {
                    this.ge.updateNode(w, req.loc);
                }
            }
            catch (Exception err) {
                // empty catch block
            }
            reqs.remove();
        }
        this.ge.update();
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public String getLabel() {
        return "AppEng Network Calculation";
    }
}

