/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.network;

import appeng.common.network.AppEngPacket;
import appeng.common.network.packets.PacketActionTile;
import appeng.common.network.packets.PacketBulkMAC;
import appeng.common.network.packets.PacketCancelCrafting;
import appeng.common.network.packets.PacketChangePage;
import appeng.common.network.packets.PacketClickCraftMe;
import appeng.common.network.packets.PacketClickSlotCraft;
import appeng.common.network.packets.PacketClickSlotME;
import appeng.common.network.packets.PacketConfigureTile;
import appeng.common.network.packets.PacketCraftingMonitor;
import appeng.common.network.packets.PacketGridAnimate;
import appeng.common.network.packets.PacketGuiButtonAction;
import appeng.common.network.packets.PacketGuiTab;
import appeng.common.network.packets.PacketInvCommand;
import appeng.common.network.packets.PacketLocalizedChatMsg;
import appeng.common.network.packets.PacketMatterCannon;
import appeng.common.network.packets.PacketMockExplosion;
import appeng.common.network.packets.PacketNEIRecipe;
import appeng.common.network.packets.PacketNMEInv;
import appeng.common.network.packets.PacketRequest;
import appeng.common.network.packets.PacketStorageMonitor;
import appeng.common.network.packets.PacketTransitionPlane;
import appeng.common.network.packets.PacketUpdatePageNum;
import java.io.DataInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class AppEngPacketHandlerBase {
    public static Map<Class, PacketTypes> reverseLookup = new HashMap<Class, PacketTypes>();

    public static enum PacketTypes {
        PACKET_NMEIINV(PacketNMEInv.class),
        PACKET_UPDATE_PAGENUM(PacketUpdatePageNum.class),
        PACKET_GRID_ANIMATE(PacketGridAnimate.class),
        PACKET_CLICK_SLOTME(PacketClickSlotME.class),
        PACKET_CLICK_CRAFTME(PacketClickCraftMe.class),
        PACKET_REQUEST(PacketRequest.class),
        PACKET_CLICK_SLOTCRAFT(PacketClickSlotCraft.class),
        PACKET_CONFIGURE_TILE(PacketConfigureTile.class),
        PACKET_ACTION_TILE(PacketActionTile.class),
        PACKET_CHANGE_PAGE(PacketChangePage.class),
        PACKET_CANCEL_CRAFTING(PacketCancelCrafting.class),
        PACKET_INV_COMMAND(PacketInvCommand.class),
        PACKET_GUI_BUTTON_ACTION(PacketGuiButtonAction.class),
        PACKET_BULK_MAC(PacketBulkMAC.class),
        PACKET_CRAFTING_MONITOR(PacketCraftingMonitor.class),
        PACKET_NEI_RECIPE(PacketNEIRecipe.class),
        PACKET_TRANPLANE(PacketTransitionPlane.class),
        PACKET_STORAGE_MONITOR(PacketStorageMonitor.class),
        PACKET_MATTERCANNON(PacketMatterCannon.class),
        PACKET_MOCKEXPLOSION(PacketMockExplosion.class),
        PACKET_GUI_TAB(PacketGuiTab.class),
        PACKET_LOCALIZED_CHATMSG(PacketLocalizedChatMsg.class);

        public final Class pc;
        public final Constructor con;

        private PacketTypes(Class c) {
            this.pc = c;
            Constructor x = null;
            try {
                x = this.pc.getConstructor(DataInputStream.class);
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
            this.con = x;
            reverseLookup.put(this.pc, this);
            if (this.con == null) {
                throw new RuntimeException("Invalid Packet Class, must be constructable on DataInputStream");
            }
        }

        AppEngPacket parsePacket(DataInputStream in) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return (AppEngPacket)this.con.newInstance(in);
        }

        public static PacketTypes getPacket(int id) {
            return PacketTypes.values()[id];
        }

        public static PacketTypes getID(Class<? extends AppEngPacket> c) {
            return reverseLookup.get(c);
        }
    }
}

