/*
 * Decompiled with CFR 0.152.
 */
package appeng.gui;

import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.util.IGridInterface;
import appeng.common.base.AppEngTile;
import appeng.common.network.packets.PacketClickCraftMe;
import appeng.common.network.packets.PacketClickSlotCraft;
import appeng.common.network.packets.PacketClickSlotME;
import appeng.common.network.packets.PacketInvCommand;
import appeng.slot.ISlotPlayerSide;
import appeng.slot.NullSlot;
import appeng.slot.SlotCraftingMatrix;
import appeng.slot.SlotCraftingTerminal;
import appeng.slot.SlotDisabled;
import appeng.slot.SlotFake;
import appeng.slot.SlotFakeBlacklist;
import appeng.slot.SlotInaccessable;
import appeng.slot.SlotME;
import appeng.util.Platform;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;

public abstract class AppEngContainer
extends Container {
    protected EntityPlayer who;
    protected AppEngTile worldEntity;
    public boolean forceUpdate = false;
    public boolean wasDragging = false;

    public Slot func_75139_a(int par1) {
        Slot s = null;
        if (this.field_75151_b.size() > par1) {
            s = super.func_75139_a(par1);
        }
        if (s == null) {
            s = new NullSlot();
        }
        return s;
    }

    public Slot func_75147_a(IInventory par1iInventory, int par2) {
        Slot s = super.func_75147_a(par1iInventory, par2);
        if (s == null) {
            s = new NullSlot();
        }
        return s;
    }

    public boolean func_94531_b(Slot slot) {
        if (slot instanceof SlotFake) {
            if (this.who != null && this.who.field_71071_by.func_70445_o() != null) {
                try {
                    this.wasDragging = true;
                    ItemStack g = this.who.field_71071_by.func_70445_o().func_77946_l();
                    g.field_77994_a = 1;
                    if (Platform.isClient()) {
                        PacketDispatcher.sendPacketToServer((Packet)new PacketInvCommand(PacketInvCommand.PacketInvCommands.DRAG_PLACEMENT, slot.field_75222_d).getPacket());
                    }
                    ((SlotFake)slot).func_75215_d(g);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
        return !(slot instanceof SlotME);
    }

    public void func_75142_b() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            Slot s = (Slot)this.field_75151_b.get(i);
            if (s instanceof SlotME) continue;
            ItemStack itemstack = s.func_75211_c();
            ItemStack itemstack1 = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            itemstack1 = itemstack == null ? null : itemstack.func_77946_l();
            this.field_75153_a.set(i, itemstack1);
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                ((ICrafting)this.field_75149_d.get(j)).func_71111_a((Container)this, i, itemstack1);
            }
        }
    }

    public Packet250CustomPayload getSlotMEPacket(SlotME slot, int mouseClick, int shift) throws IOException {
        ItemStack is = slot.getCmpStack();
        NBTTagCompound c = new NBTTagCompound();
        NBTTagCompound i = new NBTTagCompound();
        int isSize = 0;
        if (is != null) {
            isSize = is.field_77994_a;
            is.func_77955_b(i);
        }
        c.func_74766_a("#", i);
        i.func_74768_a("C", isSize);
        if (is != null && is.field_77994_a <= 0 && this.who.field_71071_by.func_70445_o() == null) {
            return new PacketClickCraftMe(mouseClick, shift, slot.field_75222_d, c).getPacket();
        }
        return new PacketClickSlotME(mouseClick, shift, slot.field_75222_d, c).getPacket();
    }

    public void handleCraftPacket(EntityPlayerMP pmp, PacketClickCraftMe p) {
        IGridTileEntity gte;
        IGridInterface gi;
        NBTTagCompound i = p.c.func_74775_l("#");
        ItemStack s = ItemStack.func_77949_a((NBTTagCompound)i);
        if (s != null) {
            s.field_77994_a = i.func_74762_e("C");
        }
        if (s != null && this.worldEntity instanceof IGridTileEntity && (gi = (gte = (IGridTileEntity)((Object)this.worldEntity)).getGrid()) != null) {
            try {
                gi.craftGui(pmp, gte, s);
            }
            catch (AppEngTileMissingException e) {
                e.printStackTrace();
            }
        }
    }

    public Packet250CustomPayload getSlotCraftPacket(SlotCraftingTerminal slot, int mouseClick, int shift) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        if (shift == 6) {
            shift = 0;
        }
        NBTTagCompound c = new NBTTagCompound();
        NBTTagCompound i = new NBTTagCompound();
        int isSize = 0;
        ItemStack is = slot.func_75211_c();
        if (is != null) {
            isSize = is.field_77994_a;
            is.func_77955_b(i);
        }
        c.func_74766_a("#", i);
        i.func_74768_a("C", isSize);
        return new PacketClickSlotCraft(mouseClick, shift, slot.field_75222_d, c).getPacket();
    }

    public void handleSlotCraftPacket(int mouseClick, int shift, int slotNumber, NBTTagCompound c) {
        ItemStack s = null;
        NBTTagCompound i = c.func_74775_l("#");
        s = ItemStack.func_77949_a((NBTTagCompound)i);
        if (s != null) {
            s.field_77994_a = i.func_74762_e("C");
        }
        if (s != null) {
            Slot sl = this.func_75139_a(slotNumber);
            if (sl != null && sl instanceof SlotCraftingTerminal) {
                SlotCraftingTerminal sme = (SlotCraftingTerminal)sl;
                sme.doClick(mouseClick, shift, this.who);
            }
        } else if (this.who.field_71071_by.func_70445_o() != null) {
            // empty if block
        }
    }

    public void handleSlotMEPacket(int mouseClick, int shift, int slotNumber, NBTTagCompound c) {
        NBTTagCompound i = c.func_74775_l("#");
        ItemStack s = ItemStack.func_77949_a((NBTTagCompound)i);
        if (s != null) {
            s.field_77994_a = i.func_74762_e("C");
        }
        if (s != null) {
            if (slotNumber >= this.field_75151_b.size()) {
                return;
            }
            Slot sl = this.func_75139_a(slotNumber);
            if (sl != null && sl instanceof SlotME) {
                SlotME sme = (SlotME)sl;
                if (sme.attuneSlot(s)) {
                    this.func_75144_a(sme.field_75222_d, mouseClick, shift, this.who);
                }
                sme.resetSlot();
            }
        } else if (this.who.field_71071_by.func_70445_o() != null) {
            if (slotNumber >= this.field_75151_b.size()) {
                return;
            }
            if (this.func_75139_a(slotNumber) instanceof SlotME) {
                this.func_75144_a(slotNumber, mouseClick, shift, this.who);
            }
        }
    }

    protected AppEngContainer(EntityPlayer _who, TileEntity t) {
        this.who = _who;
        this.worldEntity = (AppEngTile)t;
    }

    public void func_75132_a(ICrafting par1iCrafting) {
        super.func_75132_a(par1iCrafting);
        if (Platform.isServer() && this.worldEntity != null) {
            this.worldEntity.triggerContainerUpdate();
        }
    }

    public ItemStack func_75144_a(int slotNum, int mouseClick, int holdingShift, EntityPlayer p) {
        if (slotNum >= 0 && slotNum < this.field_75151_b.size()) {
            ItemStack held;
            Slot cs;
            int x;
            Slot clickSlot = (Slot)this.field_75151_b.get(slotNum);
            if (clickSlot instanceof SlotDisabled) {
                return null;
            }
            if (clickSlot instanceof SlotFakeBlacklist && mouseClick == 1) {
                ItemStack is = clickSlot.func_75211_c();
                if (is != null && Platform.isClient()) {
                    try {
                        PacketDispatcher.sendPacketToServer((Packet)new PacketInvCommand(PacketInvCommand.PacketInvCommands.InvertBlacklist, slotNum).getPacket());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    is.field_77994_a = -is.field_77994_a;
                    clickSlot.func_75215_d(is);
                }
                return null;
            }
            ArrayList<Slot> oppositeSlots = new ArrayList<Slot>();
            if (clickSlot instanceof ISlotPlayerSide) {
                for (x = 0; x < this.field_75151_b.size(); ++x) {
                    cs = (Slot)this.field_75151_b.get(x);
                    if (cs instanceof ISlotPlayerSide || cs instanceof SlotFake) continue;
                    oppositeSlots.add(cs);
                }
            } else {
                for (x = 0; x < this.field_75151_b.size(); ++x) {
                    cs = (Slot)this.field_75151_b.get(x);
                    if (!(cs instanceof ISlotPlayerSide) || cs instanceof SlotFake) continue;
                    oppositeSlots.add(cs);
                }
            }
            if (clickSlot instanceof SlotFake) {
                SlotFake mes = (SlotFake)clickSlot;
                held = p.field_71071_by.func_70445_o();
                if (held != null) {
                    if (mes.func_75214_a(held)) {
                        if (mouseClick > 0) {
                            ItemStack f = held.func_77946_l();
                            f.field_77994_a = 1;
                            mes.addToInv(f);
                        } else {
                            mes.addToInv(held);
                        }
                    }
                } else if (mouseClick > 0) {
                    mes.func_75209_a(1);
                } else {
                    mes.addToInv(null);
                }
                this.updateSlot(clickSlot);
                return null;
            }
            if (clickSlot instanceof SlotME) {
                SlotME mes = (SlotME)clickSlot;
                held = p.field_71071_by.func_70445_o();
                if (holdingShift == 1 && mouseClick > 0) {
                    if (held == null || Platform.isSameItem(mes.func_75211_c(), held)) {
                        ItemStack f;
                        if (held == null) {
                            p.field_71071_by.func_70437_b(mes.func_75209_a(1));
                        } else if (held.field_77994_a < held.func_77976_d() && (f = mes.func_75209_a(1)) != null) {
                            held.field_77994_a += f.field_77994_a;
                        }
                    }
                } else if (held != null) {
                    if (mes.func_75214_a(held)) {
                        if (mouseClick > 0) {
                            ItemStack small = held.func_77979_a(1);
                            ItemStack r = mes.addToInv(small);
                            if (r != null) {
                                held.field_77994_a += r.field_77994_a;
                            }
                            if (held.field_77994_a <= 0) {
                                p.field_71071_by.func_70437_b(null);
                            }
                        } else {
                            ItemStack r = mes.addToInv(held);
                            p.field_71071_by.func_70437_b(r);
                            if (holdingShift == 1) {
                                // empty if block
                            }
                        }
                        return null;
                    }
                } else {
                    ItemStack inSlot = mes.func_75211_c();
                    if (inSlot != null) {
                        if (holdingShift == 1) {
                            this.func_82846_b(p, slotNum);
                        } else {
                            ItemStack r = null;
                            if (mouseClick == 0) {
                                r = mes.func_75209_a(inSlot.func_77976_d());
                            } else {
                                int halfStack;
                                int n = halfStack = inSlot.field_77994_a > inSlot.func_77976_d() ? inSlot.func_77976_d() / 2 : (int)Math.ceil((float)inSlot.field_77994_a / 2.0f);
                                if (halfStack < 1) {
                                    halfStack = 1;
                                }
                                r = mes.func_75209_a(halfStack);
                            }
                            p.field_71071_by.func_70437_b(r);
                            return null;
                        }
                    }
                }
                return null;
            }
        }
        if (holdingShift == 2) {
            for (Slot s : this.field_75151_b) {
                if (!s.func_75217_a((IInventory)p.field_71071_by, mouseClick) || !(s instanceof SlotDisabled)) continue;
                return null;
            }
        }
        return super.func_75144_a(slotNum, mouseClick, holdingShift, p);
    }

    public final ItemStack func_82846_b(EntityPlayer p, int idx) {
        if (Platform.isClient()) {
            return null;
        }
        boolean hasMETiles = false;
        for (Object is : this.field_75151_b) {
            if (!(is instanceof SlotME)) continue;
            hasMETiles = true;
            break;
        }
        if (hasMETiles && Platform.isClient()) {
            return null;
        }
        ItemStack tis = null;
        Slot clickSlot = (Slot)this.field_75151_b.get(idx);
        if (clickSlot instanceof SlotDisabled || clickSlot instanceof SlotInaccessable) {
            return null;
        }
        if (clickSlot != null && clickSlot.func_75216_d()) {
            int placeAble;
            ItemStack source;
            Slot cs;
            int x;
            ItemStack is = clickSlot.func_75211_c();
            if (is == null) {
                return null;
            }
            tis = clickSlot instanceof SlotME ? ((SlotME)clickSlot).func_75209_a(64) : is.func_77946_l();
            ArrayList<Slot> selectedSlots = new ArrayList<Slot>();
            if (clickSlot instanceof ISlotPlayerSide) {
                for (x = 0; x < this.field_75151_b.size(); ++x) {
                    cs = (Slot)this.field_75151_b.get(x);
                    if (cs instanceof ISlotPlayerSide || cs instanceof SlotFake || cs instanceof SlotCraftingMatrix || !cs.func_75214_a(is)) continue;
                    selectedSlots.add(cs);
                }
            } else {
                for (x = 0; x < this.field_75151_b.size(); ++x) {
                    cs = (Slot)this.field_75151_b.get(x);
                    if (!(cs instanceof ISlotPlayerSide) || cs instanceof SlotFake || cs instanceof SlotCraftingMatrix || !cs.func_75214_a(is)) continue;
                    selectedSlots.add(cs);
                }
            }
            if (selectedSlots.isEmpty() && clickSlot instanceof ISlotPlayerSide && (source = clickSlot.func_75211_c()) != null) {
                for (int x2 = 0; x2 < this.field_75151_b.size(); ++x2) {
                    Slot cs2 = (Slot)this.field_75151_b.get(x2);
                    ItemStack dest = cs2.func_75211_c();
                    if (cs2 instanceof ISlotPlayerSide || !(cs2 instanceof SlotFake)) continue;
                    if (Platform.isSameItem(dest, source)) {
                        return null;
                    }
                    if (dest != null) continue;
                    cs2.func_75215_d(source);
                    cs2.func_75218_e();
                    this.updateSlot(cs2);
                    return null;
                }
            }
            for (Slot d : selectedSlots) {
                if (d instanceof SlotDisabled) continue;
                if (d instanceof SlotME) {
                    if (!d.func_75214_a(tis) || tis == null) continue;
                    tis = ((SlotME)d).addToInv(tis);
                    continue;
                }
                if (!d.func_75214_a(tis) || tis == null || !d.func_75216_d()) continue;
                ItemStack t = d.func_75211_c();
                if (tis == null || !Platform.isSameItem(tis, t)) continue;
                int maxSize = t.func_77976_d();
                if (maxSize > d.func_75219_a()) {
                    maxSize = d.func_75219_a();
                }
                if (tis.field_77994_a < (placeAble = maxSize - t.field_77994_a)) {
                    placeAble = tis.field_77994_a;
                }
                t.field_77994_a += placeAble;
                tis.field_77994_a -= placeAble;
                if (tis.field_77994_a <= 0) {
                    clickSlot.func_75215_d(null);
                    d.func_75218_e();
                    this.updateSlot(clickSlot);
                    this.updateSlot(d);
                    return null;
                }
                this.updateSlot(d);
            }
            for (Slot d : selectedSlots) {
                if (d instanceof SlotDisabled || d instanceof SlotME || !d.func_75214_a(tis) || tis == null) continue;
                if (d.func_75216_d()) {
                    ItemStack t = d.func_75211_c();
                    if (tis == null || !Platform.isSameItem(t, tis)) continue;
                    int maxSize = t.func_77976_d();
                    if (d.func_75219_a() < maxSize) {
                        maxSize = d.func_75219_a();
                    }
                    if (tis.field_77994_a < (placeAble = maxSize - t.field_77994_a)) {
                        placeAble = tis.field_77994_a;
                    }
                    t.field_77994_a += placeAble;
                    tis.field_77994_a -= placeAble;
                    if (tis.field_77994_a <= 0) {
                        clickSlot.func_75215_d(null);
                        d.func_75218_e();
                        this.updateSlot(clickSlot);
                        this.updateSlot(d);
                        return null;
                    }
                    this.updateSlot(d);
                    continue;
                }
                int maxSize = tis.func_77976_d();
                if (maxSize > d.func_75219_a()) {
                    maxSize = d.func_75219_a();
                }
                ItemStack tmp = tis.func_77946_l();
                if (tmp.field_77994_a > maxSize) {
                    tmp.field_77994_a = maxSize;
                }
                tis.field_77994_a -= tmp.field_77994_a;
                d.func_75215_d(tmp);
                if (tis.field_77994_a <= 0) {
                    clickSlot.func_75215_d(null);
                    d.func_75218_e();
                    this.updateSlot(clickSlot);
                    this.updateSlot(d);
                    return null;
                }
                this.updateSlot(d);
            }
            if (clickSlot instanceof SlotME) {
                if ((tis = ((SlotME)clickSlot).addToInv(tis)) != null && this.worldEntity != null) {
                    ArrayList<ItemStack> isr = new ArrayList<ItemStack>();
                    isr.add(tis);
                    Platform.spawnDrops(p.field_70170_p, this.worldEntity.field_70329_l, this.worldEntity.field_70330_m, this.worldEntity.field_70327_n, isr);
                }
                this.updateSlot(clickSlot);
                return null;
            }
            clickSlot.func_75215_d(tis);
        }
        this.updateSlot(clickSlot);
        return null;
    }

    private void updateSlot(Slot s) {
        if (s instanceof SlotME || Platform.isClient()) {
            return;
        }
        EntityPlayerMP p = (EntityPlayerMP)this.getPlayer();
        p.func_71111_a((Container)this, s.field_75222_d, s.func_75211_c());
    }

    public void updateClient() {
    }

    public void triggerUpdate() {
        if (Platform.isServer()) {
            this.updateClient();
            EntityPlayerMP pmp = (EntityPlayerMP)this.who;
            ArrayList<ItemStack> var3 = new ArrayList<ItemStack>();
            for (int var4 = 0; var4 < this.field_75151_b.size(); ++var4) {
                Slot s = (Slot)this.field_75151_b.get(var4);
                ItemStack is = s.func_75211_c();
                var3.add(is);
            }
            pmp.func_71110_a((Container)this, var3);
        }
    }

    public EntityPlayer getPlayer() {
        return this.who;
    }

    public AppEngTile getTile() {
        return this.worldEntity;
    }

    public void setTile(AppEngTile a) {
        this.worldEntity = a;
    }

    public boolean func_75145_c(EntityPlayer v) {
        return this.getTile().isCommonUseableByPlayer(v);
    }
}

