/*
 * Decompiled with CFR 0.152.
 */
package appeng.gui;

import appeng.api.exceptions.AppEngException;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.IPriorityTile;
import appeng.api.me.tiles.ITileIOCable;
import appeng.api.me.util.IGridInterface;
import appeng.common.AppEngInternalInventory;
import appeng.me.container.ContainerAssembler;
import appeng.me.container.ContainerBasicExportBus;
import appeng.me.container.ContainerChest;
import appeng.me.container.ContainerCondenser;
import appeng.me.container.ContainerController;
import appeng.me.container.ContainerCrafting;
import appeng.me.container.ContainerCraftingMonitor;
import appeng.me.container.ContainerCraftingTerminal;
import appeng.me.container.ContainerDrive;
import appeng.me.container.ContainerIOCable;
import appeng.me.container.ContainerIOPort;
import appeng.me.container.ContainerInterface;
import appeng.me.container.ContainerLevelEmitter;
import appeng.me.container.ContainerNull;
import appeng.me.container.ContainerPatternEncoder;
import appeng.me.container.ContainerPowerRelay;
import appeng.me.container.ContainerPreformatter;
import appeng.me.container.ContainerPriority;
import appeng.me.container.ContainerQuantumLink;
import appeng.me.container.ContainerStorageBus;
import appeng.me.container.ContainerTerminal;
import appeng.me.container.ContainerWireless;
import appeng.me.gui.GuiAssembler;
import appeng.me.gui.GuiAssemblerMB;
import appeng.me.gui.GuiBasicExportBus;
import appeng.me.gui.GuiCrafting;
import appeng.me.gui.GuiCraftingTerminal;
import appeng.me.gui.GuiIOCable;
import appeng.me.gui.GuiInterface;
import appeng.me.gui.GuiNull;
import appeng.me.gui.GuiStorageBus;
import appeng.me.gui.GuiTerminal;
import appeng.me.tile.TileAssembler;
import appeng.me.tile.TileAssemblerMB;
import appeng.me.tile.TileChest;
import appeng.me.tile.TileCondenser;
import appeng.me.tile.TileController;
import appeng.me.tile.TileCraftingMonitor;
import appeng.me.tile.TileCraftingTerminal;
import appeng.me.tile.TileDrive;
import appeng.me.tile.TileIOPort;
import appeng.me.tile.TileInterfaceBase;
import appeng.me.tile.TileLevelEmitter;
import appeng.me.tile.TilePartitioner;
import appeng.me.tile.TilePatternEncoder;
import appeng.me.tile.TilePowerRelay;
import appeng.me.tile.TileQuantumBridge;
import appeng.me.tile.TileStorageBus;
import appeng.me.tile.TileTerminal;
import appeng.me.tile.TileWireless;
import appeng.tech1.container.ContainerGrinder;
import appeng.tech1.tile.TileGrinder;
import appeng.util.Platform;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public enum AppEngGuiHandler implements IGuiHandler
{
    GUI_Handler,
    GUI_CHEST(ContainerChest.class, TileChest.class),
    GUI_PATTERN_ENCODER(ContainerPatternEncoder.class, TilePatternEncoder.class),
    GUI_DRIVE(ContainerDrive.class, TileDrive.class),
    GUI_CONTROLLER(ContainerController.class, TileController.class),
    GUI_INTERFACE(ContainerInterface.class, TileInterfaceBase.class),
    GUI_PREFORMATTER(ContainerPreformatter.class, TilePartitioner.class),
    GUI_WIRELESS(ContainerWireless.class, TileWireless.class),
    GUI_GRINDER(ContainerGrinder.class, TileGrinder.class),
    GUI_CRAFTING_TERMINAL(ContainerCraftingTerminal.class, TileCraftingTerminal.class),
    GUI_LEVELEMITTER(ContainerLevelEmitter.class, TileLevelEmitter.class),
    GUI_STORAGE_BUS(ContainerStorageBus.class, TileStorageBus.class),
    GUI_IO_PORT(ContainerIOPort.class, TileIOPort.class),
    GUI_CRAFTINGMONITOR(ContainerCraftingMonitor.class, TileCraftingMonitor.class),
    GUI_POWERRELAY(ContainerPowerRelay.class, TilePowerRelay.class),
    GUI_CONDENSER(ContainerCondenser.class, TileCondenser.class),
    GUI_PRIORITY(ContainerPriority.class, IPriorityTile.class),
    GUI_QUANTUM_LINK(ContainerQuantumLink.class, TileQuantumBridge.class),
    GUI_IO_CABLE(ContainerIOCable.class),
    GUI_ASSEMBLER(ContainerAssembler.class),
    GUI_ASSEMBLERMB(ContainerAssembler.class),
    GUI_TERMINAL(ContainerTerminal.class),
    GUI_WTERMINAL(ContainerTerminal.class),
    GUI_CRAFTING(ContainerCrafting.class),
    GUI_TERMINAL_RETURN(ContainerTerminal.class),
    GUI_WTERMINAL_RETURN(ContainerTerminal.class),
    GUI_CRAFTING_TERMINAL_RETURN(ContainerTerminal.class);

    private Class Tile;
    private Class Gui;
    private Class Container;

    private AppEngGuiHandler() {
        this.Tile = null;
        this.Gui = null;
        this.Container = null;
    }

    private void getGui() {
        if (Platform.isClient()) {
            String GuiClass = this.Container.getName().replaceFirst("container.Container", "gui.Gui");
            this.Gui = ReflectionHelper.getClass((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String[])new String[]{GuiClass});
            if (this.Gui == null) {
                throw new RuntimeException("Cannot Load class: " + GuiClass);
            }
        }
    }

    private AppEngGuiHandler(Class _Container) {
        this.Container = _Container;
        this.Tile = null;
        this.getGui();
    }

    private AppEngGuiHandler(Class _Container, Class _Tile) {
        this.Container = _Container;
        this.Tile = _Tile;
        this.getGui();
    }

    public boolean CorrectTile(TileEntity tE) {
        if (this.Tile == null) {
            throw new RuntimeException("This Gui Cannot use the standard Handler.");
        }
        return this.Tile.isInstance(tE);
    }

    public Object ConstructContainer(InventoryPlayer inventory, TileEntity tE) {
        try {
            Constructor<?>[] c = this.Container.getConstructors();
            if (c.length == 0) {
                throw new AppEngException("Invalid Gui Class");
            }
            return c[0].newInstance(inventory, tE);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (AppEngException e) {
            throw new RuntimeException(e);
        }
    }

    public Object ConstructGui(InventoryPlayer inventory, TileEntity tE) {
        try {
            Constructor<?>[] c = this.Gui.getConstructors();
            if (c.length == 0) {
                throw new AppEngException("Invalid Gui Class");
            }
            return c[0].newInstance(inventory, tE);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (AppEngException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getServerGuiElement(int ID_ORDINAL, EntityPlayer player, World w, int x, int y, int z) {
        AppEngGuiHandler ID = AppEngGuiHandler.values()[ID_ORDINAL];
        if (ID == GUI_ASSEMBLER || ID == GUI_ASSEMBLERMB) {
            TileEntity Ch = w.func_72796_p(x, y, z);
            if (Ch instanceof TileAssemblerMB && ((TileAssemblerMB)Ch).isComplete()) {
                TileAssemblerMB mb = (TileAssemblerMB)Ch;
                TileAssembler firstAssembler = (TileAssembler)mb.getCluster().getAssembler(mb.getCluster().getLastOffset());
                return new ContainerAssembler(player.field_71071_by, x, y, z, firstAssembler, firstAssembler);
            }
            if (player.field_71070_bA instanceof ContainerAssembler) {
                ContainerAssembler ca = (ContainerAssembler)player.field_71070_bA;
                x = ca.xCoord;
                y = ca.yCoord;
                z = ca.zCoord;
            }
            if (Ch instanceof TileAssembler) {
                return new ContainerAssembler(player.field_71071_by, x, y, z, Ch, (TileAssembler)Ch);
            }
        } else if (ID == GUI_TERMINAL || ID == GUI_TERMINAL_RETURN) {
            TileEntity Ch = w.func_72796_p(x, y, z);
            if (Ch instanceof TileTerminal) {
                return new ContainerTerminal(player.field_71071_by, (TileTerminal)Ch, false);
            }
        } else if (ID == GUI_WTERMINAL || ID == GUI_WTERMINAL_RETURN) {
            TileEntity Ch = w.func_72796_p(x, y, z);
            if (Ch instanceof TileWireless) {
                return new ContainerTerminal(player.field_71071_by, (TileWireless)Ch, true);
            }
        } else if (ID == GUI_CRAFTING_TERMINAL || ID == GUI_CRAFTING_TERMINAL_RETURN) {
            TileEntity Ch = w.func_72796_p(x, y, z);
            if (Ch instanceof TileTerminal) {
                return new ContainerCraftingTerminal(player.field_71071_by, (TileTerminal)Ch);
            }
        } else if (ID == GUI_IO_CABLE) {
            TileEntity Ch = w.func_72796_p(x, y, z);
            if (Ch instanceof ITileIOCable) {
                if (((ITileIOCable)Ch).getVersion() == ITileIOCable.Version.Basic) {
                    return new ContainerBasicExportBus(player.field_71071_by, (ITileIOCable)Ch);
                }
                return new ContainerIOCable(player.field_71071_by, (ITileIOCable)Ch);
            }
        } else if (ID == GUI_CRAFTING) {
            TileEntity c;
            IGridTileEntity tt;
            IGridInterface gi;
            TileEntity Ch = w.func_72796_p(x, y, z);
            if (Ch instanceof IGridTileEntity && (gi = (tt = (IGridTileEntity)Ch).getGrid()) != null && (c = gi.getController()) != null) {
                return new ContainerCrafting(player.field_71071_by, tt, ((TileController)c).lastCraftingRequest);
            }
        } else if (ID == GUI_STORAGE_BUS) {
            TileEntity Ch = w.func_72796_p(x, y, z);
            if (Ch instanceof TileStorageBus) {
                return new ContainerStorageBus(player.field_71071_by, (TileStorageBus)Ch, ((TileStorageBus)Ch).getConfiguration());
            }
        } else {
            TileEntity TE = w.func_72796_p(x, y, z);
            if (ID.CorrectTile(TE)) {
                return ID.ConstructContainer(player.field_71071_by, TE);
            }
        }
        return new ContainerNull();
    }

    public Object getClientGuiElement(int ID_ORDINAL, EntityPlayer player, World w, int x, int y, int z) {
        AppEngGuiHandler ID = AppEngGuiHandler.values()[ID_ORDINAL];
        if (ID == GUI_ASSEMBLER || ID == GUI_ASSEMBLERMB) {
            TileEntity Ch = w.func_72796_p(x, y, z);
            if (Ch instanceof TileAssemblerMB && ((TileAssemblerMB)Ch).isComplete()) {
                return new GuiAssemblerMB(player.field_71071_by, x, y, z, null, new AppEngInternalInventory(null, 54));
            }
            if (player.field_71070_bA instanceof ContainerAssembler) {
                ContainerAssembler ca = (ContainerAssembler)player.field_71070_bA;
                x = ca.xCoord;
                y = ca.yCoord;
                z = ca.zCoord;
            }
            if (ID == GUI_ASSEMBLERMB) {
                return new GuiAssemblerMB(player.field_71071_by, x, y, z, null, new AppEngInternalInventory(null, 54));
            }
            if (Ch instanceof TileAssembler) {
                return new GuiAssembler(player.field_71071_by, x, y, z, (TileAssembler)Ch, (TileAssembler)Ch);
            }
        } else if (ID == GUI_INTERFACE) {
            TileEntity Ch = w.func_72796_p(x, y, z);
            if (Ch instanceof TileInterfaceBase) {
                return new GuiInterface(player.field_71071_by, (TileInterfaceBase)Ch);
            }
        } else {
            if (ID == GUI_TERMINAL || ID == GUI_TERMINAL_RETURN) {
                if (ID == GUI_TERMINAL) {
                    GuiTerminal.initialSearch = "";
                    GuiTerminal.initialScroll = 0;
                }
                return new GuiTerminal(new ContainerTerminal(player.field_71071_by, null, false));
            }
            if (ID == GUI_WTERMINAL || ID == GUI_WTERMINAL_RETURN) {
                if (ID == GUI_WTERMINAL) {
                    GuiTerminal.initialSearch = "";
                    GuiTerminal.initialScroll = 0;
                }
                return new GuiTerminal(new ContainerTerminal(player.field_71071_by, null, true));
            }
            if (ID == GUI_CRAFTING_TERMINAL || ID == GUI_CRAFTING_TERMINAL_RETURN) {
                TileEntity Ch = w.func_72796_p(x, y, z);
                if (ID == GUI_CRAFTING_TERMINAL) {
                    GuiCraftingTerminal.initialSearch = "";
                    GuiCraftingTerminal.initialScroll = 0;
                }
                if (Ch instanceof TileTerminal) {
                    return new GuiCraftingTerminal(new ContainerCraftingTerminal(player.field_71071_by, (TileTerminal)Ch));
                }
            } else if (ID == GUI_IO_CABLE) {
                TileEntity Ch = w.func_72796_p(x, y, z);
                if (Ch instanceof ITileIOCable) {
                    if (((ITileIOCable)Ch).getVersion() == ITileIOCable.Version.Basic) {
                        return new GuiBasicExportBus(player.field_71071_by, (ITileIOCable)Ch);
                    }
                    return new GuiIOCable(player.field_71071_by, (ITileIOCable)Ch);
                }
            } else {
                if (ID == GUI_CRAFTING) {
                    return new GuiCrafting(player.field_71071_by, null);
                }
                if (ID == GUI_STORAGE_BUS) {
                    TileEntity Ch = w.func_72796_p(x, y, z);
                    if (Ch instanceof TileStorageBus) {
                        return new GuiStorageBus(player.field_71071_by, (TileStorageBus)Ch, ((TileStorageBus)Ch).getConfiguration());
                    }
                } else {
                    TileEntity TE = w.func_72796_p(x, y, z);
                    if (ID.CorrectTile(TE)) {
                        return ID.ConstructGui(player.field_71071_by, TE);
                    }
                }
            }
        }
        return new GuiNull(new ContainerNull());
    }
}

