/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.IItemList;
import appeng.api.exceptions.AppEngException;
import appeng.api.me.items.IAssemblerPatternItem;
import appeng.api.me.items.IMEPatternItem;
import appeng.api.me.tiles.IPushable;
import appeng.api.me.util.IAssemblerCluster;
import appeng.api.me.util.IAssemblerPattern;
import appeng.api.me.util.IMEInventory;
import appeng.common.base.AppEngMultiItem;
import appeng.common.base.AppEngSubItem;
import appeng.me.MEInventoryNetwork;
import appeng.me.MEInventoryUtil;
import appeng.me.container.ContainerNull;
import appeng.util.Platform;
import appeng.util.inv.AdaptorList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class AssemblerPatternInventory
implements IAssemblerPattern {
    private IAssemblerPatternItem PatternType;
    private ItemStack ip;
    private ItemStack output;
    private ItemStack[] matrix;
    private List<ItemStack> inputs;
    IRecipe cacheOutputRecipe;
    public List<IPushable> tes;
    public IAssemblerCluster ac;
    private static final String CRAFTING_MATRIX_SLOT = "#";
    private static final String OUTPUT_SLOT = "Out";
    private static final String ENCODED_VALUE = "Enc";

    private AssemblerPatternInventory(ItemStack o) throws AppEngException {
        AppEngSubItem si;
        if (o == null) {
            throw new AppEngException("ItemStack was used as a AssemblerPattern, but was not a AssemblerPattern!");
        }
        this.PatternType = null;
        this.ip = o;
        Item type = this.ip.func_77973_b();
        if (type instanceof IAssemblerPatternItem) {
            this.PatternType = (IAssemblerPatternItem)this.ip.func_77973_b();
        } else if (type instanceof AppEngMultiItem && (si = ((AppEngMultiItem)type).getSubItem(this.ip)) instanceof IAssemblerPatternItem) {
            this.PatternType = (IAssemblerPatternItem)((Object)si);
        }
        if (this.PatternType == null) {
            throw new AppEngException("ItemStack was used as a AssemblerPattern, but was not a AssemblerPattern!");
        }
        this.readNBT();
    }

    public static AssemblerPatternInventory getAssemblerPattern(ItemStack i) {
        try {
            return new AssemblerPatternInventory(i);
        }
        catch (AppEngException appEngException) {
            return null;
        }
    }

    public static boolean isBlankPattern(ItemStack i) {
        AppEngSubItem si;
        Item type = i.func_77973_b();
        if (type instanceof IMEPatternItem) {
            return !((IMEPatternItem)i.func_77973_b()).isEncoded();
        }
        if (type instanceof AppEngMultiItem && (si = ((AppEngMultiItem)type).getSubItem(i)) != null && si instanceof IMEPatternItem) {
            return !((IMEPatternItem)((Object)si)).isEncoded();
        }
        return false;
    }

    public static boolean isPattern(ItemStack i) {
        AppEngSubItem si;
        Item type = i.func_77973_b();
        if (type instanceof IMEPatternItem) {
            return true;
        }
        return type instanceof AppEngMultiItem && (si = ((AppEngMultiItem)type).getSubItem(i)) != null && si instanceof IMEPatternItem;
    }

    public static IMEPatternItem getPattern(ItemStack i) {
        AppEngSubItem si;
        Item type = i.func_77973_b();
        if (type instanceof IMEPatternItem) {
            return (IMEPatternItem)i.func_77973_b();
        }
        if (type instanceof AppEngMultiItem && (si = ((AppEngMultiItem)type).getSubItem(i)) != null && si instanceof IMEPatternItem) {
            return (IMEPatternItem)((Object)si);
        }
        return null;
    }

    public static boolean isAssemblerPattern(ItemStack i) {
        AppEngSubItem si;
        Item type = i.func_77973_b();
        if (type instanceof IAssemblerPatternItem) {
            return true;
        }
        return type instanceof AppEngMultiItem && (si = ((AppEngMultiItem)type).getSubItem(i)) != null && si instanceof IAssemblerPatternItem;
    }

    @Override
    public boolean isEncoded() {
        NBTTagCompound c = Platform.openNbtData(this.ip);
        return c.func_74767_n(ENCODED_VALUE);
    }

    @Override
    public void encodePattern(ItemStack[] craftingMatrix, ItemStack output) {
        if (AssemblerPatternInventory.isAssemblerPattern(this.ip)) {
            NBTTagCompound nc = new NBTTagCompound();
            if (output != null) {
                for (int x = 0; x < 9; ++x) {
                    if (craftingMatrix[x] == null) continue;
                    NBTTagCompound Slot2 = new NBTTagCompound();
                    craftingMatrix[x].func_77955_b(Slot2);
                    nc.func_74766_a(CRAFTING_MATRIX_SLOT + x, Slot2);
                }
                NBTTagCompound oSlot = new NBTTagCompound();
                output.func_77955_b(oSlot);
                nc.func_74766_a(OUTPUT_SLOT, oSlot);
                nc.func_74757_a(ENCODED_VALUE, true);
                this.ip.func_77982_d(nc);
                this.readNBT();
            }
        }
    }

    private void readNBT() {
        this.matrix = null;
        this.inputs = null;
        this.output = null;
        if (AssemblerPatternInventory.isAssemblerPattern(this.ip) && this.isEncoded()) {
            NBTTagCompound c = Platform.openNbtData(this.ip);
            NBTTagCompound oSlot = c.func_74775_l(OUTPUT_SLOT);
            ItemStack[] Matrix = new ItemStack[9];
            for (int x = 0; x < 9; ++x) {
                NBTTagCompound Slot2 = c.func_74775_l(CRAFTING_MATRIX_SLOT + x);
                if (Slot2 == null) continue;
                Matrix[x] = ItemStack.func_77949_a((NBTTagCompound)Slot2);
            }
            this.matrix = Matrix;
            if (oSlot != null) {
                ItemStack s;
                this.output = s = ItemStack.func_77949_a((NBTTagCompound)oSlot);
            }
            ArrayList<ItemStack> input = new ArrayList<ItemStack>();
            ItemStack[] set = this.getCraftingMatrix();
            for (int x = 0; x < 9; ++x) {
                Platform.sumItemToList(input, set[x]);
            }
            this.inputs = input;
        }
    }

    @Override
    public ItemStack[] getCraftingMatrix() {
        return this.matrix;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public List<ItemStack> condensedRequirements() {
        return this.inputs;
    }

    @Override
    public boolean isCraftable(World w) {
        InventoryCrafting cm = this.getCraftingInv(w, null, null, null, null);
        if (cm == null) {
            return false;
        }
        ItemStack out = Platform.findMatchingRecipeOutput(cm, w);
        ItemStack ro = this.getOutput();
        if (out != null) {
            return Platform.isSameItem(out, ro) && out.field_77994_a == ro.field_77994_a;
        }
        return false;
    }

    @Override
    public InventoryCrafting getCraftingInv(World w, IMEInventory invItemPool, List<ItemStack> missing, List<ItemStack> used, IItemList all) {
        int x;
        MEInventoryUtil itemPool = invItemPool != null ? new MEInventoryUtil(invItemPool) : new MEInventoryUtil();
        InventoryCrafting pattern = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
        ItemStack[] set = this.getCraftingMatrix();
        for (int x2 = 0; x2 < 9; ++x2) {
            if (set[x2] == null) continue;
            pattern.func_70299_a(x2, set[x2]);
        }
        IRecipe recipe = this.getMatchingRecipe(pattern, w);
        if (recipe == null) {
            return null;
        }
        ItemStack output = null;
        try {
            output = recipe.func_77572_b(pattern);
        }
        catch (Throwable t) {
            // empty catch block
        }
        InventoryCrafting cm = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
        boolean isGood = true;
        for (x = 0; x < 9; ++x) {
            if (set[x] == null) continue;
            if (itemPool == null) {
                if (used != null) {
                    new AdaptorList(used).addItems(set[x]);
                }
                cm.func_70299_a(0, set[x].func_77946_l());
                continue;
            }
            ItemStack fromPool = itemPool.extractItemsByRecipe(w, recipe, output, pattern, set[x], x, all);
            if (fromPool == null) {
                isGood = false;
                if (missing != null) {
                    new AdaptorList(missing).addItems(set[x]);
                }
            } else if (used != null) {
                new AdaptorList(used).addItems(fromPool);
            }
            cm.func_70299_a(x, fromPool);
        }
        if (!isGood) {
            if (invItemPool instanceof MEInventoryNetwork) {
                ((MEInventoryNetwork)invItemPool).registerInputs = false;
            }
            for (x = 0; x < 9; ++x) {
                if (cm.func_70301_a(x) == null) continue;
                Platform.addItems(invItemPool, cm.func_70301_a(x));
            }
            if (invItemPool instanceof MEInventoryNetwork) {
                ((MEInventoryNetwork)invItemPool).registerInputs = true;
            }
            return null;
        }
        return cm;
    }

    @Override
    public List<IPushable> getInterface() {
        return this.tes;
    }

    @Override
    public void setInterface(IPushable a) {
        if (this.tes == null) {
            this.tes = new ArrayList<IPushable>();
        }
        this.tes.add(a);
    }

    @Override
    public IAssemblerCluster getCluster() {
        return this.ac;
    }

    @Override
    public ItemStack getRecipeOutput(InventoryCrafting ic, World w) {
        IRecipe r = this.getMatchingRecipe(ic, w);
        if (r == null) {
            return null;
        }
        return r.func_77572_b(ic);
    }

    @Override
    public IRecipe getMatchingRecipe(InventoryCrafting ic, World w) {
        if (this.cacheOutputRecipe == null) {
            this.cacheOutputRecipe = Platform.findMatchingRecipe(ic, w);
        }
        return this.cacheOutputRecipe;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AssemblerPatternInventory) {
            if (this.tes != null) {
                AssemblerPatternInventory api = (AssemblerPatternInventory)obj;
                if (this.output == null) {
                    return false;
                }
                if (api.output == null) {
                    return false;
                }
                if (Platform.isSameItem(api.output, this.output) && api.output.field_77994_a == this.output.field_77994_a) {
                    List<ItemStack> myReqs = this.condensedRequirements();
                    List<ItemStack> itsReqs = api.condensedRequirements();
                    if (myReqs.size() != itsReqs.size()) {
                        return false;
                    }
                    for (ItemStack o : itsReqs) {
                        boolean good = false;
                        for (ItemStack g : myReqs) {
                            if (!Platform.isSameItem(g, o)) continue;
                            if (o.field_77994_a != g.field_77994_a) {
                                return false;
                            }
                            good = true;
                            break;
                        }
                        if (good) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            AssemblerPatternInventory api = (AssemblerPatternInventory)obj;
            boolean theSame = true;
            if (this.output == null) {
                return false;
            }
            if (Platform.isSameItem(api.output, this.output) && api.output.field_77994_a == this.output.field_77994_a) {
                for (int x = 0; x < 9; ++x) {
                    if (this.matrix[x] != null && api.matrix[x] != null || this.matrix[x] == null && api.matrix[x] == null) {
                        if (this.matrix[x] == null) continue;
                        if (Platform.isSameItem(api.matrix[x], this.matrix[x])) {
                            if (api.matrix[x].field_77994_a == this.matrix[x].field_77994_a) continue;
                            return false;
                        }
                        return false;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

