/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.exceptions.AppEngException;
import appeng.api.me.items.IStorageCell;
import appeng.api.me.util.IMEInventory;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.base.AppEngMultiItem;
import appeng.common.base.AppEngSubItem;
import appeng.me.CellInventoryHandler;
import appeng.me.CreativeCellInventory;
import appeng.util.AEItemStack;
import appeng.util.ItemList;
import appeng.util.Platform;
import java.util.HashSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagShort;

public class CellInventory
implements IMEInventory {
    static final String ITEM_TYPE_TAG = "it";
    static final String ITEM_COUNT_TAG = "ic";
    static final String ITEM_SLOT = "#";
    static final String ITEM_SLOTCOUNT = "@";
    static final String ITEM_PRE_FORMATED_COUNT = "PF";
    static final String ITEM_PRE_FORMATED_SLOT = "PF#";
    static final String ITEM_PRE_FORMATED_NAME = "PN";
    static final String ITEM_PRE_FORMATED_FUZZY = "FP";
    protected static String[] ITEM_SLOT_ARR;
    protected static String[] ITEM_SLOTCOUNT_ARR;
    protected final NBTTagCompound tagCompound;
    protected int MAX_ITEM_TYPES = 63;
    protected short storedItems = 0;
    protected int storedItemCount = 0;
    protected ItemList cellItems;
    protected ItemStack i;
    protected IStorageCell CellType;
    private static HashSet<Integer> blackList;

    protected CellInventory(NBTTagCompound data) {
        this.tagCompound = data;
    }

    protected void loadCellItems() {
        if (this.cellItems == null) {
            this.cellItems = new ItemList();
        }
        this.cellItems.resetStatus();
        int types = (int)this.storedItemTypes();
        for (int x = 0; x < types; ++x) {
            ItemStack t = ItemStack.func_77949_a((NBTTagCompound)this.tagCompound.func_74775_l(ITEM_SLOT_ARR[x]));
            if (t == null) continue;
            t.field_77994_a = this.tagCompound.func_74762_e(ITEM_SLOTCOUNT_ARR[x]);
            if (t.func_77942_o()) {
                t.func_77982_d(Platform.getSharedTagCompound(t));
            }
            if (t.field_77994_a <= 0) continue;
            this.cellItems.add(AEItemStack.create(t));
        }
        this.cellItems.clean();
    }

    void saveChanges() {
        this.cellItems.clean();
        int itemCount = 0;
        int x = 0;
        for (IAEItemStack v : this.cellItems) {
            itemCount = (int)((long)itemCount + v.getStackSize());
            NBTBase c = this.tagCompound.func_74781_a(ITEM_SLOT_ARR[x]);
            if (c instanceof NBTTagCompound) {
                v.writeToNBT((NBTTagCompound)c);
            } else {
                NBTTagCompound g = new NBTTagCompound();
                v.writeToNBT(g);
                this.tagCompound.func_74766_a(ITEM_SLOT_ARR[x], g);
            }
            NBTBase tagSlotCount = this.tagCompound.func_74781_a(ITEM_SLOTCOUNT_ARR[x]);
            if (tagSlotCount instanceof NBTTagInt) {
                ((NBTTagInt)tagSlotCount).field_74748_a = (int)v.getStackSize();
            } else {
                this.tagCompound.func_74768_a(ITEM_SLOTCOUNT_ARR[x], (int)v.getStackSize());
            }
            ++x;
        }
        NBTBase tagType = this.tagCompound.func_74781_a(ITEM_TYPE_TAG);
        NBTBase tagCount = this.tagCompound.func_74781_a(ITEM_COUNT_TAG);
        int oldStoreditems = this.storedItems;
        if (tagType instanceof NBTTagShort) {
            ((NBTTagShort)tagType).field_74752_a = this.storedItems = (short)this.cellItems.size();
        } else {
            this.storedItems = (short)this.cellItems.size();
            this.tagCompound.func_74777_a(ITEM_TYPE_TAG, this.storedItems);
        }
        if (tagCount instanceof NBTTagInt) {
            ((NBTTagInt)tagCount).field_74748_a = this.storedItemCount = itemCount;
        } else {
            this.storedItemCount = itemCount;
            this.tagCompound.func_74768_a(ITEM_COUNT_TAG, this.storedItemCount);
        }
        while (x < oldStoreditems && x < this.MAX_ITEM_TYPES) {
            this.tagCompound.func_82580_o(ITEM_SLOT_ARR[x]);
            this.tagCompound.func_82580_o(ITEM_SLOTCOUNT_ARR[x]);
            ++x;
        }
    }

    protected CellInventory(ItemStack o) throws AppEngException {
        AppEngSubItem si;
        if (ITEM_SLOT_ARR == null) {
            ITEM_SLOT_ARR = new String[this.MAX_ITEM_TYPES];
            ITEM_SLOTCOUNT_ARR = new String[this.MAX_ITEM_TYPES];
            for (int x = 0; x < this.MAX_ITEM_TYPES; ++x) {
                CellInventory.ITEM_SLOT_ARR[x] = ITEM_SLOT + x;
                CellInventory.ITEM_SLOTCOUNT_ARR[x] = ITEM_SLOTCOUNT + x;
            }
        }
        if (o == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        this.CellType = null;
        this.i = o;
        Item type = this.i.func_77973_b();
        if (type instanceof IStorageCell) {
            this.CellType = (IStorageCell)this.i.func_77973_b();
            this.MAX_ITEM_TYPES = this.CellType.getTotalTypes(this.i);
        } else if (type instanceof AppEngMultiItem && (si = ((AppEngMultiItem)type).getSubItem(this.i)) instanceof IStorageCell) {
            this.CellType = (IStorageCell)((Object)si);
            this.MAX_ITEM_TYPES = this.CellType.getTotalTypes(this.i);
        }
        if (this.CellType == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        if (this.MAX_ITEM_TYPES > 63) {
            this.MAX_ITEM_TYPES = 63;
        }
        if (this.MAX_ITEM_TYPES < 1) {
            this.MAX_ITEM_TYPES = 1;
        }
        this.tagCompound = Platform.openNbtData(o);
        this.storedItems = this.tagCompound.func_74765_d(ITEM_TYPE_TAG);
        this.storedItemCount = this.tagCompound.func_74762_e(ITEM_COUNT_TAG);
        this.cellItems = null;
    }

    ItemList getCellItems() {
        if (this.cellItems == null) {
            this.cellItems = new ItemList();
            this.loadCellItems();
        }
        return this.cellItems;
    }

    public int BytesPerType() {
        return this.CellType.BytePerType(this.i);
    }

    public boolean canHoldNewItem() {
        long bytesFree = this.freeBytes();
        return (bytesFree > (long)this.BytesPerType() || bytesFree == (long)this.BytesPerType() && this.unusedItemCount() > 0) && this.remainingItemTypes() > 0L;
    }

    public static IMEInventoryHandler getCell(ItemStack o) {
        try {
            return new CellInventoryHandler(new CellInventory(o));
        }
        catch (AppEngException appEngException) {
            return CreativeCellInventory.getCell(o);
        }
    }

    private static boolean isStorageCell(ItemStack i) {
        if (i == null) {
            return false;
        }
        try {
            AppEngSubItem si;
            Item type = i.func_77973_b();
            if (type instanceof IStorageCell) {
                return !((IStorageCell)type).storableInStorageCell();
            }
            if (type instanceof AppEngMultiItem && (si = ((AppEngMultiItem)type).getSubItem(i)) != null && si instanceof IStorageCell) {
                return !((IStorageCell)((Object)si)).storableInStorageCell();
            }
        }
        catch (Throwable err) {
            return true;
        }
        return false;
    }

    public static Boolean isCell(ItemStack i) {
        AppEngSubItem si;
        if (i == null) {
            return false;
        }
        Item type = i.func_77973_b();
        if (type instanceof IStorageCell) {
            return true;
        }
        if (type instanceof AppEngMultiItem && (si = ((AppEngMultiItem)type).getSubItem(i)) != null && si instanceof IStorageCell) {
            return true;
        }
        return CreativeCellInventory.isCell(i);
    }

    public long totalBytes() {
        return this.CellType.getBytes(this.i);
    }

    public long freeBytes() {
        return this.totalBytes() - this.usedBytes();
    }

    public long usedBytes() {
        long bytesForItemCount = (this.storedItemCount() + (long)this.unusedItemCount()) / 8L;
        return this.storedItemTypes() * (long)this.BytesPerType() + bytesForItemCount;
    }

    @Override
    public long getTotalItemTypes() {
        return this.MAX_ITEM_TYPES;
    }

    @Override
    public long storedItemTypes() {
        return this.storedItems;
    }

    @Override
    public long storedItemCount() {
        return this.storedItemCount;
    }

    private void updateItemCount(long delta) {
        int itemCount = this.storedItemCount;
        this.storedItemCount = (int)((long)this.storedItemCount + delta);
        this.tagCompound.func_74768_a(ITEM_COUNT_TAG, this.storedItemCount);
    }

    @Override
    public long remainingItemTypes() {
        long baseOnTotal;
        long basedOnStorage = this.freeBytes() / (long)this.BytesPerType();
        return basedOnStorage > (baseOnTotal = this.getTotalItemTypes() - this.storedItemTypes()) ? baseOnTotal : basedOnStorage;
    }

    @Override
    public long remainingItemCount() {
        long remaining = this.freeBytes() * 8L + (long)this.unusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    public int unusedItemCount() {
        int div = (int)(this.storedItemCount() % 8L);
        if (div == 0) {
            return 0;
        }
        return 8 - div;
    }

    public static void addBasicBlackList(int itemID, int Meta) {
        blackList.add(Meta << 16 | itemID);
    }

    public static boolean isBlackListed(IAEItemStack input) {
        if (blackList.contains(0x7FFF0000 | input.getItemID())) {
            return true;
        }
        return blackList.contains(input.getItemDamage() << 16 | input.getItemID());
    }

    @Override
    public boolean containsItemType(IAEItemStack i) {
        if (i == null) {
            return false;
        }
        return this.countOfItemType(i) > 0L;
    }

    @Override
    public long countOfItemType(IAEItemStack i) {
        if (i == null) {
            return 0L;
        }
        IAEItemStack ix = this.getCellItems().findItem(i);
        if (ix != null) {
            return ix.getStackSize();
        }
        return 0L;
    }

    @Override
    public IAEItemStack calculateItemAddition(IAEItemStack input) {
        IMEInventoryHandler meinv;
        if (input == null) {
            return null;
        }
        if (CellInventory.isBlackListed(input) || this.CellType.isBlackListed(this.i, input)) {
            return input;
        }
        IAEItemStack in = input;
        ItemStack shared = Platform.getSharedItemStack(in);
        if (CellInventory.isStorageCell(shared) && (meinv = CellInventory.getCell(shared)).storedItemCount() != 0L) {
            return input;
        }
        IAEItemStack stack = this.getCellItems().findItem(input);
        if (stack != null) {
            long remainingItemSlots = this.remainingItemCount();
            if (input.getStackSize() > remainingItemSlots) {
                IAEItemStack r = in.copy();
                r.setStackSize(r.getStackSize() - remainingItemSlots);
                return r;
            }
            return null;
        }
        if (this.canHoldNewItem()) {
            short itemTypes = this.storedItems;
            long remainingItemCount = this.remainingItemCount();
            if (in.getStackSize() > remainingItemCount) {
                IAEItemStack toReturn = in.copy();
                toReturn.setStackSize(in.getStackSize() - (long)((int)remainingItemCount));
                return toReturn;
            }
            return null;
        }
        return in;
    }

    @Override
    public synchronized IAEItemStack addItems(IAEItemStack input) {
        int remainingItemCount;
        IMEInventoryHandler meinv;
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (CellInventory.isBlackListed(input) || this.CellType.isBlackListed(this.i, input)) {
            return input;
        }
        ItemStack sharedItemStack = Platform.getSharedItemStack(input);
        if (CellInventory.isStorageCell(sharedItemStack) && (meinv = CellInventory.getCell(sharedItemStack)).storedItemCount() != 0L) {
            return input;
        }
        IAEItemStack l = this.getCellItems().findItem(input);
        if (l != null) {
            long remainingItemSlots = this.remainingItemCount();
            if (remainingItemSlots < 0L) {
                return input;
            }
            if (input.getStackSize() > remainingItemSlots) {
                l.setStackSize(l.getStackSize() + remainingItemSlots);
                IAEItemStack r = input.copy();
                r.setStackSize(r.getStackSize() - remainingItemSlots);
                this.updateItemCount(remainingItemSlots);
                this.saveChanges();
                return r;
            }
            l.setStackSize(l.getStackSize() + input.getStackSize());
            this.updateItemCount(input.getStackSize());
            this.saveChanges();
            return null;
        }
        if (this.canHoldNewItem() && (remainingItemCount = (int)this.remainingItemCount() - this.BytesPerType() * 8) > 0) {
            if (input.getStackSize() > (long)remainingItemCount) {
                ItemStack toWrite = Platform.cloneItemStack(sharedItemStack);
                ItemStack toReturn = Platform.cloneItemStack(sharedItemStack);
                toWrite.field_77994_a = remainingItemCount;
                toReturn.field_77994_a = sharedItemStack.field_77994_a - remainingItemCount;
                this.cellItems.add(AEItemStack.create(toWrite));
                this.updateItemCount(toWrite.field_77994_a);
                this.saveChanges();
                return AEItemStack.create(toReturn);
            }
            this.updateItemCount(input.getStackSize());
            this.cellItems.add(input);
            this.saveChanges();
            return null;
        }
        return input;
    }

    @Override
    public synchronized IAEItemStack extractItems(IAEItemStack request) {
        ItemStack sharedItem;
        if (request == null) {
            return null;
        }
        int size = sharedItem.field_77994_a;
        sharedItem = Platform.getSharedItemStack(request);
        int slimit = sharedItem.func_77973_b().func_77639_j();
        if (size > slimit) {
            size = slimit;
        }
        int moveBackStacks = -1;
        IAEItemStack Results = null;
        IAEItemStack l = this.getCellItems().findItem(request);
        if (l != null) {
            Results = l.copy();
            if (l.getStackSize() <= (long)size) {
                Results.setStackSize(l.getStackSize());
                this.updateItemCount(-l.getStackSize());
                l.setStackSize(0L);
                this.saveChanges();
            } else {
                l.setStackSize(l.getStackSize() - (long)size);
                Results.setStackSize(size);
                this.updateItemCount(-size);
                this.saveChanges();
            }
        }
        return Results;
    }

    @Override
    public synchronized IItemList getAvailableItems(IItemList Output) {
        for (IAEItemStack i : this.getCellItems()) {
            Output.add(i);
        }
        return Output;
    }

    @Override
    public synchronized long getAvailableSpaceByItem(IAEItemStack in, long maxNeeded) {
        IMEInventoryHandler meinv;
        if (in == null) {
            return 0L;
        }
        if (CellInventory.isBlackListed(in) || this.CellType.isBlackListed(this.i, in)) {
            return 0L;
        }
        ItemStack sharedItem = Platform.getSharedItemStack(in);
        if (CellInventory.isStorageCell(sharedItem) && (meinv = CellInventory.getCell(sharedItem)).storedItemCount() != 0L) {
            return 0L;
        }
        if (this.getCellItems().findItem(in) != null) {
            return this.remainingItemCount();
        }
        if (this.canHoldNewItem()) {
            int remainingItemCount = (int)this.remainingItemCount() - 8 * this.BytesPerType();
            return remainingItemCount;
        }
        return 0L;
    }

    @Override
    public IItemList getAvailableItems() {
        return this.getAvailableItems(new ItemList());
    }

    static {
        blackList = new HashSet();
    }
}

