/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.me.util.IMEInventory;
import appeng.util.AEItemStack;
import appeng.util.InventoryAdaptor;
import appeng.util.ItemList;
import appeng.util.Platform;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class MEIInventoryWrapper
implements IMEInventory {
    protected IInventory target;
    protected InventoryAdaptor adaptor;

    public MEIInventoryWrapper(IInventory m, InventoryAdaptor ia) {
        this.target = m;
        this.adaptor = ia;
    }

    @Override
    public long storedItemTypes() {
        int types = 0;
        int count = 0;
        for (int x = 0; x < this.target.func_70302_i_(); ++x) {
            ItemStack s = this.target.func_70301_a(x);
            if (s == null) continue;
            ++types;
            count += s.field_77994_a;
        }
        return (short)types;
    }

    @Override
    public long storedItemCount() {
        int types = 0;
        int count = 0;
        for (int x = 0; x < this.target.func_70302_i_(); ++x) {
            ItemStack s = this.target.func_70301_a(x);
            if (s == null) continue;
            ++types;
            count += s.field_77994_a;
        }
        return count;
    }

    @Override
    public long remainingItemTypes() {
        int types = 0;
        for (int x = 0; x < this.target.func_70302_i_(); ++x) {
            ItemStack s = this.target.func_70301_a(x);
            if (s != null) continue;
            ++types;
        }
        return types;
    }

    @Override
    public long remainingItemCount() {
        int count = 0;
        for (int x = 0; x < this.target.func_70302_i_(); ++x) {
            ItemStack s = this.target.func_70301_a(x);
            if (s != null) {
                count += this.target.func_70297_j_() - s.field_77994_a;
                continue;
            }
            count += this.target.func_70297_j_();
        }
        return count;
    }

    @Override
    public boolean containsItemType(IAEItemStack i) {
        for (int x = 0; x < this.target.func_70302_i_(); ++x) {
            if (!i.equals(this.target.func_70301_a(x))) continue;
            return true;
        }
        return false;
    }

    @Override
    public long countOfItemType(IAEItemStack i) {
        int total = 0;
        for (int x = 0; x < this.target.func_70302_i_(); ++x) {
            ItemStack ss = this.target.func_70301_a(x);
            if (!i.equals(ss)) continue;
            total += ss.field_77994_a;
        }
        return total;
    }

    @Override
    public synchronized IAEItemStack addItems(IAEItemStack iox) {
        ItemStack t;
        int x;
        if (iox == null) {
            return null;
        }
        ItemStack input = iox.getItemStack();
        if (input.field_77994_a == 0) {
            return null;
        }
        if (this.adaptor != null) {
            ItemStack is = this.adaptor.addItems(input);
            if (is == null) {
                return null;
            }
            return AEItemStack.create(is);
        }
        ItemStack out = Platform.cloneItemStack(input);
        for (x = 0; x < this.target.func_70302_i_(); ++x) {
            t = this.target.func_70301_a(x);
            if (!Platform.isSameItem(t, input)) continue;
            int oriStack = t.field_77994_a;
            t.field_77994_a += out.field_77994_a;
            this.target.func_70299_a(x, t);
            if (t.field_77994_a > this.target.func_70297_j_()) {
                t.field_77994_a = this.target.func_70297_j_();
            }
            if (t.field_77994_a > t.func_77976_d()) {
                t.field_77994_a = t.func_77976_d();
            }
            out.field_77994_a -= t.field_77994_a - oriStack;
            if (out.field_77994_a > 0) continue;
            return null;
        }
        for (x = 0; x < this.target.func_70302_i_(); ++x) {
            t = this.target.func_70301_a(x);
            if (t != null) continue;
            t = Platform.cloneItemStack(input);
            t.field_77994_a = out.field_77994_a;
            if (t.field_77994_a > this.target.func_70297_j_()) {
                t.field_77994_a = this.target.func_70297_j_();
            }
            out.field_77994_a -= t.field_77994_a;
            this.target.func_70299_a(x, t);
            if (out.field_77994_a > 0) continue;
            return null;
        }
        return AEItemStack.create(out);
    }

    @Override
    public synchronized IAEItemStack calculateItemAddition(IAEItemStack input) {
        ItemStack out = input.getItemStack();
        if (this.adaptor != null) {
            return AEItemStack.create(this.adaptor.simulateAdd(out));
        }
        for (int x = 0; x < this.target.func_70302_i_(); ++x) {
            ItemStack t = this.target.func_70301_a(x);
            if (t == null) {
                int st = out.field_77994_a;
                if (st > this.target.func_70297_j_()) {
                    st = this.target.func_70297_j_();
                }
                out.field_77994_a -= st;
                if (out.field_77994_a > 0) continue;
                return null;
            }
            if (!Platform.isSameItem(t, out)) continue;
            int oriStack = t.field_77994_a;
            int st = t.field_77994_a + out.field_77994_a;
            if (st > this.target.func_70297_j_()) {
                st = this.target.func_70297_j_();
            }
            if (st > t.func_77976_d()) {
                st = t.func_77976_d();
            }
            out.field_77994_a -= st - oriStack;
            if (out.field_77994_a > 0) continue;
            return null;
        }
        return AEItemStack.create(out);
    }

    @Override
    public synchronized IItemList getAvailableItems(IItemList out) {
        for (int x = 0; x < this.target.func_70302_i_(); ++x) {
            out.addStorage(AEItemStack.create(this.target.func_70301_a(x)));
        }
        return out;
    }

    @Override
    public synchronized IAEItemStack extractItems(IAEItemStack request) {
        ItemStack Req;
        ItemStack Gathered = null;
        int request_stackSize = Req.field_77994_a;
        Req = request.getItemStack();
        if (request_stackSize > Req.func_77976_d()) {
            request_stackSize = Req.func_77976_d();
        }
        Req.field_77994_a = request_stackSize;
        if (this.adaptor != null) {
            Gathered = this.adaptor.removeItems(Req.field_77994_a, Req, null);
        } else {
            Gathered = request.getItemStack();
            Gathered.field_77994_a = 0;
            for (int x = 0; x < this.target.func_70302_i_(); ++x) {
                ItemStack sub = this.target.func_70301_a(x);
                if (!Platform.isSameItem(sub, Req)) continue;
                int reqNum = Req.field_77994_a;
                if (reqNum > sub.field_77994_a) {
                    reqNum = Req.field_77994_a;
                }
                ItemStack retrieved = null;
                if (sub.field_77994_a < Req.field_77994_a) {
                    retrieved = Platform.cloneItemStack(sub);
                    sub.field_77994_a = 0;
                } else {
                    retrieved = sub.func_77979_a(Req.field_77994_a);
                }
                if (sub.field_77994_a <= 0) {
                    this.target.func_70299_a(x, null);
                } else {
                    this.target.func_70299_a(x, sub);
                }
                if (retrieved != null) {
                    Gathered.field_77994_a += retrieved.field_77994_a;
                    Req.field_77994_a -= retrieved.field_77994_a;
                }
                if (request_stackSize != Gathered.field_77994_a) continue;
                return AEItemStack.create(Gathered);
            }
            if (Gathered.field_77994_a == 0) {
                return null;
            }
        }
        return AEItemStack.create(Gathered);
    }

    @Override
    public long getTotalItemTypes() {
        return this.target.func_70302_i_();
    }

    @Override
    public long getAvailableSpaceByItem(IAEItemStack i, long maxNeeded) {
        if (i == null) {
            return 0L;
        }
        int available = 0;
        ItemStack in = Platform.getSharedItemStack(i);
        for (int x = 0; x < this.target.func_70302_i_(); ++x) {
            ItemStack g = this.target.func_70301_a(x);
            if (g == null) {
                if (!this.target.func_94041_b(x, in)) continue;
                available += in.func_77976_d();
                continue;
            }
            if (!in.func_77969_a(g)) continue;
            available += g.func_77976_d() - g.field_77994_a;
        }
        return available;
    }

    @Override
    public IItemList getAvailableItems() {
        return this.getAvailableItems(new ItemList());
    }
}

