/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.config.FuzzyMode;
import appeng.api.config.ItemFlow;
import appeng.api.config.ListMode;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventory;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.me.MEInventoryNetwork;
import appeng.util.ItemList;
import appeng.util.Platform;
import cpw.mods.fml.common.FMLLog;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class MEInventoryHandlerWrapper
implements IMEInventory,
IMEInventoryHandler {
    ItemFlow flow = ItemFlow.READ_WRITE;
    List<ItemStack> preformatted;
    FuzzyMode fmode = FuzzyMode.Percent_99;
    ListMode lmode = ListMode.WHITELIST;
    int priority;
    boolean fuzzy;
    IMEInventoryHandler parent;
    IMEInventoryHandler target;

    public MEInventoryHandlerWrapper(IMEInventoryHandler h) {
        this.target = h;
        this.preformatted = null;
        this.priority = 1;
    }

    @Override
    public long storedItemTypes() {
        return this.target.storedItemTypes();
    }

    @Override
    public long storedItemCount() {
        return this.target.storedItemCount();
    }

    @Override
    public long remainingItemTypes() {
        return this.target.remainingItemTypes();
    }

    @Override
    public long remainingItemCount() {
        return this.target.remainingItemCount();
    }

    @Override
    public boolean containsItemType(IAEItemStack i) {
        return this.target.containsItemType(i);
    }

    @Override
    public long getTotalItemTypes() {
        return this.target.getTotalItemTypes();
    }

    @Override
    public long countOfItemType(IAEItemStack i) {
        return this.target.countOfItemType(i);
    }

    @Override
    public IAEItemStack addItems(IAEItemStack input) {
        if (this.flow == ItemFlow.READ) {
            return input;
        }
        if (this.canAccept(input)) {
            return this.target.addItems(input);
        }
        return input;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request) {
        if (this.flow == ItemFlow.WRITE) {
            return null;
        }
        return this.target.extractItems(request);
    }

    @Override
    public IItemList getAvailableItems(IItemList out) {
        if (this.flow == ItemFlow.WRITE) {
            return out;
        }
        if (this.target instanceof MEInventoryNetwork) {
            MEInventoryNetwork net = (MEInventoryNetwork)this.target;
            out.setCurrentPriority(this.getPriority());
            IItemList il = net.getAvailableItems();
            for (IAEItemStack iae : il) {
                out.add(iae);
            }
            return out;
        }
        out.setCurrentPriority(this.getPriority());
        return this.target.getAvailableItems(out);
    }

    @Override
    public IAEItemStack calculateItemAddition(IAEItemStack stack) {
        if (this.flow == ItemFlow.READ) {
            return stack;
        }
        if (this.canAccept(stack)) {
            return this.target.calculateItemAddition(stack);
        }
        return stack;
    }

    @Override
    public long getAvailableSpaceByItem(IAEItemStack i, long maxNeeded) {
        return this.target.getAvailableSpaceByItem(i, maxNeeded);
    }

    @Override
    public IItemList getAvailableItems() {
        if (this.flow == ItemFlow.WRITE) {
            return new ItemList();
        }
        return this.target.getAvailableItems();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int p) {
        this.priority = p;
    }

    @Override
    public long totalBytes() {
        return this.target.totalBytes();
    }

    @Override
    public long freeBytes() {
        return this.target.freeBytes();
    }

    @Override
    public long usedBytes() {
        return this.target.usedBytes();
    }

    @Override
    public long unusedItemCount() {
        return this.target.unusedItemCount();
    }

    @Override
    public boolean canHoldNewItem() {
        return this.target.canHoldNewItem();
    }

    @Override
    public void setUpdateTarget(TileEntity e) {
    }

    @Override
    public List<ItemStack> getPreformattedItems() {
        return this.preformatted;
    }

    @Override
    public boolean isPreformatted() {
        return this.preformatted != null;
    }

    @Override
    public boolean isFuzzyPreformatted() {
        return this.fuzzy;
    }

    @Override
    public void setFuzzyPreformatted(boolean nf) {
        this.fuzzy = nf;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setGrid(IGridInterface grid) {
        FMLLog.severe((String)"EH?", (Object[])new Object[0]);
    }

    @Override
    public IGridInterface getGrid() {
        return this.target.getGrid();
    }

    public IMEInventoryHandler getTarget() {
        return this.target;
    }

    @Override
    public void setParent(IMEInventoryHandler p) {
        this.target.setParent(p);
    }

    @Override
    public IMEInventoryHandler getParent() {
        return this.target.getParent();
    }

    @Override
    public void removeGrid(IGridInterface grid, IMEInventoryHandler ignore, List<IMEInventoryHandler> duplicates) {
        this.target.removeGrid(grid, ignore, duplicates);
    }

    @Override
    public void validate(List<IMEInventoryHandler> duplicates) {
        this.target.validate(duplicates);
    }

    @Override
    public boolean canAccept(IAEItemStack input) {
        List<ItemStack> l = this.getPreformattedItems();
        if (this.isPreformatted()) {
            boolean haslist = l.size() > 0 && this.lmode == ListMode.WHITELIST;
            for (int x = 0; x < l.size(); ++x) {
                ItemStack is = l.get(x);
                if (is == null) continue;
                if (this.isFuzzyPreformatted()) {
                    if (!Platform.isSameItemFuzzy(is, Platform.getSharedItemStack(input), this.getFuzzyModePreformatted())) continue;
                    return this.lmode == ListMode.WHITELIST;
                }
                if (!Platform.isSameItemPrecise(is, Platform.getSharedItemStack(input))) continue;
                return this.lmode == ListMode.WHITELIST;
            }
            if (haslist) {
                return false;
            }
        }
        return this.target.canAccept(input);
    }

    @Override
    public ItemFlow getFlow() {
        return this.flow;
    }

    @Override
    public void setFlow(ItemFlow p) {
        this.flow = p;
    }

    @Override
    public void setPreformattedItems(IItemList in, FuzzyMode fuzzyMode, ListMode lm) {
        this.preformatted = in != null ? in.getItems() : null;
        this.fmode = fuzzyMode;
        this.lmode = lm;
    }

    @Override
    public FuzzyMode getFuzzyModePreformatted() {
        return this.fmode;
    }

    @Override
    public ListMode getListMode() {
        return this.lmode;
    }
}

