/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.basetiles;

import appeng.api.DimentionalCoord;
import appeng.api.WorldCoord;
import appeng.api.me.tiles.IColoredMETile;
import appeng.api.me.tiles.IConnectionSensitive;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IFulllyOptionalMETile;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.ITileCable;
import appeng.api.me.util.IGridInterface;
import appeng.common.AppEng;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.network.IAppEngNetworkTile;
import appeng.interfaces.ICustomCollision;
import appeng.me.basetiles.TileME;
import appeng.me.tile.TileColorlessCable;
import appeng.proxy.helpers.IFacadeProxy;
import appeng.proxy.helpers.IFacadeTile;
import appeng.render.AppEngBlockRenderer;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileCableBase
extends TileME
implements IConnectionSensitive,
IFacadeTile,
ICustomCollision,
ITileCable {
    final EnumSet<ForgeDirection> All = EnumSet.allOf(ForgeDirection.class);
    protected byte connections = (byte)-1;
    protected byte connectionMask = 0;
    protected byte coveredMask = 0;
    IFacadeProxy FP;
    public static HashMap<Integer, Float> Blinks = new HashMap();

    public abstract int getColor();

    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return true;
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        return AppEngTextureRegistry.Blocks.MECable.get();
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        this.FP.writeToNBT(par1nbtTagCompound);
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.FP.readFromNBT(par1nbtTagCompound);
    }

    public TileCableBase() {
        this.FP = AppEng.getInstance().BCProxy != null ? AppEng.getInstance().BCProxy.createFacadeProxy() : AppEng.getInstance().nFacadeProxy;
        this.updatesOnPower = false;
    }

    @Override
    public IFacadeProxy getFacadeProxy() {
        return this.FP;
    }

    @Override
    public void dropFacadeItem(ItemStack facade) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(facade);
        this.notifyNeightbors();
        Platform.spawnDrops(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, drops);
    }

    @Override
    public boolean isConnected(ForgeDirection direction) {
        if (this instanceof IDirectionalMETile && !((IDirectionalMETile)((Object)this)).canConnect(direction)) {
            return true;
        }
        return this.connectsTo((IBlockAccess)this.field_70331_k, this.field_70329_l + direction.offsetX, this.field_70330_m + direction.offsetY, this.field_70327_n + direction.offsetZ);
    }

    private boolean isCovered(IBlockAccess w, int x, int y, int z) {
        if (this.connections == -1) {
            this.onMEConnectionsChanged(this.All, this.All);
        }
        if (this instanceof TileColorlessCable && this.isCovered(this)) {
            return true;
        }
        if (x - this.field_70329_l == -1) {
            return (this.coveredMask & 1) == 1;
        }
        if (x - this.field_70329_l == 1) {
            return (this.coveredMask & 2) == 2;
        }
        if (y - this.field_70330_m == -1) {
            return (this.coveredMask & 4) == 4;
        }
        if (y - this.field_70330_m == 1) {
            return (this.coveredMask & 8) == 8;
        }
        if (z - this.field_70327_n == -1) {
            return (this.coveredMask & 0x10) == 16;
        }
        if (z - this.field_70327_n == 1) {
            return (this.coveredMask & 0x20) == 32;
        }
        return false;
    }

    public boolean connectsTo(IBlockAccess w, int x, int y, int z) {
        if (this.connections == -1) {
            this.onMEConnectionsChanged(this.All, this.All);
        }
        if (x - this.field_70329_l == -1) {
            return (this.connectionMask & 1) == 1;
        }
        if (x - this.field_70329_l == 1) {
            return (this.connectionMask & 2) == 2;
        }
        if (y - this.field_70330_m == -1) {
            return (this.connectionMask & 4) == 4;
        }
        if (y - this.field_70330_m == 1) {
            return (this.connectionMask & 8) == 8;
        }
        if (z - this.field_70327_n == -1) {
            return (this.connectionMask & 0x10) == 16;
        }
        if (z - this.field_70327_n == 1) {
            return (this.connectionMask & 0x20) == 32;
        }
        return false;
    }

    @Override
    public boolean coveredConnections() {
        return false;
    }

    public boolean isCovered(TileEntity te) {
        if (te instanceof ITileCable) {
            return ((ITileCable)te).coveredConnections();
        }
        return true;
    }

    @Override
    public float getHoleThickness(ForgeDirection direction) {
        return 0.32f;
    }

    @Override
    public void setGrid(IGridInterface gi) {
        super.setGrid(gi);
    }

    public boolean calcConnectsTo(IBlockAccess w, int x, int y, int z, int mv) {
        IDirectionalMETile dmet;
        TileEntity te = null;
        te = Platform.isClient() ? w.func_72796_p(x, y, z) : (TileEntity)AppEng.getInstance().GridManager.getEntityFromCoord(new DimentionalCoord(this.field_70331_k, x, y, z));
        ForgeDirection directionTo = this.getLocation().DirectionTo(new WorldCoord(x, y, z));
        if (te instanceof IGridTileEntity) {
            if (!((IGridTileEntity)te).isValid()) {
                return false;
            }
        } else {
            return false;
        }
        if (te instanceof IFulllyOptionalMETile && ((IFulllyOptionalMETile)te).isSeperated()) {
            return false;
        }
        if (this instanceof IDirectionalMETile && !((IDirectionalMETile)((Object)this)).canConnect(directionTo)) {
            return false;
        }
        if (te instanceof IDirectionalMETile && !(dmet = (IDirectionalMETile)te).canConnect(directionTo.getOpposite())) {
            return false;
        }
        if (this instanceof IColoredMETile && te instanceof IColoredMETile && ((IColoredMETile)((Object)this)).isColored() && ((IColoredMETile)te).isColored()) {
            if (((IColoredMETile)te).getColor() == this.getColor()) {
                this.connections = (byte)(this.connections + 1);
                this.connectionMask = (byte)(this.connectionMask | mv);
                if (this.isCovered(te)) {
                    this.coveredMask = (byte)(this.coveredMask | mv);
                }
                return true;
            }
            return false;
        }
        this.connections = (byte)(this.connections + 1);
        this.connectionMask = (byte)(this.connectionMask | mv);
        if (this.isCovered(te)) {
            this.coveredMask = (byte)(this.coveredMask | mv);
        }
        return true;
    }

    @Override
    public void onMEConnectionsChanged(Set<ForgeDirection> cDirections, Set<ForgeDirection> visualConnections) {
        if (Platform.isClient()) {
            return;
        }
        byte old = this.connectionMask;
        byte oldc = this.coveredMask;
        this.connections = 0;
        this.connectionMask = 0;
        this.coveredMask = 0;
        if (visualConnections.contains(ForgeDirection.WEST)) {
            this.calcConnectsTo((IBlockAccess)this.field_70331_k, this.field_70329_l - 1, this.field_70330_m, this.field_70327_n, 1);
        }
        if (visualConnections.contains(ForgeDirection.EAST)) {
            this.calcConnectsTo((IBlockAccess)this.field_70331_k, this.field_70329_l + 1, this.field_70330_m, this.field_70327_n, 2);
        }
        if (visualConnections.contains(ForgeDirection.DOWN)) {
            this.calcConnectsTo((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, 4);
        }
        if (visualConnections.contains(ForgeDirection.UP)) {
            this.calcConnectsTo((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, 8);
        }
        if (visualConnections.contains(ForgeDirection.NORTH)) {
            this.calcConnectsTo((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n - 1, 16);
        }
        if (visualConnections.contains(ForgeDirection.SOUTH)) {
            this.calcConnectsTo((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n + 1, 32);
        }
        if (old != this.connectionMask || oldc != this.coveredMask) {
            this.markForUpdate();
        }
    }

    public static void initBlink(int gIdx) {
        Blinks.put(gIdx, Float.valueOf(1.0f));
    }

    public Icon getTransientTextureFor(int x, int y, int z) {
        int col;
        TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
        if (te instanceof IColoredMETile && ((IColoredMETile)te).isColored() && (col = ((IColoredMETile)te).getColor()) >= 0 && col < AppEngTextureRegistry.Blocks.MECableColors.length) {
            return AppEngTextureRegistry.Blocks.MECableColors[col].get();
        }
        return AppEngTextureRegistry.Blocks.MECableClear.get();
    }

    @SideOnly(value=Side.CLIENT)
    public void setTipRenderBounds(RenderBlocks r, ForgeDirection dir, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (minX < 0.63f && dir == ForgeDirection.EAST) {
            minX = 0.61f;
        }
        if (minY < 0.63f && dir == ForgeDirection.UP) {
            minY = 0.61f;
        }
        if (minZ < 0.63f && dir == ForgeDirection.SOUTH) {
            minZ = 0.61f;
        }
        if (maxX > 0.37f && dir == ForgeDirection.WEST) {
            maxX = 0.39f;
        }
        if (maxY > 0.37f && dir == ForgeDirection.DOWN) {
            maxY = 0.39f;
        }
        if (maxZ > 0.37f && dir == ForgeDirection.NORTH) {
            maxZ = 0.39f;
        }
        r.func_83020_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderCableAtTransient(double Thickness, IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer, double pull) {
        AppEngBlockRenderer AppEngRenderer = AppEngBlockRenderer.instance;
        AppEngRenderer.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.MECableClear.get());
        renderer.func_83020_a(0.5 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.5 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        renderer.func_78570_q(block, x, y, z);
        if (this.connectsTo(world, x - 1, y, z)) {
            AppEngRenderer.setOverrideBlockTexture(block, this.getTransientTextureFor(x - 1, y, z));
            renderer.func_83020_a(0.0, 0.5 - Thickness, 0.5 - Thickness, 0.5 - Thickness - pull, 0.5 + Thickness, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x + 1, y, z)) {
            AppEngRenderer.setOverrideBlockTexture(block, this.getTransientTextureFor(x + 1, y, z));
            renderer.func_83020_a(0.5 + Thickness + pull, 0.5 - Thickness, 0.5 - Thickness, 1.0, 0.5 + Thickness, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y, z - 1)) {
            AppEngRenderer.setOverrideBlockTexture(block, this.getTransientTextureFor(x, y, z - 1));
            renderer.func_83020_a(0.5 - Thickness, 0.5 - Thickness, 0.0, 0.5 + Thickness, 0.5 + Thickness, 0.5 - Thickness - pull);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y, z + 1)) {
            AppEngRenderer.setOverrideBlockTexture(block, this.getTransientTextureFor(x, y, z + 1));
            renderer.func_83020_a(0.5 - Thickness, 0.5 - Thickness, 0.5 + Thickness + pull, 0.5 + Thickness, 0.5 + Thickness, 1.0);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y - 1, z)) {
            AppEngRenderer.setOverrideBlockTexture(block, this.getTransientTextureFor(x, y - 1, z));
            renderer.func_83020_a(0.5 - Thickness, 0.0, 0.5 - Thickness, 0.5 + Thickness, 0.5 - Thickness - pull, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y + 1, z)) {
            AppEngRenderer.setOverrideBlockTexture(block, this.getTransientTextureFor(x, y + 1, z));
            renderer.func_83020_a(0.5 - Thickness, 0.5 + Thickness + pull, 0.5 - Thickness, 0.5 + Thickness, 1.0, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        AppEngRenderer.setOverrideBlockTexture(block, null);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderCableAt(double Thickness, IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer, Icon texture, boolean center, double pull) {
        AppEngBlockRenderer AppEngRenderer = AppEngBlockRenderer.instance;
        AppEngRenderer.setOverrideBlockTexture(block, texture);
        if (center && !this.isCovered(world, x, y, z)) {
            renderer.func_83020_a(0.5 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.5 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        } else if (center && this.isCovered(world, x, y, z)) {
            double g = 0.05;
            renderer.func_83020_a(0.5 - Thickness - g, 0.5 - Thickness - g, 0.5 - Thickness - g, 0.5 + Thickness + g, 0.5 + Thickness + g, 0.5 + Thickness + g);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x - 1, y, z) && (this.isCovered(world, x - 1, y, z) || center)) {
            renderer.func_83020_a(0.0, 0.5 - Thickness, 0.5 - Thickness, 0.5 - Thickness - pull, 0.5 + Thickness, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x + 1, y, z) && (this.isCovered(world, x + 1, y, z) || center)) {
            renderer.func_83020_a(0.5 + Thickness + pull, 0.5 - Thickness, 0.5 - Thickness, 1.0, 0.5 + Thickness, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y, z - 1) && (this.isCovered(world, x, y, z - 1) || center)) {
            renderer.func_83020_a(0.5 - Thickness, 0.5 - Thickness, 0.0, 0.5 + Thickness, 0.5 + Thickness, 0.5 - Thickness - pull);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y, z + 1) && (this.isCovered(world, x, y, z + 1) || center)) {
            renderer.func_83020_a(0.5 - Thickness, 0.5 - Thickness, 0.5 + Thickness + pull, 0.5 + Thickness, 0.5 + Thickness, 1.0);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y - 1, z) && (this.isCovered(world, x, y - 1, z) || center)) {
            renderer.func_83020_a(0.5 - Thickness, 0.0, 0.5 - Thickness, 0.5 + Thickness, 0.5 - Thickness - pull, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y + 1, z) && (this.isCovered(world, x, y + 1, z) || center)) {
            renderer.func_83020_a(0.5 - Thickness, 0.5 + Thickness + pull, 0.5 - Thickness, 0.5 + Thickness, 1.0, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        AppEngRenderer.setOverrideBlockTexture(block, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.FP.facadeRender(renderer, block, this, x, y, z, 0.4f);
        return false;
    }

    @Override
    public void updateClientTile() {
        this.onMEConnectionsChanged(this.All, this.All);
    }

    @Override
    public void addCollidingBlockToList(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        AppEngMultiBlock blk = (AppEngMultiBlock)this.func_70311_o();
        float thickness = 0.18f;
        float xminPos = 0.5f - thickness;
        float xmaxPos = 0.5f + thickness;
        float yminPos = 0.5f - thickness;
        float ymaxPos = 0.5f + thickness;
        float zminPos = 0.5f - thickness;
        float zmaxPos = 0.5f + thickness;
        if (this.FP.hasFacade(this, ForgeDirection.WEST)) {
            xminPos = 0.0f;
            yminPos = 0.0f;
            ymaxPos = 1.0f;
            zmaxPos = 1.0f;
            zminPos = 0.0f;
        } else if (this.connectsTo((IBlockAccess)world, x - 1, y, z)) {
            xminPos = 0.0f;
        }
        if (this.FP.hasFacade(this, ForgeDirection.EAST)) {
            xmaxPos = 1.0f;
            yminPos = 0.0f;
            ymaxPos = 1.0f;
            zmaxPos = 1.0f;
            zminPos = 0.0f;
        } else if (this.connectsTo((IBlockAccess)world, x + 1, y, z)) {
            xmaxPos = 1.0f;
        }
        if (this.FP.hasFacade(this, ForgeDirection.DOWN)) {
            yminPos = 0.0f;
            xmaxPos = 1.0f;
            xminPos = 0.0f;
            zmaxPos = 1.0f;
            zminPos = 0.0f;
        } else if (this.connectsTo((IBlockAccess)world, x, y - 1, z)) {
            yminPos = 0.0f;
        }
        if (this.FP.hasFacade(this, ForgeDirection.UP)) {
            ymaxPos = 1.0f;
            xmaxPos = 1.0f;
            xminPos = 0.0f;
            zmaxPos = 1.0f;
            zminPos = 0.0f;
        } else if (this.connectsTo((IBlockAccess)world, x, y + 1, z)) {
            ymaxPos = 1.0f;
        }
        if (this.FP.hasFacade(this, ForgeDirection.NORTH)) {
            zminPos = 0.0f;
            xmaxPos = 1.0f;
            xminPos = 0.0f;
            ymaxPos = 1.0f;
            yminPos = 0.0f;
        } else if (this.connectsTo((IBlockAccess)world, x, y, z - 1)) {
            zminPos = 0.0f;
        }
        if (this.FP.hasFacade(this, ForgeDirection.SOUTH)) {
            zmaxPos = 1.0f;
            xmaxPos = 1.0f;
            xminPos = 0.0f;
            ymaxPos = 1.0f;
            yminPos = 0.0f;
        } else if (this.connectsTo((IBlockAccess)world, x, y, z + 1)) {
            zmaxPos = 1.0f;
        }
        AxisAlignedBB b = this.extendBusCollision(AxisAlignedBB.func_72332_a().func_72299_a((double)xminPos, (double)yminPos, (double)zminPos, (double)xmaxPos, (double)ymaxPos, (double)zmaxPos));
        blk.func_71905_a((float)b.field_72340_a, (float)b.field_72338_b, (float)b.field_72339_c, (float)b.field_72336_d, (float)b.field_72337_e, (float)b.field_72334_f);
        blk.configureCollidingBlockToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
        blk.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AxisAlignedBB IOBusCollision(float diff, ForgeDirection orientation, AxisAlignedBB b) {
        if (orientation == ForgeDirection.NORTH) {
            b.field_72339_c = 0.0;
            b.field_72340_a = Math.min(b.field_72340_a, (double)diff);
            b.field_72336_d = Math.max(b.field_72336_d, (double)(1.0f - diff));
            b.field_72338_b = Math.min(b.field_72338_b, (double)diff);
            b.field_72337_e = Math.max(b.field_72337_e, (double)(1.0f - diff));
        }
        if (orientation == ForgeDirection.SOUTH) {
            b.field_72334_f = 1.0;
            b.field_72340_a = Math.min(b.field_72340_a, (double)diff);
            b.field_72336_d = Math.max(b.field_72336_d, (double)(1.0f - diff));
            b.field_72338_b = Math.min(b.field_72338_b, (double)diff);
            b.field_72337_e = Math.max(b.field_72337_e, (double)(1.0f - diff));
        }
        if (orientation == ForgeDirection.WEST) {
            b.field_72340_a = 0.0;
            b.field_72339_c = Math.min(b.field_72339_c, (double)diff);
            b.field_72334_f = Math.max(b.field_72334_f, (double)(1.0f - diff));
            b.field_72338_b = Math.min(b.field_72338_b, (double)diff);
            b.field_72337_e = Math.max(b.field_72337_e, (double)(1.0f - diff));
        }
        if (orientation == ForgeDirection.EAST) {
            b.field_72336_d = 1.0;
            b.field_72339_c = Math.min(b.field_72339_c, (double)diff);
            b.field_72334_f = Math.max(b.field_72334_f, (double)(1.0f - diff));
            b.field_72338_b = Math.min(b.field_72338_b, (double)diff);
            b.field_72337_e = Math.max(b.field_72337_e, (double)(1.0f - diff));
        }
        if (orientation == ForgeDirection.DOWN) {
            b.field_72338_b = 0.0;
            b.field_72339_c = Math.min(b.field_72339_c, (double)diff);
            b.field_72334_f = Math.max(b.field_72334_f, (double)(1.0f - diff));
            b.field_72340_a = Math.min(b.field_72340_a, (double)diff);
            b.field_72336_d = Math.max(b.field_72336_d, (double)(1.0f - diff));
        }
        if (orientation == ForgeDirection.UP) {
            b.field_72337_e = 1.0;
            b.field_72339_c = Math.min(b.field_72339_c, (double)diff);
            b.field_72334_f = Math.max(b.field_72334_f, (double)(1.0f - diff));
            b.field_72340_a = Math.min(b.field_72340_a, (double)diff);
            b.field_72336_d = Math.max(b.field_72336_d, (double)(1.0f - diff));
        }
        return b;
    }

    public AxisAlignedBB extendBusCollision(AxisAlignedBB b) {
        return b;
    }

    @Override
    public AxisAlignedBB[] getSelectedBoundingBoxsFromPool(World world, int x, int y, int z) {
        float thickness = 0.18f;
        float xminPos = 0.5f - thickness;
        float xmaxPos = 0.5f + thickness;
        float yminPos = 0.5f - thickness;
        float ymaxPos = 0.5f + thickness;
        float zminPos = 0.5f - thickness;
        float zmaxPos = 0.5f + thickness;
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        if (this.FP.hasFacade(this, ForgeDirection.WEST)) {
            xminPos = 0.0f;
            yminPos = 0.0f;
            ymaxPos = 1.0f;
            zmaxPos = 1.0f;
            zminPos = 0.0f;
        } else if (this.connectsTo((IBlockAccess)world, x - 1, y, z)) {
            xminPos = 0.0f;
        }
        if (this.FP.hasFacade(this, ForgeDirection.EAST)) {
            xmaxPos = 1.0f;
            yminPos = 0.0f;
            ymaxPos = 1.0f;
            zmaxPos = 1.0f;
            zminPos = 0.0f;
        } else if (this.connectsTo((IBlockAccess)world, x + 1, y, z)) {
            xmaxPos = 1.0f;
        }
        boxes.add(AxisAlignedBB.func_72332_a().func_72299_a((double)xminPos, (double)yminPos, (double)zminPos, (double)xmaxPos, (double)ymaxPos, (double)zmaxPos));
        xminPos = 0.5f - thickness;
        xmaxPos = 0.5f + thickness;
        yminPos = 0.5f - thickness;
        ymaxPos = 0.5f + thickness;
        zminPos = 0.5f - thickness;
        zmaxPos = 0.5f + thickness;
        if (this.FP.hasFacade(this, ForgeDirection.DOWN)) {
            yminPos = 0.0f;
            xmaxPos = 1.0f;
            xminPos = 0.0f;
            zmaxPos = 1.0f;
            zminPos = 0.0f;
        } else if (this.connectsTo((IBlockAccess)world, x, y - 1, z)) {
            yminPos = 0.0f;
        }
        if (this.FP.hasFacade(this, ForgeDirection.UP)) {
            ymaxPos = 1.0f;
            xmaxPos = 1.0f;
            xminPos = 0.0f;
            zmaxPos = 1.0f;
            zminPos = 0.0f;
        } else if (this.connectsTo((IBlockAccess)world, x, y + 1, z)) {
            ymaxPos = 1.0f;
        }
        boxes.add(AxisAlignedBB.func_72332_a().func_72299_a((double)xminPos, (double)yminPos, (double)zminPos, (double)xmaxPos, (double)ymaxPos, (double)zmaxPos));
        xminPos = 0.5f - thickness;
        xmaxPos = 0.5f + thickness;
        yminPos = 0.5f - thickness;
        ymaxPos = 0.5f + thickness;
        zminPos = 0.5f - thickness;
        zmaxPos = 0.5f + thickness;
        if (this.FP.hasFacade(this, ForgeDirection.NORTH)) {
            zminPos = 0.0f;
            xmaxPos = 1.0f;
            xminPos = 0.0f;
            ymaxPos = 1.0f;
            yminPos = 0.0f;
        } else if (this.connectsTo((IBlockAccess)world, x, y, z - 1)) {
            zminPos = 0.0f;
        }
        if (this.FP.hasFacade(this, ForgeDirection.SOUTH)) {
            zmaxPos = 1.0f;
            xmaxPos = 1.0f;
            xminPos = 0.0f;
            ymaxPos = 1.0f;
            yminPos = 0.0f;
        } else if (this.connectsTo((IBlockAccess)world, x, y, z + 1)) {
            zmaxPos = 1.0f;
        }
        boxes.add(AxisAlignedBB.func_72332_a().func_72299_a((double)xminPos, (double)yminPos, (double)zminPos, (double)xmaxPos, (double)ymaxPos, (double)zmaxPos));
        xminPos = 0.5f - thickness;
        xmaxPos = 0.5f + thickness;
        yminPos = 0.5f - thickness;
        ymaxPos = 0.5f + thickness;
        zminPos = 0.5f - thickness;
        zmaxPos = 0.5f + thickness;
        AxisAlignedBB bus = this.extendBusCollision(AxisAlignedBB.func_72332_a().func_72299_a((double)xminPos, (double)yminPos, (double)zminPos, (double)xmaxPos, (double)ymaxPos, (double)zmaxPos));
        boxes.add(bus);
        return boxes.toArray(new AxisAlignedBB[boxes.size()]);
    }

    @Override
    public boolean getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        for (ItemStack is : this.FP.getDrops(this)) {
            drops.add(is);
        }
        return false;
    }

    public void handleTilePacket(DataInputStream stream) throws IOException {
        byte oldconnections = this.connections;
        byte oldconnectionMask = this.connectionMask;
        boolean newFacades = this.FP.readFromStream(stream);
        this.connections = stream.readByte();
        this.connectionMask = stream.readByte();
        this.coveredMask = stream.readByte();
        this.gIdx = stream.readInt();
        if (this.connectionMask != oldconnectionMask || this.connections != oldconnections || newFacades) {
            this.markForUpdate();
        }
    }

    public void configureTilePacket(DataOutputStream data) throws IOException {
        this.FP.writeToStream(data);
        data.writeByte(this.connections);
        data.writeByte(this.connectionMask);
        data.writeByte(this.coveredMask);
        data.writeInt(this.gIdx);
    }

    public float getFlashIntensity() {
        if (Blinks.containsKey(this.gIdx)) {
            return Blinks.get(this.gIdx).floatValue();
        }
        return -1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawFlashes(RenderBlocks renderer) {
        this.renderCableAt(0.030000001788139344, (IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o(), 0, renderer, AppEngTextureRegistry.Blocks.CableBeam.get(), true, 0.0);
    }
}

