/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.basetiles;

import appeng.api.events.GridStorageUpdateEvent;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.me.tiles.ICellContainer;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEngConfiguration;
import appeng.common.base.AppEngTile;
import appeng.util.ItemList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class TileME
extends AppEngTile {
    public boolean updatesOnPower = true;
    private IGridInterface myGrid = null;
    public boolean hasPower = false;
    public int gIdx = 0;

    protected TileME() {
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    @Override
    public void func_70312_q() {
        super.func_70312_q();
        this.myGrid = null;
        this.gIdx = 0;
    }

    @Override
    protected void terminate() {
        super.terminate();
        if (this instanceof IGridTileEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new GridTileUnloadEvent((IGridTileEntity)((Object)this), this.field_70331_k, this.getLocation()));
        }
    }

    public void onNetworkInventoryChange(ItemList is) {
    }

    public float getStoragePowerUsage(List<IMEInventoryHandler> cellArray) {
        float current = 0.0f;
        for (IMEInventoryHandler h : cellArray) {
            switch ((int)h.totalBytes()) {
                case 1024: {
                    current += AppEngConfiguration.tier1Power;
                    break;
                }
                case 4096: {
                    current += AppEngConfiguration.tier2Power;
                    break;
                }
                case 16384: {
                    current += AppEngConfiguration.tier3Power;
                    break;
                }
                case 65536: {
                    current += AppEngConfiguration.tier4Power;
                }
            }
        }
        return current;
    }

    public IGridInterface getGrid() {
        return this.myGrid instanceof IGridInterface ? (this.myGrid.isValid() ? this.myGrid : null) : null;
    }

    public void triggerPowerUpdate() {
        if (this.myGrid != null) {
            this.myGrid.triggerPowerUpdate();
        }
    }

    public void setGrid(IGridInterface gi) {
        if (gi != this.myGrid) {
            IGridInterface oldGrid = this.myGrid;
            this.myGrid = gi;
            this.gIdx = gi != null ? gi.getGridIndex() : 0;
            if (this.myGrid == null) {
                this.setPowerStatus(false);
            }
            if (this instanceof ICellContainer) {
                MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), oldGrid));
                MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), this.myGrid));
            }
            this.markForUpdate();
        }
    }

    public void setPowerStatus(boolean _hasPower) {
        if (this.hasPower != _hasPower) {
            this.hasPower = _hasPower;
            if (this.updatesOnPower) {
                this.markForUpdate();
            }
        }
    }
}

