/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.basetiles;

import appeng.api.me.tiles.IMEPowerStorage;
import appeng.common.AppEngConfiguration;
import appeng.me.basetiles.TileME;
import appeng.util.Platform;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.electricity.ElectricityPack;

public abstract class TilePoweredBase
extends TileME
implements IElectrical,
IPowerReceptor,
IEnergySink,
IMEPowerStorage {
    public float maxStoredPower;
    public float storedPower;
    private PowerHandler bcPowerhandler;
    final float UERatio = 0.2f;

    @Override
    public double getMEMaxPower() {
        return this.maxStoredPower;
    }

    @Override
    public double getMECurrentPower() {
        return this.storedPower;
    }

    @Override
    public void updateTileEntity() {
        if (Platform.isClient()) {
            return;
        }
        super.updateTileEntity();
        if (AppEngConfiguration.requirePower) {
            try {
                if (this.getPowerProvider() != null && this.storedPower < this.maxStoredPower) {
                    float want = (this.maxStoredPower - this.storedPower) / 5.0f;
                    if (want < 0.0f) {
                        want = 0.0f;
                    }
                    float used = this.getPowerProvider().useEnergy(1.0f, Math.min(want, this.getPowerProvider().getMaxEnergyStored()), true);
                    this.storedPower += used * 5.0f;
                    this.onUpdatePower();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected abstract int getMaxStoredPower();

    @Override
    public void func_70313_j() {
        super.func_70313_j();
    }

    @Override
    public void init() {
        super.init();
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return AppEngConfiguration.requirePower;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return AppEngConfiguration.requirePower;
    }

    public int demandsEnergy() {
        if (!AppEngConfiguration.requirePower) {
            return 0;
        }
        int diff = (int)Math.floor((this.maxStoredPower - this.storedPower) / 2.0f);
        return diff > 0 ? diff : 0;
    }

    public double demandedEnergyUnits() {
        if (!AppEngConfiguration.requirePower) {
            return 0.0;
        }
        int diff = (int)Math.floor((this.maxStoredPower - this.storedPower) / 2.0f);
        return diff > 0 ? (double)diff : 0.0;
    }

    @Override
    public double addMEPower(double amt) {
        if (!AppEngConfiguration.requirePower) {
            return amt;
        }
        float old = this.storedPower;
        this.storedPower = (float)((double)this.storedPower + amt);
        if (this.storedPower > this.maxStoredPower) {
            int diff = (int)Math.ceil(this.storedPower - this.maxStoredPower);
            this.storedPower = this.maxStoredPower;
            this.onUpdatePower();
            return diff;
        }
        this.onUpdatePower();
        return 0.0;
    }

    public void onUpdatePower() {
    }

    public int injectEnergy(Direction directionFrom, int amount) {
        if (!AppEngConfiguration.requirePower) {
            return amount;
        }
        this.storedPower += (float)(2 * amount);
        this.onUpdatePower();
        return 0;
    }

    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        if (!AppEngConfiguration.requirePower) {
            return amount;
        }
        this.storedPower = (float)((double)this.storedPower + 2.0 * amount);
        this.onUpdatePower();
        return 0.0;
    }

    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    public void doWork(PowerHandler workProvider) {
    }

    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.getPowerProvider().getPowerReceiver();
    }

    public PowerHandler getPowerProvider() {
        if (this.bcPowerhandler == null) {
            this.bcPowerhandler = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.MACHINE);
            if (this.bcPowerhandler != null) {
                this.bcPowerhandler.configure(1.0f, 320.0f, 800.0f, 640.0f);
            }
        }
        return this.bcPowerhandler;
    }

    @Override
    public void func_70307_a(NBTTagCompound tagCompound) {
        try {
            super.func_70307_a(tagCompound);
            this.storedPower = tagCompound.func_74762_e("storedPower");
            try {
                this.getPowerProvider().readFromNBT(tagCompound);
            }
            catch (Throwable _) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tagCompound) {
        try {
            super.func_70310_b(tagCompound);
            tagCompound.func_74768_a("storedPower", (int)this.storedPower);
            try {
                this.getPowerProvider().writeToNBT(tagCompound);
            }
            catch (Throwable _) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canConnect(ForgeDirection direction) {
        return AppEngConfiguration.requirePower;
    }

    public float receiveElectricity(ForgeDirection from, ElectricityPack receive, boolean doReceive) {
        if (receive == null) {
            return 0.0f;
        }
        if (doReceive) {
            float energy = receive.getWatts() / 0.2f;
            this.storedPower += energy;
            this.onUpdatePower();
        }
        return receive.getWatts();
    }

    public ElectricityPack provideElectricity(ForgeDirection from, ElectricityPack request, boolean doProvide) {
        return null;
    }

    public float getRequest(ForgeDirection direction) {
        if (!AppEngConfiguration.requirePower) {
            return 0.0f;
        }
        int diff = (int)Math.floor((this.maxStoredPower - this.storedPower) * 0.2f);
        return diff > 0 ? (float)diff : 0.0f;
    }

    public float getProvide(ForgeDirection direction) {
        return 0.0f;
    }

    public float getVoltage() {
        return 120.0f;
    }
}

