/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.block;

import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngSubBlock;
import appeng.common.base.AppEngTile;
import appeng.interfaces.IDismantleable;
import appeng.me.tile.TileDrive;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockDrive
extends AppEngSubBlock
implements IDismantleable {
    public BlockDrive(AppEngMultiBlock mb) {
        super(mb, true);
        this.unlocalizedName = "Drive";
    }

    @Override
    public boolean isOpaqueCube() {
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World w) {
        return new TileDrive();
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public Icon getBlockTextureFromSide(int side) {
        if (side == 0) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        if (side == 1) {
            return AppEngTextureRegistry.Blocks.GenericTop.get();
        }
        if (side == 2) {
            return AppEngTextureRegistry.Blocks.BlockDriveFace.get();
        }
        if (side == 3) {
            return AppEngTextureRegistry.Blocks.MEDriveStatus[0][0].get();
        }
        return AppEngTextureRegistry.Blocks.GenericSide.get();
    }

    @Override
    public boolean onBlockActivated(World w, int x, int y, int z, EntityPlayer p, int side) {
        TileEntity tileEntity = w.func_72796_p(x, y, z);
        ItemStack eq = p.func_71045_bC();
        if (Platform.isWrench(p, eq, x, y, z) && tileEntity instanceof TileDrive) {
            TileDrive c = (TileDrive)tileEntity;
            c.orientation = Platform.cycleOrientations(c.orientation, false);
            c.markForUpdate();
            return true;
        }
        if (tileEntity == null || p.func_70093_af()) {
            return false;
        }
        if (Platform.isClient()) {
            return true;
        }
        if (tileEntity != null && tileEntity instanceof AppEngTile) {
            ((AppEngTile)tileEntity).openGui(p);
        }
        return true;
    }
}

