/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.block;

import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.util.IGridInterface;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngSubBlock;
import appeng.gui.AppEngGuiHandler;
import appeng.interfaces.IDismantleable;
import appeng.me.tile.TileTerminal;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockTerminal
extends AppEngSubBlock
implements IDismantleable {
    AppEngGuiHandler GuiToOpen = AppEngGuiHandler.GUI_TERMINAL;

    public BlockTerminal(AppEngMultiBlock mb, boolean en) {
        super(mb, en);
        this.unlocalizedName = "Terminal";
    }

    @Override
    public boolean isOpaqueCube() {
        return true;
    }

    @Override
    public boolean onBlockActivated(World w, int x, int y, int z, EntityPlayer p, int side) {
        TileEntity tileEntity = w.func_72796_p(x, y, z);
        if (tileEntity == null || p.func_70093_af()) {
            return false;
        }
        if (Platform.isClient()) {
            return true;
        }
        IGridTileEntity gte = (IGridTileEntity)tileEntity;
        if (gte.getGrid() != null) {
            Platform.openGui(p, this.GuiToOpen, w, x, y, z);
            IGridInterface gi = gte.getGrid();
            if (gi != null) {
                gi.addViewingPlayer(p);
            }
        } else {
            Platform.LocalizedChatMsg("ChatMsg.NoController", p);
        }
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World w) {
        return new TileTerminal();
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public Icon getBlockTextureFromSide(int side) {
        if (side == 0) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        if (side == 1) {
            return AppEngTextureRegistry.Blocks.GenericTop.get();
        }
        if (side == 2) {
            return AppEngTextureRegistry.Blocks.METerminals[7].get();
        }
        return AppEngTextureRegistry.Blocks.GenericSide.get();
    }
}

