/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster;

import appeng.api.DimentionalCoord;
import appeng.api.TileRef;
import appeng.api.WorldCoord;
import appeng.api.events.LocateableEventAnnounce;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.ILocateable;
import appeng.common.AppEng;
import appeng.me.tile.TileQuantumBridge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;

public class QuantumCluster
implements ILocateable {
    public WorldCoord min;
    public WorldCoord max;
    boolean registered = false;
    private long thisSide;
    private long otherSide;
    public TileRef<TileQuantumBridge>[] Ring;
    private TileRef<TileQuantumBridge> center;

    public void setCenter(TileQuantumBridge c) {
        this.registered = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.center = new TileRef(c);
    }

    public QuantumCluster(WorldCoord _min, WorldCoord _max) {
        this.min = _min;
        this.max = _max;
        this.Ring = new TileRef[8];
    }

    public boolean canUseNode(long qe) {
        try {
            QuantumCluster qc = (QuantumCluster)AppEng.getApiInstance().getLocateableRegistry().findLocateableBySerial(qe);
            if (qc.center.getTile() instanceof TileQuantumBridge && qc.center.getTile().field_70331_k.func_72938_d((int)qc.center.getTile().field_70329_l, (int)qc.center.getTile().field_70327_n).field_76636_d) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    @ForgeSubscribe
    public void onUnload(WorldEvent.Unload e) {
        if (!e.world.field_72995_K && this.center.getCoord().getWorld() == e.world) {
            this.destroy();
        }
    }

    public void updateStatus(boolean updateGrid) {
        long qe;
        long oldOtherSide = this.otherSide;
        try {
            qe = this.center.getTile().getQEDest();
        }
        catch (AppEngTileMissingException e) {
            qe = 0L;
        }
        if (this.thisSide != qe && this.thisSide != -qe) {
            if (qe != 0L) {
                if (this.thisSide != 0L) {
                    MinecraftForge.EVENT_BUS.post((Event)new LocateableEventAnnounce(this, LocateableEventAnnounce.LocateableEvent.Unregister));
                }
                if (this.canUseNode(-qe)) {
                    this.otherSide = qe;
                    this.thisSide = -qe;
                } else if (this.canUseNode(qe)) {
                    this.thisSide = qe;
                    this.otherSide = -qe;
                }
                MinecraftForge.EVENT_BUS.post((Event)new LocateableEventAnnounce(this, LocateableEventAnnounce.LocateableEvent.Register));
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new LocateableEventAnnounce(this, LocateableEventAnnounce.LocateableEvent.Unregister));
                this.otherSide = 0L;
                this.thisSide = 0L;
            }
        }
        if (updateGrid) {
            Object oldMyOtherSide;
            this.updateGrid(this);
            Object myOtherSide = this.otherSide == 0L ? null : AppEng.getApiInstance().getLocateableRegistry().findLocateableBySerial(this.otherSide);
            Object object = oldMyOtherSide = oldOtherSide == 0L ? null : AppEng.getApiInstance().getLocateableRegistry().findLocateableBySerial(oldOtherSide);
            if (myOtherSide instanceof QuantumCluster) {
                this.updateGrid((QuantumCluster)myOtherSide);
            }
            if (oldMyOtherSide instanceof QuantumCluster) {
                this.updateGrid((QuantumCluster)oldMyOtherSide);
            }
        }
    }

    public void updateRender() {
        for (int x = 0; x < this.Ring.length; ++x) {
            try {
                this.Ring[x].getTile().markForUpdate();
                continue;
            }
            catch (AppEngTileMissingException appEngTileMissingException) {
                // empty catch block
            }
        }
    }

    private void updateGrid(QuantumCluster c) {
        if (c != null) {
            try {
                c.center.getTile().updateGrid();
            }
            catch (Throwable e) {
                // empty catch block
            }
            for (int x = 0; x < c.Ring.length; ++x) {
                try {
                    c.Ring[x].getTile().updateGrid();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void destroy() {
        if (this.registered) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.registered = false;
        }
        if (this.getLocatableSerial() != 0L) {
            Object myOtherSide;
            this.updateGrid(this);
            Object object = myOtherSide = this.otherSide == 0L ? null : AppEng.getApiInstance().getLocateableRegistry().findLocateableBySerial(this.otherSide);
            if (myOtherSide instanceof QuantumCluster) {
                this.updateGrid((QuantumCluster)myOtherSide);
            }
            MinecraftForge.EVENT_BUS.post((Event)new LocateableEventAnnounce(this, LocateableEventAnnounce.LocateableEvent.Unregister));
        }
        try {
            this.center.getTile().updateStatus(null, (byte)-1);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (TileRef<TileQuantumBridge> r : this.Ring) {
            try {
                r.getTile().updateStatus(null, (byte)-1);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.center = null;
        this.Ring = new TileRef[8];
    }

    public boolean isCorner(TileQuantumBridge tileQuantumBridge) {
        try {
            return this.Ring[0].getTile() == tileQuantumBridge || this.Ring[2].getTile() == tileQuantumBridge || this.Ring[4].getTile() == tileQuantumBridge || this.Ring[6].getTile() == tileQuantumBridge;
        }
        catch (AppEngTileMissingException e) {
            return true;
        }
    }

    public DimentionalCoord[] getOtherSide() {
        Object myOtherSide = AppEng.getApiInstance().getLocateableRegistry().findLocateableBySerial(this.otherSide);
        if (myOtherSide != null) {
            try {
                QuantumCluster qc = (QuantumCluster)myOtherSide;
                DimentionalCoord[] out = new DimentionalCoord[]{qc.Ring[1].getCoord(), qc.Ring[3].getCoord(), qc.Ring[4].getCoord(), qc.Ring[6].getCoord()};
                return out;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new DimentionalCoord[0];
    }

    @Override
    public long getLocatableSerial() {
        return this.thisSide;
    }

    public boolean hasPower() {
        try {
            return this.center.getTile().bridgePowered;
        }
        catch (AppEngTileMissingException appEngTileMissingException) {
            return false;
        }
    }

    public TileRef<TileQuantumBridge> getCenter() {
        return this.center;
    }

    public boolean hasQES() {
        return this.getLocatableSerial() != 0L;
    }
}

