/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.crafting;

import appeng.api.TileRef;
import appeng.api.WorldCoord;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.util.IAssemblerCluster;
import appeng.me.basetiles.TileME;
import appeng.me.tile.TileAssembler;
import appeng.me.tile.TileAssemblerMB;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class AssemblerCluster
implements IAssemblerCluster {
    public WorldCoord min;
    public WorldCoord max;
    public int lastPage;
    public int accelerators;
    public int used_accelerators;
    public IInventory inv;
    int[] cpuResetQueue = new int[4];
    public List<TileRef<TileAssemblerMB>> MB;
    public List<TileRef<TileAssembler>> Assemblers;
    public long inst;

    public AssemblerCluster(WorldCoord _min, WorldCoord _max) {
        this.min = _min;
        this.max = _max;
    }

    @Override
    public void cycleCpus() {
        this.used_accelerators -= this.cpuResetQueue[0];
        this.cpuResetQueue[0] = this.cpuResetQueue[1];
        this.cpuResetQueue[1] = this.cpuResetQueue[2];
        this.cpuResetQueue[2] = this.cpuResetQueue[3];
        this.cpuResetQueue[3] = 0;
    }

    @Override
    public TileAssembler getAssembler(int i) {
        try {
            return this.Assemblers.get(i).getTile();
        }
        catch (AppEngTileMissingException appEngTileMissingException) {
            return null;
        }
    }

    @Override
    public void addCraft() {
        ++this.used_accelerators;
        this.cpuResetQueue[3] = this.cpuResetQueue[3] + 1;
    }

    @Override
    public boolean canCraft() {
        return this.accelerators > this.used_accelerators;
    }

    public void destroy() {
        if (!this.MB.isEmpty()) {
            try {
                TileAssemblerMB mb = this.MB.get(0).getTile();
                mb.sendUpdate(false, null);
            }
            catch (AppEngTileMissingException e) {
                // empty catch block
            }
        }
        for (TileRef<TileAssembler> tileRef : this.Assemblers) {
            try {
                tileRef.getTile().updateStatus(null);
            }
            catch (Exception e) {}
        }
        for (TileRef<TileME> tileRef : this.MB) {
            try {
                ((TileAssemblerMB)tileRef.getTile()).updateStatus(null);
                MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent((IGridTileEntity)((Object)tileRef.getTile()), ((TileAssemblerMB)tileRef.getTile()).getWorld(), ((TileAssemblerMB)tileRef.getTile()).getLocation()));
            }
            catch (Exception exception) {}
        }
    }

    public int howManyCpus() {
        return this.cpuResetQueue[0];
    }

    @Override
    public int getLastOffset() {
        return this.lastPage <= 0 ? 0 : (this.lastPage >= this.Assemblers.size() ? 0 : this.lastPage);
    }

    @Override
    public void setLastOffset(int x) {
        this.lastPage = x;
    }
}

