/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.crafting;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.me.tiles.IPushable;
import appeng.api.me.util.IAssemblerPattern;
import appeng.api.me.util.IMEInventory;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.me.METhrottle;
import appeng.me.crafting.CraftRequest;
import appeng.me.crafting.CraftingJobPacket;
import appeng.me.crafting.MultiPushTask;
import appeng.me.tile.TileController;
import appeng.util.AEItemStack;
import appeng.util.Platform;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.item.ItemStack;

public class MultiPushCraftRequest
extends CraftRequest {
    List<IPushable> ti;
    boolean canCraft;
    private METhrottle t;
    IPushable currentTarget;
    Queue<MultiPushTask> completeRequests;
    Queue<MultiPushTask> pushRequests = new LinkedList<MultiPushTask>();

    public MultiPushCraftRequest(String NetworkID, ItemStack fullJob, MultiPushTask[] is, List<IPushable> te, boolean allowCrafting) {
        super(NetworkID, fullJob);
        this.completeRequests = new LinkedList<MultiPushTask>();
        this.ti = te;
        this.canCraft = allowCrafting;
        this.t = new METhrottle(5, AppEngConfiguration.automationMinTickRate, AppEngConfiguration.automationMinTickRate + 300);
        this.t.wakeUp();
        for (int x = 0; x < is.length; ++x) {
            this.pushRequests.add(is[x]);
            AppEng.craftingLog(NetworkID, is[x].fulljob, " will push " + is[x].fulljob.getStackSize());
        }
    }

    @Override
    public String requestType() {
        return "MultiPushCraftRequest";
    }

    @Override
    public void populateJobPacket(CraftingJobPacket cjp) {
        for (MultiPushTask Mt : this.pushRequests) {
            for (CraftRequest cr : Mt.Prereqs) {
                cr.populateJobPacket(cjp);
            }
        }
        for (MultiPushTask Mt : this.completeRequests) {
            for (CraftRequest cr : Mt.Prereqs) {
                cr.populateJobPacket(cjp);
            }
        }
    }

    @Override
    protected void completePreReq(CraftRequest craftRequest) {
        super.completePreReq(craftRequest);
        for (MultiPushTask Mt : this.pushRequests) {
            Mt.Prereqs.remove(craftRequest);
        }
        for (MultiPushTask Mt : this.completeRequests) {
            Mt.Prereqs.remove(craftRequest);
        }
        this.t.wakeUp();
    }

    @Override
    public boolean Craft(TileController tc, IAssemblerPattern pattern, IMEInventory invItemPool, IItemList all, Deque<CraftRequest> craftingQueue, Deque<CraftRequest> waitingQueue) {
        if (this.t.process()) {
            int max_pushes = (int)(2.0f * this.t.getMultipler());
            if (this.pushRequests.isEmpty()) {
                while (!this.completeRequests.isEmpty()) {
                    MultiPushTask mpt = this.completeRequests.poll();
                    mpt.currentjob = mpt.resetamt.copy();
                    if (mpt.currentjob.getStackSize() > mpt.fulljob.getStackSize()) {
                        mpt.currentjob.setStackSize(mpt.fulljob.getStackSize());
                    }
                    if (mpt.currentjob.getStackSize() <= 0L) continue;
                    this.pushRequests.add(mpt);
                }
                if (this.pushRequests.isEmpty()) {
                    return false;
                }
                this.currentTarget = null;
            }
            MultiPushTask task = this.pushRequests.poll();
            IAEItemStack currntJob = task.currentjob;
            if (task.Prereqs.size() > 0) {
                this.pushRequests.add(task);
                return false;
            }
            while (currntJob.getStackSize() > 0L) {
                if (max_pushes-- < 0) {
                    if (task.currentjob.getStackSize() > 0L) {
                        this.pushRequests.add(task);
                    } else {
                        this.completeRequests.add(task);
                    }
                    return true;
                }
                IAEItemStack b = currntJob.copy();
                if (this.currentTarget == null) {
                    for (IPushable p : this.ti) {
                        if (p.isBusy()) continue;
                        this.currentTarget = p;
                        this.ti.remove(p);
                        this.ti.add(p);
                        break;
                    }
                }
                if (this.currentTarget == null) {
                    if (task.currentjob.getStackSize() > 0L) {
                        this.pushRequests.add(task);
                    } else {
                        this.completeRequests.add(task);
                    }
                    return false;
                }
                if (this.currentTarget.canPushItem(Platform.getSharedItemStack(b))) {
                    IAEItemStack is = invItemPool.extractItems(b);
                    if (is == null && this.canRequestPrereqs(task)) {
                        ItemStack ps;
                        if (this.canCraft) {
                            ps = Platform.getSharedItemStack(currntJob);
                            ps.field_77994_a = (int)currntJob.getStackSize();
                            this.requestedPreReqs(task.addPreReq(tc.craftingRequest(ps)));
                        } else {
                            ps = Platform.getSharedItemStack(currntJob);
                            ps.field_77994_a = (int)currntJob.getStackSize();
                            this.requestedPreReqs(task.addPreReq(tc.waitingRequest(ps)));
                        }
                        if (task.currentjob.getStackSize() > 0L) {
                            this.pushRequests.add(task);
                        } else {
                            this.completeRequests.add(task);
                        }
                        return true;
                    }
                    int pushed = 0;
                    if (is != null && tc.useMEEnergy(2.0f, "pushItem")) {
                        AppEng.craftingLog(this.NetworkID, currntJob, " pushing.");
                        int prePush = (int)is.getStackSize();
                        is = AEItemStack.create(this.currentTarget.pushItem(Platform.getSharedItemStack(is)));
                        pushed = is == null ? prePush : prePush - (int)is.getStackSize();
                    }
                    if (pushed > 0) {
                        this.t.hasAccomplishedWork();
                    }
                    currntJob.decStackSize(pushed);
                    task.fulljob.decStackSize(pushed);
                    for (int x = 0; x < pushed; ++x) {
                        this.markCrafted();
                    }
                    if (is != null) {
                        invItemPool.addItems(is);
                        this.pushRequests.add(task);
                        return false;
                    }
                    if (task.currentjob.getStackSize() > 0L) {
                        this.pushRequests.add(task);
                    } else {
                        this.completeRequests.add(task);
                    }
                    if (this.pushRequests.isEmpty()) {
                        return true;
                    }
                    task = this.pushRequests.poll();
                    currntJob = task.currentjob;
                    continue;
                }
                if (task.currentjob.getStackSize() > 0L) {
                    this.pushRequests.add(task);
                } else {
                    this.completeRequests.add(task);
                }
                return false;
            }
            if (task.currentjob.getStackSize() > 0L) {
                this.pushRequests.add(task);
            } else {
                this.completeRequests.add(task);
            }
        }
        return false;
    }

    private boolean canRequestPrereqs(MultiPushTask task) {
        return task.Prereqs.size() == 0;
    }

    @Override
    public boolean requirePattern() {
        return false;
    }
}

