/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.Items;
import appeng.api.TileRef;
import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.events.GridPatternUpdateEvent;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.me.tiles.IAssemblerMB;
import appeng.api.me.tiles.IFulllyOptionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.util.IAssemblerCluster;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngSubBlock;
import appeng.me.basetiles.TileMEWInventory;
import appeng.me.block.BlockAssemblerFieldWall;
import appeng.me.block.BlockCraftingAccelerator;
import appeng.me.block.BlockHeatVent;
import appeng.me.crafting.AssemblerCluster;
import appeng.me.tile.TileAssemblerMB;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorIInventory;
import buildcraft.api.inventory.ISpecialInventory;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileAssembler
extends TileMEWInventory
implements ISpecialInventory,
IFulllyOptionalMETile,
IGridMachine,
IAssemblerMB {
    AssemblerCluster ac = null;
    long instanceCalc = Long.MIN_VALUE;

    @Override
    protected void terminate() {
        super.terminate();
        this.ac = null;
    }

    @Override
    public void func_70299_a(int var1, ItemStack var2) {
        super.func_70299_a(var1, var2);
        if (Platform.isServer() && this.getGrid() != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GridPatternUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
        }
    }

    @Override
    public ItemStack func_70298_a(int var1, int var2) {
        ItemStack is = super.func_70298_a(var1, var2);
        if (Platform.isServer() && this.getGrid() != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GridPatternUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
        }
        return is;
    }

    @Override
    public IAssemblerCluster getCluster() {
        return this.ac;
    }

    @Override
    public boolean isComplete() {
        return this.ac != null;
    }

    public TileAssembler() {
        super(54);
        this.updatesOnPower = false;
    }

    public static void completeRegion(long nInst, IBlockAccess w, WorldCoord min, WorldCoord max, AssemblerCluster ac) {
        TileAssemblerMB lastMB = null;
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    AssemblerCluster acc;
                    TileEntity te = w.func_72796_p(x, y, z);
                    if (te instanceof TileAssembler) {
                        if (ac == null && (acc = ((TileAssembler)te).ac) != null) {
                            acc.destroy();
                        }
                        ((TileAssembler)te).instanceCalc = nInst;
                        ((TileAssembler)te).updateStatus(ac);
                        continue;
                    }
                    if (!(te instanceof TileAssemblerMB)) continue;
                    if (ac == null && (acc = ((TileAssemblerMB)te).ac) != null) {
                        acc.destroy();
                    }
                    lastMB = (TileAssemblerMB)te;
                    lastMB.instanceCalc = nInst;
                    ((TileAssemblerMB)te).updateStatus(ac);
                }
            }
        }
        if (ac != null && lastMB != null) {
            lastMB.sendUpdate(true, null);
            MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(lastMB, lastMB.field_70331_k, lastMB.getLocation()));
        }
    }

    @Override
    public boolean requiresTickingUpdates() {
        return false;
    }

    public static AssemblerCluster verifyOwnedRegion(IBlockAccess w, WorldCoord min, WorldCoord max) {
        AssemblerCluster ac = new AssemblerCluster(min, max);
        ac.Assemblers = new ArrayList<TileRef<TileAssembler>>();
        ac.MB = new ArrayList<TileRef<TileAssemblerMB>>();
        ac.accelerators = 1;
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    TileEntity te = w.func_72796_p(x, y, z);
                    if (x != min.x && x != max.x && y != min.y && y != max.y && z != min.z && z != max.z && te instanceof TileAssembler) {
                        ac.Assemblers.add(new TileRef((TileAssembler)te));
                        continue;
                    }
                    if (te instanceof TileAssemblerMB) {
                        AppEngMultiBlock mb = (AppEngMultiBlock)te.func_70311_o();
                        if (mb == null) {
                            return null;
                        }
                        AppEngSubBlock sb = mb.getSubBlock(te.func_70322_n());
                        if (sb == null) {
                            return null;
                        }
                        ac.MB.add(new TileRef((TileAssemblerMB)te));
                        if (sb instanceof BlockCraftingAccelerator) {
                            ++ac.accelerators;
                        } else if (x != min.x && x != max.x && y != min.y && y != max.y && z != min.z && z != max.z) {
                            return null;
                        }
                        if (!(x == min.x && z == min.z || x == min.x && z == max.z || x == max.x && z == min.z || x == max.x && z == max.z || x == min.x && y == min.y || x == min.x && y == max.y || x == max.x && y == min.y || x == max.x && y == max.y || z == min.z && y == min.y || z == min.z && y == max.y || z == max.z && y == min.y || z == max.z && y == max.y || y == min.y && x == min.x || y == min.y && x == max.x || y == max.y && z == min.z || y == max.y && z == max.z ? !(sb instanceof BlockAssemblerFieldWall) : (x == max.x || x == min.x || y == min.y || y == max.y || z == min.z || z == max.z) && !(sb instanceof BlockHeatVent))) continue;
                        return null;
                    }
                    return null;
                }
            }
        }
        if (ac.Assemblers.size() > 0) {
            return ac;
        }
        return null;
    }

    public static boolean verifyUnownedRegionInner(IBlockAccess w, int minx, int miny, int minz, int maxx, int maxy, int maxz, ForgeDirection side) {
        switch (side) {
            case WEST: {
                maxx = --minx;
                break;
            }
            case EAST: {
                minx = ++maxx;
                break;
            }
            case DOWN: {
                maxy = --miny;
                break;
            }
            case NORTH: {
                minz = ++maxz;
                break;
            }
            case SOUTH: {
                maxz = --minz;
                break;
            }
            case UP: {
                miny = ++maxy;
                break;
            }
            case UNKNOWN: {
                return false;
            }
        }
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                for (int z = minz; z <= maxz; ++z) {
                    TileEntity te = w.func_72796_p(x, y, z);
                    if (!(te instanceof TileAssemblerMB)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean verifyUnownedRegion(IBlockAccess w, WorldCoord min, WorldCoord max) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!TileAssembler.verifyUnownedRegionInner(w, min.x, min.y, min.z, max.x, max.y, max.z, side)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void calculateMultiblock(long instanceCalc) {
        TileAssembler.calculateMultiblockR(this, instanceCalc);
    }

    public static boolean isAnAssembler(IBlockAccess w, int x, int y, int z, long inst) {
        TileEntity TE = w.func_72796_p(x, y, z);
        if (TE instanceof IAssemblerMB) {
            ((IAssemblerMB)TE).markViewed(inst);
            return true;
        }
        return false;
    }

    @Override
    public long markViewed(long inst) {
        long old = this.instanceCalc;
        this.instanceCalc = inst;
        return old;
    }

    public static void calculateMultiblockR(IAssemblerMB start, long instanceCalc) {
        if (Platform.isClient()) {
            return;
        }
        long old = start.markViewed(instanceCalc);
        if (old == instanceCalc) {
            return;
        }
        try {
            AssemblerCluster ac;
            WorldCoord min = start.getLocation();
            WorldCoord max = start.getLocation();
            World w = ((TileEntity)start).field_70331_k;
            while (TileAssembler.isAnAssembler((IBlockAccess)w, min.x - 1, min.y, min.z, instanceCalc)) {
                --min.x;
            }
            while (TileAssembler.isAnAssembler((IBlockAccess)w, min.x, min.y - 1, min.z, instanceCalc)) {
                --min.y;
            }
            while (TileAssembler.isAnAssembler((IBlockAccess)w, min.x, min.y, min.z - 1, instanceCalc)) {
                --min.z;
            }
            while (TileAssembler.isAnAssembler((IBlockAccess)w, max.x + 1, max.y, max.z, instanceCalc)) {
                ++max.x;
            }
            while (TileAssembler.isAnAssembler((IBlockAccess)w, max.x, max.y + 1, max.z, instanceCalc)) {
                ++max.y;
            }
            while (TileAssembler.isAnAssembler((IBlockAccess)w, max.x, max.y, max.z + 1, instanceCalc)) {
                ++max.z;
            }
            int x = max.x - min.x;
            int y = max.y - min.y;
            int z = max.z - min.z;
            if (max.x - min.x >= 2 && max.y - min.y >= 2 && max.z - min.z >= 2 && (ac = TileAssembler.verifyOwnedRegion((IBlockAccess)w, min, max)) != null && TileAssembler.verifyUnownedRegion((IBlockAccess)w, min, max)) {
                TileAssembler.completeRegion(instanceCalc, (IBlockAccess)w, min, max, ac);
                return;
            }
            WorldCoord pos = start.getLocation();
            for (ForgeDirection d : ForgeDirection.values()) {
                AssemblerCluster ac2;
                TileEntity TE = w.func_72796_p(pos.x + d.offsetX, pos.y + d.offsetY, pos.z + d.offsetZ);
                if (!(TE instanceof IAssemblerMB) || (ac2 = (AssemblerCluster)((IAssemblerMB)TE).getCluster()) == null) continue;
                ac2.destroy();
            }
        }
        catch (Throwable err) {
            // empty catch block
        }
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        if (ForgeDirection.DOWN == side) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        if (ForgeDirection.UP == side) {
            return AppEngTextureRegistry.Blocks.GenericTop.get();
        }
        return AppEngTextureRegistry.Blocks.BlockAssembler.get();
    }

    public String func_70303_b() {
        return "ME Pattern Provider";
    }

    @Override
    public float getPowerDrainPerTick() {
        return this.ac != null ? 1.0f : 0.0f;
    }

    @Override
    public void updateStatus(IAssemblerCluster _ac) {
        boolean wasComplete = this.ac != null;
        this.ac = (AssemblerCluster)_ac;
        if (wasComplete != (this.ac != null)) {
            this.markForUpdate();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.ac != null;
    }

    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (Platform.isSameItemType(stack, Items.itemEncodedAsemblerPattern)) {
            AdaptorIInventory ia = new AdaptorIInventory(this);
            ItemStack used = null;
            int originalStackSize = stack.field_77994_a;
            used = doAdd ? ((InventoryAdaptor)ia).addItems(stack) : ((InventoryAdaptor)ia).simulateAdd(stack);
            if (used == null) {
                return originalStackSize;
            }
            return originalStackSize - used.field_77994_a;
        }
        return 0;
    }

    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ItemStack[] output = new ItemStack[1];
        AdaptorIInventory ia = new AdaptorIInventory(this);
        output[0] = doRemove ? ((InventoryAdaptor)ia).removeItems(maxItemCount, null, null) : ((InventoryAdaptor)ia).simulateRemove(maxItemCount, null, null);
        if (output[0] == null) {
            return new ItemStack[0];
        }
        return output;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (Util.isAssemblerPattern(itemstack).booleanValue()) {
            return Util.getAssemblerPattern(itemstack).isEncoded();
        }
        return false;
    }

    @Override
    public boolean isSeperated() {
        return !this.isEnabled();
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.isCommonUseableByPlayer(entityplayer);
    }
}

