/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.Blocks;
import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.IWirelessTermHandler;
import appeng.api.Materials;
import appeng.api.TileRef;
import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.config.InterfaceCraftingMode;
import appeng.api.config.ViewItems;
import appeng.api.events.GridErrorEvent;
import appeng.api.events.GridPatternUpdateEvent;
import appeng.api.events.GridStorageUpdateEvent;
import appeng.api.events.LocateableEventAnnounce;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.ICellContainer;
import appeng.api.me.tiles.IExtendedCellProvider;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.ILocateable;
import appeng.api.me.tiles.IOrientableTile;
import appeng.api.me.tiles.IPushable;
import appeng.api.me.tiles.IStorageAware;
import appeng.api.me.util.IAssemblerCluster;
import appeng.api.me.util.IAssemblerPattern;
import appeng.api.me.util.ICraftRequest;
import appeng.api.me.util.IGridCache;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventory;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.grid.GridEnumeration;
import appeng.common.network.IAppEngNetworkTile;
import appeng.common.network.packets.PacketGridAnimate;
import appeng.common.registries.WirelessRangeResult;
import appeng.gui.AppEngGuiHandler;
import appeng.interfaces.INetworkNotifiable;
import appeng.interfaces.IPowerSharing;
import appeng.me.AssemblerPatternInventory;
import appeng.me.GridReference;
import appeng.me.MEInventoryHandler;
import appeng.me.MEInventoryNetwork;
import appeng.me.MEInventoryNull;
import appeng.me.METhrottle;
import appeng.me.basetiles.TileMEWInventory;
import appeng.me.basetiles.TilePoweredBase;
import appeng.me.container.ContainerCraftingMonitor;
import appeng.me.container.ContainerTerminal;
import appeng.me.crafting.AssemblerCluster;
import appeng.me.crafting.CraftRequest;
import appeng.me.crafting.Crafting;
import appeng.me.crafting.CraftingInventory;
import appeng.me.crafting.CraftingJobPacket;
import appeng.me.crafting.CraftingManager;
import appeng.me.crafting.DelayedCraftRequest;
import appeng.me.crafting.ExternalCraftRequest;
import appeng.me.crafting.ICraftingManagerOwner;
import appeng.me.crafting.MissingMaterialsCraftRequest;
import appeng.me.crafting.MultiPushCraftRequest;
import appeng.me.crafting.PushCraftRequest;
import appeng.me.tile.TileAssembler;
import appeng.me.tile.TileCable;
import appeng.me.tile.TileColorlessCable;
import appeng.me.tile.TileDarkCable;
import appeng.me.tile.TileInterfaceBase;
import appeng.me.tile.TileWireless;
import appeng.proxy.helpers.ILPInventory;
import appeng.util.AEItemStack;
import appeng.util.ItemList;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;

public class TileController
extends TilePoweredBase
implements IOrientableTile,
ILocateable,
ICraftingManagerOwner,
IExtendedCellProvider,
IGridTileEntity,
IGridInterface,
IAppEngNetworkTile,
INetworkNotifiable {
    public String EncryptionKey;
    public ForgeDirection orientation;
    public int gridIndex;
    private boolean sendUpdate;
    private boolean sendCraftingUpdate;
    private int TicksBetweenFlashes = 0;
    private boolean hasFlashed;
    private boolean enabled;
    int cables = 0;
    List<ItemStack> currentStatus;
    public float powerDrained = 0.0f;
    public float powerDrainedPersonal = 0.0f;
    boolean triggerUpdate;
    int oldFace;
    public float[] personalPowerUsageLog;
    public float[] realPowerUsageLog;
    public float realPowerUsageActiveTick;
    public float personalPowerUsageActiveTick;
    private METhrottle craftingThrottle;
    private METhrottle waitingThrottle;
    public ItemStack lastCraftingRequest;
    private List<TileRef<IGridTileEntity>> AllEntities;
    private List<TileRef<IGridMachine>> AllMachines;
    private IGridCache[] Caches;
    private List<TileRef<ICellContainer>> CellContainers;
    private List<TileRef<TileAssembler>> Assemblers;
    private List<TileRef<TileInterfaceBase>> Interfaces;
    private List<TileRef<TileWireless>> WirelessNodes;
    private List<TileRef<IStorageAware>> StorageAware;
    private List<TileRef<Object>> PowerSources;
    private List<EntityPlayer> contentsViewingPlayers;
    private List<EntityPlayer> craftingViewingPlayers;
    private List<IAEItemStack> invChanges;
    private Deque<CraftRequest> CraftingQueue;
    private Deque<CraftRequest> WaitingQueue;
    private CraftingManager CManager;
    ItemList storedList;
    ItemList fullList;
    ItemList craftList;
    HashSet<IAssemblerPattern> cachedPatternSet = new HashSet();
    boolean isCalculatingCell = false;
    IMEInventoryHandler cachedCellArray = null;
    static IGridInterface topLevel = null;
    int TicksSincePower = 999;
    int TicksSinceUpdate = 0;
    int ticksBetweenUpdates = 0;
    float cachedPowerConsumption = 0.0f;
    boolean isUseingRemotePower = false;
    boolean updateStorageAware = true;
    private List<IAEItemStack> NewItemQueue;
    private static int newGridIndex = 1;
    boolean powerBar = false;
    IGridInterface myRef = null;

    @Override
    public float getPowerUsageAvg() {
        float avg = 0.0f;
        for (int x = 0; x < 20; ++x) {
            avg += this.realPowerUsageLog[x];
        }
        return avg / 20.0f;
    }

    public float getPersonalPowerUsageAvg() {
        float avg = 0.0f;
        for (int x = 0; x < 20; ++x) {
            avg += this.personalPowerUsageLog[x];
        }
        return avg / 20.0f;
    }

    private void pushPowerUsage() {
        for (int x = 1; x < 20; ++x) {
            this.personalPowerUsageLog[x - 1] = this.personalPowerUsageLog[x];
            this.realPowerUsageLog[x - 1] = this.realPowerUsageLog[x];
        }
        this.personalPowerUsageLog[19] = this.personalPowerUsageActiveTick;
        this.personalPowerUsageActiveTick = 0.0f;
        this.realPowerUsageLog[19] = this.realPowerUsageActiveTick;
        this.realPowerUsageActiveTick = 0.0f;
        this.maxStoredPower = this.getPowerUsageAvg() * 60.0f + 4000.0f;
    }

    @Override
    public void OnCraftingChange(CraftingManager cm) {
        Iterator<EntityPlayer> ip = this.craftingViewingPlayers.iterator();
        while (ip.hasNext()) {
            EntityPlayer p = ip.next();
            if (p.field_71070_bA == null) continue;
            if (p.field_71070_bA instanceof ContainerCraftingMonitor) {
                ContainerCraftingMonitor ct = (ContainerCraftingMonitor)p.field_71070_bA;
                ct.triggerUpdate();
                continue;
            }
            ip.remove();
        }
    }

    @Override
    public void jobDone(CraftingManager cm) {
        if (cm == this.CManager) {
            this.OnCraftingChange(cm);
        }
    }

    @ForgeSubscribe
    public void updatePatterns(GridPatternUpdateEvent pu) {
        if (pu.grid.getController() == this) {
            this.cachedPatternSet = null;
        }
    }

    @ForgeSubscribe
    public void updateStorage(GridStorageUpdateEvent pu) {
        if (pu.grid != null && pu.grid.getController() == this) {
            this.cachedCellArray = null;
        }
    }

    @ForgeSubscribe
    public void addToGrid(GridPatternUpdateEvent pu) {
        if (pu.grid != null && pu.grid.getController() == this) {
            this.cachedPatternSet = null;
        }
    }

    @Override
    public void init() {
        super.init();
        if (Platform.isClient()) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.post((Event)new LocateableEventAnnounce(this, LocateableEventAnnounce.LocateableEvent.Register));
    }

    @Override
    protected void terminate() {
        super.terminate();
        if (Platform.isClient()) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new LocateableEventAnnounce(this, LocateableEventAnnounce.LocateableEvent.Unregister));
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public void cancelJob(ItemStack job, ItemStack subjob) {
        List<CraftRequest> jlist = this.CManager.getPrereqs();
        ArrayList<CraftRequest> tl = new ArrayList<CraftRequest>();
        tl.addAll(0, jlist);
        for (CraftRequest cr : tl) {
            if (!Platform.isSameItem(job, cr.getRequest())) continue;
            cr.cancel(subjob, this);
            this.OnCraftingChange(null);
        }
    }

    public List<ItemStack> getJobList() {
        ArrayList<ItemStack> jobs = new ArrayList<ItemStack>();
        List<CraftRequest> jlist = this.CManager.getPrereqs();
        for (CraftRequest cr : jlist) {
            if (cr.getAmount() <= 0) continue;
            Platform.sumItemToList(jobs, cr.getRequest());
        }
        Collections.sort(jobs, ItemSorters.Accending_SortByID_Vanilla);
        return jobs;
    }

    public CraftingJobPacket getJobStatus(ItemStack is) {
        List<CraftRequest> jobs = this.CManager.getPrereqs();
        CraftingJobPacket cjp = new CraftingJobPacket();
        if (is != null) {
            cjp.Target = is;
            cjp.Target.field_77994_a = 0;
            for (CraftRequest cr : jobs) {
                if (!Platform.isSameItemType(is, cr.getRequest())) continue;
                cjp.Target.field_77994_a += cr.getAmount();
                cr.populateJobPacket(cjp);
            }
        }
        return cjp;
    }

    @Override
    public synchronized void resetWaitingQueue() {
        while (this.WaitingQueue.size() > 0) {
            CraftRequest cr = this.WaitingQueue.pop();
            while (cr.getAmount() > 0) {
                cr.markCrafted();
            }
        }
        this.OnCraftingChange(null);
    }

    public void printCraftingStatus() {
        AppEng.log(this.getName() + " is waiting on " + this.WaitingQueue.size() + " jobs");
        for (CraftRequest cr : this.WaitingQueue) {
            cr.printJobDetails();
        }
        AppEng.log(this.getName() + " is working on " + this.CraftingQueue.size() + " jobs");
        for (CraftRequest cr : this.CraftingQueue) {
            cr.printJobDetails();
        }
    }

    public boolean[] noScreen() {
        byte rotation = this.getAERotationFromDirection(this.orientation);
        this.powerBar = false;
        return null;
    }

    public boolean[] screenOnly() {
        byte rotation = this.getAERotationFromDirection(this.orientation);
        this.powerBar = true;
        return new boolean[]{rotation != 5, rotation != 4, rotation != 2, rotation != 0, rotation != 1, rotation != 3};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (AppEngConfiguration.requirePower) {
            AppEngMultiBlock b = (AppEngMultiBlock)block;
            b.dontrender = this.noScreen();
            renderer.func_78570_q(block, x, y, z);
            b.dontrender = this.screenOnly();
            int bn = 15;
            Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
            Tessellator.field_78398_a.func_78380_c(bn << 20 | bn << 4);
            this.renderFace(block, renderer, this.orientation);
            b.dontrender = null;
        } else {
            renderer.func_78570_q(block, x, y, z);
        }
        return true;
    }

    public String getMsg() {
        String Message = "";
        if (this.enabled && this.currentStatus != null && this.currentStatus.size() > 0) {
            String Extra;
            String Units = "{Units / t}";
            float conversionRate = 1.0f;
            DecimalFormat df = new DecimalFormat("0");
            switch (AppEngConfiguration.defaultUnits) {
                case EU: {
                    conversionRate = 0.5f;
                    Units = "eu/t";
                    df = new DecimalFormat("0.#");
                    break;
                }
                case MJ: {
                    conversionRate = 0.2f;
                    Units = "mj/t";
                    df = new DecimalFormat("0.#");
                    break;
                }
                case UE: {
                    conversionRate = 0.2f;
                    Units = "kj/t";
                    df = new DecimalFormat("0.#");
                }
            }
            float real = this.powerDrained * conversionRate;
            float personal = this.powerDrainedPersonal * conversionRate;
            String string = Extra = real > personal ? " + " + df.format(real - personal) : "";
            Message = this.hasPower ? " - {Online}\n{Energy Used}: " + df.format(personal) + Extra + " " + Units : " - {Offline}\n{Power is low} ( " + df.format(personal) + Extra + " " + Units + " )";
        } else {
            Message = " - {Offline}\n{Controller Conflict}";
        }
        return Message;
    }

    @Override
    public ICraftRequest pushRequest(ItemStack willAdd, IPushable out, boolean allowCrafting) {
        this.craftingThrottle.wakeUp();
        return this.pushRequest(this.getName(), willAdd, out, allowCrafting, false);
    }

    public ICraftRequest pushRequest(String name, ItemStack willAdd, IPushable out, boolean allowCrafting) {
        this.craftingThrottle.wakeUp();
        return this.pushRequest(this.getName() + (name == null ? "" : "-" + name), willAdd, out, allowCrafting, false);
    }

    public ICraftRequest pushRequest(String name, ItemStack willAdd, IPushable out, boolean allowCrafting, boolean showInManager) {
        if (willAdd == null) {
            return null;
        }
        PushCraftRequest ct = new PushCraftRequest(this.getName() + (name == null ? "" : "-" + name), willAdd, out, allowCrafting);
        this.craftingThrottle.wakeUp();
        this.CraftingQueue.add(ct);
        if (showInManager) {
            this.CManager.requestedPreReqs(ct);
        }
        return ct;
    }

    @Override
    public ICraftRequest waitingRequest(ItemStack what) {
        if (what == null) {
            return null;
        }
        this.craftingThrottle.hasAccomplishedWork();
        DelayedCraftRequest ct = new DelayedCraftRequest(this.getName(), what);
        this.WaitingQueue.add(ct);
        this.OnCraftingChange(null);
        return ct;
    }

    boolean canLogisticsMake(ItemStack what) {
        if (what == null) {
            return false;
        }
        try {
            for (TileRef<TileInterfaceBase> ar : this.Interfaces) {
                TileInterfaceBase a = ar.getTile();
                for (IMEInventory i : a.getLogisticsInv()) {
                    if (!i.containsItemType(AEItemStack.create(what))) continue;
                    return true;
                }
            }
        }
        catch (AppEngTileMissingException appEngTileMissingException) {
            // empty catch block
        }
        return false;
    }

    boolean logisticsRequest(ItemStack what) {
        if (what == null) {
            return false;
        }
        try {
            for (TileRef<TileInterfaceBase> ar : this.Interfaces) {
                TileInterfaceBase a = ar.getTile();
                for (IMEInventory i : a.getLogisticsInv()) {
                    ILPInventory lpinv = (ILPInventory)i;
                    List<ItemStack> result = lpinv.requestCrafting(what);
                    if (result != null && result.size() != 0) continue;
                    return true;
                }
            }
        }
        catch (AppEngTileMissingException appEngTileMissingException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public ICraftRequest craftingRequest(ItemStack what, boolean showInManager, boolean recursive) {
        if (what == null) {
            return null;
        }
        this.craftingThrottle.hasAccomplishedWork();
        if (recursive) {
            if (this.logisticsRequest(what)) {
                ExternalCraftRequest cr = new ExternalCraftRequest(this.getName(), what);
                cr.disablePreReqs();
                this.WaitingQueue.add(cr);
                return cr;
            }
            CraftRequest ct = new CraftRequest(this.getName(), what);
            if (showInManager) {
                this.CManager.requestedPreReqs(ct);
            }
            this.CraftingQueue.add(ct);
            this.OnCraftingChange(null);
            return ct;
        }
        CraftRequest ct = new CraftRequest(this.getName(), what);
        ct.allowPrereqs = false;
        if (showInManager) {
            this.CManager.requestedPreReqs(ct);
        }
        this.CraftingQueue.add(ct);
        this.OnCraftingChange(null);
        return ct;
    }

    @Override
    public ICraftRequest craftingRequest(ItemStack what) {
        return this.craftingRequest(what, false, true);
    }

    public void advanceCraftingCursor() {
        if (!this.isPowered()) {
            return;
        }
        if (this.waitingThrottle.process()) {
            boolean worked = false;
            LinkedList<CraftRequest> p = new LinkedList<CraftRequest>();
            p.addAll(this.WaitingQueue);
            for (CraftRequest x : p) {
                ItemStack is;
                if (!x.canRequestPrereqs() || !this.logisticsRequest(is = x.getRequest())) continue;
                FMLLog.severe((String)("Just reqyested " + Platform.getItemDisplayName(is) + " - " + is.field_77994_a), (Object[])new Object[0]);
                worked = true;
                x.disablePreReqs();
            }
            if (worked) {
                this.waitingThrottle.hasAccomplishedWork();
            }
        }
        if (!this.craftingThrottle.process()) {
            return;
        }
        ArrayList<AssemblerCluster> Clusters = new ArrayList<AssemblerCluster>();
        try {
            for (TileRef<TileAssembler> ar : this.Assemblers) {
                TileAssembler a = ar.getTile();
                if (a.ac == null || Clusters.indexOf(a.ac) != -1) continue;
                Clusters.add(a.ac);
            }
            for (AssemblerCluster ac : Clusters) {
                if (!this.useMEEnergy(3 * ac.howManyCpus(), "crafting cpus")) continue;
                ac.cycleCpus();
            }
        }
        catch (Exception err) {
            // empty catch block
        }
        if (this.CraftingQueue.size() == 0) {
            return;
        }
        IMEInventoryHandler invItemPool = this.getCellArray();
        if (invItemPool == null) {
            return;
        }
        ItemList all = (ItemList)invItemPool.getAvailableItems(this.storedList);
        all.clean();
        HashSet<IAssemblerPattern> Patterns = this.getPatterns();
        Iterator<CraftRequest> cri = this.WaitingQueue.iterator();
        while (cri.hasNext()) {
            ItemStack xRequest;
            CraftRequest x = cri.next();
            if (!x.canTry()) continue;
            x.clearMissing();
            if (x.getAmount() <= 0 || (xRequest = x.getRequest()) == null) continue;
            IAssemblerPattern pattern = Crafting.findRecipe(Patterns, xRequest);
            if (!(x instanceof DelayedCraftRequest)) continue;
            if (pattern != null) {
                while (x.getAmount() > 0) {
                    x.markCrafted();
                }
            }
            if (x.getAmount() > 0) continue;
            cri.remove();
        }
        for (int z = 0; z < this.CraftingQueue.size(); ++z) {
            CraftRequest x = this.CraftingQueue.pollFirst();
            if (x.canTry()) {
                x.clearMissing();
                if (x.getAmount() <= 0) continue;
                ItemStack xRequest = x.getRequest();
                if (xRequest != null) {
                    IAssemblerPattern pattern = Crafting.findRecipe(Patterns, xRequest);
                    boolean Recursive = false;
                    if (!(x instanceof MultiPushCraftRequest)) {
                        for (CraftRequest cr = x.getParent(); cr != null; cr = cr.getParent()) {
                            if (cr instanceof PushCraftRequest || !Platform.isSameItem(cr.getRequest(), x.getRequest())) continue;
                            Recursive = true;
                        }
                    }
                    if (Recursive) {
                        AppEng.craftingLog(this.getName(), xRequest, " is recursive");
                        this.craftingThrottle.hasAccomplishedWork();
                        x.markChainCrafted();
                    } else if (pattern == null && x.requirePattern()) {
                        if (x.canRequestPrereqs()) {
                            AppEng.craftingLog(this.getName(), xRequest, " is missing, will wait.");
                            this.craftingThrottle.hasAccomplishedWork();
                            MissingMaterialsCraftRequest ex = new MissingMaterialsCraftRequest(this.getName(), xRequest);
                            x.requestedPreReqs(ex);
                            this.WaitingQueue.add(ex);
                            this.OnCraftingChange(null);
                        }
                    } else {
                        int max = 64;
                        while (x.getAmount() > 0 && max-- >= 0) {
                            IAssemblerCluster ac = null;
                            if (pattern != null) {
                                ac = pattern.getCluster();
                            }
                            if (ac != null && !ac.canCraft()) break;
                            if (!x.Craft(this, pattern, invItemPool, all, this.CraftingQueue, this.WaitingQueue)) continue;
                            if (ac != null) {
                                ac.addCraft();
                            }
                            this.craftingThrottle.hasAccomplishedWork();
                        }
                    }
                }
                if (x.getAmount() > 0) {
                    this.CraftingQueue.addLast(x);
                    continue;
                }
                this.OnCraftingChange(null);
                continue;
            }
            this.CraftingQueue.addLast(x);
        }
    }

    public WirelessRangeResult inWirelessRange(EntityPlayer p) {
        if (!this.isPowered()) {
            return new WirelessRangeResult(null, -1.0f);
        }
        for (TileRef<TileWireless> twr : this.WirelessNodes) {
            try {
                TileWireless tw = twr.getTile();
                if (tw.field_70331_k != p.field_70170_p) continue;
                double dist = p.func_70092_e((double)tw.field_70329_l, (double)tw.field_70330_m, (double)tw.field_70327_n);
                double maxRange = AppEngConfiguration.WirelessRange;
                ItemStack boosters = tw.item.func_70301_a(0);
                if (Platform.isSameItemType(boosters, Materials.matWirelessBooster)) {
                    maxRange = boosters.field_77994_a > AppEngConfiguration.WirelessRangeExtenders ? (maxRange += (double)(AppEngConfiguration.WirelessRangeExtenders * AppEngConfiguration.WirelessRangeExtenderBonus)) : (maxRange += (double)(boosters.field_77994_a * AppEngConfiguration.WirelessRangeExtenderBonus));
                }
                if (!(dist < maxRange * maxRange)) continue;
                return new WirelessRangeResult(tw, (float)dist);
            }
            catch (AppEngTileMissingException e) {
            }
        }
        return new WirelessRangeResult(null, -1.0f);
    }

    @Override
    public void requestUpdate(IGridTileEntity tt) {
        if (!this.isPowered()) {
            return;
        }
        IMEInventoryHandler inv = this.getCellArray();
        if (tt instanceof TileInterfaceBase && inv != null) {
            TileInterfaceBase i = (TileInterfaceBase)tt;
            i.loopsSinceUpdate = 0;
            i.reqUpdate = false;
            boolean changed = false;
            for (int l = 0; l < 2; ++l) {
                for (int x = 0; x < i.Exports.func_70302_i_(); ++x) {
                    ItemStack r = i.Exports.func_70301_a(x);
                    ItemStack m = i.func_70301_a(x);
                    if (r == null) {
                        if (m == null || !this.useMEEnergy(m.field_77994_a, "interface update")) continue;
                        i.func_70299_a(x, Platform.refundEnergy(this, Platform.addItems(inv, m), "interface update"));
                        changed = true;
                        continue;
                    }
                    if (m != null && !Platform.isSameItem(r, m) && this.useMEEnergy(m.field_77994_a, "interface update")) {
                        ItemStack result;
                        m = result = Platform.refundEnergy(this, Platform.addItems(inv, m), "interface update");
                        i.func_70299_a(x, m);
                        changed = true;
                        if (result != null) continue;
                    }
                    if (r.field_77994_a > r.func_77976_d()) {
                        r.field_77994_a = r.func_77976_d();
                    }
                    if (m == null) {
                        if (this.useMEEnergy(r.field_77994_a, "interface update")) {
                            ItemStack pre = r.func_77946_l();
                            m = Platform.extractItems(inv, r);
                            i.func_70299_a(x, m);
                            int diff = Platform.calculateChange(m, pre);
                            this.refundMEEnergy(diff, "interface update");
                            if (m != null) {
                                changed = true;
                            }
                        }
                    } else {
                        ItemStack diff = r.func_77946_l();
                        diff.field_77994_a -= m.field_77994_a;
                        if (diff.field_77994_a == 0) continue;
                        if (diff.field_77994_a > 0) {
                            if (this.useMEEnergy(diff.field_77994_a, "interface update")) {
                                ItemStack ex = Platform.extractItems(inv, diff);
                                int dx = Platform.calculateChange(ex, diff);
                                this.refundMEEnergy(dx, "interface update");
                                if (ex != null) {
                                    m.field_77994_a += ex.field_77994_a;
                                    changed = true;
                                }
                            }
                        } else {
                            diff.field_77994_a = -diff.field_77994_a;
                            m.field_77994_a -= diff.field_77994_a;
                            if (this.useMEEnergy(diff.field_77994_a, "interface update")) {
                                ItemStack un_addable = Platform.refundEnergy(this, Platform.addItems(inv, diff), "Interface update");
                                changed = true;
                                if (un_addable != null) {
                                    m.field_77994_a += un_addable.field_77994_a;
                                }
                            }
                        }
                    }
                    m = i.func_70301_a(x);
                    if (r == null || m != null && (!Platform.isSameItem(r, m) || m.field_77994_a >= r.field_77994_a)) continue;
                    IItemList avail = this.getCraftableArray().getAvailableItems();
                    IAEItemStack stack = avail.findItem(AEItemStack.create(r));
                    if (i.craftingMode != InterfaceCraftingMode.Craft || stack == null || !stack.isCraftable()) continue;
                    ItemStack req = r.func_77946_l();
                    req.field_77994_a = 1;
                    i.requestCrafting(req);
                }
            }
            if (changed) {
                this.triggerContainerUpdate();
                i.func_70296_d();
            }
        }
    }

    public boolean notCrafting(ItemStack i) {
        for (CraftRequest cr : this.CraftingQueue) {
            if (!Platform.isSameItemType(cr.getRequest(), i)) continue;
            return false;
        }
        return true;
    }

    public void encodeWireless(ItemStack i) {
        if (i == null) {
            return;
        }
        IWirelessTermHandler handler = AppEng.getApiInstance().getWirelessRegistry().getWirelessTerminalHandler(i);
        if (handler != null) {
            handler.setEncryptionKey(i, this.EncryptionKey, this.getName());
        }
    }

    boolean inList(HashSet<IAssemblerPattern> patterns, AssemblerPatternInventory n, IPushable pushable) {
        if (pushable == null) {
            return false;
        }
        for (IAssemblerPattern o : patterns) {
            if (!o.equals(n)) continue;
            o.setInterface(pushable);
            return true;
        }
        return false;
    }

    public HashSet<IAssemblerPattern> getPatterns() {
        if (this.cachedPatternSet != null) {
            return this.cachedPatternSet;
        }
        HashSet<IAssemblerPattern> invs = new HashSet<IAssemblerPattern>();
        try {
            AssemblerPatternInventory api;
            ItemStack s;
            int x;
            TileMEWInventory a;
            for (TileRef<TileAssembler> tileRef : this.Assemblers) {
                a = tileRef.getTile();
                if (((TileAssembler)a).ac == null) continue;
                for (x = 0; x < a.func_70302_i_(); ++x) {
                    s = a.func_70301_a(x);
                    if (s == null || !Util.isAssemblerPattern(s).booleanValue() || this.inList(invs, api = (AssemblerPatternInventory)Util.getAssemblerPattern(s), null)) continue;
                    api.ac = ((TileAssembler)a).ac;
                    invs.add(api);
                }
            }
            for (TileRef<TileMEWInventory> tileRef : this.Interfaces) {
                a = (TileInterfaceBase)tileRef.getTile();
                for (x = 0; x < ((TileInterfaceBase)a).Crafting.func_70302_i_(); ++x) {
                    s = ((TileInterfaceBase)a).Crafting.func_70301_a(x);
                    if (s == null || !Util.isAssemblerPattern(s).booleanValue() || this.inList(invs, api = (AssemblerPatternInventory)Util.getAssemblerPattern(s), (IPushable)((Object)a))) continue;
                    api.setInterface((IPushable)((Object)a));
                    invs.add(api);
                }
            }
        }
        catch (AppEngTileMissingException err) {
            MinecraftForge.EVENT_BUS.post((Event)new GridErrorEvent(this.field_70331_k, this.getLocation()));
        }
        this.cachedPatternSet = invs;
        return this.cachedPatternSet;
    }

    @Override
    public IMEInventoryHandler getCraftableArray() {
        ArrayList<IMEInventoryHandler> invs = new ArrayList<IMEInventoryHandler>();
        try {
            for (TileRef<TileInterfaceBase> ar : this.Interfaces) {
                TileInterfaceBase a = ar.getTile();
                for (IMEInventory lp : a.getLogisticsInv()) {
                    invs.add(new MEInventoryHandler(lp));
                }
            }
            CraftingInventory inv = new CraftingInventory(this, this.getPatterns());
            invs.add(new MEInventoryHandler(inv));
        }
        catch (AppEngTileMissingException err) {
            MinecraftForge.EVENT_BUS.post((Event)new GridErrorEvent(this.field_70331_k, this.getLocation()));
        }
        IMEInventoryHandler h = MEInventoryNetwork.getMEInventoryNetwork(invs, this, this.craftList);
        h.setGrid(this);
        return h;
    }

    @Override
    public IMEInventoryHandler getFullCellArray() {
        List<IMEInventoryHandler> invs = this.getCellList();
        try {
            for (TileRef<TileInterfaceBase> ar : this.Interfaces) {
                TileInterfaceBase a = ar.getTile();
                for (IMEInventory lp : a.getLogisticsInv()) {
                    invs.add(new MEInventoryHandler(lp));
                }
            }
            CraftingInventory inv = new CraftingInventory(this, this.getPatterns());
            invs.add(new MEInventoryHandler(inv));
        }
        catch (AppEngTileMissingException err) {
            MinecraftForge.EVENT_BUS.post((Event)new GridErrorEvent(this.field_70331_k, this.getLocation()));
        }
        IMEInventoryHandler h = MEInventoryNetwork.getMEInventoryNetwork(invs, this, this.fullList);
        h.setGrid(this);
        return h;
    }

    public List<IMEInventoryHandler> getCellList() {
        this.isCalculatingCell = true;
        ArrayList<IMEInventoryHandler> invs = new ArrayList<IMEInventoryHandler>();
        try {
            for (TileRef<ICellContainer> dr : this.CellContainers) {
                ICellContainer d = dr.getTile();
                List<IMEInventoryHandler> lD = d.getCellArray();
                if (lD == null) continue;
                for (IMEInventoryHandler inv : lD) {
                    if (inv == null) continue;
                    inv.setPriority(d.getPriority());
                    invs.add(inv);
                }
            }
        }
        catch (AppEngTileMissingException err) {
            MinecraftForge.EVENT_BUS.post((Event)new GridErrorEvent(this.field_70331_k, this.getLocation()));
        }
        this.isCalculatingCell = false;
        return invs;
    }

    @Override
    public IMEInventoryHandler getCellArray() {
        if (this.isPowered()) {
            if (this.isCalculatingCell) {
                return null;
            }
            if (this.cachedCellArray != null) {
                return this.cachedCellArray;
            }
            if (topLevel == null) {
                topLevel = this;
            }
            List<IMEInventoryHandler> invs = this.getCellList();
            IMEInventoryHandler h = MEInventoryNetwork.getMEInventoryNetwork(invs, this, this.storedList);
            h.setGrid(this);
            if (topLevel == this) {
                this.cachedCellArray = h;
            }
            return h;
        }
        return new MEInventoryNull();
    }

    boolean updatePower() {
        if (this.TicksSincePower++ > 90) {
            this.TicksSincePower = 0;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void updateTileEntity() {
        if (Platform.isClient()) {
            return;
        }
        if (this.TicksBetweenFlashes >= 0) {
            --this.TicksBetweenFlashes;
        }
        if (!this.enabled) {
            return;
        }
        super.updateTileEntity();
        this.pushPowerUsage();
        try {
            if (this.updatePower()) {
                this.cachedPowerConsumption = 6.0f + (float)this.cables / 16.0f;
                for (TileRef<IGridMachine> im : this.AllMachines) {
                    this.cachedPowerConsumption += im.getTile().getPowerDrainPerTick();
                }
                this.triggerContainerUpdate();
            }
            boolean hadPower = this.hasPower;
            boolean hasLocalPower = (double)this.storedPower > 0.1;
            this.hasPower = this.useMEEnergy(this.cachedPowerConsumption, "network drain");
            boolean wasUseingRemotePower = this.isUseingRemotePower;
            boolean bl = this.isUseingRemotePower = this.hasPower && !hasLocalPower;
            if (this.isUseingRemotePower != wasUseingRemotePower) {
                this.triggerUpdate = true;
            }
            if (hadPower != this.hasPower) {
                this.triggerUpdate = true;
                this.sendUpdate = true;
                AppEng.log("Controller " + (this.hasPower ? "ONLINE" : "OFFLINE") + "!");
                if (!this.hasPower) {
                    this.storedPower = 0.0f;
                }
                for (TileRef<IGridMachine> im : this.AllMachines) {
                    im.getTile().setPowerStatus(this.hasPower);
                }
            }
            if (this.getPowerLevel() != this.oldFace) {
                this.oldFace = this.getPowerLevel();
                this.triggerUpdate = true;
            }
            if (this.triggerUpdate && this.TicksSinceUpdate++ > 5) {
                this.triggerUpdate = false;
                this.TicksSinceUpdate = 0;
                this.markForUpdate();
            }
            if (this.hasPower) {
                if (this.updateStorageAware) {
                    this.updateStorageAware = false;
                    this.updateStorageAware();
                }
                if (this.NewItemQueue.size() > 0) {
                    List<IAEItemStack> ll = this.NewItemQueue;
                    this.NewItemQueue = new LinkedList<IAEItemStack>();
                    this.sendUpdate = true;
                    block9: for (IAEItemStack is : ll) {
                        if (is.getStackSize() == 0L) continue;
                        long ItemsAdded = is.getStackSize();
                        if (is.getStackSize() <= 0L) continue;
                        LinkedList<CraftRequest> p = new LinkedList<CraftRequest>();
                        p.addAll(this.WaitingQueue);
                        for (CraftRequest x : p) {
                            if (!(x instanceof ExternalCraftRequest) || !is.equals(x.getAERequest())) continue;
                            while (ItemsAdded > 0L && x.getAmount() > 0) {
                                if (AppEngConfiguration.allowLogging && AppEngConfiguration.logCrafting) {
                                    AppEng.log(this.getName() + ": " + x.requestType() + " got " + 1 + " of " + Platform.getSharedItemStack(is).func_77977_a() + " - left: " + (x.getAmount() - 1));
                                }
                                x.markCrafted();
                                --ItemsAdded;
                                this.OnCraftingChange(null);
                            }
                            if (x.getAmount() == 0) {
                                this.WaitingQueue.remove(x);
                            }
                            if (ItemsAdded > 0L) continue;
                            continue block9;
                        }
                    }
                }
                for (IGridCache gc : this.Caches) {
                    gc.onUpdateTick(this);
                }
                this.advanceCraftingCursor();
                if ((this.sendUpdate || this.hasFlashed) && AppEngConfiguration.gfxCableAnimation && this.TicksBetweenFlashes < 0) {
                    this.hasFlashed = false;
                    this.TicksBetweenFlashes = AppEngConfiguration.gfxCableMinTickRate;
                    try {
                        PacketDispatcher.sendPacketToAllPlayers((Packet)new PacketGridAnimate(this.getGridIndex()).getPacket());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            if (this.sendUpdate && this.ticksBetweenUpdates++ > AppEngConfiguration.terminalUpdateMinTickRate) {
                this.sendUpdate = false;
                this.ticksBetweenUpdates = 0;
                Iterator<EntityPlayer> ip = this.contentsViewingPlayers.iterator();
                while (ip.hasNext()) {
                    EntityPlayer p = ip.next();
                    if (p.field_71070_bA == null) continue;
                    if (p.field_71070_bA instanceof ContainerTerminal) {
                        try {
                            ContainerTerminal ct = (ContainerTerminal)p.field_71070_bA;
                            ct.GetNetworkIME().postChanges(this.invChanges);
                            for (Packet250CustomPayload pak : ct.GetNetworkIME().getDataPacket()) {
                                PacketDispatcher.sendPacketToPlayer((Packet)pak, (Player)((Player)p));
                            }
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                    ip.remove();
                }
                this.invChanges = new ArrayList<IAEItemStack>();
            }
        }
        catch (AppEngTileMissingException e) {
        }
        catch (ClassCastException e) {
            MinecraftForge.EVENT_BUS.post((Event)new GridErrorEvent(this.field_70331_k, this.getLocation()));
        }
    }

    private void updateStorageAware() throws AppEngTileMissingException {
        ItemList iss = (ItemList)this.getCellArray().getAvailableItems(this.storedList);
        for (TileRef<IStorageAware> sm : this.StorageAware) {
            IStorageAware tsm = sm.getTile();
            tsm.onNetworkInventoryChange(iss);
        }
    }

    @Override
    public void addViewingPlayer(EntityPlayer p) {
        if (this.contentsViewingPlayers.indexOf(p) == -1) {
            this.contentsViewingPlayers.add(p);
        }
    }

    @Override
    public void rmvViewingPlayer(EntityPlayer p) {
        this.contentsViewingPlayers.remove(p);
    }

    public TileController() {
        this.gridIndex = newGridIndex++;
        this.Caches = AppEng.getApiInstance().getGridCacheRegistry().createCacheInstance();
        this.fullList = new ItemList();
        this.craftList = new ItemList();
        this.storedList = new ItemList();
        this.maxStoredPower = 4000.0f;
        this.currentStatus = new ArrayList<ItemStack>();
        this.invChanges = new ArrayList<IAEItemStack>();
        this.CellContainers = new ArrayList<TileRef<ICellContainer>>();
        this.Assemblers = new ArrayList<TileRef<TileAssembler>>();
        this.Interfaces = new ArrayList<TileRef<TileInterfaceBase>>();
        this.WirelessNodes = new ArrayList<TileRef<TileWireless>>();
        this.StorageAware = new ArrayList<TileRef<IStorageAware>>();
        this.AllMachines = new ArrayList<TileRef<IGridMachine>>();
        this.PowerSources = new ArrayList<TileRef<Object>>();
        this.WaitingQueue = new LinkedList<CraftRequest>();
        this.CraftingQueue = new LinkedList<CraftRequest>();
        this.contentsViewingPlayers = new ArrayList<EntityPlayer>();
        this.craftingViewingPlayers = new ArrayList<EntityPlayer>();
        this.personalPowerUsageLog = new float[20];
        this.realPowerUsageLog = new float[20];
        this.updateStorageAware = true;
        this.NewItemQueue = new LinkedList<IAEItemStack>();
        this.CManager = new CraftingManager(this.getName(), this);
        this.EncryptionKey = String.valueOf(new Date().getTime());
        this.orientation = ForgeDirection.NORTH;
        this.waitingThrottle = new METhrottle(40, AppEngConfiguration.craftingMinTickRate, AppEngConfiguration.craftingMinTickRate + 320);
        this.craftingThrottle = new METhrottle(1, AppEngConfiguration.craftingMinTickRate, AppEngConfiguration.craftingMinTickRate + 80);
    }

    @Override
    public String getName() {
        return this.EncryptionKey;
    }

    public int getPowerLevel() {
        int powerLevel = (int)Math.ceil(5.0f * (this.storedPower / this.maxStoredPower));
        if (powerLevel < 0) {
            powerLevel = 0;
        }
        if (powerLevel >= AppEngTextureRegistry.Blocks.MEControllerPower.length) {
            powerLevel = AppEngTextureRegistry.Blocks.MEControllerPower.length - 1;
        }
        return powerLevel;
    }

    public Icon getFrontFace() {
        if (!AppEngConfiguration.requirePower) {
            return AppEngTextureRegistry.Blocks.GenericSide.get();
        }
        if (this.powerBar) {
            return this.getPowerLevelBar();
        }
        return AppEngTextureRegistry.Blocks.ControllerPanel.get();
    }

    public Icon getPowerLevelBar() {
        if (!AppEngConfiguration.requirePower) {
            return null;
        }
        if (this.isUseingRemotePower && this.hasPower) {
            return AppEngTextureRegistry.Blocks.BlockControllerLinked.get();
        }
        return AppEngTextureRegistry.Blocks.MEControllerPower[this.getPowerLevel()].get();
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        if (ForgeDirection.DOWN == side) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        if (ForgeDirection.UP == side) {
            return AppEngTextureRegistry.Blocks.GenericTop.get();
        }
        Icon frontFace = this.getFrontFace();
        if (this.orientation == side) {
            return frontFace;
        }
        return AppEngTextureRegistry.Blocks.GenericSide.get();
    }

    @Override
    public IGridInterface getGrid() {
        return this;
    }

    @Override
    public void craftGui(EntityPlayerMP pmp, IGridTileEntity gte, ItemStack s) {
        HashSet<IAssemblerPattern> patterns = this.getPatterns();
        IAssemblerPattern p = Crafting.findRecipe(patterns, s);
        if (p != null || this.canLogisticsMake(s)) {
            this.lastCraftingRequest = s;
            WorldCoord wc = gte.getLocation();
            Platform.openGui((EntityPlayer)pmp, AppEngGuiHandler.GUI_CRAFTING, pmp.field_70170_p, wc.x, wc.y, wc.z);
        }
    }

    public void configureController(Collection<GridEnumeration.NetworkNode> nodes) {
        if (Platform.isClient()) {
            return;
        }
        this.CManager = new CraftingManager(this.getName(), this);
        this.CraftingQueue.clear();
        this.WaitingQueue.clear();
        this.cables = 0;
        this.updateStorageAware = true;
        this.sendUpdate = true;
        this.currentStatus = null;
        this.cachedPatternSet = null;
        this.cachedCellArray = null;
        this.CellContainers.clear();
        this.Assemblers.clear();
        this.Interfaces.clear();
        this.WirelessNodes.clear();
        this.StorageAware.clear();
        this.AllMachines.clear();
        this.AllEntities = new ArrayList<TileRef<IGridTileEntity>>();
        this.PowerSources = new ArrayList<TileRef<Object>>();
        this.triggerPowerUpdate();
        if (nodes == null) {
            this.enabled = false;
            this.currentStatus = null;
            this.cables = 0;
            this.triggerUpdate = true;
            return;
        }
        ArrayList<IGridTileEntity> currentTiles = new ArrayList<IGridTileEntity>();
        if (this.myRef == null) {
            this.myRef = new GridReference(this);
        }
        for (GridEnumeration.NetworkNode networkNode : nodes) {
            IGridTileEntity gte = networkNode.getTile();
            currentTiles.add(gte);
            this.AllEntities.add(new TileRef((TileEntity)gte));
            gte.setGrid(this.myRef);
            gte.setPowerStatus(this.hasPower);
        }
        this.enabled = true;
        try {
            this.currentStatus = new ArrayList<ItemStack>();
            for (TileRef tileRef : this.AllEntities) {
                TileEntity tt = (TileEntity)tileRef.getTile();
                if (tt instanceof TileCable || tt instanceof TileColorlessCable) {
                    Platform.sumItemToList(this.currentStatus, Blocks.blkColorlessCable);
                } else {
                    Platform.sumItemToList(this.currentStatus, Platform.getItemStackVersion(tt.field_70331_k, tt.field_70329_l, tt.field_70330_m, tt.field_70327_n));
                }
                if (tt instanceof TileCable || tt instanceof TileDarkCable || tt instanceof TileColorlessCable) {
                    ++this.cables;
                }
                if (tt instanceof IGridMachine) {
                    this.AllMachines.add(new TileRef(tt));
                }
                if (tt instanceof IStorageAware) {
                    this.StorageAware.add(new TileRef(tt));
                }
                if (tt instanceof ICellContainer) {
                    this.CellContainers.add(new TileRef(tt));
                }
                if (tt instanceof TileWireless) {
                    this.WirelessNodes.add(new TileRef(tt));
                }
                if (tt instanceof TileAssembler) {
                    this.Assemblers.add(new TileRef(tt));
                }
                if (tt instanceof TileInterfaceBase) {
                    this.Interfaces.add(new TileRef(tt));
                }
                if (!(tt instanceof IPowerSharing)) continue;
                this.PowerSources.add(new TileRef(tt));
            }
            for (TileRef tileRef : this.Interfaces) {
                this.requestUpdate((IGridTileEntity)tileRef.getTile());
            }
            AppEng.log("Online: " + this.AllMachines.size());
            this.updateStorageAware();
            this.getCraftableArray().getAvailableItems();
            this.getFullCellArray().getAvailableItems();
            this.triggerUpdate = true;
        }
        catch (AppEngTileMissingException e) {
            this.configureController(null);
            return;
        }
        for (IGridCache gc : this.Caches) {
            gc.reset(this);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("rot", (int)this.getAERotationFromDirection(this.orientation));
        data.func_74778_a("encKey", this.EncryptionKey);
        for (IGridCache gc : this.Caches) {
            NBTTagCompound tc = gc.savetoNBTData();
            if (tc == null) continue;
            data.func_74766_a("GC." + gc.getCacheName(), tc);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.orientation = this.getDirectionFromAERotation((byte)data.func_74762_e("rot"));
        this.EncryptionKey = data.func_74779_i("encKey");
        if (this.EncryptionKey == null || this.EncryptionKey == "") {
            this.EncryptionKey = String.valueOf(new Date().getTime());
        }
        for (IGridCache gc : this.Caches) {
            NBTTagCompound o = data.func_74775_l("GC." + gc.getCacheName());
            gc.loadfromNBTData(o);
        }
    }

    @Override
    public void configureTilePacket(DataOutputStream data) {
        try {
            data.writeBoolean(this.hasPower);
            data.writeBoolean(this.enabled);
            data.writeFloat(this.storedPower);
            data.writeBoolean(this.isUseingRemotePower);
            data.writeByte(this.getAERotationFromDirection(this.orientation));
            data.writeFloat(this.getPowerUsageAvg());
            data.writeFloat(this.getPersonalPowerUsageAvg());
            if (this.currentStatus == null) {
                data.writeShort(0);
            } else {
                data.writeShort((short)this.currentStatus.size());
                for (int x = 0; x < this.currentStatus.size(); ++x) {
                    data.writeInt(this.currentStatus.get((int)x).field_77993_c);
                    data.writeInt(this.currentStatus.get((int)x).field_77994_a);
                    data.writeInt(this.currentStatus.get(x).func_77960_j());
                }
            }
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void handleTilePacket(DataInputStream stream) {
        try {
            ForgeDirection oldOrientation = this.orientation;
            float oldstoredPower = this.storedPower;
            boolean wasUseingRemotePower = this.isUseingRemotePower;
            this.hasPower = stream.readBoolean();
            this.enabled = stream.readBoolean();
            this.storedPower = stream.readFloat();
            this.isUseingRemotePower = stream.readBoolean();
            this.orientation = this.getDirectionFromAERotation(stream.readByte());
            this.powerDrained = stream.readFloat();
            this.powerDrainedPersonal = stream.readFloat();
            int statusCount = stream.readShort();
            if (statusCount > 0) {
                this.currentStatus = new ArrayList<ItemStack>();
                for (int x = 0; x < statusCount; ++x) {
                    this.currentStatus.add(new ItemStack(stream.readInt(), stream.readInt(), stream.readInt()));
                }
                Collections.sort(this.currentStatus, ItemSorters.Decending_SortBySize_Vanilla);
            } else {
                this.currentStatus = null;
            }
            if ((double)Math.abs(this.storedPower - oldstoredPower) > 0.05 || oldOrientation != this.orientation || this.isUseingRemotePower != wasUseingRemotePower) {
                this.markForUpdate();
            }
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    public IMEInventoryHandler provideCell() {
        if (this.hasPower) {
            return this.getFullCellArray();
        }
        return null;
    }

    @Override
    public boolean useMEEnergy(float use, String for_what) {
        if (!AppEngConfiguration.requirePower) {
            return true;
        }
        if (AppEngConfiguration.allowLogging && AppEngConfiguration.logPowerUsage) {
            AppEng.log(this.getName() + ": " + use + " units for " + for_what);
        }
        this.personalPowerUsageActiveTick += use;
        return this.useMEEnergyRecursive(use, new ArrayList<Object>());
    }

    List<Object> getPowerSources() {
        ArrayList<Object> providers = new ArrayList<Object>();
        for (TileRef<TileInterfaceBase> i : this.Interfaces) {
            try {
                TileInterfaceBase tib = i.getTile();
                for (Object lpp : tib.getLogisticsPowerSources()) {
                    providers.add(lpp);
                }
            }
            catch (AppEngTileMissingException e) {
                AppEng.log("Error accessing Interface.");
            }
        }
        for (TileRef<Object> irpp : this.PowerSources) {
            try {
                providers.add(irpp.getTile());
            }
            catch (AppEngTileMissingException e) {
                AppEng.log("Error accessing PowerSource.");
            }
        }
        return providers;
    }

    public boolean useMEEnergyRecursive(float amount, List<Object> providersToIgnore) {
        if (!providersToIgnore.contains(this)) {
            providersToIgnore.add(this);
            if (this.storedPower >= amount) {
                return this.useLocalMEEnergy(amount);
            }
            this.storedPower = 0.0f;
            for (Object pp : this.getPowerSources()) {
                if (!(pp instanceof IPowerSharing ? ((IPowerSharing)pp).useEnergy((int)Math.ceil(amount), providersToIgnore) : AppEng.getInstance().LPProxy != null && AppEng.getInstance().LPProxy.canUseEnergy(pp, (int)Math.ceil(amount), providersToIgnore) && AppEng.getInstance().LPProxy.useEnergy(pp, (int)Math.ceil(amount), providersToIgnore))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canUseEnergyRecursive(float amount, List<Object> providersToIgnore) {
        if (!providersToIgnore.contains(this)) {
            if (this.storedPower >= amount) {
                return true;
            }
            providersToIgnore.add(this);
            for (Object pp : this.getPowerSources()) {
                if (!(pp instanceof IPowerSharing ? ((IPowerSharing)pp).canUseEnergy((int)Math.ceil(amount), providersToIgnore) : AppEng.getInstance().LPProxy != null && AppEng.getInstance().LPProxy.canUseEnergy(pp, (int)Math.ceil(amount), providersToIgnore))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void refundMEEnergy(float use, String for_what) {
        if (!AppEngConfiguration.requirePower) {
            return;
        }
        if (use < 0.0f) {
            return;
        }
        this.storedPower += (use *= AppEngConfiguration.powerUsageMultiplier);
        this.realPowerUsageActiveTick -= use;
        this.personalPowerUsageActiveTick -= use;
    }

    public boolean useLocalMEEnergy(float use) {
        if (!AppEngConfiguration.requirePower) {
            return true;
        }
        this.realPowerUsageActiveTick += (use *= AppEngConfiguration.powerUsageMultiplier);
        if (this.storedPower >= use) {
            this.storedPower -= use;
            return true;
        }
        this.storedPower = 0.0f;
        return false;
    }

    @Override
    public TileEntity getController() {
        return this;
    }

    @Override
    public void placedBy(EntityLivingBase entityliving) {
        this.orientation = this.getOrientationFromLivingEntity(entityliving, false);
    }

    @Override
    public int usePowerForAddition(int items, int multiplier) {
        if (!AppEngConfiguration.requirePower) {
            return items;
        }
        if (!this.hasPower) {
            return 0;
        }
        if (this.storedPower > (float)(items * multiplier)) {
            return this.useMEEnergy(items, "adding items") ? items : 0;
        }
        if (this.useMEEnergy(items * multiplier, "adding items")) {
            return items;
        }
        int amt = (int)Math.floor(this.storedPower * (float)multiplier);
        return this.useMEEnergy(amt, "adding items") ? amt / 2 : 0;
    }

    @Override
    protected int getMaxStoredPower() {
        return (int)this.maxStoredPower;
    }

    public ItemStack getCraftAmount(ItemStack willAdd) {
        IAssemblerPattern p = Crafting.findRecipe(this.getPatterns(), willAdd);
        if (p != null) {
            return p.getOutput();
        }
        return null;
    }

    public List<ItemStack> getParts() {
        if (this.currentStatus == null) {
            return new ArrayList<ItemStack>();
        }
        return this.currentStatus;
    }

    @Override
    public List<TileRef<IGridMachine>> getMachines() {
        ArrayList<TileRef<IGridMachine>> mac = new ArrayList<TileRef<IGridMachine>>();
        for (TileRef<IGridMachine> r : this.AllMachines) {
            try {
                mac.add(new TileRef((TileEntity)r.getTile()));
            }
            catch (AppEngTileMissingException e) {}
        }
        return mac;
    }

    @Override
    public void addCraftingPlayer(EntityPlayer p) {
        if (this.craftingViewingPlayers.indexOf(p) == -1) {
            this.craftingViewingPlayers.add(p);
        }
    }

    @Override
    public void rmvCraftingPlayer(EntityPlayer p) {
        this.craftingViewingPlayers.remove(p);
    }

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return true;
    }

    public void removeFromCraftingQueues(CraftRequest craftRequest) {
        this.CraftingQueue.remove(craftRequest);
        this.WaitingQueue.remove(craftRequest);
    }

    @Override
    public IMEInventoryHandler provideCell(String Filter2) {
        if (this.hasPower) {
            if (Filter2.equals(ViewItems.ALL.toString())) {
                return this.getFullCellArray();
            }
            if (Filter2.equals(ViewItems.CRAFTABLE.toString())) {
                return this.getCraftableArray();
            }
            if (Filter2.equals(ViewItems.STORED.toString())) {
                return this.getCellArray();
            }
        }
        return null;
    }

    @Override
    public int getGridIndex() {
        return this.gridIndex;
    }

    @Override
    public IAssemblerPattern getPatternFor(ItemStack req) {
        for (IAssemblerPattern p : this.getPatterns()) {
            if (!Platform.isSameItem(req, p.getOutput())) continue;
            return p;
        }
        return null;
    }

    @Override
    public void notifyExtractItems(IAEItemStack removed) {
        this.sendUpdate = true;
        IAEItemStack ns = removed.copy();
        ns.setStackSize(-ns.getStackSize());
        Platform.sumItemToList(this.invChanges, ns);
        this.updateStorageAware = true;
    }

    @Override
    public void notifyAddItems(IAEItemStack added) {
        this.sendUpdate = true;
        IAEItemStack ns = added.copy();
        Platform.sumItemToList(this.NewItemQueue, ns);
        Platform.sumItemToList(this.invChanges, ns);
        this.updateStorageAware = true;
        this.craftingThrottle.wakeUp();
    }

    @Override
    public void triggerPowerUpdate() {
        this.TicksSincePower = 900;
    }

    @Override
    public long getLocatableSerial() {
        return Long.valueOf(this.EncryptionKey);
    }

    @Override
    public IGridCache getCacheByID(int id) {
        return this.Caches[id];
    }

    @Override
    public void signalEnergyTransfer(IGridTileEntity a, IGridTileEntity b, float amt) {
        this.hasFlashed = true;
    }

    @Override
    public ForgeDirection getPrimaryOrientation() {
        return this.orientation;
    }

    @Override
    public int getSpin() {
        return 0;
    }

    @Override
    public void setPrimaryOrientation(ForgeDirection s) {
        this.orientation = s;
    }

    @Override
    public void setSpin(int spin) {
    }
}

